/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import io.gravitee.fetcher.api.Fetcher;
import io.gravitee.fetcher.api.FetcherConfiguration;
import io.gravitee.fetcher.api.FetcherException;
import io.gravitee.fetcher.api.FilepathAwareFetcherConfiguration;
import io.gravitee.fetcher.api.FilesFetcher;
import io.gravitee.fetcher.api.Resource;
import io.gravitee.fetcher.api.Sensitive;
import io.gravitee.plugin.core.api.PluginManager;
import io.gravitee.plugin.fetcher.FetcherPlugin;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.repository.management.api.search.PageCriteria;
import io.gravitee.repository.management.model.AccessControl;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Page;
import io.gravitee.repository.management.model.PageMedia;
import io.gravitee.repository.management.model.PageReferenceType;
import io.gravitee.repository.management.model.PageSource;
import io.gravitee.rest.api.fetcher.FetcherConfigurationFactory;
import io.gravitee.rest.api.model.AccessControlEntity;
import io.gravitee.rest.api.model.AccessControlReferenceType;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.ApiPageEntity;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.FetchablePageEntity;
import io.gravitee.rest.api.model.ImportPageEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.MetadataEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageMediaEntity;
import io.gravitee.rest.api.model.PageRevisionEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.descriptor.GraviteeDescriptorEntity;
import io.gravitee.rest.api.model.descriptor.GraviteeDescriptorPageEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.GraviteeDescriptorService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.MetadataService;
import io.gravitee.rest.api.service.PageRevisionService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.PageConverter;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.NoFetcherDefinedException;
import io.gravitee.rest.api.service.exceptions.PageActionException;
import io.gravitee.rest.api.service.exceptions.PageContentUnsafeException;
import io.gravitee.rest.api.service.exceptions.PageFolderActionException;
import io.gravitee.rest.api.service.exceptions.PageNotFoundException;
import io.gravitee.rest.api.service.exceptions.PageUsedAsGeneralConditionsException;
import io.gravitee.rest.api.service.exceptions.PageUsedByCategoryException;
import io.gravitee.rest.api.service.exceptions.SwaggerDescriptorException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.TemplateProcessingException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.swagger.parser.OAIParser;
import io.gravitee.rest.api.service.impl.swagger.transformer.entrypoints.EntrypointsOAITransformer;
import io.gravitee.rest.api.service.impl.swagger.transformer.page.PageConfigurationOAITransformer;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.sanitizer.HtmlSanitizer;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.gravitee.rest.api.service.swagger.OAIDescriptor;
import io.gravitee.rest.api.service.swagger.SwaggerDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PageServiceImpl
extends AbstractService
implements PageService,
ApplicationContextAware {
    public static final String SYSTEM_CONTRIBUTOR = "system";
    private static final Gson gson = new Gson();
    private static final Logger logger = LoggerFactory.getLogger(PageServiceImpl.class);
    private static final String SENSITIVE_DATA_REPLACEMENT = "********";
    @Value(value="${documentation.markdown.sanitize:false}")
    private boolean markdownSanitize;
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private PluginManager<FetcherPlugin> fetcherPluginManager;
    @Autowired
    private FetcherConfigurationFactory fetcherConfigurationFactory;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private PageRevisionService pageRevisionService;
    @Autowired
    private GraviteeDescriptorService graviteeDescriptorService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ImportConfiguration importConfiguration;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private PlanService planService;
    @Autowired
    private AccessControlService accessControlService;
    @Autowired
    private PageConverter pageConverter;

    private static Page convert(NewPageEntity newPageEntity) {
        Page page = new Page();
        page.setCrossId(newPageEntity.getCrossId());
        page.setName(newPageEntity.getName());
        PageType type = newPageEntity.getType();
        if (type != null) {
            page.setType(type.name());
        }
        page.setContent(newPageEntity.getContent());
        page.setLastContributor(newPageEntity.getLastContributor());
        page.setOrder(newPageEntity.getOrder());
        page.setPublished(newPageEntity.isPublished());
        if (newPageEntity.getVisibility() != null) {
            page.setVisibility(newPageEntity.getVisibility().name());
        }
        page.setHomepage(newPageEntity.isHomepage());
        page.setSource(PageServiceImpl.convert(newPageEntity.getSource()));
        page.setConfiguration(newPageEntity.getConfiguration());
        page.setExcludedAccessControls(newPageEntity.isExcludedAccessControls().booleanValue());
        page.setAccessControls(PageServiceImpl.convertACL(newPageEntity.getAccessControls()));
        page.setParentId("".equals(newPageEntity.getParentId()) ? null : newPageEntity.getParentId());
        page.setMetadata(newPageEntity.getMetadata());
        page.setUseAutoFetch(newPageEntity.getUseAutoFetch());
        return page;
    }

    private static Page convert(ImportPageEntity importPageEntity) {
        Page page = new Page();
        PageType type = importPageEntity.getType();
        if (type != null) {
            page.setType(type.name());
        }
        page.setLastContributor(importPageEntity.getLastContributor());
        page.setPublished(importPageEntity.isPublished());
        page.setVisibility(importPageEntity.getVisibility().name());
        page.setSource(PageServiceImpl.convert(importPageEntity.getSource()));
        page.setConfiguration(importPageEntity.getConfiguration());
        page.setExcludedAccessControls(importPageEntity.isExcludedAccessControls());
        if (importPageEntity.getExcludedGroups() != null && !importPageEntity.getExcludedGroups().isEmpty()) {
            page.setExcludedAccessControls(true);
            page.setAccessControls(importPageEntity.getExcludedGroups().stream().map(groupId -> {
                AccessControl accessControl = new AccessControl();
                accessControl.setReferenceType("GROUP");
                accessControl.setReferenceId(groupId);
                return accessControl;
            }).collect(Collectors.toSet()));
        } else {
            page.setAccessControls(PageServiceImpl.convertACL(importPageEntity.getAccessControls()));
        }
        return page;
    }

    private static Page merge(UpdatePageEntity updatePageEntity, Page withUpdatePage) {
        Page page = new Page();
        page.setCrossId(updatePageEntity.getCrossId() != null ? updatePageEntity.getCrossId() : withUpdatePage.getCrossId());
        page.setName(updatePageEntity.getName() != null ? updatePageEntity.getName() : withUpdatePage.getName());
        page.setContent(updatePageEntity.getContent() != null ? updatePageEntity.getContent() : withUpdatePage.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor() != null ? updatePageEntity.getLastContributor() : withUpdatePage.getLastContributor());
        page.setOrder(updatePageEntity.getOrder() != null ? updatePageEntity.getOrder().intValue() : withUpdatePage.getOrder());
        page.setPublished(updatePageEntity.isPublished() != null ? updatePageEntity.isPublished().booleanValue() : withUpdatePage.isPublished());
        page.setVisibility(updatePageEntity.getVisibility() != null ? updatePageEntity.getVisibility().name() : withUpdatePage.getVisibility());
        PageSource pageSource = PageServiceImpl.convert(updatePageEntity.getSource());
        page.setSource(pageSource != null ? pageSource : withUpdatePage.getSource());
        page.setConfiguration(updatePageEntity.getConfiguration() != null ? updatePageEntity.getConfiguration() : withUpdatePage.getConfiguration());
        page.setHomepage(updatePageEntity.isHomepage() != null ? updatePageEntity.isHomepage().booleanValue() : withUpdatePage.isHomepage());
        page.setExcludedAccessControls(updatePageEntity.isExcludedAccessControls() != null ? updatePageEntity.isExcludedAccessControls().booleanValue() : withUpdatePage.isExcludedAccessControls());
        page.setAccessControls(updatePageEntity.getAccessControls() != null ? PageServiceImpl.convertACL(updatePageEntity.getAccessControls()) : withUpdatePage.getAccessControls());
        List pageMediaList = PageServiceImpl.convertMediaEntity(updatePageEntity.getAttachedMedia());
        page.setAttachedMedia(pageMediaList != null ? pageMediaList : withUpdatePage.getAttachedMedia());
        page.setParentId((String)(updatePageEntity.getParentId() != null ? (updatePageEntity.getParentId().isEmpty() ? null : updatePageEntity.getParentId()) : withUpdatePage.getParentId()));
        return page;
    }

    private static Page convert(UpdatePageEntity updatePageEntity) {
        Page page = new Page();
        page.setCrossId(updatePageEntity.getCrossId());
        page.setName(updatePageEntity.getName());
        page.setContent(updatePageEntity.getContent());
        page.setLastContributor(updatePageEntity.getLastContributor());
        page.setOrder(updatePageEntity.getOrder().intValue());
        page.setPublished(Boolean.TRUE.equals(updatePageEntity.isPublished()));
        if (updatePageEntity.getVisibility() != null) {
            page.setVisibility(updatePageEntity.getVisibility().name());
        }
        page.setSource(PageServiceImpl.convert(updatePageEntity.getSource()));
        page.setConfiguration(updatePageEntity.getConfiguration());
        page.setHomepage(Boolean.TRUE.equals(updatePageEntity.isHomepage()));
        page.setExcludedAccessControls(Boolean.TRUE.equals(updatePageEntity.isExcludedAccessControls()));
        page.setAccessControls(PageServiceImpl.convertACL(updatePageEntity.getAccessControls()));
        page.setAttachedMedia(PageServiceImpl.convertMediaEntity(updatePageEntity.getAttachedMedia()));
        page.setParentId("".equals(updatePageEntity.getParentId()) ? null : updatePageEntity.getParentId());
        page.setMetadata(updatePageEntity.getMetadata());
        page.setUseAutoFetch(updatePageEntity.getUseAutoFetch());
        return page;
    }

    private static PageSource convert(PageSourceEntity pageSourceEntity) {
        PageSource source = null;
        if (pageSourceEntity != null && pageSourceEntity.getType() != null && pageSourceEntity.getConfiguration() != null) {
            source = new PageSource();
            source.setType(pageSourceEntity.getType());
            source.setConfiguration(pageSourceEntity.getConfiguration());
        }
        return source;
    }

    private static boolean isJson(String content) {
        try {
            gson.fromJson(content, Object.class);
            return true;
        }
        catch (JsonSyntaxException ex) {
            return false;
        }
    }

    private static List<PageMediaEntity> convertMedia(List<PageMedia> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(PageServiceImpl::convertMedia).collect(Collectors.toList());
    }

    private static PageMediaEntity convertMedia(PageMedia pm) {
        PageMediaEntity pageMediaEntity = new PageMediaEntity();
        pageMediaEntity.setMediaHash(pm.getMediaHash());
        pageMediaEntity.setMediaName(pm.getMediaName());
        pageMediaEntity.setAttachedAt(pm.getAttachedAt());
        return pageMediaEntity;
    }

    private static List<PageMedia> convertMediaEntity(List<PageMediaEntity> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(PageServiceImpl::convertMediaEntity).collect(Collectors.toList());
    }

    private static PageMedia convertMediaEntity(PageMediaEntity pme) {
        PageMedia pageMedia = new PageMedia();
        pageMedia.setMediaHash(pme.getMediaHash());
        pageMedia.setMediaName(pme.getMediaName());
        pageMedia.setAttachedAt(pme.getAttachedAt());
        return pageMedia;
    }

    private PageSituation getPageSituation(String pageId) throws TechnicalException {
        if (pageId == null) {
            return PageSituation.ROOT;
        }
        Optional optionalPage = this.pageRepository.findById(pageId);
        if (optionalPage.isPresent()) {
            Page page = (Page)optionalPage.get();
            if (PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(page.getType())) {
                return PageSituation.SYSTEM_FOLDER;
            }
            if (PageType.TRANSLATION.name().equalsIgnoreCase(page.getType())) {
                return PageSituation.TRANSLATION;
            }
            String parentId = page.getParentId();
            if (parentId == null) {
                return PageSituation.IN_ROOT;
            }
            Optional optionalParent = this.pageRepository.findById(parentId);
            if (optionalParent.isPresent()) {
                Page parentPage = (Page)optionalParent.get();
                if (PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(parentPage.getType())) {
                    return PageSituation.IN_SYSTEM_FOLDER;
                }
                if (PageType.FOLDER.name().equalsIgnoreCase(parentPage.getType())) {
                    String grandParentId = parentPage.getParentId();
                    if (grandParentId == null) {
                        return PageSituation.IN_FOLDER_IN_ROOT;
                    }
                    Optional optionalGrandParent = this.pageRepository.findById(grandParentId);
                    if (optionalGrandParent.isPresent()) {
                        Page grandParentPage = (Page)optionalGrandParent.get();
                        if (PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(grandParentPage.getType())) {
                            return PageSituation.IN_FOLDER_IN_SYSTEM_FOLDER;
                        }
                        if (PageType.FOLDER.name().equalsIgnoreCase(grandParentPage.getType())) {
                            return PageSituation.IN_FOLDER_IN_FOLDER;
                        }
                    }
                }
            }
        }
        logger.debug("Impossible to determine page situation for the page " + pageId);
        return null;
    }

    @Override
    public boolean isPageUsedAsGeneralConditions(ExecutionContext executionContext, PageEntity page, String apiId) {
        boolean result = false;
        if (PageType.MARKDOWN.name().equals(page.getType())) {
            Optional<PlanEntity> optPlan = this.planService.findByApi(executionContext, apiId).stream().filter(p -> p.getGeneralConditions() != null).filter(p -> !PlanStatus.CLOSED.equals((Object)p.getStatus()) && !PlanStatus.STAGING.equals((Object)p.getStatus())).filter(p -> page.getId().equals(p.getGeneralConditions())).findFirst();
            result = optPlan.isPresent();
        }
        return result;
    }

    @Override
    public io.gravitee.common.data.domain.Page<PageEntity> findAll(Pageable pageable) {
        Objects.requireNonNull(pageable, "FindAll requires a pageable parameter");
        logger.debug("Find all pages with pageNumber {} and pageSize {}", (Object)pageable.getPageNumber(), (Object)pageable.getPageSize());
        try {
            io.gravitee.common.data.domain.Page pages = this.pageRepository.findAll(PageServiceImpl.convert(pageable));
            List entities = pages.getContent().stream().map(this::convert).collect(Collectors.toList());
            logger.debug("{} pages found", (Object)pages.getPageElements());
            return new io.gravitee.common.data.domain.Page(entities, pages.getPageNumber(), entities.size(), pages.getTotalElements());
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    @Override
    public PageEntity findById(String pageId) {
        return this.findById(pageId, null);
    }

    @Override
    public PageEntity findById(String pageId, String acceptedLocale) {
        try {
            logger.debug("Find page by ID: {}", (Object)pageId);
            Optional page = this.pageRepository.findById(pageId);
            if (page.isPresent()) {
                String contentPageId = pageId;
                PageEntity foundPageEntity = this.convert((Page)page.get());
                if (acceptedLocale != null && !acceptedLocale.isEmpty()) {
                    Page translation = this.getTranslation(foundPageEntity, acceptedLocale);
                    if (translation != null) {
                        String inheritContent;
                        String translationName = translation.getName();
                        if (translationName != null && !translationName.isEmpty()) {
                            foundPageEntity.setName(translationName);
                        }
                        if ((inheritContent = (String)translation.getConfiguration().get("inheritContent")) != null && "false".equals(inheritContent)) {
                            foundPageEntity.setContent(translation.getContent());
                        }
                        contentPageId = translation.getId();
                    }
                } else {
                    List<PageEntity> translations = this.convert(this.getTranslations(foundPageEntity.getId()));
                    if (translations != null && !translations.isEmpty()) {
                        foundPageEntity.setTranslations(translations);
                    }
                }
                this.fillContentRevisionId(foundPageEntity, contentPageId);
                return foundPageEntity;
            }
            throw new PageNotFoundException(pageId);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to find a page using its ID {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find a page using its ID " + pageId, ex);
        }
    }

    private void fillContentRevisionId(PageEntity foundPageEntity, String pageId) {
        if (foundPageEntity.getType() != null && this.shouldHaveRevision(foundPageEntity.getType())) {
            Optional<PageRevisionEntity> revision = this.pageRevisionService.findLastByPageId(pageId);
            if (revision.isPresent()) {
                foundPageEntity.setContentRevisionId(new PageEntity.PageRevisionId(revision.get().getPageId(), revision.get().getRevision()));
            } else {
                logger.info("Revision is missing for the page {}", (Object)pageId);
            }
        }
    }

    @Override
    public void transformSwagger(ExecutionContext executionContext, PageEntity pageEntity) {
        String apiId = null;
        if (pageEntity instanceof ApiPageEntity) {
            apiId = ((ApiPageEntity)pageEntity).getApi();
        }
        this.transformSwagger(executionContext, pageEntity, apiId);
    }

    @Override
    public void transformSwagger(ExecutionContext executionContext, PageEntity pageEntity, String apiId) {
        if (apiId != null) {
            this.transformWithTemplate(executionContext, pageEntity, apiId);
        }
        if (this.markdownSanitize && PageType.MARKDOWN.name().equalsIgnoreCase(pageEntity.getType())) {
            HtmlSanitizer.SanitizeInfos safe = HtmlSanitizer.isSafe(pageEntity.getContent());
            if (!safe.isSafe()) {
                pageEntity.setContent(HtmlSanitizer.sanitize(pageEntity.getContent()));
            }
        } else if (PageType.SWAGGER.name().equalsIgnoreCase(pageEntity.getType())) {
            SwaggerDescriptor descriptor;
            try {
                descriptor = this.swaggerService.parse(pageEntity.getContent());
            }
            catch (SwaggerDescriptorException sde) {
                if (apiId != null) {
                    logger.error("Parsing error for API id[{}]: {}", (Object)apiId, (Object)sde.getMessage());
                }
                throw sde;
            }
            ArrayList transformers = new ArrayList();
            transformers.add(new PageConfigurationOAITransformer(pageEntity));
            if (apiId != null) {
                ApiEntity api = this.apiService.findById(executionContext, apiId);
                transformers.add(new EntrypointsOAITransformer(pageEntity, api));
            }
            this.swaggerService.transform((OAIDescriptor)descriptor, transformers);
            if (pageEntity.getContentType().equalsIgnoreCase("application/json")) {
                try {
                    pageEntity.setContent(descriptor.toJson());
                }
                catch (JsonProcessingException e) {
                    logger.error("Unexpected error", (Throwable)e);
                }
            } else {
                try {
                    pageEntity.setContent(descriptor.toYaml());
                }
                catch (JsonProcessingException e) {
                    logger.error("Unexpected error", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<PageEntity> search(String environmentId, PageQuery query) {
        return this.search(environmentId, query, false);
    }

    @Override
    public List<PageEntity> search(String environmentId, PageQuery query, boolean withTranslations) {
        return this.search(environmentId, query, null, withTranslations, true);
    }

    @Override
    public List<PageEntity> search(String environmentId, PageQuery query, String acceptedLocale) {
        return this.search(environmentId, query, acceptedLocale, false, true);
    }

    private List<PageEntity> search(String environmentId, PageQuery query, String acceptedLocale, boolean withTranslations, boolean withLinks) {
        try {
            Stream<Object> pagesStream = this.pageRepository.search(this.queryToCriteria(query, environmentId)).stream();
            if (!withTranslations) {
                pagesStream = pagesStream.filter(page -> !PageType.TRANSLATION.name().equals(page.getType()));
            }
            if (!withLinks) {
                pagesStream = pagesStream.filter(page -> !PageType.LINK.name().equals(page.getType()));
            }
            List<PageEntity> pages = pagesStream.map(this::convert).collect(Collectors.toList());
            if (acceptedLocale == null || acceptedLocale.isEmpty()) {
                pages.forEach(p -> {
                    List<PageEntity> translations;
                    if (!PageType.TRANSLATION.name().equals(p.getType()) && (translations = this.convert(this.getTranslations(p.getId()))) != null && !translations.isEmpty()) {
                        p.setTranslations(translations);
                    }
                });
            } else {
                pages.forEach(p -> {
                    Page translation;
                    if (!PageType.TRANSLATION.name().equals(p.getType()) && (translation = this.getTranslation((PageEntity)p, acceptedLocale)) != null) {
                        String inheritContent;
                        String translationName = translation.getName();
                        if (translationName != null && !translationName.isEmpty()) {
                            p.setName(translationName);
                        }
                        if ((inheritContent = (String)translation.getConfiguration().get("inheritContent")) != null && "false".equals(inheritContent)) {
                            p.setContent(translation.getContent());
                        }
                    }
                });
            }
            if (query != null && query.getPublished() != null && query.getPublished().booleanValue() || !this.isAuthenticated()) {
                return pages.stream().filter(page -> {
                    if (page.getParentId() != null) {
                        PageEntity parent = this.findById(page.getParentId());
                        if (!this.isAuthenticated()) {
                            return parent.isPublished() && Visibility.PUBLIC.equals((Object)parent.getVisibility());
                        }
                        return parent.isPublished();
                    }
                    return true;
                }).collect(Collectors.toList());
            }
            return pages;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private Page getTranslation(PageEntity pageToTranslate, String acceptedLocale) {
        if (PageType.LINK.name().equals(pageToTranslate.getType()) && pageToTranslate.getConfiguration() != null && "true".equals(pageToTranslate.getConfiguration().get("inherit"))) {
            Page relatedTranslation = this.getTranslation(pageToTranslate.getContent(), acceptedLocale);
            Page linkTranslation = null;
            if (relatedTranslation != null) {
                linkTranslation = new Page();
                linkTranslation.setName(relatedTranslation.getName());
                linkTranslation.setContent(relatedTranslation.getContent());
                linkTranslation.setConfiguration(Collections.emptyMap());
            }
            return linkTranslation;
        }
        return this.getTranslation(pageToTranslate.getId(), acceptedLocale);
    }

    private Page getTranslation(String pageId, String acceptedLocale) {
        try {
            Optional<Page> optTranslation = this.pageRepository.search(new PageCriteria.Builder().parent(pageId).type(PageType.TRANSLATION.name()).build()).stream().filter(t -> acceptedLocale.equalsIgnoreCase((String)t.getConfiguration().get("lang"))).findFirst();
            if (optTranslation.isPresent()) {
                return optTranslation.get();
            }
            return null;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    @Override
    public void transformWithTemplate(ExecutionContext executionContext, PageEntity pageEntity, String api) {
        if (pageEntity.getContent() != null) {
            HashMap model = new HashMap();
            if (api == null) {
                List<MetadataEntity> metadataList = this.metadataService.findAllDefault();
                if (metadataList != null) {
                    HashMap mapMetadata = new HashMap(metadataList.size());
                    metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue()));
                    model.put("metadata", mapMetadata);
                }
            } else {
                ApiModelEntity apiEntity = this.apiService.findByIdForTemplates(executionContext, api, true);
                model.put("api", apiEntity);
            }
            try {
                String content = this.notificationTemplateService.resolveInlineTemplateWithParam(executionContext.getOrganizationId(), pageEntity.getId(), pageEntity.getContent(), model, false);
                pageEntity.setContent(content);
            }
            catch (TemplateProcessingException e) {
                if (pageEntity.getMessages() == null) {
                    pageEntity.setMessages(new ArrayList());
                }
                pageEntity.getMessages().add("Invalid expression or value is missing for " + e.getBlamedExpressionString());
            }
        }
    }

    @Override
    public PageEntity createPage(ExecutionContext executionContext, String apiId, NewPageEntity newPageEntity) {
        return this.createPage(executionContext, apiId, newPageEntity, null);
    }

    private PageEntity createPage(ExecutionContext executionContext, String apiId, NewPageEntity newPageEntity, String pageId) {
        try {
            logger.debug("Create page {} for API {}", (Object)newPageEntity, (Object)apiId);
            String id = pageId != null && UUID.fromString(pageId) != null ? pageId : UuidString.generateRandom();
            PageType newPageType = newPageEntity.getType();
            if (newPageEntity.getVisibility() == null) {
                newPageEntity.setVisibility(Visibility.PUBLIC);
            }
            boolean createRevision = false;
            if (newPageEntity.getExcludedGroups() != null && !newPageEntity.getExcludedGroups().isEmpty()) {
                newPageEntity.setVisibility(Visibility.PRIVATE);
                newPageEntity.setExcludedAccessControls(true);
                newPageEntity.setAccessControls(newPageEntity.getExcludedGroups().stream().map(groupId -> {
                    AccessControlEntity accessControl = new AccessControlEntity();
                    accessControl.setReferenceType("GROUP");
                    accessControl.setReferenceId(groupId);
                    return accessControl;
                }).collect(Collectors.toSet()));
            }
            if (PageType.TRANSLATION.equals((Object)newPageType)) {
                this.checkTranslationConsistency(newPageEntity.getParentId(), newPageEntity.getConfiguration(), true);
                Optional optTranslatedPage = this.pageRepository.findById(newPageEntity.getParentId());
                if (optTranslatedPage.isPresent()) {
                    newPageEntity.setPublished(((Page)optTranslatedPage.get()).isPublished());
                    createRevision = this.isSwaggerOrMarkdown(((Page)optTranslatedPage.get()).getType());
                }
            }
            if (PageType.FOLDER.equals((Object)newPageType)) {
                this.checkFolderConsistency(newPageEntity);
            }
            if (PageType.LINK.equals((Object)newPageType)) {
                String resourceType = (String)newPageEntity.getConfiguration().get("resourceType");
                String content = newPageEntity.getContent();
                if (content == null || content.isEmpty()) {
                    throw new PageActionException(PageType.LINK, "be created. It must have a URL, a page Id or a category Id");
                }
                if ("root".equals(content) || "external".equals(resourceType) || "category".equals(resourceType)) {
                    newPageEntity.setPublished(true);
                } else {
                    Optional optionalRelatedPage = this.pageRepository.findById(content);
                    if (optionalRelatedPage.isPresent()) {
                        Page relatedPage = (Page)optionalRelatedPage.get();
                        this.checkLinkRelatedPageType(relatedPage);
                        newPageEntity.setPublished(relatedPage.isPublished());
                        newPageEntity.setVisibility(Visibility.valueOf((String)relatedPage.getVisibility()));
                    }
                }
            }
            if (PageType.SWAGGER == newPageType || PageType.MARKDOWN == newPageType) {
                this.checkMarkdownOrSwaggerConsistency(newPageEntity, newPageType);
                createRevision = true;
            }
            if (newPageEntity.getContent() == null && newPageEntity.getSource() != null) {
                this.fetchPage((FetchablePageEntity)newPageEntity);
            }
            Page page = PageServiceImpl.convert(newPageEntity);
            page.setId(id);
            if (StringUtils.isEmpty((CharSequence)apiId)) {
                page.setReferenceId(executionContext.getEnvironmentId());
                page.setReferenceType(PageReferenceType.ENVIRONMENT);
            } else {
                page.setReferenceId(apiId);
                page.setReferenceType(PageReferenceType.API);
            }
            page.setCreatedAt(new Date());
            page.setUpdatedAt(page.getCreatedAt());
            List<String> messages = this.validateSafeContent(executionContext, page);
            Page createdPage = this.pageRepository.create(page);
            if (createRevision) {
                this.createPageRevision(createdPage);
            }
            this.onlyOneHomepage(page);
            this.createAuditLog(executionContext, PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_CREATED, page.getCreatedAt(), null, page);
            PageEntity pageEntity = this.convert(createdPage);
            if (messages != null && messages.size() > 0) {
                pageEntity.setMessages(messages);
            }
            this.index(executionContext, pageEntity);
            return pageEntity;
        }
        catch (FetcherException | TechnicalException ex) {
            logger.error("An error occurs while trying to create {}", (Object)newPageEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + newPageEntity, ex);
        }
    }

    private void createPageRevision(Page page) {
        try {
            if (PageType.valueOf((String)page.getType()) == PageType.TRANSLATION && page.getConfiguration() != null && !page.getConfiguration().isEmpty() && ((String)page.getConfiguration().get("inheritContent")).equalsIgnoreCase("true")) {
                String translatedPageId = page.getParentId();
                this.pageRepository.findById(translatedPageId).ifPresent(translatedPage -> page.setContent(translatedPage.getContent()));
            }
            this.pageRevisionService.create(page);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to create a revision for {}", (Object)page, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create a revision for " + page, ex);
        }
    }

    private void checkMarkdownOrSwaggerConsistency(NewPageEntity newPageEntity, PageType newPageType) throws TechnicalException {
        PageSituation newPageParentSituation = this.getPageSituation(newPageEntity.getParentId());
        if (newPageParentSituation == PageSituation.SYSTEM_FOLDER || newPageParentSituation == PageSituation.IN_SYSTEM_FOLDER) {
            throw new PageActionException(newPageType, "be created under a system folder");
        }
    }

    private void checkFolderConsistency(NewPageEntity newPageEntity) throws TechnicalException {
        if (newPageEntity.getContent() != null && newPageEntity.getContent().length() > 0) {
            throw new PageFolderActionException("have a content");
        }
        if (newPageEntity.isHomepage()) {
            throw new PageFolderActionException("be affected to the home page");
        }
        PageSituation newPageParentSituation = this.getPageSituation(newPageEntity.getParentId());
        if (newPageParentSituation == PageSituation.IN_SYSTEM_FOLDER) {
            throw new PageFolderActionException("be created in a folder of a system folder");
        }
    }

    private Optional<PageEntity> findSystemFolder(String environmentId, String apiId) {
        PageQuery pageQuery = new PageQuery.Builder().api(apiId).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build();
        return this.search(environmentId, pageQuery).stream().findFirst();
    }

    private void checkTranslationConsistency(String parentId, Map<String, String> configuration, boolean forCreation) throws TechnicalException {
        if (parentId == null || parentId.isEmpty()) {
            throw new PageActionException(PageType.TRANSLATION, "have no parentId");
        }
        if (configuration == null || configuration.get("lang") == null || configuration.get("lang").isEmpty()) {
            throw new PageActionException(PageType.TRANSLATION, "have no configured language");
        }
        Optional optTranslatedPage = this.pageRepository.findById(parentId);
        if (optTranslatedPage.isPresent()) {
            String newTranslationLang;
            Page existingTranslation;
            Page translatedPage = (Page)optTranslatedPage.get();
            PageType translatedPageType = PageType.valueOf((String)translatedPage.getType());
            if (PageType.ROOT == translatedPageType || PageType.SYSTEM_FOLDER == translatedPageType || PageType.TRANSLATION == translatedPageType) {
                throw new PageActionException(PageType.TRANSLATION, "have a parent with type " + translatedPageType.name() + ". Parent " + parentId + " is not one of this type : FOLDER, LINK, MARKDOWN, SWAGGER");
            }
            if (forCreation && (existingTranslation = this.getTranslation(parentId, newTranslationLang = configuration.get("lang"))) != null) {
                throw new PageActionException(PageType.TRANSLATION, "be created. A translation for this language already exist");
            }
        }
    }

    private void checkLinkRelatedPageType(Page relatedPage) throws TechnicalException {
        PageSituation relatedPageSituation = this.getPageSituation(relatedPage.getId());
        if (PageType.LINK.name().equalsIgnoreCase(relatedPage.getType()) || PageType.SYSTEM_FOLDER.name().equalsIgnoreCase(relatedPage.getType()) || PageType.FOLDER.name().equalsIgnoreCase(relatedPage.getType()) && relatedPageSituation == PageSituation.IN_SYSTEM_FOLDER) {
            throw new PageActionException(PageType.LINK, "be related to a Link, a System folder or a folder in a System folder");
        }
    }

    @Override
    public PageEntity createPage(ExecutionContext executionContext, NewPageEntity newPageEntity) {
        return this.createPage(executionContext, null, newPageEntity);
    }

    @Override
    public PageEntity create(ExecutionContext executionContext, String apiId, PageEntity pageEntity) {
        NewPageEntity newPageEntity = this.pageConverter.toNewPageEntity(pageEntity);
        newPageEntity.setLastContributor(null);
        return this.createPage(executionContext, apiId, newPageEntity);
    }

    private void onlyOneHomepage(Page page) throws TechnicalException {
        if (page.isHomepage()) {
            List pages = this.pageRepository.search(new PageCriteria.Builder().referenceId(page.getReferenceId()).referenceType(page.getReferenceType().name()).homepage(Boolean.valueOf(true)).build());
            pages.stream().filter(i -> !i.getId().equals(page.getId())).forEach(i -> {
                try {
                    i.setHomepage(false);
                    this.pageRepository.update(i);
                }
                catch (TechnicalException e) {
                    logger.error("An error occurs while trying update homepage attribute from {}", (Object)page, (Object)e);
                }
            });
        }
    }

    @Override
    public PageEntity update(ExecutionContext executionContext, String pageId, UpdatePageEntity updatePageEntity) {
        return this.update(executionContext, pageId, updatePageEntity, false);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public PageEntity update(ExecutionContext executionContext, String pageId, UpdatePageEntity updatePageEntity, boolean partial) {
        try {
            PageServiceImpl.logger.debug("Update Page {}", (Object)pageId);
            optPageToUpdate = this.pageRepository.findById(pageId);
            if (!optPageToUpdate.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            pageToUpdate = (Page)optPageToUpdate.get();
            page = null;
            pageType = pageToUpdate.getType();
            createRevision = false;
            if (PageType.LINK.name().equalsIgnoreCase(pageType)) {
                newResourceRef = updatePageEntity.getContent();
                actualResourceRef = pageToUpdate.getContent();
                if (newResourceRef != null && !newResourceRef.equals(actualResourceRef)) {
                    v0 = resourceType = updatePageEntity.getConfiguration() != null ? (String)updatePageEntity.getConfiguration().get("resourceType") : (String)pageToUpdate.getConfiguration().get("resourceType");
                    if ("external".equals(resourceType) && updatePageEntity.getContent() != null && updatePageEntity.getContent().isEmpty()) {
                        throw new PageActionException(PageType.LINK, "be created. An external Link must have a URL");
                    }
                    if ("root".equals(newResourceRef) || "external".equals(resourceType) || "category".equals(resourceType)) {
                        updatePageEntity.setPublished(Boolean.valueOf(true));
                    } else {
                        optionalRelatedPage = this.pageRepository.findById(newResourceRef);
                        if (optionalRelatedPage.isPresent()) {
                            relatedPage = (Page)optionalRelatedPage.get();
                            this.checkLinkRelatedPageType(relatedPage);
                            updatePageEntity.setPublished(Boolean.valueOf(relatedPage.isPublished()));
                        }
                    }
                } else if (newResourceRef != null && newResourceRef.equals(actualResourceRef)) {
                    updatePageEntity.setPublished(Boolean.valueOf(pageToUpdate.isPublished()));
                }
            }
            if (PageType.TRANSLATION.name().equalsIgnoreCase(pageType)) {
                parentId = updatePageEntity.getParentId() != null && updatePageEntity.getParentId().isEmpty() == false ? updatePageEntity.getParentId() : pageToUpdate.getParentId();
                configuration = updatePageEntity.getConfiguration() != null ? updatePageEntity.getConfiguration() : pageToUpdate.getConfiguration();
                this.checkTranslationConsistency(parentId, configuration, false);
                hasChanged = this.pageHasChanged(updatePageEntity, pageToUpdate);
                optParentPage = this.pageRepository.findById(parentId);
                if (optParentPage.isPresent()) {
                    v1 = createRevision = this.isSwaggerOrMarkdown(((Page)optParentPage.get()).getType()) != false && hasChanged != false;
                }
            }
            if (updatePageEntity.getParentId() != null && !updatePageEntity.getParentId().equals(pageToUpdate.getParentId())) {
                this.checkUpdatedPageSituation(updatePageEntity, pageType, pageId);
                if (PageType.TRANSLATION.name().equalsIgnoreCase(pageType) && (optionalTranslatedPage = this.pageRepository.findById(updatePageEntity.getParentId())).isPresent()) {
                    updatePageEntity.setPublished(Boolean.valueOf(((Page)optionalTranslatedPage.get()).isPublished()));
                }
            }
            if (updatePageEntity.getExcludedGroups() != null && !updatePageEntity.getExcludedGroups().isEmpty()) {
                updatePageEntity.setVisibility(Visibility.PRIVATE);
                updatePageEntity.setExcludedAccessControls(Boolean.valueOf(true));
                accessControlEntities = updatePageEntity.getAccessControls() != null ? updatePageEntity.getAccessControls() : new HashSet<E>();
                accessControlEntities.addAll(updatePageEntity.getExcludedGroups().stream().map((Function<String, AccessControlEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$update$15(java.lang.String ), (Ljava/lang/String;)Lio/gravitee/rest/api/model/AccessControlEntity;)()).collect(Collectors.toSet()));
                updatePageEntity.setAccessControls((Set)accessControlEntities);
                updatePageEntity.setExcludedGroups(updatePageEntity.getExcludedGroups());
            }
            if (updatePageEntity.getSource() != null) {
                try {
                    if (updatePageEntity.getContent() != null) ** GOTO lbl56
                    this.fetchPage((FetchablePageEntity)updatePageEntity);
                }
                catch (FetcherException e) {
                    throw this.onUpdateFail(pageId, e);
                }
            } else {
                updatePageEntity.setUseAutoFetch(null);
            }
lbl56:
            // 3 sources

            page = partial != false ? PageServiceImpl.merge(updatePageEntity, pageToUpdate) : PageServiceImpl.convert(updatePageEntity);
            try {
                if (page.getSource() != null && page.getSource().getConfiguration() != null) {
                    newFetcherConfiguration = this.getFetcher(page.getSource()).getConfiguration();
                    if (newFetcherConfiguration.isAutoFetch()) {
                        page.setUseAutoFetch(Boolean.TRUE);
                    } else {
                        page.setUseAutoFetch(null);
                    }
                    if (pageToUpdate.getSource() != null && pageToUpdate.getSource().getConfiguration() != null) {
                        originalFetcherConfiguration = this.getFetcher(pageToUpdate.getSource()).getConfiguration();
                        this.mergeSensitiveData(originalFetcherConfiguration, page);
                    }
                }
            }
            catch (FetcherException e) {
                throw this.onUpdateFail(pageId, e);
            }
            if (this.isSwaggerOrMarkdown(pageType)) {
                createRevision = this.pageHasChanged(pageToUpdate, page);
            }
            page.setId(pageId);
            page.setUpdatedAt(new Date());
            page.setCreatedAt(pageToUpdate.getCreatedAt());
            page.setType(pageType);
            page.setReferenceId(pageToUpdate.getReferenceId());
            page.setReferenceType(pageToUpdate.getReferenceType());
            if (page.getVisibility() == null) {
                page.setVisibility(pageToUpdate.getVisibility());
            }
            if (page.getCrossId() == null) {
                page.setCrossId(pageToUpdate.getCrossId());
            }
            this.onlyOneHomepage(page);
            if (PageReferenceType.API.equals((Object)pageToUpdate.getReferenceType()) && updatePageEntity.isPublished() != null && !updatePageEntity.isPublished().booleanValue() && (activePlan = this.planService.findByApi(executionContext, pageToUpdate.getReferenceId()).stream().filter((Predicate<PlanEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$update$16(io.gravitee.rest.api.model.PlanEntity ), (Lio/gravitee/rest/api/model/PlanEntity;)Z)()).filter((Predicate<PlanEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$update$17(io.gravitee.repository.management.model.Page io.gravitee.rest.api.model.PlanEntity ), (Lio/gravitee/rest/api/model/PlanEntity;)Z)((Page)pageToUpdate)).filter((Predicate<PlanEntity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$update$18(io.gravitee.rest.api.model.PlanEntity ), (Lio/gravitee/rest/api/model/PlanEntity;)Z)()).findFirst()).isPresent()) {
                throw new PageUsedAsGeneralConditionsException(pageId, page.getName(), "unpublish", activePlan.get().getName());
            }
            if (PageReferenceType.ENVIRONMENT.equals((Object)pageToUpdate.getReferenceType()) && updatePageEntity.isPublished() != null && !updatePageEntity.isPublished().booleanValue() && !(categoriesUsingPage = this.categoryService.findByPage(pageId)).isEmpty()) {
                categoriesName = categoriesUsingPage.stream().map((Function<CategoryEntity, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getName(), (Lio/gravitee/rest/api/model/CategoryEntity;)Ljava/lang/String;)()).collect(Collectors.joining(", ", "{ ", " }"));
                throw new PageUsedByCategoryException(pageId, page.getName(), "unpublish", categoriesName);
            }
            if (page.getOrder() != pageToUpdate.getOrder()) {
                this.reorderAndSavePages(page);
            }
            messages = this.validateSafeContent(executionContext, page);
            updatedPage = this.pageRepository.update(page);
            if (!(pageToUpdate.isPublished() == page.isPublished() && Objects.equals(pageToUpdate.getVisibility(), page.getVisibility()) || PageType.LINK.name().equalsIgnoreCase(pageType) || PageType.TRANSLATION.name().equalsIgnoreCase(pageType))) {
                newVisibility = updatePageEntity.getVisibility() == null ? pageToUpdate.getVisibility() : updatePageEntity.getVisibility().name();
                this.changeRelatedPagesPublicationStatusAndVisibility(pageId, updatePageEntity.isPublished(), newVisibility);
            }
            this.createAuditLog(executionContext, PageReferenceType.API.equals((Object)page.getReferenceType()) != false ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_UPDATED, page.getUpdatedAt(), pageToUpdate, page);
            if (createRevision) {
                this.createPageRevision(updatedPage);
            }
            pageEntity = this.convert(updatedPage);
            pageEntity.setMessages(messages);
            if (pageToUpdate.isPublished() && !page.isPublished()) {
                this.searchEngineService.delete(executionContext, (Indexable)this.convert(pageToUpdate));
            } else {
                this.index(executionContext, pageEntity);
            }
            return pageEntity;
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private boolean pageHasChanged(UpdatePageEntity updatePageEntity, Page pageToUpdate) {
        return this.pageHasChanged(PageServiceImpl.convert(updatePageEntity), pageToUpdate);
    }

    private boolean pageHasChanged(Page updatedPage, Page pageToUpdate) {
        String newContent = updatedPage.getContent();
        String actualContent = pageToUpdate.getContent();
        String newName = updatedPage.getName();
        String actualName = pageToUpdate.getName();
        boolean hasChanged = newContent != null && !newContent.equals(actualContent) || newName != null && !newName.equals(actualName);
        return hasChanged;
    }

    private boolean isSwaggerOrMarkdown(String pageType) {
        return PageType.SWAGGER.name().equalsIgnoreCase(pageType) || PageType.MARKDOWN.name().equalsIgnoreCase(pageType);
    }

    private void checkUpdatedPageSituation(UpdatePageEntity updatePageEntity, String pageType, String pageId) throws TechnicalException {
        PageSituation newParentSituation = this.getPageSituation(updatePageEntity.getParentId());
        switch (pageType) {
            case "SYSTEM_FOLDER": {
                if (newParentSituation == PageSituation.ROOT) break;
                throw new PageActionException(PageType.SYSTEM_FOLDER, " be moved in this folder");
            }
            case "MARKDOWN": {
                if (newParentSituation != PageSituation.SYSTEM_FOLDER && newParentSituation != PageSituation.IN_SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.MARKDOWN, " be moved in a system folder or in a folder of a system folder");
            }
            case "SWAGGER": {
                if (newParentSituation != PageSituation.SYSTEM_FOLDER && newParentSituation != PageSituation.IN_SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.SWAGGER, " be moved in a system folder or in a folder of a system folder");
            }
            case "FOLDER": {
                PageSituation folderSituation = this.getPageSituation(pageId);
                if (folderSituation == PageSituation.IN_SYSTEM_FOLDER && newParentSituation != PageSituation.SYSTEM_FOLDER) {
                    throw new PageActionException(PageType.FOLDER, " be moved anywhere other than in a system folder");
                }
                if (folderSituation == PageSituation.IN_SYSTEM_FOLDER || newParentSituation != PageSituation.SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.FOLDER, " be moved in a system folder");
            }
            case "LINK": {
                if (newParentSituation == PageSituation.SYSTEM_FOLDER || newParentSituation == PageSituation.IN_SYSTEM_FOLDER) break;
                throw new PageActionException(PageType.LINK, " be moved anywhere other than in a system folder or in a folder of a system folder");
            }
            case "TRANSLATION": {
                if (newParentSituation != PageSituation.ROOT && newParentSituation != PageSituation.SYSTEM_FOLDER && newParentSituation != PageSituation.TRANSLATION) break;
                throw new PageActionException(PageType.TRANSLATION, "be updated. Parent " + updatePageEntity.getParentId() + " is not one of this type : FOLDER, LINK, MARKDOWN, SWAGGER");
            }
        }
    }

    private void changeRelatedPagesPublicationStatusAndVisibility(String pageId, Boolean published, String newVisibility) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().type(PageType.LINK.name()).build()).stream().filter(p -> pageId.equals(p.getContent())).forEach(p -> {
                try {
                    p.setPublished(published.booleanValue());
                    p.setVisibility(newVisibility);
                    this.pageRepository.update(p);
                    this.changeTranslationPagesPublicationStatusAndVisibility(p.getId(), published, newVisibility);
                }
                catch (TechnicalException ex) {
                    throw this.onUpdateFail(p.getId(), ex);
                }
            });
            this.changeTranslationPagesPublicationStatusAndVisibility(pageId, published, newVisibility);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void changeTranslationPagesPublicationStatusAndVisibility(String translatedPageId, Boolean published, String newVisibility) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().parent(translatedPageId).type(PageType.TRANSLATION.name()).build()).stream().forEach(p -> {
                try {
                    p.setPublished(published.booleanValue());
                    p.setVisibility(newVisibility);
                    this.pageRepository.update(p);
                }
                catch (TechnicalException ex) {
                    throw this.onUpdateFail(p.getId(), ex);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void deleteRelatedPages(String pageId) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().type("LINK").build()).stream().filter(p -> pageId.equals(p.getContent())).forEach(p -> {
                try {
                    this.pageRepository.delete(p.getId());
                    this.deleteRelatedTranslations(p.getId());
                }
                catch (TechnicalException ex) {
                    logger.error("An error occurs while trying to delete Page {}", (Object)p.getId(), (Object)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete Page " + p.getId(), ex);
                }
            });
            this.deleteRelatedTranslations(pageId);
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void deleteRelatedTranslations(String pageId) {
        try {
            this.pageRepository.search(new PageCriteria.Builder().parent(pageId).type(PageType.TRANSLATION.name()).build()).stream().forEach(p -> {
                try {
                    this.pageRepository.delete(p.getId());
                }
                catch (TechnicalException ex) {
                    logger.error("An error occurs while trying to delete Page {}", (Object)p.getId(), (Object)ex);
                    throw new TechnicalManagementException("An error occurs while trying to delete Page " + p.getId(), ex);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private void index(ExecutionContext executionContext, PageEntity pageEntity) {
        if (pageEntity.isPublished()) {
            this.searchEngineService.index(executionContext, (Indexable)pageEntity, false);
        }
    }

    private void fetchPage(FetchablePageEntity page) throws FetcherException {
        this.validateSafeSource(page.getSource());
        Fetcher fetcher = this.getFetcher(PageServiceImpl.convert(page.getSource()));
        if (fetcher != null) {
            try {
                Resource resource = fetcher.fetch();
                page.setContent(this.getResourceContentAsString(resource));
                if (resource.getMetadata() != null) {
                    page.setMetadata(new HashMap(resource.getMetadata().size()));
                    for (Map.Entry entry : resource.getMetadata().entrySet()) {
                        if (entry.getValue() instanceof Map) continue;
                        page.getMetadata().put((String)entry.getKey(), String.valueOf(entry.getValue()));
                    }
                }
                if (fetcher.getConfiguration().isAutoFetch()) {
                    page.setUseAutoFetch(Boolean.TRUE);
                } else {
                    page.setUseAutoFetch(null);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new FetcherException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Fetcher getFetcher(PageSource ps) throws FetcherException {
        if (ps == null || ps.getConfiguration().isEmpty()) {
            return null;
        }
        try {
            Fetcher fetcher;
            FetcherPlugin fetcherPlugin = (FetcherPlugin)this.fetcherPluginManager.get(ps.getType());
            ClassLoader fetcherCL = fetcherPlugin.fetcher().getClassLoader();
            if (fetcherPlugin.configuration().isAssignableFrom(FilepathAwareFetcherConfiguration.class)) {
                Class<?> fetcherConfigurationClass = fetcherCL.loadClass(fetcherPlugin.configuration().getName());
                Class<?> fetcherClass = fetcherCL.loadClass(fetcherPlugin.clazz());
                FetcherConfiguration fetcherConfigurationInstance = this.fetcherConfigurationFactory.create(fetcherConfigurationClass, ps.getConfiguration());
                fetcher = (Fetcher)fetcherClass.getConstructor(fetcherConfigurationClass).newInstance(fetcherConfigurationInstance);
            } else {
                Class<?> fetcherConfigurationClass = fetcherCL.loadClass(fetcherPlugin.configuration().getName());
                Class<?> fetcherClass = fetcherCL.loadClass(fetcherPlugin.clazz());
                FetcherConfiguration fetcherConfigurationInstance = this.fetcherConfigurationFactory.create(fetcherConfigurationClass, ps.getConfiguration());
                fetcher = (Fetcher)fetcherClass.getConstructor(fetcherConfigurationClass).newInstance(fetcherConfigurationInstance);
            }
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)fetcher);
            return fetcher;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FetcherException(e.getMessage(), (Throwable)e);
        }
    }

    private String getResourceContentAsString(Resource resource) throws FetcherException {
        try {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.getContent()));){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new FetcherException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<PageEntity> importFiles(ExecutionContext executionContext, ImportPageEntity pageEntity) {
        return this.importFiles(executionContext, null, pageEntity);
    }

    @Override
    public List<PageEntity> importFiles(ExecutionContext executionContext, String apiId, ImportPageEntity pageEntity) {
        Page page = this.upsertRootPage(executionContext, apiId, pageEntity);
        pageEntity.setSource(this.convert(page.getSource(), false));
        return this.fetchPages(executionContext, apiId, pageEntity);
    }

    @Override
    public long execAutoFetch(ExecutionContext executionContext) {
        logger.debug("Auto Fetch pages");
        try {
            List autoFetchPages = this.pageRepository.search(new PageCriteria.Builder().withAutoFetch().build());
            long nbOfFetchedPages = autoFetchPages.stream().filter(pageListItem -> pageListItem.getSource() != null).filter(this::isFetchRequired).map(page -> this.executeAutoFetch(executionContext, (Page)page)).flatMap(Collection::stream).count();
            logger.debug("{} pages fetched", (Object)nbOfFetchedPages);
            return nbOfFetchedPages;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    private boolean isFetchRequired(Page pageItem) {
        boolean fetchRequired = false;
        try {
            String cron;
            Fetcher fetcher = this.getFetcher(pageItem.getSource());
            if (fetcher == null) {
                logger.error("An error occurs while trying to fetch page source");
                throw new TechnicalManagementException("An error occurs while trying to fetch page source");
            }
            FetcherConfiguration configuration = fetcher.getConfiguration();
            if (configuration.isAutoFetch() && (cron = configuration.getFetchCron()) != null && !cron.isEmpty()) {
                CronSequenceGenerator cronSequenceGenerator = new CronSequenceGenerator(cron);
                if (pageItem.getUpdatedAt() != null) {
                    Date nextRun = cronSequenceGenerator.next(pageItem.getUpdatedAt());
                    fetchRequired = nextRun.before(new Date());
                }
            }
        }
        catch (FetcherException e) {
            logger.error("An error occurs while trying to initialize fetcher '{}'", (Object)pageItem.getSource().getType(), (Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("An error occurs while trying to parse the cron expression", (Throwable)e);
        }
        return fetchRequired;
    }

    private List<PageEntity> executeAutoFetch(ExecutionContext executionContext, Page page) {
        try {
            if (page.getType() != null && page.getType().toString().equals("ROOT")) {
                ImportPageEntity pageEntity = new ImportPageEntity();
                pageEntity.setType(PageType.valueOf((String)page.getType().toString()));
                pageEntity.setSource(this.convert(page.getSource(), false));
                pageEntity.setConfiguration(page.getConfiguration());
                pageEntity.setPublished(page.isPublished());
                pageEntity.setExcludedAccessControls(page.isExcludedAccessControls());
                pageEntity.setAccessControls(PageServiceImpl.convertToEntities(page.getAccessControls()));
                pageEntity.setLastContributor(SYSTEM_CONTRIBUTOR);
                pageEntity.setVisibility(Visibility.valueOf((String)page.getVisibility()));
                return this.fetchPages(executionContext, page.getReferenceId(), pageEntity);
            }
            return Arrays.asList(this.fetch(executionContext, page, SYSTEM_CONTRIBUTOR));
        }
        catch (TechnicalException e) {
            logger.error("An error occurs while trying to auto fetch page {}", (Object)page.getId(), (Object)e);
            return Collections.emptyList();
        }
    }

    @Override
    public void fetchAll(ExecutionContext executionContext, PageQuery query, String contributor) {
        try {
            this.pageRepository.search(this.queryToCriteria(query, executionContext.getEnvironmentId())).stream().filter(pageListItem -> pageListItem.getSource() != null).forEach(pageListItem -> {
                if (pageListItem.getType() != null && pageListItem.getType().toString().equals("ROOT")) {
                    ImportPageEntity pageEntity = new ImportPageEntity();
                    pageEntity.setType(PageType.valueOf((String)pageListItem.getType().toString()));
                    pageEntity.setSource(this.convert(pageListItem.getSource(), false));
                    pageEntity.setConfiguration(pageListItem.getConfiguration());
                    pageEntity.setPublished(pageListItem.isPublished());
                    pageEntity.setExcludedAccessControls(pageListItem.isExcludedAccessControls());
                    pageEntity.setAccessControls(PageServiceImpl.convertToEntities(pageListItem.getAccessControls()));
                    pageEntity.setLastContributor(contributor);
                    this.fetchPages(executionContext, query.getApi(), pageEntity);
                } else {
                    this.fetch(executionContext, pageListItem.getId(), contributor);
                }
            });
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to fetch pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to fetch pages", ex);
        }
    }

    private List<PageEntity> importDescriptor(ExecutionContext executionContext, String apiId, ImportPageEntity descriptorPageEntity, FilesFetcher fetcher, GraviteeDescriptorEntity descriptorEntity) {
        if (descriptorEntity.getDocumentation() == null || descriptorEntity.getDocumentation().getPages() == null || descriptorEntity.getDocumentation().getPages().isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, String> parentsIdByPath = new HashMap<String, String>();
        ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
        int order = 0;
        for (GraviteeDescriptorPageEntity descriptorPage : descriptorEntity.getDocumentation().getPages()) {
            NewPageEntity newPage = new NewPageEntity();
            newPage.setName(StringUtils.isEmpty((CharSequence)descriptorPage.getName()) ? FilenameUtils.getBaseName((String)descriptorPage.getSrc()) : descriptorPage.getName());
            newPage.setHomepage(descriptorPage.isHomepage());
            newPage.setLastContributor(descriptorPageEntity.getLastContributor());
            newPage.setPublished(descriptorPageEntity.isPublished());
            newPage.setOrder(order++);
            newPage.setVisibility(descriptorPageEntity.getVisibility());
            newPage.setSource(descriptorPageEntity.getSource());
            try {
                this.fetchPageAndDefineType(newPage, (Fetcher)fetcher, descriptorPage.getSrc());
                if (newPage.getType() == null) {
                    logger.warn("Unable to find a source file to import. Please fix the descriptor content.");
                    continue;
                }
                String parentPath = descriptorPage.getDest() == null || descriptorPage.getDest().isEmpty() ? this.getParentPathFromFilePath(descriptorPage.getSrc()) : descriptorPage.getDest();
                createdPages.addAll(this.upsertPageAndParentFolders(executionContext, parentPath, newPage, parentsIdByPath, fetcher, apiId, descriptorPage.getSrc()));
            }
            catch (FetcherException | TechnicalException ex) {
                logger.error("An error occurs while trying to import a gravitee descriptor", ex);
                throw new TechnicalManagementException("An error occurs while trying to import a gravitee descriptor", ex);
            }
        }
        return createdPages;
    }

    private void fetchPageAndDefineType(NewPageEntity newPage, Fetcher fetcher, String filePath) throws FetcherException {
        this.updatePageSourceConfigurationFromFetcherConfiguration(newPage.getSource(), fetcher, filePath);
        this.fetchPage((FetchablePageEntity)newPage);
        newPage.setType(PageType.fromPageExtensionAndContent((String)FilenameUtils.getExtension((String)filePath), (String)newPage.getContent()));
    }

    private void updatePageSourceConfigurationFromFetcherConfiguration(PageSourceEntity pageSource, Fetcher fetcher, String filePath) {
        FilepathAwareFetcherConfiguration configuration = (FilepathAwareFetcherConfiguration)fetcher.getConfiguration();
        configuration.setFilepath(filePath);
        pageSource.setConfiguration(new ObjectMapper().valueToTree((Object)configuration));
    }

    private List<PageEntity> importDirectory(ExecutionContext executionContext, String apiId, ImportPageEntity pageEntity, FilesFetcher fetcher) {
        try {
            String[] filenames = fetcher.files();
            Optional<String> optDescriptor = Arrays.stream(filenames).filter(f -> f.endsWith(this.graviteeDescriptorService.descriptorName())).findFirst();
            if (optDescriptor.isPresent()) {
                try {
                    ((FilepathAwareFetcherConfiguration)fetcher.getConfiguration()).setFilepath(optDescriptor.get());
                    Resource resource = fetcher.fetch();
                    GraviteeDescriptorEntity descriptorEntity = this.graviteeDescriptorService.read(this.getResourceContentAsString(resource));
                    return this.importDescriptor(executionContext, apiId, pageEntity, fetcher, descriptorEntity);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new FetcherException(e.getMessage(), (Throwable)e);
                }
            }
            HashMap<String, String> parentsIdByPath = new HashMap<String, String>();
            ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
            int order = 0;
            for (String filename : filenames) {
                NewPageEntity newPage = new NewPageEntity();
                newPage.setLastContributor(pageEntity.getLastContributor());
                newPage.setPublished(pageEntity.isPublished());
                newPage.setSource(pageEntity.getSource());
                newPage.setOrder(order++);
                newPage.setName(FilenameUtils.getBaseName((String)filename));
                this.fetchPageAndDefineType(newPage, (Fetcher)fetcher, filename);
                if (newPage.getType() != null) {
                    try {
                        createdPages.addAll(this.upsertPageAndParentFolders(executionContext, this.getParentPathFromFilePath(filename), newPage, parentsIdByPath, fetcher, apiId, filename));
                        continue;
                    }
                    catch (TechnicalException ex) {
                        logger.error("An error occurs while trying to import a directory", (Throwable)ex);
                        throw new TechnicalManagementException("An error occurs while trying to import a directory", ex);
                    }
                }
                logger.warn("Importing a directory containing a file {} in a unknown format. Ignoring this file.", (Object)filename);
            }
            return createdPages;
        }
        catch (FetcherException ex) {
            logger.error("An error occurs while trying to import a directory", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying import a directory", ex);
        }
    }

    protected String getParentPathFromFilePath(String filePath) {
        return StringUtils.isEmpty((CharSequence)filePath) ? "/" : FilenameUtils.getFullPathNoEndSeparator((String)filePath);
    }

    private List<PageEntity> upsertPageAndParentFolders(ExecutionContext executionContext, String parentPath, NewPageEntity newPageEntity, Map<String, String> parentsIdByPath, FilesFetcher fetcher, String apiId, String src) throws TechnicalException {
        String[] pathElements = parentPath.split("/");
        Object pwd = "";
        ArrayList<PageEntity> createdPages = new ArrayList<PageEntity>();
        for (String pathElement : pathElements) {
            if (pathElement.isEmpty()) continue;
            String futurePwd = (String)pwd + "/" + pathElement;
            if (!parentsIdByPath.containsKey(futurePwd)) {
                PageEntity folder;
                String parentId = parentsIdByPath.get(pwd);
                List pages = this.pageRepository.search(new PageCriteria.Builder().parent(parentId).referenceId(apiId).referenceType(PageReferenceType.API.name()).name(pathElement).type(PageType.FOLDER.name()).build());
                if (pages.isEmpty()) {
                    NewPageEntity newPage = new NewPageEntity();
                    newPage.setParentId(parentId);
                    newPage.setPublished(newPageEntity.isPublished());
                    newPage.setLastContributor(newPageEntity.getLastContributor());
                    newPage.setName(pathElement);
                    newPage.setType(PageType.FOLDER);
                    newPage.setVisibility(Visibility.PUBLIC);
                    folder = this.createPage(executionContext, apiId, newPage);
                } else {
                    folder = this.convert((Page)pages.get(0));
                }
                parentsIdByPath.put(futurePwd, folder.getId());
                createdPages.add(folder);
            }
            pwd = futurePwd;
        }
        String parentId = parentsIdByPath.get(pwd);
        List pages = this.pageRepository.search(new PageCriteria.Builder().parent(parentId).referenceId(apiId).referenceType(PageReferenceType.API.name()).name(newPageEntity.getName()).type(newPageEntity.getType().name()).build());
        if (pages.isEmpty()) {
            newPageEntity.setParentId(parentId);
            this.updatePageSourceConfigurationFromFetcherConfiguration(newPageEntity.getSource(), (Fetcher)fetcher, src);
            newPageEntity.setVisibility(Visibility.PUBLIC);
            createdPages.add(this.createPage(executionContext, apiId, newPageEntity));
        } else {
            Page page = (Page)pages.get(0);
            UpdatePageEntity updatePage = this.convertToUpdateEntity(page);
            updatePage.setContent(newPageEntity.getContent());
            updatePage.setLastContributor(newPageEntity.getLastContributor());
            updatePage.setPublished(Boolean.valueOf(newPageEntity.isPublished()));
            updatePage.setOrder(Integer.valueOf(newPageEntity.getOrder()));
            updatePage.setHomepage(Boolean.valueOf(newPageEntity.isHomepage()));
            updatePage.setSource(newPageEntity.getSource());
            this.updatePageSourceConfigurationFromFetcherConfiguration(updatePage.getSource(), (Fetcher)fetcher, src);
            createdPages.add(this.update(executionContext, page.getId(), updatePage));
        }
        return createdPages;
    }

    private Page upsertRootPage(ExecutionContext executionContext, String apiId, ImportPageEntity rootPage) {
        try {
            FetcherConfiguration configuration;
            Fetcher fetcher;
            List searchResult = this.pageRepository.search(new PageCriteria.Builder().referenceId(apiId).referenceType(PageReferenceType.API.name()).type(PageType.ROOT.name()).build());
            Page page = PageServiceImpl.convert(rootPage);
            page.setReferenceId(apiId);
            page.setReferenceType(PageReferenceType.API);
            if (page.getSource() != null) {
                fetcher = this.getFetcher(page.getSource());
                if (fetcher == null) {
                    logger.error("An error occurs while trying to fetch page source");
                    throw new TechnicalManagementException("An error occurs while trying to fetch page source");
                }
                configuration = fetcher.getConfiguration();
                if (configuration.isAutoFetch()) {
                    page.setUseAutoFetch(Boolean.TRUE);
                } else {
                    page.setUseAutoFetch(null);
                }
            }
            if (searchResult.isEmpty()) {
                page.setCreatedAt(new Date());
                page.setUpdatedAt(page.getCreatedAt());
                page.setId(UuidString.generateRandom());
                this.validateSafeContent(executionContext, page);
                return this.pageRepository.create(page);
            }
            page.setId(((Page)searchResult.get(0)).getId());
            fetcher = this.getFetcher(((Page)searchResult.get(0)).getSource());
            if (fetcher == null) {
                logger.error("An error occurs while trying to fetch page source");
                throw new TechnicalManagementException("An error occurs while trying to fetch page source");
            }
            configuration = fetcher.getConfiguration();
            this.mergeSensitiveData(configuration, page);
            page.setUpdatedAt(new Date());
            this.validateSafeContent(executionContext, page);
            return this.pageRepository.update(page);
        }
        catch (FetcherException | TechnicalException ex) {
            logger.error("An error occurs while trying to save the configuration", ex);
            throw new TechnicalManagementException("An error occurs while trying to save the configuration", ex);
        }
    }

    private void reorderAndSavePages(Page pageToReorder) throws TechnicalException {
        PageCriteria.Builder q = new PageCriteria.Builder().referenceId(pageToReorder.getReferenceId()).referenceType(pageToReorder.getReferenceType().name());
        if (pageToReorder.getParentId() == null) {
            q.rootParent(Boolean.TRUE);
        } else {
            q.parent(pageToReorder.getParentId());
        }
        List pages = this.pageRepository.search(q.build());
        List<Boolean> increment = Arrays.asList(true);
        pages.stream().sorted(Comparator.comparingInt(Page::getOrder)).forEachOrdered(page -> {
            try {
                if (page.equals((Object)pageToReorder)) {
                    increment.set(0, false);
                    page.setOrder(pageToReorder.getOrder());
                } else {
                    Boolean isIncrement = (Boolean)increment.get(0);
                    int newOrder = page.getOrder() < pageToReorder.getOrder() ? page.getOrder() - (isIncrement != false ? 0 : 1) : (page.getOrder() > pageToReorder.getOrder() ? page.getOrder() + (isIncrement != false ? 1 : 0) : page.getOrder() + (isIncrement != false ? 1 : -1));
                    page.setOrder(newOrder);
                }
                this.pageRepository.update(page);
            }
            catch (TechnicalException ex) {
                throw this.onUpdateFail(page.getId(), ex);
            }
        });
    }

    private TechnicalManagementException onUpdateFail(String pageId, TechnicalException ex) {
        logger.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to update page " + pageId, ex);
    }

    private TechnicalManagementException onUpdateFail(String pageId, FetcherException ex) {
        logger.error("An error occurs while trying to update page {}", (Object)pageId, (Object)ex);
        return new TechnicalManagementException("An error occurs while trying to fetch content. " + ex.getMessage(), ex);
    }

    @Override
    public void delete(ExecutionContext executionContext, String pageId) {
        try {
            Optional<PlanEntity> activePlan;
            List search;
            logger.debug("Delete Page : {}", (Object)pageId);
            Optional optPage = this.pageRepository.findById(pageId);
            if (!optPage.isPresent()) {
                throw new PageNotFoundException(pageId);
            }
            Page page = (Page)optPage.get();
            if (PageType.FOLDER.name().equalsIgnoreCase(page.getType()) && !(search = this.pageRepository.search(new PageCriteria.Builder().referenceId(page.getReferenceId()).referenceType(page.getReferenceType().name()).parent(page.getId()).build())).isEmpty()) {
                throw new TechnicalManagementException("Unable to remove the folder. It must be empty before being removed.");
            }
            List<CategoryEntity> categories = this.categoryService.findByPage(pageId);
            if (categories != null && !categories.isEmpty()) {
                String categoriesKeys = categories.stream().map(CategoryEntity::getKey).collect(Collectors.joining(","));
                throw new PageActionException(PageType.valueOf((String)page.getType()), "be deleted since it is used in categories [" + categoriesKeys + "]");
            }
            if (page.getReferenceType() != null && page.getReferenceType().equals((Object)PageReferenceType.API) && (activePlan = this.planService.findByApi(executionContext, page.getReferenceId()).stream().filter(plan -> plan.getGeneralConditions() != null).filter(plan -> PageType.TRANSLATION.name().equals(page.getType()) && plan.getGeneralConditions().equals(page.getParentId()) || plan.getGeneralConditions().equals(page.getId())).filter(plan -> !PlanStatus.CLOSED.equals((Object)plan.getStatus())).findFirst()).isPresent()) {
                throw new PageUsedAsGeneralConditionsException(pageId, page.getName(), "remove", activePlan.get().getName());
            }
            this.pageRepository.delete(pageId);
            if (!PageType.LINK.name().equalsIgnoreCase(page.getType()) && !PageType.TRANSLATION.name().equalsIgnoreCase(page.getType())) {
                this.deleteRelatedPages(page.getId());
            }
            this.createAuditLog(executionContext, PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_DELETED, new Date(), page, null);
            this.searchEngineService.delete(executionContext, (Indexable)this.convert(page));
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to delete Page {}", (Object)pageId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete Page " + pageId, ex);
        }
    }

    @Override
    public void deleteAllByApi(ExecutionContext executionContext, String apiId) {
        List<PageEntity> pages = this.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(apiId).build(), null, false, false);
        pages.sort(new Comparator<PageEntity>(){

            @Override
            public int compare(PageEntity p0, PageEntity p1) {
                Integer r1;
                Integer r0 = PageType.valueOf((String)p0.getType()).getRemoveOrder();
                if (r0.equals(r1 = PageType.valueOf((String)p1.getType()).getRemoveOrder())) {
                    return Integer.compare(p1.getOrder(), p0.getOrder());
                }
                return r0.compareTo(r1);
            }
        });
        pages.forEach(pageEntity -> this.delete(executionContext, pageEntity.getId()));
    }

    @Override
    public int findMaxApiPageOrderByApi(String apiName) {
        try {
            logger.debug("Find Max Order Page for api name : {}", (Object)apiName);
            Integer maxPageOrder = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder(apiName, PageReferenceType.API);
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            logger.error("An error occured when searching max order page for api name [{}]", (Object)apiName, (Object)ex);
            throw new TechnicalManagementException("An error occured when searching max order page for api name " + apiName, ex);
        }
    }

    @Override
    public int findMaxPortalPageOrder(String referenceId) {
        try {
            logger.debug("Find Max Order Portal Page");
            Integer maxPageOrder = this.pageRepository.findMaxPageReferenceIdAndReferenceTypeOrder(referenceId, PageReferenceType.ENVIRONMENT);
            return maxPageOrder == null ? 0 : maxPageOrder;
        }
        catch (TechnicalException ex) {
            logger.error("An error occured when searching max order portal page", (Throwable)ex);
            throw new TechnicalManagementException("An error occured when searching max order portal ", ex);
        }
    }

    @Override
    public PageEntity fetch(ExecutionContext executionContext, String pageId, String contributor) {
        try {
            logger.debug("Fetch page {}", (Object)pageId);
            Page pageToUpdate = (Page)this.pageRepository.findById(pageId).orElseThrow(() -> new PageNotFoundException(pageId));
            if (pageToUpdate.getSource() == null) {
                throw new NoFetcherDefinedException(pageId);
            }
            return this.fetch(executionContext, pageToUpdate, contributor);
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    private PageEntity fetch(ExecutionContext executionContext, Page page, String contributor) throws TechnicalException {
        Page previousPage = new Page();
        previousPage.setContent(page.getContent());
        previousPage.setName(page.getName());
        UpdatePageEntity updatePageEntity = this.convertToUpdateEntity(page, false);
        try {
            this.fetchPage((FetchablePageEntity)updatePageEntity);
        }
        catch (FetcherException e) {
            throw this.onUpdateFail(page.getId(), e);
        }
        page.setContent(updatePageEntity.getContent());
        page.setMetadata(updatePageEntity.getMetadata());
        page.setUseAutoFetch(updatePageEntity.getUseAutoFetch());
        page.setUpdatedAt(new Date());
        page.setLastContributor(contributor);
        List<String> messages = this.validateSafeContent(executionContext, page);
        Page updatedPage = this.pageRepository.update(page);
        if (this.isSwaggerOrMarkdown(updatedPage.getType()) && this.pageHasChanged(updatedPage, previousPage)) {
            this.createPageRevision(updatedPage);
        }
        this.createAuditLog(executionContext, PageReferenceType.API.equals((Object)page.getReferenceType()) ? page.getReferenceId() : null, (Audit.AuditEvent)Page.AuditEvent.PAGE_UPDATED, page.getUpdatedAt(), page, page);
        PageEntity pageEntity = this.convert(updatedPage);
        pageEntity.setMessages(messages);
        return pageEntity;
    }

    private List<PageEntity> fetchPages(ExecutionContext executionContext, String apiId, ImportPageEntity pageEntity) {
        try {
            Fetcher _fetcher = this.getFetcher(PageServiceImpl.convert(pageEntity.getSource()));
            if (_fetcher == null) {
                return Collections.emptyList();
            }
            if (!(_fetcher instanceof FilesFetcher)) {
                throw new UnsupportedOperationException("The plugin does not support to import a directory.");
            }
            FilesFetcher fetcher = (FilesFetcher)_fetcher;
            return this.importDirectory(executionContext, apiId, pageEntity, fetcher);
        }
        catch (FetcherException ex) {
            logger.error("An error occurs while trying to import a directory", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying import a directory", ex);
        }
    }

    private List<PageEntity> convert(List<Page> pages) {
        if (pages == null) {
            return Collections.emptyList();
        }
        return pages.stream().map(this::convert).collect(Collectors.toList());
    }

    private PageEntity convert(Page page) {
        PageEntity pageEntity;
        if (page.getReferenceId() != null && PageReferenceType.API.equals((Object)page.getReferenceType())) {
            pageEntity = new ApiPageEntity();
            ((ApiPageEntity)pageEntity).setApi(page.getReferenceId());
        } else {
            pageEntity = new PageEntity();
        }
        pageEntity.setId(page.getId());
        pageEntity.setCrossId(page.getCrossId());
        pageEntity.setName(page.getName());
        pageEntity.setHomepage(page.isHomepage());
        pageEntity.setType(page.getType());
        pageEntity.setContent(page.getContent());
        pageEntity.setReferenceType(page.getReferenceType().name());
        pageEntity.setReferenceId(page.getReferenceId());
        if (PageServiceImpl.isJson(page.getContent())) {
            pageEntity.setContentType("application/json");
        } else {
            pageEntity.setContentType("text/yaml");
        }
        pageEntity.setLastContributor(page.getLastContributor());
        pageEntity.setLastModificationDate(page.getUpdatedAt());
        pageEntity.setOrder(page.getOrder());
        pageEntity.setPublished(page.isPublished());
        pageEntity.setVisibility(Visibility.valueOf((String)page.getVisibility()));
        if (page.getSource() != null) {
            pageEntity.setSource(this.convert(page.getSource()));
        }
        if (page.getConfiguration() != null) {
            pageEntity.setConfiguration(page.getConfiguration());
        }
        if (page.getAttachedMedia() != null) {
            pageEntity.setAttachedMedia(PageServiceImpl.convertMedia(page.getAttachedMedia()));
        }
        pageEntity.setExcludedAccessControls(page.isExcludedAccessControls());
        pageEntity.setAccessControls(PageServiceImpl.convertToEntities(page.getAccessControls()));
        if (page.isExcludedAccessControls() && Visibility.PRIVATE.name().equals(page.getVisibility())) {
            List excludedGroups = Collections.emptyList();
            if (page.getAccessControls() != null) {
                excludedGroups = page.getAccessControls().stream().filter(accessControl -> AccessControlReferenceType.GROUP.name().equals(accessControl.getReferenceType())).map(accessControl -> accessControl.getReferenceId()).collect(Collectors.toList());
            }
            pageEntity.setExcludedGroups(excludedGroups);
        }
        pageEntity.setParentId("".equals(page.getParentId()) ? null : page.getParentId());
        pageEntity.setMetadata(page.getMetadata());
        pageEntity.setParentPath(this.computeParentPath(page, ""));
        return pageEntity;
    }

    private String computeParentPath(Page page, String suffix) {
        String path = suffix;
        String parentId = page.getParentId();
        if (!StringUtils.isEmpty((CharSequence)parentId)) {
            try {
                Optional optParent = this.pageRepository.findById(parentId);
                if (optParent.isPresent()) {
                    return this.computeParentPath((Page)optParent.get(), "/" + ((Page)optParent.get()).getName() + path);
                }
            }
            catch (TechnicalException ex) {
                logger.error("An error occurs while trying to find a page using its ID {}", (Object)parentId, (Object)ex);
            }
        }
        return path;
    }

    private List<Page> getTranslations(String pageId) {
        try {
            List searchResult = this.pageRepository.search(new PageCriteria.Builder().parent(pageId).type(PageType.TRANSLATION.name()).build());
            searchResult.sort((p1, p2) -> {
                String lang1 = (String)p1.getConfiguration().get("lang");
                String lang2 = (String)p2.getConfiguration().get("lang");
                return lang1.compareTo(lang2);
            });
            return searchResult;
        }
        catch (TechnicalException ex) {
            logger.error("An error occurs while trying to search pages", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search pages", ex);
        }
    }

    private UpdatePageEntity convertToUpdateEntity(Page page) {
        return this.convertToUpdateEntity(page, true);
    }

    private UpdatePageEntity convertToUpdateEntity(Page page, boolean removeSensitiveData) {
        UpdatePageEntity updatePageEntity = new UpdatePageEntity();
        updatePageEntity.setCrossId(page.getCrossId());
        updatePageEntity.setName(page.getName());
        updatePageEntity.setContent(page.getContent());
        updatePageEntity.setLastContributor(page.getLastContributor());
        updatePageEntity.setOrder(Integer.valueOf(page.getOrder()));
        updatePageEntity.setPublished(Boolean.valueOf(page.isPublished()));
        updatePageEntity.setSource(this.convert(page.getSource(), removeSensitiveData));
        updatePageEntity.setConfiguration(page.getConfiguration());
        updatePageEntity.setHomepage(Boolean.valueOf(page.isHomepage()));
        updatePageEntity.setExcludedAccessControls(Boolean.valueOf(page.isExcludedAccessControls()));
        updatePageEntity.setAccessControls(PageServiceImpl.convertToEntities(page.getAccessControls()));
        updatePageEntity.setAttachedMedia(PageServiceImpl.convertMedia(page.getAttachedMedia()));
        updatePageEntity.setParentId("".equals(page.getParentId()) ? null : page.getParentId());
        updatePageEntity.setVisibility(Visibility.valueOf((String)page.getVisibility()));
        return updatePageEntity;
    }

    private static Set<AccessControlEntity> convertToEntities(Set<AccessControl> accessControls) {
        if (accessControls == null) {
            return Collections.emptySet();
        }
        return accessControls.stream().map(accessControl -> PageServiceImpl.convert(accessControl)).collect(Collectors.toSet());
    }

    private static AccessControlEntity convert(AccessControl accessControl) {
        AccessControlEntity accessControlEntity = new AccessControlEntity();
        accessControlEntity.setReferenceId(accessControl.getReferenceId());
        accessControlEntity.setReferenceType(accessControl.getReferenceType());
        return accessControlEntity;
    }

    private static Set<AccessControl> convertACL(Set<AccessControlEntity> accessControlEntities) {
        if (accessControlEntities == null) {
            return Collections.emptySet();
        }
        return accessControlEntities.stream().map(PageServiceImpl::convert).collect(Collectors.toSet());
    }

    private static AccessControl convert(AccessControlEntity accessControlEntity) {
        AccessControl accessControl = new AccessControl();
        accessControl.setReferenceId(accessControlEntity.getReferenceId());
        accessControl.setReferenceType(accessControlEntity.getReferenceType());
        return accessControl;
    }

    private PageSourceEntity convert(PageSource pageSource) {
        return this.convert(pageSource, true);
    }

    private PageSourceEntity convert(PageSource pageSource, boolean removeSensitiveData) {
        PageSourceEntity entity = null;
        if (pageSource != null) {
            entity = new PageSourceEntity();
            entity.setType(pageSource.getType());
            try {
                Fetcher fetcher = this.getFetcher(pageSource);
                if (fetcher == null) {
                    logger.error("An error occurs while trying to fetch page source");
                    throw new TechnicalManagementException("An error occurs while trying to fetch page source");
                }
                FetcherConfiguration fetcherConfiguration = fetcher.getConfiguration();
                if (removeSensitiveData) {
                    this.removeSensitiveData(fetcherConfiguration);
                }
                entity.setConfiguration(new ObjectMapper().valueToTree((Object)fetcherConfiguration));
            }
            catch (FetcherException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return entity;
    }

    private void removeSensitiveData(FetcherConfiguration fetcherConfiguration) {
        Field[] fields;
        for (Field field : fields = fetcherConfiguration.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Sensitive.class)) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(fetcherConfiguration, SENSITIVE_DATA_REPLACEMENT);
            }
            catch (IllegalAccessException e) {
                logger.error("Error while removing fetcher sensitive data", (Throwable)e);
            }
            field.setAccessible(accessible);
        }
    }

    private void mergeSensitiveData(FetcherConfiguration originalFetcherConfiguration, Page page) throws FetcherException {
        Field[] fields;
        Fetcher fetcher = this.getFetcher(page.getSource());
        if (fetcher == null) {
            logger.error("An error occurs while trying to fetch page source");
            throw new TechnicalManagementException("An error occurs while trying to fetch page source");
        }
        FetcherConfiguration updatedFetcherConfiguration = fetcher.getConfiguration();
        boolean updated = false;
        for (Field field : fields = originalFetcherConfiguration.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Sensitive.class)) continue;
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                Object updatedValue = field.get(updatedFetcherConfiguration);
                if (SENSITIVE_DATA_REPLACEMENT.equals(updatedValue)) {
                    updated = true;
                    field.set(updatedFetcherConfiguration, field.get(originalFetcherConfiguration));
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                logger.error("Error while merging original fetcher sensitive data to new fetcher", (Throwable)e);
            }
            field.setAccessible(accessible);
        }
        if (updated) {
            page.getSource().setConfiguration(new ObjectMapper().valueToTree((Object)updatedFetcherConfiguration).toString());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private List<String> validateSafeContent(ExecutionContext executionContext, Page page) {
        String apiId = null;
        if (PageReferenceType.API.equals((Object)page.getReferenceType())) {
            apiId = page.getReferenceId();
        }
        return this.validateSafeContent(executionContext, this.convert(page), apiId);
    }

    @Override
    public List<String> validateSafeContent(ExecutionContext executionContext, PageEntity pageEntity, String apiId) {
        if (pageEntity != null) {
            OAIDescriptor openApiDescriptor;
            if (this.markdownSanitize && PageType.MARKDOWN.name().equals(pageEntity.getType())) {
                this.transformWithTemplate(executionContext, pageEntity, apiId);
                if (!CollectionUtils.isEmpty((Collection)pageEntity.getMessages())) {
                    return Arrays.asList(pageEntity.getMessages().toString());
                }
                HtmlSanitizer.SanitizeInfos sanitizeInfos = HtmlSanitizer.isSafe(pageEntity.getContent());
                if (!sanitizeInfos.isSafe()) {
                    throw new PageContentUnsafeException(sanitizeInfos.getRejectedMessage());
                }
            } else if (PageType.SWAGGER.name().equals(pageEntity.getType()) && pageEntity.getContent() != null && (openApiDescriptor = new OAIParser().parse(pageEntity.getContent())) != null && openApiDescriptor.getMessages() != null) {
                return openApiDescriptor.getMessages();
            }
        }
        return new ArrayList<String>();
    }

    private void validateSafeSource(PageSourceEntity source) {
        Map map;
        if (this.importConfiguration.isAllowImportFromPrivate() || source == null || source.getConfiguration() == null) {
            return;
        }
        try {
            map = (Map)new ObjectMapper().readValue(source.getConfiguration(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e2) {
            throw new InvalidDataException("Source is invalid", e2);
        }
        Optional<String> urlOpt = map.entrySet().stream().filter(e -> ((String)e.getKey()).equals("repository") || ((String)e.getKey()).matches(".*[uU]rl")).map(Map.Entry::getValue).findFirst();
        if (!urlOpt.isPresent()) {
            return;
        }
        UrlSanitizerUtils.checkAllowed(urlOpt.get(), this.importConfiguration.getImportWhitelist(), false);
    }

    private void createAuditLog(ExecutionContext executionContext, String apiId, Audit.AuditEvent event, Date createdAt, Page oldValue, Page newValue) {
        String pageId;
        String string = pageId = oldValue != null ? oldValue.getId() : newValue.getId();
        if (apiId == null) {
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.PAGE, pageId), event, createdAt, oldValue, newValue);
        } else {
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.singletonMap(Audit.AuditProperties.PAGE, pageId), event, createdAt, oldValue, newValue);
        }
    }

    private PageCriteria queryToCriteria(PageQuery query, String environmentId) {
        PageCriteria.Builder builder = new PageCriteria.Builder();
        if (query != null) {
            builder.homepage(query.getHomepage());
            if (query.getApi() != null) {
                builder.referenceId(query.getApi());
                builder.referenceType(PageReferenceType.API.name());
            } else {
                builder.referenceId(environmentId);
                builder.referenceType(PageReferenceType.ENVIRONMENT.name());
            }
            builder.name(query.getName());
            builder.parent(query.getParent());
            builder.published(query.getPublished());
            if (!this.isAuthenticated()) {
                builder.visibility(Visibility.PUBLIC.name());
            }
            if (query.getType() != null) {
                builder.type(query.getType().name());
            }
            builder.rootParent(query.getRootParent());
        }
        return builder.build();
    }

    @Override
    public Map<SystemFolderType, String> initialize(ExecutionContext executionContext) {
        HashMap<SystemFolderType, String> result = new HashMap<SystemFolderType, String>();
        result.put(SystemFolderType.HEADER, this.createSystemFolder(executionContext, null, SystemFolderType.HEADER, 1).getId());
        result.put(SystemFolderType.TOPFOOTER, this.createSystemFolder(executionContext, null, SystemFolderType.TOPFOOTER, 2).getId());
        result.put(SystemFolderType.FOOTER, this.createSystemFolder(executionContext, null, SystemFolderType.FOOTER, 3).getId());
        return result;
    }

    @Override
    public PageEntity createAsideFolder(ExecutionContext executionContext, String apiId) {
        return this.createSystemFolder(executionContext, apiId, SystemFolderType.ASIDE, 0);
    }

    @Override
    public PageEntity createSystemFolder(ExecutionContext executionContext, String apiId, SystemFolderType systemFolderType, int order) {
        NewPageEntity newSysFolder = new NewPageEntity();
        newSysFolder.setName(systemFolderType.folderName());
        newSysFolder.setOrder(order);
        newSysFolder.setPublished(true);
        newSysFolder.setType(PageType.SYSTEM_FOLDER);
        newSysFolder.setVisibility(Visibility.PUBLIC);
        return this.createPage(executionContext, apiId, newSysFolder);
    }

    @Override
    public boolean shouldHaveRevision(String pageType) {
        PageType type = PageType.valueOf((String)pageType);
        switch (type) {
            case MARKDOWN: 
            case SWAGGER: 
            case TRANSLATION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void attachMedia(String pageId, String mediaId, String mediaName) {
        try {
            Optional optPage = this.pageRepository.findById(pageId);
            if (optPage.isPresent()) {
                Page page = (Page)optPage.get();
                if (page.getAttachedMedia() == null) {
                    page.setAttachedMedia(new ArrayList());
                }
                page.getAttachedMedia().add(new PageMedia(mediaId, mediaName, new Date()));
                this.pageRepository.update(page);
            }
        }
        catch (TechnicalException ex) {
            throw this.onUpdateFail(pageId, ex);
        }
    }

    @Override
    public PageEntity createWithDefinition(ExecutionContext executionContext, String apiId, String pageDefinition) {
        try {
            NewPageEntity newPage = this.convertToEntity(pageDefinition);
            JsonNode jsonNode = this.objectMapper.readTree(pageDefinition);
            return this.createPage(executionContext, apiId, newPage, jsonNode.get("id") != null ? jsonNode.get("id").asText() : null);
        }
        catch (JsonProcessingException e) {
            logger.error("An error occurs while trying to JSON deserialize the Page {}", (Object)pageDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the Page definition.");
        }
    }

    @Override
    public void createOrUpdatePages(ExecutionContext executionContext, List<PageEntity> pages, String apiId) {
        PageEntityTreeNode pageEntityTreeNode = new PageEntityTreeNode(new PageEntity());
        pageEntityTreeNode.appendListToTree(pages);
        this.createOrUpdateChildrenPages(executionContext, apiId, null, pageEntityTreeNode.children);
    }

    @Override
    public void createOrUpdateSwaggerPage(ExecutionContext executionContext, String apiId, ImportSwaggerDescriptorEntity swaggerDescriptor, boolean isForCreation) {
        if (swaggerDescriptor != null && swaggerDescriptor.isWithDocumentation()) {
            List<PageEntity> apiDocs = this.search(executionContext.getEnvironmentId(), new PageQuery.Builder().api(apiId).type(PageType.SWAGGER).build());
            if (isForCreation || apiDocs == null || apiDocs.isEmpty()) {
                NewPageEntity page = new NewPageEntity();
                page.setName("Swagger");
                page.setType(PageType.SWAGGER);
                page.setOrder(1);
                if (ImportSwaggerDescriptorEntity.Type.INLINE.equals((Object)swaggerDescriptor.getType())) {
                    page.setContent(swaggerDescriptor.getPayload());
                } else {
                    PageSourceEntity source = new PageSourceEntity();
                    page.setSource(source);
                    source.setType("http-fetcher");
                    source.setConfiguration((JsonNode)this.objectMapper.convertValue(Collections.singletonMap("url", swaggerDescriptor.getPayload()), JsonNode.class));
                }
                this.createPage(executionContext, apiId, page);
            } else if (apiDocs.size() == 1) {
                PageEntity pageToUpdate = apiDocs.get(0);
                UpdatePageEntity page = new UpdatePageEntity();
                page.setName(pageToUpdate.getName());
                page.setOrder(Integer.valueOf(pageToUpdate.getOrder()));
                page.setHomepage(Boolean.valueOf(pageToUpdate.isHomepage()));
                page.setPublished(Boolean.valueOf(pageToUpdate.isPublished()));
                page.setParentId(pageToUpdate.getParentId());
                page.setConfiguration(pageToUpdate.getConfiguration());
                if (ImportSwaggerDescriptorEntity.Type.INLINE.equals((Object)swaggerDescriptor.getType())) {
                    page.setContent(swaggerDescriptor.getPayload());
                } else {
                    PageSourceEntity source = new PageSourceEntity();
                    page.setSource(source);
                    source.setType("http-fetcher");
                    source.setConfiguration((JsonNode)this.objectMapper.convertValue(Collections.singletonMap("url", swaggerDescriptor.getPayload()), JsonNode.class));
                }
                this.update(executionContext, pageToUpdate.getId(), page);
            }
        }
    }

    @Override
    public Map<String, String> duplicatePages(ExecutionContext executionContext, List<PageEntity> pages, String apiId) {
        PageEntityTreeNode pageEntityTreeNode = new PageEntityTreeNode(new PageEntity());
        pageEntityTreeNode.appendListToTree(pages);
        return this.duplicateChildrenPages(executionContext, apiId, null, pageEntityTreeNode.children);
    }

    private NewPageEntity convertToEntity(String pageDefinition) throws JsonProcessingException {
        return (NewPageEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(pageDefinition, NewPageEntity.class);
    }

    private void createOrUpdateChildrenPages(ExecutionContext executionContext, String apiId, String parentId, List<PageEntityTreeNode> children) {
        for (PageEntityTreeNode child : children) {
            PageEntity createdOrUpdatedPage;
            PageEntity pageEntityToImport = child.data;
            pageEntityToImport.setParentId(parentId);
            pageEntityToImport.setReferenceId(apiId);
            pageEntityToImport.setReferenceType(PageReferenceType.API.name());
            if (PageType.SYSTEM_FOLDER.name().equals(pageEntityToImport.getType())) {
                this.findSystemFolder(executionContext.getEnvironmentId(), apiId).ifPresent(sysFolder -> {
                    if (!sysFolder.getId().equals(pageEntityToImport.getId())) {
                        logger.warn("An existing system folder has been found for API [{}] on environment [{}] with another ID, the existing system folder will be updated", (Object)apiId, (Object)executionContext.getEnvironmentId());
                    }
                    pageEntityToImport.setId(sysFolder.getId());
                });
            }
            try {
                this.findById(pageEntityToImport.getId());
                createdOrUpdatedPage = this.update(executionContext, pageEntityToImport.getId(), this.pageConverter.toUpdatePageEntity(pageEntityToImport));
            }
            catch (PageNotFoundException e) {
                createdOrUpdatedPage = this.createPage(executionContext, apiId, this.pageConverter.toNewPageEntity(pageEntityToImport), pageEntityToImport.getId());
            }
            if (child.children == null || child.children.isEmpty()) continue;
            this.createOrUpdateChildrenPages(executionContext, apiId, createdOrUpdatedPage.getId(), child.children);
        }
    }

    private Map<String, String> duplicateChildrenPages(ExecutionContext executionContext, String apiId, String parentId, List<PageEntityTreeNode> children) {
        HashMap<String, String> idsMap = new HashMap<String, String>();
        for (PageEntityTreeNode child : children) {
            PageEntity pageEntityToImport = child.data;
            pageEntityToImport.setParentId(parentId);
            String newId = UuidString.generateForEnvironment(executionContext.getEnvironmentId(), apiId, pageEntityToImport.getId());
            this.createPage(executionContext, apiId, this.pageConverter.toNewPageEntity(pageEntityToImport, true), newId);
            idsMap.put(pageEntityToImport.getId(), newId);
            if (child.children == null || child.children.isEmpty()) continue;
            idsMap.putAll(this.duplicateChildrenPages(executionContext, apiId, newId, child.children));
        }
        return idsMap;
    }

    private static /* synthetic */ boolean lambda$update$18(PlanEntity plan) {
        return !PlanStatus.CLOSED.equals((Object)plan.getStatus()) && !PlanStatus.STAGING.equals((Object)plan.getStatus());
    }

    private static /* synthetic */ boolean lambda$update$17(Page pageToUpdate, PlanEntity plan) {
        return pageToUpdate.getId().equals(plan.getGeneralConditions());
    }

    private static /* synthetic */ boolean lambda$update$16(PlanEntity plan) {
        return plan.getGeneralConditions() != null;
    }

    private static /* synthetic */ AccessControlEntity lambda$update$15(String groupId) {
        AccessControlEntity accessControl = new AccessControlEntity();
        accessControl.setReferenceType("GROUP");
        accessControl.setReferenceId(groupId);
        return accessControl;
    }

    static class PageEntityTreeNode {
        PageEntity data;
        PageEntityTreeNode parent;
        List<PageEntityTreeNode> children;

        public PageEntityTreeNode(PageEntity data) {
            this.data = data;
            this.children = new LinkedList<PageEntityTreeNode>();
        }

        public PageEntityTreeNode addChild(PageEntity child) {
            PageEntityTreeNode childNode = new PageEntityTreeNode(child);
            childNode.parent = this;
            this.children.add(childNode);
            return childNode;
        }

        private PageEntityTreeNode findById(String id) {
            if (id.equals(this.data.getId())) {
                return this;
            }
            for (PageEntityTreeNode child : this.children) {
                PageEntityTreeNode result = child.findById(id);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void appendListToTree(List<PageEntity> pagesList) {
            ArrayList<PageEntity> orphans = new ArrayList<PageEntity>();
            for (PageEntity newPage : pagesList) {
                if (newPage.getParentId() == null || newPage.getParentId().isEmpty()) {
                    this.addChild(newPage);
                    continue;
                }
                PageEntityTreeNode parentNode = this.findById(newPage.getParentId());
                if (parentNode != null) {
                    parentNode.addChild(newPage);
                    continue;
                }
                orphans.add(newPage);
            }
            if (!orphans.isEmpty() && orphans.size() < pagesList.size()) {
                this.appendListToTree(orphans);
            }
        }
    }

    private static enum PageSituation {
        ROOT,
        IN_ROOT,
        IN_FOLDER_IN_ROOT,
        IN_FOLDER_IN_FOLDER,
        SYSTEM_FOLDER,
        IN_SYSTEM_FOLDER,
        IN_FOLDER_IN_SYSTEM_FOLDER,
        TRANSLATION;

    }
}

