/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Category;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.NewCategoryEntity;
import io.gravitee.rest.api.model.UpdateCategoryEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.CategoryNotFoundException;
import io.gravitee.rest.api.service.exceptions.DuplicateCategoryNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CategoryServiceImpl
extends TransactionalService
implements CategoryService {
    private final Logger LOGGER = LoggerFactory.getLogger(CategoryServiceImpl.class);
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private ApiService apiService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private EnvironmentService environmentService;

    @Override
    public List<CategoryEntity> findAll(String environmentId) {
        try {
            this.LOGGER.debug("Find all categories");
            return this.categoryRepository.findAllByEnvironment(environmentId).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all categories", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all categories", ex);
        }
    }

    @Override
    public Set<CategoryEntity> findByIdIn(String environmentId, Set<String> ids) {
        try {
            return this.categoryRepository.findByEnvironmentIdAndIdIn(environmentId, ids).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            this.LOGGER.error("An error occurs while trying to find categories by ids", (Throwable)e);
            throw new TechnicalManagementException("An error occurs while trying to find categories by ids", e);
        }
    }

    @Override
    public List<CategoryEntity> findByPage(String page) {
        try {
            this.LOGGER.debug("Find all categories by page");
            return this.categoryRepository.findByPage(page).stream().map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all categories by page", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all categories by page", ex);
        }
    }

    @Override
    public CategoryEntity findById(String id, String environmentId) {
        try {
            this.LOGGER.debug("Find category by id : {}", (Object)id);
            Optional category = this.categoryRepository.findById(id);
            if (!category.isPresent()) {
                category = this.categoryRepository.findByKey(id, environmentId);
            }
            if (category.isPresent()) {
                return this.convert((Category)category.get());
            }
            throw new CategoryNotFoundException(id);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find a category using its id: " + id;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public CategoryEntity findNotHiddenById(String id, String environmentId) {
        CategoryEntity category = this.findById(id, environmentId);
        if (!category.isHidden()) {
            return category;
        }
        throw new CategoryNotFoundException(id);
    }

    @Override
    public CategoryEntity create(ExecutionContext executionContext, NewCategoryEntity newCategory) {
        List<CategoryEntity> categories = this.findAll(executionContext.getEnvironmentId());
        Optional<CategoryEntity> optionalCategory = categories.stream().filter(v -> v.getName().equals(newCategory.getName())).findAny();
        if (optionalCategory.isPresent()) {
            throw new DuplicateCategoryNameException(optionalCategory.get().getName());
        }
        try {
            this.environmentService.findById(executionContext.getEnvironmentId());
            Category category = this.convert(newCategory);
            Date createdAt = new Date();
            category.setCreatedAt(createdAt);
            category.setUpdatedAt(createdAt);
            category.setEnvironmentId(executionContext.getEnvironmentId());
            category.setOrder(categories.size());
            CategoryEntity createdCategory = this.convert(this.categoryRepository.create(category));
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.CATEGORY, category.getId()), (Audit.AuditEvent)Category.AuditEvent.CATEGORY_CREATED, createdAt, null, category);
            return createdCategory;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create category {}", (Object)newCategory.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create category " + newCategory.getName(), ex);
        }
    }

    @Override
    public CategoryEntity update(ExecutionContext executionContext, String categoryId, UpdateCategoryEntity categoryEntity) {
        try {
            this.LOGGER.debug("Update Category {}", (Object)categoryId);
            Optional optCategoryToUpdate = this.categoryRepository.findById(categoryId);
            if (!optCategoryToUpdate.isPresent()) {
                throw new CategoryNotFoundException(categoryId);
            }
            Category categoryToUpdate = (Category)optCategoryToUpdate.get();
            Category category = this.convert(categoryEntity, categoryToUpdate.getEnvironmentId());
            if (categoryEntity.getPicture() == null && categoryEntity.getPictureUrl() != null && categoryEntity.getPictureUrl().indexOf("?hash") > 0) {
                category.setPicture(categoryToUpdate.getPicture());
            }
            Date updatedAt = new Date();
            category.setCreatedAt(categoryToUpdate.getCreatedAt());
            category.setUpdatedAt(updatedAt);
            CategoryEntity updatedCategory = this.convert(this.categoryRepository.update(category));
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.CATEGORY, category.getId()), (Audit.AuditEvent)Category.AuditEvent.CATEGORY_UPDATED, updatedAt, categoryToUpdate, category);
            return updatedCategory;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update category {}", (Object)categoryEntity.getName(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update category " + categoryEntity.getName(), ex);
        }
    }

    @Override
    public List<CategoryEntity> update(ExecutionContext executionContext, List<UpdateCategoryEntity> categoriesEntities) {
        ArrayList<CategoryEntity> savedCategories = new ArrayList<CategoryEntity>(categoriesEntities.size());
        categoriesEntities.forEach(categoryEntity -> {
            try {
                Optional optCategoryToUpdate = this.categoryRepository.findById(categoryEntity.getId());
                if (optCategoryToUpdate.isPresent()) {
                    Category categoryToUpdate = (Category)optCategoryToUpdate.get();
                    Category category = this.convert((UpdateCategoryEntity)categoryEntity, categoryToUpdate.getEnvironmentId());
                    if (category.getPicture() == null) {
                        category.setPicture(categoryToUpdate.getPicture());
                    }
                    if (category.getBackground() == null) {
                        category.setBackground(categoryToUpdate.getBackground());
                    }
                    Date updatedAt = new Date();
                    category.setCreatedAt(categoryToUpdate.getCreatedAt());
                    category.setUpdatedAt(updatedAt);
                    savedCategories.add(this.convert(this.categoryRepository.update(category)));
                    this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.CATEGORY, category.getId()), (Audit.AuditEvent)Category.AuditEvent.CATEGORY_UPDATED, updatedAt, categoryToUpdate, category);
                }
            }
            catch (TechnicalException ex) {
                this.LOGGER.error("An error occurs while trying to update category {}", (Object)categoryEntity.getName(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update category " + categoryEntity.getName(), ex);
            }
        });
        return savedCategories;
    }

    @Override
    public void delete(ExecutionContext executionContext, String categoryId) {
        try {
            Optional categoryOptional = this.categoryRepository.findById(categoryId);
            if (categoryOptional.isPresent()) {
                Category categoryToDelete = (Category)categoryOptional.get();
                this.categoryRepository.delete(categoryToDelete.getId());
                this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.CATEGORY, categoryId), (Audit.AuditEvent)Category.AuditEvent.CATEGORY_DELETED, new Date(), null, categoryToDelete);
                this.apiService.deleteCategoryFromAPIs(executionContext, categoryId);
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete category {}", (Object)categoryId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete category " + categoryId, ex);
        }
    }

    @Override
    public InlinePictureEntity getPicture(String environmentId, String categoryId) {
        CategoryEntity categoryEntity = this.findById(categoryId, environmentId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (categoryEntity.getPicture() != null) {
            String[] parts = categoryEntity.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = categoryEntity.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public InlinePictureEntity getBackground(String environmentId, String categoryId) {
        CategoryEntity categoryEntity = this.findById(categoryId, environmentId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (categoryEntity.getBackground() != null) {
            String[] parts = categoryEntity.getBackground().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = categoryEntity.getBackground().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    private Category convert(NewCategoryEntity categoryEntity) {
        Category category = new Category();
        category.setId(UuidString.generateRandom());
        category.setKey(IdGenerator.generate((String)categoryEntity.getName()));
        category.setName(categoryEntity.getName());
        category.setDescription(categoryEntity.getDescription());
        category.setOrder(categoryEntity.getOrder());
        category.setHidden(categoryEntity.isHidden());
        category.setHighlightApi(categoryEntity.getHighlightApi());
        category.setPicture(categoryEntity.getPicture());
        category.setBackground(categoryEntity.getBackground());
        category.setPage(categoryEntity.getPage());
        return category;
    }

    private Category convert(UpdateCategoryEntity categoryEntity, String environment) {
        Category category = new Category();
        category.setId(categoryEntity.getId());
        category.setKey(IdGenerator.generate((String)categoryEntity.getName()));
        category.setEnvironmentId(environment);
        category.setName(categoryEntity.getName());
        category.setDescription(categoryEntity.getDescription());
        category.setOrder(categoryEntity.getOrder());
        category.setHidden(categoryEntity.isHidden());
        category.setHighlightApi(categoryEntity.getHighlightApi());
        category.setPicture(categoryEntity.getPicture());
        category.setBackground(categoryEntity.getBackground());
        category.setPage(categoryEntity.getPage());
        return category;
    }

    private CategoryEntity convert(Category category) {
        CategoryEntity categoryEntity = new CategoryEntity();
        categoryEntity.setId(category.getId());
        categoryEntity.setKey(category.getKey());
        categoryEntity.setName(category.getName());
        categoryEntity.setDescription(category.getDescription());
        categoryEntity.setOrder(category.getOrder());
        categoryEntity.setHidden(category.isHidden());
        categoryEntity.setHighlightApi(category.getHighlightApi());
        categoryEntity.setPicture(category.getPicture());
        categoryEntity.setBackground(category.getBackground());
        categoryEntity.setPage(category.getPage());
        categoryEntity.setUpdatedAt(category.getUpdatedAt());
        categoryEntity.setCreatedAt(category.getCreatedAt());
        return categoryEntity;
    }

    @Override
    public long getTotalApisByCategory(Set<ApiEntity> apis, CategoryEntity category) {
        return apis.stream().filter(api -> api.getCategories() != null && api.getCategories().contains(category.getKey())).count();
    }
}

