/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.GroupRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.OrganizationRepository;
import io.gravitee.repository.management.api.RoleRepository;
import io.gravitee.repository.management.api.UserRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.repository.management.model.MembershipMemberType;
import io.gravitee.repository.management.model.MembershipReferenceType;
import io.gravitee.repository.management.model.Organization;
import io.gravitee.repository.management.model.Role;
import io.gravitee.repository.management.model.RoleReferenceType;
import io.gravitee.repository.management.model.RoleScope;
import io.gravitee.repository.management.model.User;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class ApiPrimaryOwnerRemovalUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(ApiPrimaryOwnerRemovalUpgrader.class);
    private final RoleRepository roleRepository;
    private final ApiRepository apiRepository;
    private final MembershipRepository membershipRepository;
    private final OrganizationRepository organizationRepository;
    private final EnvironmentRepository environmentRepository;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;
    @Value(value="${services.api-primary-owner-default:}")
    private String defaultPrimaryOwnerId;

    public ApiPrimaryOwnerRemovalUpgrader(@Lazy RoleRepository roleRepository, @Lazy ApiRepository apiRepository, @Lazy MembershipRepository membershipRepository, @Lazy OrganizationRepository organizationRepository, @Lazy EnvironmentRepository environmentRepository, @Lazy UserRepository userRepository, @Lazy GroupRepository groupRepository) {
        this.roleRepository = roleRepository;
        this.apiRepository = apiRepository;
        this.membershipRepository = membershipRepository;
        this.organizationRepository = organizationRepository;
        this.environmentRepository = environmentRepository;
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
    }

    @Override
    public boolean upgrade() {
        try {
            Set organizations = this.organizationRepository.findAll();
            for (Organization org : organizations) {
                this.checkOrganization(org.getId());
            }
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to fix APIs Primary Owner removal", (Throwable)e);
            return true;
        }
    }

    private void checkOrganization(String organizationId) throws TechnicalException {
        List<String> unCorruptedApiIds;
        String apiPrimaryOwnerRoleId = this.findApiPrimaryOwnerRoleId(organizationId);
        List<String> environmentIds = this.findEnvironmentIds(organizationId);
        List apiIds = this.apiRepository.searchIds(new ApiCriteria[]{new ApiCriteria.Builder().environments(environmentIds).build()});
        if (this.shouldFix(apiIds, unCorruptedApiIds = this.findApiPrimaryOwnerReferenceIds(apiPrimaryOwnerRoleId, apiIds))) {
            ArrayList<String> corruptedApiIds = new ArrayList<String>(apiIds);
            corruptedApiIds.removeAll(unCorruptedApiIds);
            this.warnOrFix(corruptedApiIds, apiPrimaryOwnerRoleId);
        }
    }

    private boolean shouldFix(List<String> apiIds, List<String> unCorruptedApiIds) {
        return apiIds.size() > unCorruptedApiIds.size();
    }

    private void warnOrFix(List<String> apiIds, String apiPrimaryOwnerRoleId) throws TechnicalException {
        if (StringUtils.isEmpty((CharSequence)this.defaultPrimaryOwnerId)) {
            this.warn(apiIds);
        } else {
            this.warnAndFix(apiIds, apiPrimaryOwnerRoleId);
        }
    }

    private void warn(List<String> apiIds) {
        LOG.warn("");
        LOG.warn("##############################################################");
        LOG.warn("#                           WARNING                          #");
        LOG.warn("##############################################################");
        LOG.warn("");
        LOG.warn("The following APIs do not have a Primary Owner:");
        LOG.warn("");
        apiIds.forEach(arg_0 -> ((Logger)LOG).warn(arg_0));
        LOG.warn("");
        LOG.warn("This can be fixed by editing the services.api-primary-owner-default property of your configuration file");
        LOG.warn("This value must refer to a valid user or group ID");
        LOG.warn("");
        LOG.warn("##############################################################");
        LOG.warn("");
    }

    private void warnAndFix(List<String> apiIds, String apiPrimaryOwnerRoleId) throws TechnicalException {
        this.warn(apiIds);
        LOG.info("Attempting to fix APIs without a Primary Owner from configuration");
        Membership membership = this.prepareMembership(apiPrimaryOwnerRoleId);
        for (String apiId : apiIds) {
            membership.setId(UuidString.generateRandom());
            membership.setReferenceId(apiId);
            this.membershipRepository.create(membership);
        }
        String memberType = membership.getMemberType().name().toLowerCase();
        LOG.info("APIs without a Primary Owner has been associated with {} {}", (Object)memberType, (Object)this.defaultPrimaryOwnerId);
    }

    @Override
    public int getOrder() {
        return 140;
    }

    private String findApiPrimaryOwnerRoleId(String organizationId) throws TechnicalException {
        return this.roleRepository.findByScopeAndNameAndReferenceIdAndReferenceType(RoleScope.API, SystemRole.PRIMARY_OWNER.name(), organizationId, RoleReferenceType.ORGANIZATION).map(Role::getId).orElseThrow(() -> new TechnicalException("Unable to find API Primary Owner role for organization " + organizationId));
    }

    private List<String> findEnvironmentIds(String organizationId) throws TechnicalException {
        return this.environmentRepository.findByOrganization(organizationId).stream().map(Environment::getId).collect(Collectors.toList());
    }

    private List<String> findApiPrimaryOwnerReferenceIds(String apiPrimaryOwnerRoleId, List<String> apiIds) throws TechnicalException {
        return this.membershipRepository.findByReferencesAndRoleId(MembershipReferenceType.API, apiIds, apiPrimaryOwnerRoleId).stream().map(Membership::getReferenceId).collect(Collectors.toList());
    }

    private Membership prepareMembership(String poRoleId) throws TechnicalException {
        Optional optUser = this.userRepository.findById((Object)this.defaultPrimaryOwnerId);
        if (optUser.isPresent()) {
            User user = (User)optUser.get();
            return ApiPrimaryOwnerRemovalUpgrader.membership(user.getId(), MembershipMemberType.USER, poRoleId);
        }
        return this.groupRepository.findById((Object)this.defaultPrimaryOwnerId).map(group -> ApiPrimaryOwnerRemovalUpgrader.membership(group.getId(), MembershipMemberType.GROUP, poRoleId)).orElseThrow(() -> new TechnicalException("Unable to find a user or group with id " + this.defaultPrimaryOwnerId));
    }

    private static Membership membership(String memberId, MembershipMemberType memberType, String roleId) {
        return new Membership(null, memberId, memberType, null, MembershipReferenceType.API, roleId);
    }
}

