/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionNotClosableException
extends AbstractManagementException {
    private final Subscription subscription;

    public SubscriptionNotClosableException(Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public String getMessage() {
        return "Subscription [" + this.subscription.getId() + "] can not be closed because of its status: " + this.subscription.getStatus();
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "subscription.closed";
    }

    @Override
    public Map<String, String> getParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("subscription", this.subscription.getId());
        parameters.put("status", this.subscription.getStatus().name());
        return parameters;
    }
}

