/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.common.http.HttpMethod;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.SubscriptionRepository;
import io.gravitee.repository.management.api.search.SubscriptionCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MessageChannel;
import io.gravitee.rest.api.model.MessageEntity;
import io.gravitee.rest.api.model.MessageRecipientEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.MessageService;
import io.gravitee.rest.api.service.PortalNotificationService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.MessageEmptyException;
import io.gravitee.rest.api.service.exceptions.MessageRecipientFormatException;
import io.gravitee.rest.api.service.exceptions.MessageUrlForbiddenException;
import io.gravitee.rest.api.service.exceptions.NotifierDisabledException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.Hook;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.notification.PortalHook;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MessageServiceImpl
extends AbstractService
implements MessageService,
InitializingBean {
    private static final String API_SUBSCRIBERS = "API_SUBSCRIBERS";
    private final Logger LOGGER = LoggerFactory.getLogger(MessageServiceImpl.class);
    @Autowired
    ApiRepository apiRepository;
    @Autowired
    MembershipService membershipService;
    @Autowired
    SubscriptionRepository subscriptionRepository;
    @Autowired
    PortalNotificationService portalNotificationService;
    @Autowired
    UserService userService;
    @Autowired
    AuditService auditService;
    @Autowired
    EmailService emailService;
    @Autowired
    ApiService apiService;
    @Autowired
    ApplicationService applicationService;
    @Autowired
    RoleService roleService;
    @Autowired
    GroupService groupService;
    @Autowired
    HttpClientService httpClientService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    SubscriptionService subscriptionService;
    @Value(value="${notifiers.webhook.enabled:true}")
    private boolean httpEnabled;
    @Autowired
    private Environment environment;
    private List<String> httpWhitelist;

    public void afterPropertiesSet() {
        String whitelistUrl;
        int i = 0;
        this.httpWhitelist = new ArrayList<String>();
        while ((whitelistUrl = this.environment.getProperty("notifiers.webhook.whitelist[" + i + "]")) != null) {
            this.httpWhitelist.add(whitelistUrl);
            ++i;
        }
    }

    @Override
    public int create(ExecutionContext context, String apiId, MessageEntity message) {
        this.assertMessageNotEmpty(message);
        try {
            Optional optionalApi = this.apiRepository.findById((Object)apiId);
            if (!optionalApi.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            Api api = (Api)optionalApi.get();
            int msgSize = this.send(context, api, message, this.getRecipientsId(context, api, message));
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), MessageEvent.MESSAGE_SENT, new Date(), null, message);
            return msgSize;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get create a message", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to create a message", ex);
        }
    }

    @Override
    public int create(ExecutionContext context, MessageEntity message) {
        this.assertMessageNotEmpty(message);
        int msgSize = this.send(context, null, message, this.getRecipientsId(context, message));
        this.auditService.createEnvironmentAuditLog(context.getEnvironmentId(), Collections.emptyMap(), MessageEvent.MESSAGE_SENT, new Date(), null, message);
        return msgSize;
    }

    private int send(ExecutionContext context, Api api, MessageEntity message, Set<String> recipientsId) {
        switch (message.getChannel()) {
            case MAIL: {
                Set<String> mails = this.getRecipientsEmails(recipientsId);
                if (!mails.isEmpty()) {
                    this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().to(EmailService.DEFAULT_MAIL_TO).bcc(mails.toArray(new String[0])).template(EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_GENERIC_MESSAGE).param("message", message.getText()).param("messageSubject", message.getTitle()).build(), context.getReferenceContext());
                }
                return mails.size();
            }
            case PORTAL: {
                Enum hook = api == null ? PortalHook.MESSAGE : ApiHook.MESSAGE;
                this.portalNotificationService.create((Hook)((Object)hook), (List<String>)new ArrayList<String>(recipientsId), this.getPortalParams(api, message));
                return recipientsId.size();
            }
            case HTTP: {
                if (!this.httpEnabled) {
                    throw new NotifierDisabledException();
                }
                String url = recipientsId.iterator().next();
                this.environment.getProperty("notifiers.webhook.whitelist");
                if (this.httpWhitelist != null && !this.httpWhitelist.isEmpty() && this.httpWhitelist.stream().noneMatch(whitelistUrl -> whitelistUrl.endsWith("/") ? url.startsWith((String)whitelistUrl) : url.equals(whitelistUrl) || url.startsWith(whitelistUrl + "/"))) {
                    throw new MessageUrlForbiddenException();
                }
                this.httpClientService.request(HttpMethod.POST, url, message.getParams(), this.getPostMessage(api, message), message.isUseSystemProxy());
                return 1;
            }
        }
        return 0;
    }

    @Override
    public Set<String> getRecipientsId(ExecutionContext context, MessageEntity message) {
        if (MessageChannel.HTTP.equals((Object)message.getChannel())) {
            return Collections.singleton(message.getRecipient().getUrl());
        }
        return this.getRecipientsId(context, null, message);
    }

    @Override
    public Set<String> getRecipientsId(ExecutionContext context, Api api, MessageEntity message) {
        if (message != null && MessageChannel.HTTP.equals((Object)message.getChannel())) {
            return Collections.singleton(message.getRecipient().getUrl());
        }
        this.assertRecipientsNotEmpty(message);
        MessageRecipientEntity recipientEntity = message.getRecipient();
        try {
            HashSet<String> recipientIds = new HashSet<String>();
            if (api == null && RoleScope.ENVIRONMENT.name().equals(recipientEntity.getRoleScope())) {
                for (String roleName : recipientEntity.getRoleValues()) {
                    Optional<RoleEntity> optRole = this.roleService.findByScopeAndName(RoleScope.valueOf((String)recipientEntity.getRoleScope()), roleName);
                    if (!optRole.isPresent()) continue;
                    recipientIds.addAll(this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.ENVIRONMENT, context.getEnvironmentId(), optRole.get().getId()).stream().map(MembershipEntity::getMemberId).collect(Collectors.toSet()));
                }
            } else if (api != null && RoleScope.APPLICATION.name().equals(recipientEntity.getRoleScope())) {
                List<String> applicationIds = this.subscriptionRepository.search(new SubscriptionCriteria.Builder().apis(Collections.singleton(api.getId())).status(Subscription.Status.ACCEPTED).build()).stream().map(Subscription::getApplication).collect(Collectors.toList());
                for (String roleName : recipientEntity.getRoleValues()) {
                    Optional<RoleEntity> optRole = this.roleService.findByScopeAndName(RoleScope.APPLICATION, roleName);
                    if (optRole.isPresent()) {
                        recipientIds.addAll(this.membershipService.getMembershipsByReferencesAndRole(MembershipReferenceType.APPLICATION, applicationIds, optRole.get().getId()).stream().map(MembershipEntity::getMemberId).collect(Collectors.toSet()));
                        recipientIds.addAll(this.getIndirectMemberIds(context, applicationIds, optRole.get()));
                        continue;
                    }
                    if (!roleName.equals(API_SUBSCRIBERS)) continue;
                    Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(api.getId());
                    List subscribersId = subscriptions.stream().map(SubscriptionEntity::getSubscribedBy).distinct().collect(Collectors.toList());
                    recipientIds.addAll(subscribersId);
                }
            }
            return recipientIds;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to get recipients", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to get recipients", ex);
        }
    }

    private Set<String> getIndirectMemberIds(ExecutionContext context, List<String> applicationIds, RoleEntity roleEntity) {
        if (applicationIds.isEmpty() || SystemRole.PRIMARY_OWNER.name().equals(roleEntity.getName())) {
            return Collections.emptySet();
        }
        List<String> applicationsGroups = this.applicationService.findByIds(context, applicationIds).stream().flatMap(applicationListItem -> applicationListItem.getGroups().stream()).distinct().collect(Collectors.toList());
        if (applicationsGroups.isEmpty()) {
            return Collections.emptySet();
        }
        return this.membershipService.getMembershipsByReferencesAndRole(MembershipReferenceType.GROUP, applicationsGroups, roleEntity.getId()).stream().map(MembershipEntity::getMemberId).collect(Collectors.toSet());
    }

    private Set<String> getRecipientsEmails(Set<String> recipientsId) {
        if (recipientsId.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> emails = this.userService.findByIds(new ArrayList<String>(recipientsId)).stream().filter(userEntity -> !StringUtils.isEmpty((Object)userEntity.getEmail())).map(UserEntity::getEmail).collect(Collectors.toSet());
        return emails;
    }

    private void assertMessageNotEmpty(MessageEntity messageEntity) {
        if (messageEntity == null || StringUtils.isEmpty((Object)messageEntity.getTitle()) && StringUtils.isEmpty((Object)messageEntity.getText())) {
            throw new MessageEmptyException();
        }
    }

    private void assertRecipientsNotEmpty(MessageEntity messageEntity) {
        if (messageEntity == null || messageEntity.getRecipient() == null || messageEntity.getChannel() == null || messageEntity.getRecipient().getRoleScope() == null || messageEntity.getRecipient().getRoleValues() == null || messageEntity.getRecipient().getRoleValues().isEmpty()) {
            throw new MessageRecipientFormatException();
        }
    }

    private Map<String, Object> getPortalParams(Api api, MessageEntity message) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("title", message.getTitle());
        params.put("message", message.getText());
        if (api != null) {
            Api paramApi = new Api();
            paramApi.setId(api.getId());
            paramApi.setName(api.getName());
            paramApi.setVersion(api.getVersion());
            params.put("api", paramApi);
        }
        return params;
    }

    private String getPostMessage(Api api, MessageEntity message) {
        if (message.getText() == null || api == null) {
            return message.getText();
        }
        ApiModelEntity apiEntity = this.apiService.findByIdForTemplates(api.getId());
        HashMap<String, ApiModelEntity> model = new HashMap<String, ApiModelEntity>();
        model.put("api", apiEntity);
        return this.notificationTemplateService.resolveInlineTemplateWithParam(new Date().toString(), message.getText(), model);
    }

    public static enum MessageEvent implements Audit.AuditEvent
    {
        MESSAGE_SENT;

    }
}

