/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanEntity;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanSynchronizationProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger(PlanSynchronizationProcessor.class);
    @Autowired
    private ObjectMapper objectMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processCheckSynchronization(PlanEntity deployedPlan, PlanEntity planToDeploy) {
        Class<PlanEntity> cl = PlanEntity.class;
        ArrayList<Object> requiredFieldsDeployedPlan = new ArrayList<Object>();
        ArrayList<Object> requiredFieldsPlanToDeploy = new ArrayList<Object>();
        for (Field f : cl.getDeclaredFields()) {
            if (f.getAnnotation(DeploymentRequired.class) == null) continue;
            boolean previousAccessibleState = f.isAccessible();
            f.setAccessible(true);
            try {
                requiredFieldsDeployedPlan.add(f.get(deployedPlan));
                requiredFieldsPlanToDeploy.add(f.get(planToDeploy));
            }
            catch (Exception e) {
                this.LOGGER.error("Error access Plan required deployment fields", (Throwable)e);
            }
            finally {
                f.setAccessible(previousAccessibleState);
            }
        }
        try {
            String requiredFieldsDeployedPlanDefinition = this.objectMapper.writeValueAsString(requiredFieldsDeployedPlan);
            String requiredFieldsPlanToDeployDefinition = this.objectMapper.writeValueAsString(requiredFieldsPlanToDeploy);
            return requiredFieldsDeployedPlanDefinition.equals(requiredFieldsPlanToDeployDefinition);
        }
        catch (Exception e) {
            this.LOGGER.error("Unexpected error while generating Plan deployment required fields definition", (Throwable)e);
            return false;
        }
    }
}

