/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PlanRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Plan;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanSecurityEntity;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlansConfigurationEntity;
import io.gravitee.rest.api.model.UpdatePlanEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.plan.PlanQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.converter.PlanConverter;
import io.gravitee.rest.api.service.exceptions.ApiDeprecatedException;
import io.gravitee.rest.api.service.exceptions.KeylessPlanAlreadyPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyClosedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyDeprecatedException;
import io.gravitee.rest.api.service.exceptions.PlanAlreadyPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanGeneralConditionStatusException;
import io.gravitee.rest.api.service.exceptions.PlanInvalidException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.PlanNotYetPublishedException;
import io.gravitee.rest.api.service.exceptions.PlanWithSubscriptionsException;
import io.gravitee.rest.api.service.exceptions.SubscriptionNotClosableException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UnauthorizedPlanSecurityTypeException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.processor.PlanSynchronizationProcessor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanServiceImpl
extends TransactionalService
implements PlanService {
    private final Logger logger = LoggerFactory.getLogger(PlanServiceImpl.class);
    @Autowired
    private PlanRepository planRepository;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private PageService pageService;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private PlanSynchronizationProcessor planSynchronizationProcessor;
    @Autowired
    private ApiService apiService;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private PlanConverter planConverter;
    private static final List<PlanSecurityEntity> DEFAULT_SECURITY_LIST = Collections.unmodifiableList(Arrays.asList(new PlanSecurityEntity("oauth2", "OAuth2", "oauth2"), new PlanSecurityEntity("jwt", "JWT", "'jwt'"), new PlanSecurityEntity("api_key", "API Key", "api-key"), new PlanSecurityEntity("key_less", "Keyless (public)", "")));

    @Override
    public PlanEntity findById(String plan) {
        try {
            this.logger.debug("Find plan by id : {}", (Object)plan);
            Optional optPlan = this.planRepository.findById((Object)plan);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(plan);
            }
            return this.convert((io.gravitee.repository.management.model.Plan)optPlan.get());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a plan by id: {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by id: %s", plan), ex);
        }
    }

    @Override
    public Set<PlanEntity> findByIdIn(Set<String> ids) {
        try {
            return this.planRepository.findByIdIn(ids).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred retrieving plans by ids", e);
        }
    }

    @Override
    public Set<PlanEntity> findByApi(String api) {
        try {
            this.logger.debug("Find plan by api : {}", (Object)api);
            Set plans = this.planRepository.findByApi(api);
            return plans.stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to find a plan by api: {}", (Object)api, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to find a plan by api: %s", api), ex);
        }
    }

    @Override
    public List<PlanEntity> search(PlanQuery query) {
        Set<Object> planEntities = query.getApi() != null ? this.findByApi(query.getApi()) : Collections.emptySet();
        return planEntities.stream().filter(p -> {
            boolean filtered = true;
            if (query.getName() != null) {
                filtered = p.getName().equals(query.getName());
            }
            if (filtered && query.getSecurity() != null) {
                filtered = p.getSecurity().equals((Object)query.getSecurity());
            }
            return filtered;
        }).collect(Collectors.toList());
    }

    @Override
    public PlanEntity create(NewPlanEntity newPlan) {
        try {
            this.logger.debug("Create a new plan {} for API {}", (Object)newPlan.getName(), (Object)newPlan.getApi());
            this.assertPlanSecurityIsAllowed(newPlan.getSecurity());
            ApiEntity api = this.apiService.findById(newPlan.getApi());
            if (ApiLifecycleState.DEPRECATED.equals((Object)api.getLifecycleState())) {
                throw new ApiDeprecatedException(api.getName());
            }
            String id = newPlan.getId() != null && UUID.fromString(newPlan.getId()) != null ? newPlan.getId() : UuidString.generateRandom();
            newPlan.setId(id);
            io.gravitee.repository.management.model.Plan plan = this.planConverter.toPlan(newPlan, DefinitionVersion.valueOfLabel((String)api.getGraviteeDefinitionVersion()));
            plan = (io.gravitee.repository.management.model.Plan)this.planRepository.create((Object)plan);
            if (DefinitionVersion.V2.equals((Object)DefinitionVersion.valueOfLabel((String)api.getGraviteeDefinitionVersion()))) {
                UpdateApiEntity updateApi = this.apiConverter.toUpdateApiEntity(api);
                updateApi.addPlan(this.fillApiDefinitionPlan(new Plan(), plan, newPlan.getFlows()));
                this.apiService.update(api.getId(), updateApi);
            }
            this.auditService.createApiAuditLog(newPlan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_CREATED, plan.getCreatedAt(), null, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create a plan {} for API {}", new Object[]{newPlan.getName(), newPlan.getApi(), ex});
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApi()), ex);
        }
        catch (JsonProcessingException jse) {
            this.logger.error("Unexpected error while generating plan definition", (Throwable)jse);
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a plan %s for API %s", newPlan.getName(), newPlan.getApi()), jse);
        }
    }

    @Override
    public PlanEntity createOrUpdatePlan(PlanEntity planEntity, String environmentId) {
        PlanEntity resultPlanEntity;
        try {
            this.findById(planEntity.getId());
            resultPlanEntity = this.update(this.planConverter.toUpdatePlanEntity(planEntity));
        }
        catch (PlanNotFoundException npe) {
            resultPlanEntity = this.create(this.planConverter.toNewPlanEntity(planEntity));
        }
        return resultPlanEntity;
    }

    @Override
    public PlanEntity update(UpdatePlanEntity updatePlan) {
        return this.update(updatePlan, false);
    }

    @Override
    public PlanEntity update(UpdatePlanEntity updatePlan, boolean fromImport) {
        try {
            this.logger.debug("Update plan {}", (Object)updatePlan.getName());
            Optional optPlan = this.planRepository.findById((Object)updatePlan.getId());
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(updatePlan.getId());
            }
            io.gravitee.repository.management.model.Plan oldPlan = (io.gravitee.repository.management.model.Plan)optPlan.get();
            this.assertPlanSecurityIsAllowed(PlanSecurityType.valueOf((String)oldPlan.getSecurity().name()));
            ApiEntity api = this.apiService.findById(oldPlan.getApi());
            if (DefinitionVersion.V2.equals((Object)DefinitionVersion.valueOfLabel((String)api.getGraviteeDefinitionVersion())) && updatePlan.getFlows() == null) {
                throw new PlanInvalidException(updatePlan.getId());
            }
            io.gravitee.repository.management.model.Plan newPlan = new io.gravitee.repository.management.model.Plan();
            newPlan.setId(oldPlan.getId());
            newPlan.setSecurity(oldPlan.getSecurity());
            newPlan.setType(oldPlan.getType());
            newPlan.setStatus(oldPlan.getStatus());
            newPlan.setOrder(oldPlan.getOrder());
            newPlan.setApi(oldPlan.getApi());
            newPlan.setCreatedAt(oldPlan.getCreatedAt());
            newPlan.setPublishedAt(oldPlan.getPublishedAt());
            newPlan.setClosedAt(oldPlan.getClosedAt());
            if (oldPlan.getNeedRedeployAt() == null) {
                newPlan.setNeedRedeployAt(oldPlan.getUpdatedAt());
            } else {
                newPlan.setNeedRedeployAt(oldPlan.getNeedRedeployAt());
            }
            newPlan.setName(updatePlan.getName());
            newPlan.setCrossId(updatePlan.getCrossId() != null ? updatePlan.getCrossId() : oldPlan.getCrossId());
            newPlan.setDescription(updatePlan.getDescription());
            newPlan.setUpdatedAt(new Date());
            newPlan.setSecurityDefinition(updatePlan.getSecurityDefinition());
            newPlan.setCommentRequired(updatePlan.isCommentRequired());
            newPlan.setCommentMessage(updatePlan.getCommentMessage());
            newPlan.setTags(updatePlan.getTags());
            newPlan.setSelectionRule(updatePlan.getSelectionRule());
            newPlan.setGeneralConditions(updatePlan.getGeneralConditions());
            if (Plan.Status.PUBLISHED.equals((Object)newPlan.getStatus()) || Plan.Status.DEPRECATED.equals((Object)newPlan.getStatus())) {
                this.checkStatusOfGeneralConditions(newPlan);
            }
            String planPolicies = this.objectMapper.writeValueAsString((Object)updatePlan.getPaths());
            newPlan.setDefinition(planPolicies);
            newPlan.setExcludedGroups(updatePlan.getExcludedGroups());
            if (newPlan.getSecurity() == Plan.PlanSecurityType.KEY_LESS) {
                newPlan.setValidation(Plan.PlanValidationType.AUTO);
            } else {
                newPlan.setValidation(Plan.PlanValidationType.valueOf((String)updatePlan.getValidation().name()));
            }
            newPlan.setCharacteristics(updatePlan.getCharacteristics());
            this.updatePlanToApiDefinition(api, newPlan, updatePlan.getFlows(), fromImport);
            if (newPlan.getOrder() != updatePlan.getOrder()) {
                newPlan.setOrder(updatePlan.getOrder());
                this.reorderAndSavePlans(newPlan);
                return null;
            }
            if (!this.planSynchronizationProcessor.processCheckSynchronization(this.convert(oldPlan), this.convert(newPlan))) {
                newPlan.setNeedRedeployAt(newPlan.getUpdatedAt());
            }
            newPlan = (io.gravitee.repository.management.model.Plan)this.planRepository.update((Object)newPlan);
            this.auditService.createApiAuditLog(newPlan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, newPlan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_UPDATED, newPlan.getUpdatedAt(), oldPlan, newPlan);
            return this.convert(newPlan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)updatePlan.getName(), (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update plan %s", updatePlan.getName()), ex);
        }
        catch (JsonProcessingException jse) {
            this.logger.error("Unexpected error while generating plan definition", (Throwable)jse);
            throw new TechnicalManagementException(String.format("An error occurs while trying to update a plan %s", updatePlan.getName()), jse);
        }
    }

    private void checkStatusOfGeneralConditions(io.gravitee.repository.management.model.Plan plan) {
        PageEntity generalConditions;
        if (plan.getGeneralConditions() != null && !plan.getGeneralConditions().isEmpty() && !(generalConditions = this.pageService.findById(plan.getGeneralConditions())).isPublished()) {
            throw new PlanGeneralConditionStatusException(plan.getName());
        }
    }

    @Override
    public PlanEntity close(String planId, String userId) {
        try {
            this.logger.debug("Close plan {}", (Object)planId);
            Optional optPlan = this.planRepository.findById((Object)planId);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(planId);
            }
            io.gravitee.repository.management.model.Plan plan = (io.gravitee.repository.management.model.Plan)optPlan.get();
            io.gravitee.repository.management.model.Plan previousPlan = new io.gravitee.repository.management.model.Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            plan.setStatus(Plan.Status.CLOSED);
            plan.setClosedAt(new Date());
            plan.setUpdatedAt(plan.getClosedAt());
            plan.setNeedRedeployAt(plan.getClosedAt());
            if (plan.getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                this.subscriptionService.findByPlan(planId).stream().forEach(subscription -> {
                    try {
                        this.subscriptionService.close(subscription.getId());
                    }
                    catch (SubscriptionNotClosableException subscriptionNotClosableException) {
                        // empty catch block
                    }
                });
            }
            plan = (io.gravitee.repository.management.model.Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_CLOSED, plan.getUpdatedAt(), previousPlan, plan);
            this.reorderedAndSavePlansAfterRemove((io.gravitee.repository.management.model.Plan)optPlan.get());
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete plan: %s", planId), ex);
        }
    }

    @Override
    public void delete(String plan) {
        try {
            this.logger.debug("Delete plan {}", (Object)plan);
            Optional optPlan = this.planRepository.findById((Object)plan);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(plan);
            }
            if (((io.gravitee.repository.management.model.Plan)optPlan.get()).getSecurity() != Plan.PlanSecurityType.KEY_LESS) {
                int subscriptions = this.subscriptionService.findByPlan(plan).size();
                if ((((io.gravitee.repository.management.model.Plan)optPlan.get()).getStatus() == Plan.Status.PUBLISHED || ((io.gravitee.repository.management.model.Plan)optPlan.get()).getStatus() == Plan.Status.DEPRECATED) && subscriptions > 0) {
                    throw new PlanWithSubscriptionsException(plan);
                }
            }
            this.planRepository.delete((Object)plan);
            this.auditService.createApiAuditLog(((io.gravitee.repository.management.model.Plan)optPlan.get()).getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, ((io.gravitee.repository.management.model.Plan)optPlan.get()).getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_DELETED, new Date(), optPlan.get(), null);
            this.reorderedAndSavePlansAfterRemove((io.gravitee.repository.management.model.Plan)optPlan.get());
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to delete plan: {}", (Object)plan, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete plan: %s", plan), ex);
        }
    }

    private void updatePlanToApiDefinition(io.gravitee.repository.management.model.Plan updatedPlan) {
        String apiId = updatedPlan.getApi();
        if (apiId != null) {
            ApiEntity api = this.apiService.findById(apiId);
            this.updatePlanToApiDefinition(api, updatedPlan, null, false);
        }
    }

    private void updatePlanToApiDefinition(ApiEntity api, io.gravitee.repository.management.model.Plan updatedPlan, List<Flow> flows, boolean fromImport) {
        if (api != null && DefinitionVersion.V2.equals((Object)DefinitionVersion.valueOfLabel((String)api.getGraviteeDefinitionVersion()))) {
            Optional<Plan> existingPlan = api.getPlans().stream().filter(plan -> plan.getId().equals(updatedPlan.getId())).findFirst();
            UpdateApiEntity updateApi = this.apiConverter.toUpdateApiEntity(api);
            if (existingPlan.isPresent()) {
                this.fillApiDefinitionPlan(existingPlan.get(), updatedPlan, flows);
            } else if (fromImport) {
                updateApi.addPlan(this.fillApiDefinitionPlan(new Plan(), updatedPlan, flows));
            }
            this.apiService.update(updatedPlan.getApi(), updateApi);
        }
    }

    private Plan fillApiDefinitionPlan(Plan plan, io.gravitee.repository.management.model.Plan updatedPlan, List<Flow> flows) {
        plan.setId(updatedPlan.getId());
        plan.setName(updatedPlan.getName());
        plan.setSecurity(updatedPlan.getSecurity().name());
        plan.setSecurityDefinition(updatedPlan.getSecurityDefinition());
        plan.setStatus(updatedPlan.getStatus().name());
        plan.setTags(updatedPlan.getTags());
        plan.setSelectionRule(updatedPlan.getSelectionRule());
        if (flows != null) {
            plan.setFlows(flows);
        }
        return plan;
    }

    @Override
    public PlanEntity publish(String planId) {
        try {
            long count;
            this.logger.debug("Publish plan {}", (Object)planId);
            Optional optPlan = this.planRepository.findById((Object)planId);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(planId);
            }
            io.gravitee.repository.management.model.Plan plan = (io.gravitee.repository.management.model.Plan)optPlan.get();
            io.gravitee.repository.management.model.Plan previousPlan = new io.gravitee.repository.management.model.Plan(plan);
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (plan.getStatus() == Plan.Status.PUBLISHED) {
                throw new PlanAlreadyPublishedException(planId);
            }
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            this.checkStatusOfGeneralConditions(plan);
            Set plans = this.planRepository.findByApi(plan.getApi());
            if (plan.getSecurity() == Plan.PlanSecurityType.KEY_LESS && (count = plans.stream().filter(plan1 -> plan1.getStatus() == Plan.Status.PUBLISHED || plan1.getStatus() == Plan.Status.DEPRECATED).filter(plan1 -> plan1.getSecurity() == Plan.PlanSecurityType.KEY_LESS).count()) > 0L) {
                throw new KeylessPlanAlreadyPublishedException(planId);
            }
            plan.setStatus(Plan.Status.PUBLISHED);
            List orderedPublishedPlans = plans.stream().filter(plan1 -> Plan.Status.PUBLISHED.equals((Object)plan1.getStatus())).sorted(Comparator.comparingInt(io.gravitee.repository.management.model.Plan::getOrder)).collect(Collectors.toList());
            plan.setOrder(orderedPublishedPlans.isEmpty() ? 1 : ((io.gravitee.repository.management.model.Plan)orderedPublishedPlans.get(orderedPublishedPlans.size() - 1)).getOrder() + 1);
            plan.setPublishedAt(new Date());
            plan.setUpdatedAt(plan.getPublishedAt());
            plan.setNeedRedeployAt(plan.getPublishedAt());
            this.updatePlanToApiDefinition(plan);
            plan = (io.gravitee.repository.management.model.Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_PUBLISHED, plan.getUpdatedAt(), previousPlan, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to publish plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to publish plan: %s", planId), ex);
        }
    }

    @Override
    public PlanEntity deprecate(String planId) {
        return this.deprecate(planId, false);
    }

    @Override
    public PlanEntity deprecate(String planId, boolean allowStaging) {
        try {
            this.logger.debug("Deprecate plan {}", (Object)planId);
            Optional optPlan = this.planRepository.findById((Object)planId);
            if (!optPlan.isPresent()) {
                throw new PlanNotFoundException(planId);
            }
            io.gravitee.repository.management.model.Plan plan = (io.gravitee.repository.management.model.Plan)optPlan.get();
            io.gravitee.repository.management.model.Plan previousPlan = new io.gravitee.repository.management.model.Plan(plan);
            if (plan.getStatus() == Plan.Status.DEPRECATED) {
                throw new PlanAlreadyDeprecatedException(planId);
            }
            if (plan.getStatus() == Plan.Status.CLOSED) {
                throw new PlanAlreadyClosedException(planId);
            }
            if (!allowStaging && plan.getStatus() == Plan.Status.STAGING) {
                throw new PlanNotYetPublishedException(planId);
            }
            plan.setStatus(Plan.Status.DEPRECATED);
            plan.setUpdatedAt(new Date());
            this.updatePlanToApiDefinition(plan);
            plan = (io.gravitee.repository.management.model.Plan)this.planRepository.update((Object)plan);
            this.auditService.createApiAuditLog(plan.getApi(), Collections.singletonMap(Audit.AuditProperties.PLAN, plan.getId()), (Audit.AuditEvent)Plan.AuditEvent.PLAN_DEPRECATED, plan.getUpdatedAt(), previousPlan, plan);
            return this.convert(plan);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to deprecate plan: {}", (Object)planId, (Object)ex);
            throw new TechnicalManagementException(String.format("An error occurs while trying to deprecate plan: %s", planId), ex);
        }
    }

    @Override
    public PlansConfigurationEntity getConfiguration() {
        PlansConfigurationEntity config = new PlansConfigurationEntity();
        config.setSecurity(DEFAULT_SECURITY_LIST);
        return config;
    }

    private void reorderAndSavePlans(io.gravitee.repository.management.model.Plan planToReorder) throws TechnicalException {
        Set plans = this.planRepository.findByApi(planToReorder.getApi());
        io.gravitee.repository.management.model.Plan[] plansToReorder = (io.gravitee.repository.management.model.Plan[])plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus()) && !Objects.equals(p.getId(), planToReorder.getId())).sorted(Comparator.comparingInt(io.gravitee.repository.management.model.Plan::getOrder)).toArray(io.gravitee.repository.management.model.Plan[]::new);
        if (planToReorder.getOrder() < 1) {
            planToReorder.setOrder(1);
        } else if (planToReorder.getOrder() > plansToReorder.length + 1) {
            planToReorder.setOrder(plansToReorder.length + 1);
        }
        try {
            for (int i = 0; i < plansToReorder.length; ++i) {
                int newOrder;
                int n = newOrder = i + 1 < planToReorder.getOrder() ? i + 1 : i + 2;
                if (plansToReorder[i].getOrder() == newOrder) continue;
                plansToReorder[i].setOrder(newOrder);
                this.planRepository.update((Object)plansToReorder[i]);
            }
            this.planRepository.update((Object)planToReorder);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to update plan {}", (Object)planToReorder.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update plan " + planToReorder.getId(), ex);
        }
    }

    private void reorderedAndSavePlansAfterRemove(io.gravitee.repository.management.model.Plan planRemoved) throws TechnicalException {
        Set plans = this.planRepository.findByApi(planRemoved.getApi());
        plans.stream().filter(p -> Plan.Status.PUBLISHED.equals((Object)p.getStatus())).sorted(Comparator.comparingInt(io.gravitee.repository.management.model.Plan::getOrder)).forEachOrdered(plan -> {
            try {
                if (plan.getOrder() > planRemoved.getOrder()) {
                    plan.setOrder(plan.getOrder() - 1);
                    this.planRepository.update(plan);
                }
            }
            catch (TechnicalException ex) {
                this.logger.error("An error occurs while trying to reorder plan {}", (Object)plan.getId(), (Object)ex);
                throw new TechnicalManagementException("An error occurs while trying to update plan " + plan.getId(), ex);
            }
        });
    }

    private PlanEntity convert(io.gravitee.repository.management.model.Plan plan) {
        return this.planConverter.toPlanEntity(plan, this.apiService.findById(plan.getApi()));
    }

    private void assertPlanSecurityIsAllowed(PlanSecurityType securityType) {
        Key securityKey;
        switch (securityType) {
            case API_KEY: {
                securityKey = Key.PLAN_SECURITY_APIKEY_ENABLED;
                break;
            }
            case OAUTH2: {
                securityKey = Key.PLAN_SECURITY_OAUTH2_ENABLED;
                break;
            }
            case JWT: {
                securityKey = Key.PLAN_SECURITY_JWT_ENABLED;
                break;
            }
            case KEY_LESS: {
                securityKey = Key.PLAN_SECURITY_KEYLESS_ENABLED;
                break;
            }
            default: {
                return;
            }
        }
        if (!this.parameterService.findAsBoolean(securityKey, ParameterReferenceType.ENVIRONMENT)) {
            throw new UnauthorizedPlanSecurityTypeException(securityType);
        }
    }

    @Override
    public boolean anyPlanMismatchWithApi(List<String> planIds, String apiId) {
        try {
            return this.planRepository.findByIdIn(planIds).stream().map(io.gravitee.repository.management.model.Plan::getApi).filter(Objects::nonNull).anyMatch(id -> !id.equals(apiId));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error has occurred checking plans ownership", e);
        }
    }
}

