/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.repository.management.model.Subscription;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionNotClosableException
extends AbstractManagementException {
    private final Subscription subscription;

    public SubscriptionNotClosableException(Subscription subscription) {
        this.subscription = subscription;
    }

    @Override
    public String getMessage() {
        return "Subscription [" + this.subscription.getId() + "] can not be closed because of its status: " + this.subscription.getStatus();
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "subscription.closed";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("subscription", SubscriptionNotClosableException.this.subscription.getId());
                this.put("status", SubscriptionNotClosableException.this.subscription.getStatus().name());
            }
        };
    }
}

