/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.common.util.Maps;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.List;
import java.util.Map;

public class InvalidVirtualHostException
extends AbstractManagementException {
    private final String host;
    private final List<String> restrictions;

    public InvalidVirtualHostException(String host, List<String> restrictions) {
        this.host = host;
        this.restrictions = restrictions;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "virtualHost.invalid";
    }

    @Override
    public Map<String, String> getParameters() {
        return Maps.builder().put((Object)"host", (Object)this.host).put((Object)"restrictions", (Object)String.join((CharSequence)",", this.restrictions)).build();
    }

    @Override
    public String getMessage() {
        return "Host [" + this.host + "] must be a subdomain of " + this.restrictions;
    }
}

