/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.imports;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.gravitee.rest.api.service.imports.ImportJsonNode;
import io.gravitee.rest.api.service.imports.ImportJsonNodeWithIds;
import java.util.List;
import java.util.stream.Collectors;

public class ImportApiJsonNode
extends ImportJsonNodeWithIds {
    public static final String PLANS = "plans";
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String VIEWS = "views";
    public static final String API_MEDIA = "apiMedia";
    public static final String MEMBERS = "members";

    public ImportApiJsonNode(JsonNode jsonNode) {
        super(jsonNode);
    }

    public boolean hasPlans() {
        return this.hasArray(PLANS);
    }

    public List<ImportJsonNodeWithIds> getPlans() {
        return this.getChildNodesWithIdByName(PLANS);
    }

    public boolean hasPages() {
        return this.hasArray(PAGES);
    }

    public List<ImportJsonNodeWithIds> getPages() {
        return this.getChildNodesWithIdByName(PAGES);
    }

    public ArrayNode getPagesArray() {
        return this.getArray(PAGES);
    }

    public List<ImportJsonNode> getMetadata() {
        return this.getChildExtendedNodesByName(METADATA);
    }

    public List<ImportJsonNode> getViews() {
        return this.getChildExtendedNodesByName(VIEWS);
    }

    public List<ImportJsonNode> getMedia() {
        return this.getChildExtendedNodesByName(API_MEDIA);
    }

    public List<ImportJsonNode> getMembers() {
        return this.getChildExtendedNodesByName(MEMBERS);
    }

    public boolean hasMembers() {
        return this.hasArray(MEMBERS);
    }

    private List<ImportJsonNodeWithIds> getChildNodesWithIdByName(String fieldName) {
        return this.getChildNodesByName(fieldName).stream().map(ImportJsonNodeWithIds::new).collect(Collectors.toList());
    }

    private List<ImportJsonNode> getChildExtendedNodesByName(String fieldName) {
        return this.getChildNodesByName(fieldName).stream().map(ImportJsonNode::new).collect(Collectors.toList());
    }
}

