/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Category;
import io.gravitee.rest.api.service.impl.upgrade.OneShotUpgrader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrphanCategoryUpgrader
extends OneShotUpgrader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrphanCategoryUpgrader.class);
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private CategoryRepository categoryRepository;

    public OrphanCategoryUpgrader() {
        super("ORPHAN_CATEGORY_UPGRADER_STATUS");
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    protected void processOneShotUpgrade() throws TechnicalException {
        Set<Api> updatedApis = this.findAndFixApisWithOrphanCategories();
        for (Api api : updatedApis) {
            LOGGER.info("Removing orphan categories for API [{}]", (Object)api.getId());
            this.apiRepository.update((Object)api);
        }
    }

    private Set<Api> findAndFixApisWithOrphanCategories() throws TechnicalException {
        Set<String> existingCategoryIds = this.getExistingCategoryIds();
        return this.apiRepository.findAll().stream().filter(api -> this.hasOrphanCategories((Api)api, existingCategoryIds)).peek(api -> this.removeOrphanCategories((Api)api, existingCategoryIds)).collect(Collectors.toSet());
    }

    private void removeOrphanCategories(Api api, Set<String> existingCategoryIds) {
        HashSet updatedCategories = new HashSet(api.getCategories());
        updatedCategories.retainAll(existingCategoryIds);
        api.setCategories(updatedCategories);
    }

    private boolean hasOrphanCategories(Api api, Set<String> existingCategoryIds) {
        if (CollectionUtils.isEmpty((Collection)api.getCategories())) {
            return false;
        }
        HashSet orphanCategories = new HashSet(api.getCategories());
        orphanCategories.removeAll(existingCategoryIds);
        return !orphanCategories.isEmpty();
    }

    private Set<String> getExistingCategoryIds() throws TechnicalException {
        return this.categoryRepository.findAll().stream().map(Category::getId).collect(Collectors.toSet());
    }
}

