/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.media.api.MediaRepository;
import io.gravitee.repository.media.model.Media;
import io.gravitee.rest.api.model.MediaEntity;
import io.gravitee.rest.api.model.PageMediaEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MediaServiceImpl
implements MediaService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaServiceImpl.class);
    @Autowired
    private MediaRepository mediaRepository;
    @Autowired
    private ConfigService configService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public String savePortalMedia(MediaEntity mediaEntity) {
        return this.saveApiMedia(null, mediaEntity);
    }

    @Override
    public String saveApiMedia(String api, MediaEntity mediaEntity) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(mediaEntity.getData());
            String hashString = DatatypeConverter.printHexBinary((byte[])hash);
            String id = mediaEntity.getId() != null && UUID.fromString(mediaEntity.getId()) != null ? mediaEntity.getId() : UuidString.generateRandom();
            Optional checkMedia = null;
            checkMedia = api != null ? this.mediaRepository.findByHashAndApiAndType(hashString, api, mediaEntity.getType()) : this.mediaRepository.findByHashAndType(hashString, mediaEntity.getType());
            if (checkMedia.isPresent()) {
                return ((Media)checkMedia.get()).getHash();
            }
            Media media = MediaServiceImpl.convert(mediaEntity);
            media.setId(id);
            media.setHash(hashString);
            media.setSize(Long.valueOf(mediaEntity.getData().length));
            media.setApi(api);
            media.setData(mediaEntity.getData());
            this.mediaRepository.create(media);
            return hashString;
        }
        catch (TechnicalException | NoSuchAlgorithmException ex) {
            LOGGER.error("An error occurs while trying to create {}", (Object)mediaEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + mediaEntity, ex);
        }
    }

    @Override
    public MediaEntity findByHash(String hash) {
        Optional mediaData = this.mediaRepository.findByHashAndType(hash, "image");
        return mediaData.isPresent() ? MediaServiceImpl.convert((Media)mediaData.get()) : null;
    }

    @Override
    public MediaEntity findByHashAndApiId(String hash, String apiId) {
        Optional mediaData = this.mediaRepository.findByHashAndApiAndType(hash, apiId, "image");
        return mediaData.isPresent() ? MediaServiceImpl.convert((Media)mediaData.get()) : null;
    }

    @Override
    public MediaEntity findByHash(String id, boolean ignoreType) {
        Optional mediaData = ignoreType ? this.mediaRepository.findByHash(id) : this.mediaRepository.findByHashAndType(id, "image");
        return mediaData.isPresent() ? MediaServiceImpl.convert((Media)mediaData.get()) : null;
    }

    @Override
    public MediaEntity findByHashAndApi(String id, String api, boolean ignoreType) {
        Optional mediaData = ignoreType ? this.mediaRepository.findByHashAndApi(id, api) : this.mediaRepository.findByHashAndApiAndType(id, api, "image");
        return mediaData.isPresent() ? MediaServiceImpl.convert((Media)mediaData.get()) : null;
    }

    @Override
    public List<MediaEntity> findAllWithoutContent(List<PageMediaEntity> pageMediaEntities) {
        return this.findAllWithoutContent(pageMediaEntities, null);
    }

    @Override
    public List<MediaEntity> findAllWithoutContent(List<PageMediaEntity> pageMediaEntities, String api) {
        ArrayList<MediaEntity> result = new ArrayList<MediaEntity>();
        if (pageMediaEntities != null && !pageMediaEntities.isEmpty()) {
            for (PageMediaEntity pme : pageMediaEntities) {
                Optional foundMedia = this.mediaRepository.findByHashAndApi(pme.getMediaHash(), api, false);
                if (!foundMedia.isPresent()) continue;
                MediaEntity me = MediaServiceImpl.convert((Media)foundMedia.get());
                me.setFileName(pme.getMediaName());
                me.setUploadDate(pme.getAttachedAt());
                result.add(me);
            }
        }
        return result;
    }

    @Override
    public Long getMediaMaxSize(String environmentId) {
        return (long)this.configService.getPortalSettings(environmentId).getPortal().getUploadMedia().getMaxSizeInOctet();
    }

    @Override
    public List<MediaEntity> findAllByApiId(String apiId) {
        return this.mediaRepository.findAllByApi(apiId).stream().map(media -> MediaServiceImpl.convert(media)).collect(Collectors.toList());
    }

    @Override
    public String createWithDefinition(String api, String mediaDefinition) {
        try {
            MediaEntity media = this.convertToEntity(mediaDefinition);
            return this.saveApiMedia(api, media);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the media {}", (Object)mediaDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the Media definition.");
        }
    }

    @Override
    public void deleteAllByApi(String apiId) {
        this.mediaRepository.deleteAllByApi(apiId);
    }

    private MediaEntity convertToEntity(String mediaDefinition) throws JsonProcessingException {
        MediaEntity media = (MediaEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(mediaDefinition, MediaEntity.class);
        return media;
    }

    private static Media convert(MediaEntity imageEntity) {
        Media media = new Media();
        media.setFileName(imageEntity.getFileName());
        media.setSize(Long.valueOf(imageEntity.getSize()));
        media.setType(imageEntity.getType());
        media.setSubType(imageEntity.getSubType());
        media.setId(imageEntity.getId());
        return media;
    }

    private static MediaEntity convert(Media media) {
        MediaEntity mediaEntity = new MediaEntity();
        mediaEntity.setId(media.getId());
        mediaEntity.setData(media.getData());
        mediaEntity.setType(media.getType());
        mediaEntity.setSubType(media.getSubType());
        mediaEntity.setFileName(media.getFileName());
        mediaEntity.setSize(media.getSize().longValue());
        mediaEntity.setUploadDate(media.getCreatedAt());
        mediaEntity.setHash(media.getHash());
        return mediaEntity;
    }
}

