/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.node.api.Node;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.CommandRepository;
import io.gravitee.repository.management.api.search.CommandCriteria;
import io.gravitee.repository.management.model.Command;
import io.gravitee.rest.api.model.command.CommandEntity;
import io.gravitee.rest.api.model.command.CommandQuery;
import io.gravitee.rest.api.model.command.CommandTags;
import io.gravitee.rest.api.model.command.NewCommandEntity;
import io.gravitee.rest.api.service.CommandService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.Message2RecipientNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommandServiceImpl
extends AbstractService
implements CommandService {
    private final Logger logger = LoggerFactory.getLogger(CommandServiceImpl.class);
    @Autowired
    CommandRepository commandRepository;
    @Autowired
    Node node;

    @Override
    public void send(NewCommandEntity messageEntity) {
        if (messageEntity.getTo() == null || messageEntity.getTo().isEmpty()) {
            throw new Message2RecipientNotFoundException();
        }
        Command command = new Command();
        command.setId(UuidString.generateRandom());
        command.setEnvironmentId(GraviteeContext.getCurrentEnvironmentOrDefault());
        command.setFrom(this.node.id());
        command.setTo(messageEntity.getTo());
        command.setTags(this.convert(messageEntity.getTags()));
        long now = System.currentTimeMillis();
        command.setCreatedAt(new Date(now));
        command.setUpdatedAt(command.getCreatedAt());
        command.setExpiredAt(new Date(now + messageEntity.getTtlInSeconds() * 1000L));
        if (messageEntity.getContent() != null) {
            command.setContent(messageEntity.getContent());
        }
        try {
            this.commandRepository.create((Object)command);
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to create {}", (Object)command, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying create " + command, ex);
        }
    }

    @Override
    public List<CommandEntity> search(CommandQuery query) {
        String[] tags = null;
        if (query.getTags() != null) {
            tags = (String[])query.getTags().stream().map(Enum::name).toArray(String[]::new);
        }
        CommandCriteria criteria = new CommandCriteria.Builder().to(query.getTo()).tags(tags).environmentId(GraviteeContext.getCurrentEnvironment()).build();
        return this.commandRepository.search(criteria).stream().map(this::map).collect(Collectors.toList());
    }

    @Override
    public void ack(String messageId) {
        try {
            Optional optMsg = this.commandRepository.findById((Object)messageId);
            if (optMsg.isPresent()) {
                Command msg = (Command)optMsg.get();
                if (msg.getAcknowledgments() == null) {
                    msg.setAcknowledgments(Collections.singletonList(this.node.id()));
                } else if (!msg.getAcknowledgments().contains(this.node.id())) {
                    msg.getAcknowledgments().add(this.node.id());
                }
                this.commandRepository.update((Object)msg);
            }
        }
        catch (TechnicalException ex) {
            this.logger.error("An error occurs while trying to acknowledge a message", (Throwable)ex);
        }
    }

    @Override
    public void delete(String commandId) {
        try {
            Optional commandOptional = this.commandRepository.findById((Object)commandId);
            if (commandOptional.isPresent()) {
                this.commandRepository.delete((Object)commandId);
            }
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to delete command " + commandId;
            this.logger.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    private List<String> convert(List<CommandTags> tags) {
        if (tags == null || tags.isEmpty()) {
            return Collections.emptyList();
        }
        return tags.stream().map(Enum::name).collect(Collectors.toList());
    }

    private CommandEntity map(Command command) {
        if (command == null) {
            return null;
        }
        CommandEntity commandEntity = new CommandEntity();
        commandEntity.setId(command.getId());
        commandEntity.setTo(command.getTo());
        commandEntity.setContent(command.getContent());
        if (command.getTags() != null && !command.getTags().isEmpty()) {
            commandEntity.setTags(command.getTags().stream().map(CommandTags::valueOf).collect(Collectors.toList()));
        }
        commandEntity.setExpired(command.getExpiredAt().before(new Date()));
        List acknowledgments = command.getAcknowledgments();
        if (acknowledgments != null) {
            commandEntity.setProcessedInCurrentNode(acknowledgments.contains(this.node.id()));
        }
        return commandEntity;
    }
}

