/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.common;

import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.EnvironmentNotFoundException;
import java.util.Objects;
import java.util.Optional;

public class ExecutionContext {
    private final String organizationId;
    private final Optional<String> environmentId;

    public ExecutionContext(String organizationId, String environmentId) {
        this.organizationId = organizationId;
        this.environmentId = Optional.ofNullable(environmentId);
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getEnvironmentId() throws EnvironmentNotFoundException {
        return this.environmentId.orElseThrow(() -> new EnvironmentNotFoundException(null));
    }

    public GraviteeContext.ReferenceContext getReferenceContext() {
        if (this.environmentId.isPresent()) {
            return new GraviteeContext.ReferenceContext(this.environmentId.get(), GraviteeContext.ReferenceContextType.ENVIRONMENT);
        }
        return new GraviteeContext.ReferenceContext(this.organizationId, GraviteeContext.ReferenceContextType.ORGANIZATION);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionContext that = (ExecutionContext)o;
        return Objects.equals(this.organizationId, that.organizationId) && Objects.equals(this.environmentId, that.environmentId);
    }

    public int hashCode() {
        return Objects.hash(this.organizationId, this.environmentId);
    }
}

