/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class UserAlreadyExistsException
extends AbstractManagementException {
    private final String source;
    private final String userId;
    private final String organizationId;

    public UserAlreadyExistsException(String source, String userId, String organizationId) {
        this.source = source;
        this.userId = userId;
        this.organizationId = organizationId;
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "A user [" + this.userId + "] already exists for organization " + this.organizationId + ".";
    }

    @Override
    public String getTechnicalCode() {
        return "user.exists";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("user", UserAlreadyExistsException.this.userId);
                this.put("organizationId", UserAlreadyExistsException.this.organizationId);
                this.put("source", UserAlreadyExistsException.this.source);
            }
        };
    }
}

