/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.impl.upgrade.UpgradeStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class ApiLoggingConditionUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiLoggingConditionUpgrader.class);
    @Autowired
    private InstallationService installationService;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private EnvironmentRepository environmentRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private ApiService apiService;
    @Autowired
    private EventService eventService;
    private List<String> apisFixedAndDeployed = new ArrayList<String>();
    private List<String> apisFixed = new ArrayList<String>();

    @Override
    public boolean upgrade() {
        InstallationEntity installation = this.installationService.getOrInitialize();
        if (this.isStatus(installation, UpgradeStatus.SUCCESS)) {
            LOGGER.info("Skipping {} execution cause it has already been successfully executed", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, UpgradeStatus.RUNNING)) {
            LOGGER.warn("Skipping {} execution cause it's already running", (Object)this.getClass().getSimpleName());
            return false;
        }
        try {
            LOGGER.info("Starting {} execution", (Object)this.getClass().getSimpleName());
            this.setExecutionStatus(installation, UpgradeStatus.RUNNING);
            for (Environment environment : this.environmentRepository.findAll()) {
                this.fixApis(environment.getId());
            }
            this.setExecutionStatus(installation, UpgradeStatus.SUCCESS);
        }
        catch (Throwable e) {
            LOGGER.error("{} execution failed", (Object)this.getClass().getSimpleName(), (Object)e);
            this.setExecutionStatus(installation, UpgradeStatus.FAILURE);
            return false;
        }
        if (!this.apisFixedAndDeployed.isEmpty()) {
            LOGGER.info("{} has updated and deployed {} API with the following identifiers: {}", new Object[]{this.getClass().getSimpleName(), this.apisFixedAndDeployed.size(), this.apisFixedAndDeployed});
        }
        if (!this.apisFixed.isEmpty()) {
            LOGGER.warn("{} has updated {} API with the following identifiers: {}", new Object[]{this.getClass().getSimpleName(), this.apisFixed.size(), this.apisFixed});
            LOGGER.warn("They need to be redeployed manually to apply the patch.");
        }
        LOGGER.info("Finishing {} execution", (Object)this.getClass().getSimpleName());
        return true;
    }

    protected void fixApis(String environmentId) throws Exception {
        for (Api api : this.apiRepository.search(new ApiCriteria.Builder().environmentId(environmentId).build())) {
            String condition;
            io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
            if (apiDefinition.getProxy() == null || apiDefinition.getProxy().getLogging() == null || apiDefinition.getProxy().getLogging().getCondition() == null || !(condition = apiDefinition.getProxy().getLogging().getCondition().trim()).contains("#") || condition.startsWith("{") || condition.endsWith("}")) continue;
            this.fixLoggingCondition(environmentId, api, apiDefinition, condition);
        }
    }

    protected void fixLoggingCondition(String environmentId, Api api, io.gravitee.definition.model.Api apiDefinition, String condition) throws Exception {
        apiDefinition.getProxy().getLogging().setCondition("{" + condition + "}");
        api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
        ApiDeploymentEntity apiDeploymentEntity = null;
        if (this.apiService.isSynchronized(api.getId())) {
            apiDeploymentEntity = new ApiDeploymentEntity();
            apiDeploymentEntity.setDeploymentLabel("Auto-deployed - 3.15.7 upgrade");
        }
        this.updateApi(environmentId, api, apiDeploymentEntity);
    }

    @Override
    public int getOrder() {
        return 550;
    }

    private void setExecutionStatus(InstallationEntity installation, UpgradeStatus status) {
        installation.getAdditionalInformation().put("API_LOGGING_CONDITION_UPGRADER", status.toString());
        this.installationService.setAdditionalInformation(installation.getAdditionalInformation());
    }

    private boolean isStatus(InstallationEntity installation, UpgradeStatus status) {
        return status.toString().equals(installation.getAdditionalInformation().get("API_LOGGING_CONDITION_UPGRADER"));
    }

    private void updateApi(String environmentId, Api api, ApiDeploymentEntity apiDeploymentEntity) throws Exception {
        api.setUpdatedAt(new Date());
        api.setDeployedAt(api.getUpdatedAt());
        api = (Api)this.apiRepository.update((Object)api);
        if (apiDeploymentEntity != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.API_ID.getValue(), api.getId());
            api.setPicture(null);
            this.addDeploymentLabelToProperties(api.getId(), properties, apiDeploymentEntity);
            this.eventService.create(Collections.singleton(environmentId), EventType.PUBLISH_API, this.objectMapper.writeValueAsString((Object)api), properties);
            this.apisFixedAndDeployed.add(api.getId());
        } else {
            this.apisFixed.add(api.getId());
        }
    }

    private void addDeploymentLabelToProperties(String apiId, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        Optional<EventEntity> optEvent = this.eventService.search(query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        String lastDeployNumber = optEvent.isPresent() ? optEvent.get().getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0") : "0";
        String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
        properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
        if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
            properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
        }
    }
}

