/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.NewTopApiEntity;
import io.gravitee.rest.api.model.TopApiEntity;
import io.gravitee.rest.api.model.UpdateTopApiEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TopApiServiceImpl
extends TransactionalService
implements TopApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopApiServiceImpl.class);
    @Inject
    private ParameterService parameterService;
    @Inject
    private ApiService apiService;

    @Override
    public List<TopApiEntity> findAll() {
        LOGGER.debug("Find all top APIs");
        List<ApiEntity> apis = this.parameterService.findAll(Key.PORTAL_TOP_APIS, apiId -> this.apiService.findById((String)apiId), this.apiService::exists, ParameterReferenceType.ENVIRONMENT);
        if (!apis.isEmpty()) {
            ArrayList<TopApiEntity> topApis = new ArrayList<TopApiEntity>(apis.size());
            for (int i = 0; i < apis.size(); ++i) {
                ApiEntity api = apis.get(i);
                TopApiEntity topApiEntity = new TopApiEntity();
                topApiEntity.setApi(api.getId());
                topApiEntity.setName(api.getName());
                topApiEntity.setVersion(api.getVersion());
                topApiEntity.setDescription(api.getDescription());
                topApiEntity.setOrder(i);
                topApis.add(topApiEntity);
            }
            return topApis;
        }
        return Collections.emptyList();
    }

    @Override
    public List<TopApiEntity> create(NewTopApiEntity topApi) {
        List<String> existingTopApis = this.parameterService.findAll(Key.PORTAL_TOP_APIS, ParameterReferenceType.ENVIRONMENT);
        if (existingTopApis.contains(topApi.getApi())) {
            throw new IllegalArgumentException("The API is already defined on top APIs");
        }
        ArrayList<String> newTopApis = new ArrayList<String>(existingTopApis);
        newTopApis.add(topApi.getApi());
        this.parameterService.save(Key.PORTAL_TOP_APIS, newTopApis, ParameterReferenceType.ENVIRONMENT);
        return this.findAll();
    }

    @Override
    public List<TopApiEntity> update(List<UpdateTopApiEntity> topApis) {
        List<String> existingTopApis = this.parameterService.findAll(Key.PORTAL_TOP_APIS, ParameterReferenceType.ENVIRONMENT);
        List updatingTopApis = topApis.stream().map(UpdateTopApiEntity::getApi).collect(Collectors.toList());
        if (existingTopApis.size() != updatingTopApis.size() || !updatingTopApis.containsAll(existingTopApis) || !existingTopApis.containsAll(updatingTopApis)) {
            throw new IllegalArgumentException("Invalid content to update");
        }
        this.parameterService.save(Key.PORTAL_TOP_APIS, topApis.stream().sorted(Comparator.comparing(UpdateTopApiEntity::getOrder)).map(UpdateTopApiEntity::getApi).collect(Collectors.toList()), ParameterReferenceType.ENVIRONMENT);
        return this.findAll();
    }

    @Override
    public void delete(String apiId) {
        List<TopApiEntity> topApis = this.findAll();
        if (!topApis.isEmpty()) {
            topApis.removeIf(topApiEntity -> apiId.equals(topApiEntity.getApi()));
            this.parameterService.save(Key.PORTAL_TOP_APIS, topApis.stream().sorted(Comparator.comparing(TopApiEntity::getOrder)).map(TopApiEntity::getApi).collect(Collectors.toList()), ParameterReferenceType.ENVIRONMENT);
        }
    }
}

