/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.NewReferenceMetadataEntity;
import io.gravitee.rest.api.model.ReferenceMetadataEntity;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UpdateReferenceMetadataEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.impl.AbstractReferenceMetadataService;
import io.gravitee.rest.api.service.search.SearchEngineService;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiMetadataServiceImpl
extends AbstractReferenceMetadataService
implements ApiMetadataService {
    @Autowired
    private ApiService apiService;
    @Autowired
    private SearchEngineService searchEngineService;

    @Override
    public List<ApiMetadataEntity> findAllByApi(String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, true);
        return allMetadata.stream().map(m -> this.convert((ReferenceMetadataEntity)m, apiId)).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity findByIdAndApi(String metadataId, String apiId) {
        return this.convert(this.findByIdAndReference(metadataId, MetadataReferenceType.API, apiId, true), apiId);
    }

    @Override
    public void delete(String metadataId, String apiId) {
        this.delete(metadataId, MetadataReferenceType.API, apiId);
    }

    @Override
    public void deleteAllByApi(String apiId) {
        List<ReferenceMetadataEntity> allMetadata = this.findAllByReference(MetadataReferenceType.API, apiId, false);
        allMetadata.stream().forEach(referenceMetadataEntity -> this.delete(referenceMetadataEntity.getKey(), MetadataReferenceType.API, apiId));
    }

    @Override
    public List<ApiMetadataEntity> create(List<ApiMetadataEntity> apiMetadata, String apiId) {
        if (apiMetadata == null || apiMetadata.isEmpty()) {
            return Collections.emptyList();
        }
        return apiMetadata.stream().map(data -> {
            NewApiMetadataEntity newMD = new NewApiMetadataEntity();
            newMD.setFormat(data.getFormat());
            newMD.setName(data.getName());
            newMD.setValue(data.getValue());
            newMD.setApiId(apiId);
            return newMD;
        }).map(this::create).collect(Collectors.toList());
    }

    @Override
    public ApiMetadataEntity create(NewApiMetadataEntity metadataEntity) {
        return this.convert(this.create((NewReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true, GraviteeContext.getCurrentEnvironment()), metadataEntity.getApiId());
    }

    @Override
    public ApiMetadataEntity update(UpdateApiMetadataEntity metadataEntity) {
        ApiMetadataEntity apiMetadataEntity = this.convert(this.update((UpdateReferenceMetadataEntity)metadataEntity, MetadataReferenceType.API, metadataEntity.getApiId(), true, GraviteeContext.getCurrentEnvironment()), metadataEntity.getApiId());
        ApiEntity apiEntity = this.apiService.fetchMetadataForApi(this.apiService.findById(apiMetadataEntity.getApiId()));
        this.searchEngineService.index((Indexable)apiEntity, false);
        return apiMetadataEntity;
    }

    @Override
    protected void checkReferenceMetadataFormat(MetadataFormat format, String value, MetadataReferenceType referenceType, String referenceId, String environmentId) {
        ApiEntity apiEntity = this.apiService.findById(referenceId);
        this.metadataService.checkMetadataFormat(format, value, referenceType, apiEntity);
    }

    private ApiMetadataEntity convert(ReferenceMetadataEntity m, String apiId) {
        ApiMetadataEntity apiMetadataEntity = new ApiMetadataEntity();
        apiMetadataEntity.setKey(m.getKey());
        apiMetadataEntity.setName(m.getName());
        apiMetadataEntity.setFormat(m.getFormat());
        apiMetadataEntity.setValue(m.getValue());
        apiMetadataEntity.setDefaultValue(m.getDefaultValue());
        apiMetadataEntity.setApiId(apiId);
        return apiMetadataEntity;
    }
}

