/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Category;
import io.gravitee.rest.api.model.InstallationEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.impl.upgrade.UpgradeStatus;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OrphanCategoryUpgrader
implements Upgrader,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(OrphanCategoryUpgrader.class);
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private InstallationService installationService;

    @Override
    public boolean upgrade() {
        InstallationEntity installation = this.installationService.getOrInitialize();
        if (this.isStatus(installation, UpgradeStatus.SUCCESS)) {
            LOGGER.info("Skipping {} execution because it has already been successfully executed", (Object)this.getClass().getSimpleName());
            return false;
        }
        if (this.isStatus(installation, UpgradeStatus.RUNNING)) {
            LOGGER.warn("Skipping {} execution because it is already running", (Object)this.getClass().getSimpleName());
            return false;
        }
        try {
            this.setExecutionStatus(installation, UpgradeStatus.RUNNING);
            this.deleteOrphanCategoryReferences();
            this.setExecutionStatus(installation, UpgradeStatus.SUCCESS);
        }
        catch (TechnicalException e) {
            LOGGER.error("Error while deleting orphan categories, execution will be running again on next start", (Throwable)e);
            this.setExecutionStatus(installation, UpgradeStatus.FAILURE);
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    private void deleteOrphanCategoryReferences() throws TechnicalException {
        Set<Api> updatedApis = this.findAndFixApisWithOrphanCategories();
        for (Api api : updatedApis) {
            LOGGER.info("Removing orphan categories for API [{}]", (Object)api.getId());
            this.apiRepository.update((Object)api);
        }
    }

    private Set<Api> findAndFixApisWithOrphanCategories() throws TechnicalException {
        Set<String> existingCategoryIds = this.getExistingCategoryIds();
        return this.apiRepository.findAll().stream().filter(api -> this.hasOrphanCategories((Api)api, existingCategoryIds)).peek(api -> this.removeOrphanCategories((Api)api, existingCategoryIds)).collect(Collectors.toSet());
    }

    private void removeOrphanCategories(Api api, Set<String> existingCategoryIds) {
        HashSet updatedCategories = new HashSet(api.getCategories());
        updatedCategories.retainAll(existingCategoryIds);
        api.setCategories(updatedCategories);
    }

    private boolean hasOrphanCategories(Api api, Set<String> existingCategoryIds) {
        if (CollectionUtils.isEmpty((Collection)api.getCategories())) {
            return false;
        }
        HashSet orphanCategories = new HashSet(api.getCategories());
        orphanCategories.removeAll(existingCategoryIds);
        return !orphanCategories.isEmpty();
    }

    private Set<String> getExistingCategoryIds() throws TechnicalException {
        return this.categoryRepository.findAll().stream().map(Category::getId).collect(Collectors.toSet());
    }

    private void setExecutionStatus(InstallationEntity installation, UpgradeStatus status) {
        installation.getAdditionalInformation().put("ORPHAN_CATEGORY_UPGRADER_STATUS", status.toString());
        this.installationService.setAdditionalInformation(installation.getAdditionalInformation());
    }

    private boolean isStatus(InstallationEntity installation, UpgradeStatus status) {
        return status.toString().equals(installation.getAdditionalInformation().get("ORPHAN_CATEGORY_UPGRADER_STATUS"));
    }
}

