/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.rest.api.model.OrganizationEntity;
import io.gravitee.rest.api.model.UpdateEnvironmentEntity;
import io.gravitee.rest.api.model.UpdateOrganizationEntity;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class CockpitIdUpgrader
implements Upgrader,
Ordered {
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private EnvironmentService environmentService;

    @Override
    public boolean upgrade() {
        Collection<OrganizationEntity> organizations = this.organizationService.findAll();
        organizations.stream().filter(org -> !org.getId().equals(GraviteeContext.getDefaultOrganization()) && org.getCockpitId() == null).forEach(org -> {
            UpdateOrganizationEntity newOrganization = new UpdateOrganizationEntity(org);
            newOrganization.setCockpitId(org.getId());
            this.organizationService.updateOrganization(org.getId(), newOrganization);
        });
        organizations.forEach(org -> this.environmentService.findByOrganization(org.getId()).stream().filter(env -> !env.getId().equals(GraviteeContext.getDefaultEnvironment()) && env.getCockpitId() == null).forEach(env -> {
            UpdateEnvironmentEntity updateEnv = new UpdateEnvironmentEntity(env);
            updateEnv.setCockpitId(env.getId());
            this.environmentService.createOrUpdate(org.getId(), env.getId(), updateEnv);
        }));
        return true;
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

