/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.service.exceptions.AbstractNotFoundException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class GroupsNotFoundException
extends AbstractNotFoundException {
    private final String groupIds;

    public GroupsNotFoundException(Set<String> groupIds) {
        this.groupIds = String.join((CharSequence)", ", groupIds);
    }

    @Override
    public String getMessage() {
        return "Groups [" + this.groupIds + "] can not be found.";
    }

    @Override
    public String getTechnicalCode() {
        return "groups.notFound";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("groups", this.groupIds);
    }
}

