/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.CategoryRepository;
import io.gravitee.repository.management.model.Category;
import io.gravitee.rest.api.service.Upgrader;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultCategoryUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultCategoryUpgrader.class);
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private ApiRepository apiRepository;

    @Override
    public boolean upgrade() {
        try {
            Set categories = this.categoryRepository.findAll();
            Optional<Category> optionalKeyLessCategory = categories.stream().filter(c -> c.getKey() == null || c.getKey().isEmpty()).findFirst();
            Optional<Category> optionalCategoryWithoutCreationDate = categories.stream().filter(c -> c.getCreatedAt() == null).findFirst();
            boolean keyLessCategoriesExist = optionalKeyLessCategory.isPresent();
            boolean categoriesWithoutCreationDateExist = optionalCategoryWithoutCreationDate.isPresent();
            if (keyLessCategoriesExist || categoriesWithoutCreationDateExist) {
                if (keyLessCategoriesExist) {
                    this.logger.info("Update categories to add field key");
                }
                if (categoriesWithoutCreationDateExist) {
                    this.logger.info("Update categories to add createdAt");
                }
                for (Category category : categories) {
                    if (keyLessCategoriesExist) {
                        category.setKey(IdGenerator.generate((String)category.getName()));
                    }
                    if (categoriesWithoutCreationDateExist) {
                        Date createdAt = new Date();
                        category.setCreatedAt(createdAt);
                        category.setUpdatedAt(createdAt);
                    }
                    this.categoryRepository.update(category);
                }
            }
        }
        catch (TechnicalException e) {
            this.logger.error("Error while upgrading categories : {}", (Throwable)e);
        }
        return true;
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

