/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.definition.model.DebugApi;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.LoggingContent;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.LoggingScope;
import io.gravitee.repository.management.model.ApiDebugStatus;
import io.gravitee.repository.management.model.Event;
import io.gravitee.rest.api.model.DebugApiEntity;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.InstanceEntity;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.DebugApiService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.InstanceService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.DebugApiInvalidDefinitionVersionException;
import io.gravitee.rest.api.service.exceptions.DebugApiNoCompatibleInstanceException;
import io.gravitee.rest.api.service.exceptions.DebugApiNoValidPlanException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DebugApiServiceImpl
implements DebugApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugApiServiceImpl.class);
    private final ApiService apiService;
    private final EventService eventService;
    private final ObjectMapper objectMapper;
    private final InstanceService instanceService;

    public DebugApiServiceImpl(ApiService apiService, EventService eventService, ObjectMapper objectMapper, InstanceService instanceService) {
        this.apiService = apiService;
        this.eventService = eventService;
        this.objectMapper = objectMapper;
        this.instanceService = instanceService;
    }

    @Override
    public EventEntity debug(String apiId, String userId, DebugApiEntity debugApiEntity) {
        try {
            LOGGER.debug("Debug API : {}", (Object)apiId);
            this.apiService.checkPolicyConfigurations(debugApiEntity.getPaths(), debugApiEntity.getFlows(), debugApiEntity.getPlans());
            ApiEntity api = this.apiService.findById(apiId);
            InstanceEntity instanceEntity = this.selectTargetGateway(api);
            Map<String, String> properties = Map.ofEntries(Map.entry(Event.EventProperties.USER.getValue(), userId), Map.entry(Event.EventProperties.API_DEBUG_STATUS.getValue(), ApiDebugStatus.TO_DEBUG.name()), Map.entry(Event.EventProperties.GATEWAY_ID.getValue(), instanceEntity.getId()));
            DebugApi debugApi = this.convert(debugApiEntity, apiId);
            this.validatePlan(debugApi);
            this.validateDefinitionVersion(apiId, debugApi);
            return this.eventService.create(Collections.singleton(GraviteeContext.getCurrentEnvironment()), EventType.DEBUG_API, this.objectMapper.writeValueAsString((Object)debugApi), properties);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("An error occurs while trying to debug API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to debug API: " + apiId, ex);
        }
    }

    private void validateDefinitionVersion(String apiId, DebugApi debugApi) {
        if (!debugApi.getDefinitionVersion().equals((Object)DefinitionVersion.V2)) {
            throw new DebugApiInvalidDefinitionVersionException(apiId);
        }
    }

    private void validatePlan(DebugApi debugApi) {
        boolean hasValidPlan = debugApi.getPlans().stream().anyMatch(plan -> PlanStatus.STAGING.name().equalsIgnoreCase(plan.getStatus()) || PlanStatus.PUBLISHED.name().equalsIgnoreCase(plan.getStatus()));
        if (!hasValidPlan) {
            throw new DebugApiNoValidPlanException(debugApi.getId());
        }
    }

    private InstanceEntity selectTargetGateway(ApiEntity api) {
        List<InstanceEntity> startedInstances = this.instanceService.findAllStarted();
        String debugPluginId = "gateway-debug";
        return startedInstances.stream().filter(instanceEntity -> instanceEntity.getEnvironments().contains(api.getReferenceId())).filter(instanceEntity -> instanceEntity.getPlugins().stream().map(PluginEntity::getId).anyMatch(debugPluginId::equalsIgnoreCase)).filter(instanceEntity -> EnvironmentUtils.hasMatchingTags(Optional.ofNullable(instanceEntity.getTags()), (Set)api.getTags())).max(Comparator.comparing(InstanceEntity::getStartedAt)).orElseThrow(() -> new DebugApiNoCompatibleInstanceException(api.getId()));
    }

    private DebugApi convert(DebugApiEntity debugApiEntity, String apiId) {
        DebugApi debugApi = new DebugApi();
        debugApi.setId(apiId);
        debugApi.setRequest(debugApiEntity.getRequest());
        debugApi.setResponse(debugApiEntity.getResponse());
        debugApi.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)debugApiEntity.getGraviteeDefinitionVersion()));
        debugApi.setName(debugApiEntity.getName());
        debugApi.setVersion(debugApiEntity.getVersion());
        debugApi.setProperties(debugApiEntity.getProperties());
        debugApi.setProxy(debugApiEntity.getProxy());
        debugApi.setResources(debugApiEntity.getResources());
        debugApi.setResponseTemplates(debugApiEntity.getResponseTemplates());
        debugApi.setServices(debugApiEntity.getServices());
        debugApi.setTags(debugApiEntity.getTags());
        debugApi.setPaths(debugApiEntity.getPaths());
        debugApi.setFlows(debugApiEntity.getFlows());
        debugApi.setPlans(debugApiEntity.getPlans());
        if (debugApiEntity.getProxy() != null && debugApiEntity.getProxy().getLogging() != null) {
            debugApi.getProxy().getLogging().setMode(LoggingMode.NONE);
            debugApi.getProxy().getLogging().setContent(LoggingContent.NONE);
            debugApi.getProxy().getLogging().setScope(LoggingScope.NONE);
        }
        if (debugApiEntity.getServices() != null && debugApi.getServices().getHealthCheckService() != null) {
            debugApi.getServices().getHealthCheckService().setEnabled(false);
        }
        return debugApi;
    }
}

