/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.ApplicationRepository;
import io.gravitee.repository.management.api.MembershipRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Membership;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.UserMembership;
import io.gravitee.rest.api.model.alert.ApplicationAlertEventType;
import io.gravitee.rest.api.model.alert.ApplicationAlertMembershipEvent;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.providers.User;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationAlertService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EmailNotification;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.IdentityService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.MembershipAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.NotAuthorizedMembershipException;
import io.gravitee.rest.api.service.exceptions.PaginationInvalidException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MembershipServiceImpl
extends AbstractService
implements MembershipService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MembershipServiceImpl.class);
    private static final String DEFAULT_SOURCE = "system";
    @Autowired
    private UserService userService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private MembershipRepository membershipRepository;
    @Autowired
    private RoleService roleService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ApplicationAlertService applicationAlertService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApplicationRepository applicationRepository;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private EventManager eventManager;
    private final Cache<String, Set<RoleEntity>> roles = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    @Override
    public MemberEntity addRoleToMemberOnReference(String organizationId, String environmentId, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String role) {
        return this.addRoleToMemberOnReference(organizationId, environmentId, referenceType, referenceId, memberType, memberId, role, DEFAULT_SOURCE);
    }

    @Override
    public MemberEntity addRoleToMemberOnReference(String organizationId, String environmentId, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String role, String source) {
        RoleEntity roleToAdd = this.roleService.findById(role);
        return this._addRoleToMemberOnReference(new MembershipService.MembershipReference(referenceType, referenceId), new MembershipService.MembershipMember(memberId, null, memberType), new MembershipService.MembershipRole(roleToAdd.getScope(), roleToAdd.getName()), source, true, false, environmentId, organizationId);
    }

    @Override
    public MemberEntity addRoleToMemberOnReference(String organizationId, String environmentId, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, MembershipService.MembershipRole role) {
        return this._addRoleToMemberOnReference(reference, member, role, DEFAULT_SOURCE, true, false, environmentId, organizationId);
    }

    private MemberEntity _addRoleToMemberOnReference(MembershipService.MembershipReference reference, MembershipService.MembershipMember member, MembershipService.MembershipRole role, String source, boolean notify, boolean update, String environmentId, String organizationId) {
        try {
            LOGGER.debug("Add a new member for {} {}", (Object)reference.getType(), (Object)reference.getId());
            Optional<RoleEntity> optRoleEntity = this.roleService.findByScopeAndName(role.getScope(), role.getName());
            if (optRoleEntity.isPresent()) {
                Set similarMemberships;
                RoleEntity roleEntity = optRoleEntity.get();
                this.assertRoleScopeAllowedForReference(reference, roleEntity);
                this.assertRoleNameAllowedForReference(reference, roleEntity);
                if (member.getMemberId() != null && !(similarMemberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(member.getMemberId(), this.convert(member.getMemberType()), this.convert(reference.getType()), reference.getId(), roleEntity.getId())).isEmpty()) {
                    if (update) {
                        UserEntity userEntity = this.findUserFromMembershipMember(member, organizationId, environmentId);
                        return this.getUserMember(environmentId, reference.getType(), reference.getId(), userEntity.getId());
                    }
                    throw new MembershipAlreadyExistsException(member.getMemberId(), member.getMemberType(), reference.getId(), reference.getType());
                }
                Date updateDate = new Date();
                MemberEntity userMember = null;
                if (member.getMemberType() == MembershipMemberType.USER) {
                    EmailNotification emailNotification;
                    boolean shouldNotify;
                    UserEntity userEntity = this.findUserFromMembershipMember(member, organizationId, environmentId);
                    Membership membership = new Membership(UuidString.generateRandom(), userEntity.getId(), this.convert(member.getMemberType()), reference.getId(), this.convert(reference.getType()), roleEntity.getId());
                    membership.setSource(source);
                    membership.setCreatedAt(updateDate);
                    membership.setUpdatedAt(updateDate);
                    this.membershipRepository.create(membership);
                    this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_CREATED, membership.getCreatedAt(), null, membership, environmentId, organizationId);
                    if (MembershipReferenceType.APPLICATION.equals((Object)reference.getType())) {
                        this.applicationAlertService.addMemberToApplication(environmentId, reference.getId(), userEntity.getEmail());
                    }
                    Set userRolesOnReference = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(userEntity.getId(), this.convert(member.getMemberType()), this.convert(reference.getType()), reference.getId());
                    boolean bl = shouldNotify = notify && userRolesOnReference != null && userRolesOnReference.size() == 1 && userEntity.getEmail() != null && !userEntity.getEmail().isEmpty();
                    if (shouldNotify) {
                        if (MembershipReferenceType.GROUP.equals((Object)reference.getType())) {
                            GroupEntity group = this.groupService.findById(environmentId, reference.getId());
                            shouldNotify = !group.isDisableMembershipNotifications();
                        } else if (MembershipReferenceType.API.equals((Object)reference.getType())) {
                            ApiEntity api = this.apiService.findById(reference.getId());
                            shouldNotify = !api.isDisableMembershipNotifications();
                        } else if (MembershipReferenceType.APPLICATION.equals((Object)reference.getType())) {
                            ApplicationEntity application = this.applicationService.findById(environmentId, reference.getId());
                            boolean bl2 = shouldNotify = !application.isDisableMembershipNotifications();
                        }
                    }
                    if (shouldNotify && (emailNotification = this.buildEmailNotification(userEntity, reference.getType(), reference.getId(), environmentId)) != null) {
                        GraviteeContext.ReferenceContext context = environmentId != null ? new GraviteeContext.ReferenceContext(environmentId, GraviteeContext.ReferenceContextType.ENVIRONMENT) : new GraviteeContext.ReferenceContext(organizationId, GraviteeContext.ReferenceContextType.ORGANIZATION);
                        this.emailService.sendAsyncEmailNotification(emailNotification, context);
                    }
                    userMember = this.getUserMember(environmentId, reference.getType(), reference.getId(), userEntity.getId());
                } else {
                    Membership membership = new Membership(UuidString.generateRandom(), member.getMemberId(), this.convert(member.getMemberType()), reference.getId(), this.convert(reference.getType()), roleEntity.getId());
                    membership.setSource(source);
                    membership.setCreatedAt(updateDate);
                    membership.setUpdatedAt(updateDate);
                    this.membershipRepository.create(membership);
                    this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_CREATED, membership.getCreatedAt(), null, membership, environmentId, organizationId);
                }
                this.roles.invalidate((Object)(reference.getType().name() + reference.getId() + member.getMemberType() + member.getMemberId()));
                return userMember;
            }
            throw new RoleNotFoundException(role.getScope().name() + "_" + role.getName());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to add member for {} {}", new Object[]{reference.getType(), reference.getId(), ex});
            throw new TechnicalManagementException("An error occurs while trying to add member for " + reference.getType() + " " + reference.getId(), ex);
        }
    }

    private void createAuditLog(Audit.AuditEvent event, Date date, Membership oldValue, Membership newValue, String environmentId, String organizationId) {
        io.gravitee.repository.management.model.MembershipReferenceType referenceType = oldValue != null ? oldValue.getReferenceType() : newValue.getReferenceType();
        String referenceId = oldValue != null ? oldValue.getReferenceId() : newValue.getReferenceId();
        String username = oldValue != null ? oldValue.getMemberId() : newValue.getMemberId();
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, username);
        switch (referenceType) {
            case API: {
                this.auditService.createApiAuditLog(referenceId, properties, event, date, oldValue, newValue);
                break;
            }
            case APPLICATION: {
                this.auditService.createApplicationAuditLog(referenceId, properties, event, date, oldValue, newValue);
                break;
            }
            case GROUP: {
                properties.put(Audit.AuditProperties.GROUP, referenceId);
                this.auditService.createEnvironmentAuditLog(environmentId, properties, event, date, oldValue, newValue);
                break;
            }
            case ENVIRONMENT: {
                this.auditService.createEnvironmentAuditLog(environmentId, properties, event, date, oldValue, newValue);
                break;
            }
            case ORGANIZATION: {
                this.auditService.createOrganizationAuditLog(organizationId, properties, event, date, oldValue, newValue);
            }
        }
    }

    private EmailNotification buildEmailNotification(UserEntity user, MembershipReferenceType referenceType, String referenceId, String environmentId) {
        EmailNotificationBuilder.EmailTemplate template = null;
        Map<String, Object> params = null;
        NotificationParamsBuilder paramsBuilder = new NotificationParamsBuilder();
        switch (referenceType) {
            case APPLICATION: {
                ApplicationEntity applicationEntity = this.applicationService.findById(environmentId, referenceId);
                template = EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_APPLICATION_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.application(applicationEntity).user(user).build();
                break;
            }
            case API: {
                ApiEntity apiEntity = this.apiService.findById(referenceId);
                template = EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_API_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.api(apiEntity).user(user).build();
                break;
            }
            case GROUP: {
                GroupEntity groupEntity = this.groupService.findById(environmentId, referenceId);
                template = EmailNotificationBuilder.EmailTemplate.TEMPLATES_FOR_ACTION_GROUP_MEMBER_SUBSCRIPTION;
                params = paramsBuilder.group(groupEntity).user(user).build();
                break;
            }
        }
        if (template == null) {
            return null;
        }
        return new EmailNotificationBuilder().to(user.getEmail()).template(template).params(params).build();
    }

    private MemberEntity convertToMemberEntity(Membership membership) {
        MemberEntity member = new MemberEntity();
        member.setId(membership.getMemberId());
        member.setCreatedAt(membership.getCreatedAt());
        member.setUpdatedAt(membership.getUpdatedAt());
        member.setReferenceId(membership.getReferenceId());
        member.setReferenceType(this.convert(membership.getReferenceType()));
        if (membership.getRoleId() != null) {
            RoleEntity role = this.roleService.findById(membership.getRoleId());
            member.setPermissions(role.getPermissions());
            ArrayList<RoleEntity> roles = new ArrayList<RoleEntity>();
            roles.add(role);
            member.setRoles(roles);
        }
        member.setType(MembershipMemberType.valueOf((String)membership.getMemberType().name()));
        return member;
    }

    private void fillMemberUserInformation(Set<Membership> memberships, List<MemberEntity> members) {
        if (memberships != null && !memberships.isEmpty()) {
            HashSet<UserEntity> userEntities = new HashSet<UserEntity>();
            List<String> userIds = members.stream().filter(m -> m.getType() == MembershipMemberType.USER).map(MemberEntity::getId).collect(Collectors.toList());
            if (userIds != null && userIds.size() > 0) {
                userEntities.addAll(this.userService.findByIds(userIds, false));
            }
            HashSet<GroupEntity> groupEntities = new HashSet<GroupEntity>();
            Set<String> groupsIds = members.stream().filter(m -> m.getType() == MembershipMemberType.GROUP).map(MemberEntity::getId).collect(Collectors.toSet());
            if (groupsIds != null && groupsIds.size() > 0) {
                groupEntities.addAll(this.groupService.findByIds(groupsIds));
            }
            members.forEach(m -> {
                Optional<Membership> membership = memberships.stream().filter(ms -> ms.getMemberId().equals(m.getId())).findFirst();
                membership.ifPresent(ms -> {
                    if (ms.getMemberType() == io.gravitee.repository.management.model.MembershipMemberType.USER) {
                        Optional<UserEntity> user = userEntities.stream().filter(u -> u.getId().equals(ms.getMemberId())).findFirst();
                        user.ifPresent(u -> {
                            m.setDisplayName(u.getDisplayName());
                            m.setEmail(u.getEmail());
                        });
                    } else {
                        Optional<GroupEntity> group = groupEntities.stream().filter(u -> u.getId().equals(ms.getMemberId())).findFirst();
                        group.ifPresent(g -> m.setDisplayName(g.getName()));
                    }
                });
            });
        }
    }

    private UserEntity findUserFromMembershipMember(MembershipService.MembershipMember member, String organizationId, String environmentId) {
        UserEntity userEntity;
        if (member.getMemberId() != null) {
            userEntity = this.userService.findById(member.getMemberId());
        } else {
            Optional<User> providerUser = this.identityService.findByReference(member.getReference());
            if (providerUser.isPresent()) {
                User identityUser = providerUser.get();
                userEntity = this.findOrCreateUser(identityUser, organizationId, environmentId);
            } else {
                throw new UserNotFoundException(member.getReference());
            }
        }
        return userEntity;
    }

    private UserEntity findOrCreateUser(User identityUser, String organizationId, String environmentId) {
        UserEntity userEntity;
        try {
            userEntity = this.userService.findBySource(identityUser.getSource(), identityUser.getSourceId(), false);
        }
        catch (UserNotFoundException unfe) {
            NewExternalUserEntity newUser = new NewExternalUserEntity();
            newUser.setFirstname(identityUser.getFirstname());
            newUser.setLastname(identityUser.getLastname());
            newUser.setSource(identityUser.getSource());
            newUser.setEmail(identityUser.getEmail());
            newUser.setSourceId(identityUser.getSourceId());
            newUser.setPicture(identityUser.getPicture());
            if (identityUser.getRoles() == null || identityUser.getRoles().isEmpty()) {
                userEntity = this.userService.create(newUser, true);
            }
            userEntity = this.userService.create(newUser, false);
            for (Map.Entry role : identityUser.getRoles().entrySet()) {
                MembershipReferenceType membershipReferenceType = MembershipReferenceType.valueOf((String)((String)role.getKey()));
                MembershipService.MembershipReference reference = null;
                if (membershipReferenceType == MembershipReferenceType.ORGANIZATION) {
                    reference = new MembershipService.MembershipReference(membershipReferenceType, organizationId);
                } else if (membershipReferenceType == MembershipReferenceType.ENVIRONMENT) {
                    reference = new MembershipService.MembershipReference(membershipReferenceType, environmentId);
                }
                if (reference == null) continue;
                this.addRoleToMemberOnReference(organizationId, environmentId, reference, new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), new MembershipService.MembershipRole(RoleScope.valueOf((String)((String)role.getKey())), (String)role.getValue()));
            }
        }
        return userEntity;
    }

    private void assertRoleScopeAllowedForReference(MembershipService.MembershipReference reference, RoleEntity roleEntity) {
        if (MembershipReferenceType.API == reference.getType() && RoleScope.API != roleEntity.getScope() || MembershipReferenceType.APPLICATION == reference.getType() && RoleScope.APPLICATION != roleEntity.getScope() || MembershipReferenceType.GROUP == reference.getType() && RoleScope.GROUP != roleEntity.getScope() && RoleScope.API != roleEntity.getScope() && RoleScope.APPLICATION != roleEntity.getScope()) {
            throw new NotAuthorizedMembershipException(roleEntity.getName());
        }
    }

    public void assertRoleNameAllowedForReference(MembershipService.MembershipReference reference, RoleEntity roleEntity) throws TechnicalException {
        if (MembershipReferenceType.GROUP == reference.getType() && SystemRole.PRIMARY_OWNER.name().equals(roleEntity.getName())) {
            if (roleEntity.getScope() == RoleScope.APPLICATION) {
                throw new NotAuthorizedMembershipException(roleEntity.getName());
            }
            if (roleEntity.getScope() == RoleScope.API && this.membershipRepository.findByReferenceAndRoleId(io.gravitee.repository.management.model.MembershipReferenceType.GROUP, reference.getId(), roleEntity.getId()).size() > 0) {
                throw new NotAuthorizedMembershipException(roleEntity.getName());
            }
        }
    }

    @Override
    public void deleteMembership(String organizationId, String environmentId, String membershipId) {
        try {
            Optional membership = this.membershipRepository.findById(membershipId);
            if (membership.isPresent()) {
                LOGGER.debug("Delete membership {}", membership.get());
                this.membershipRepository.delete(membershipId);
                this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), (Membership)membership.get(), null, environmentId, organizationId);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete membership {}", (Object)membershipId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete membership " + membershipId, ex);
        }
    }

    @Override
    public void deleteReference(String organizationId, String environmentId, MembershipReferenceType referenceType, String referenceId) {
        try {
            Set memberships = this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, null);
            if (!memberships.isEmpty()) {
                for (Membership membership : memberships) {
                    LOGGER.debug("Delete membership {}", (Object)membership.getId());
                    this.membershipRepository.delete(membership.getId());
                    this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), membership, null, environmentId, organizationId);
                }
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete memberships for {} {}", new Object[]{referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete memberships for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public void deleteReferenceMember(String organizationId, String environmentId, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId) {
        this.deleteReferenceMemberBySource(organizationId, environmentId, referenceType, referenceId, memberType, memberId, null);
    }

    @Override
    public void deleteReferenceMemberBySource(String organizationId, String environmentId, MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String sourceId) {
        try {
            Optional<RoleEntity> optApiPORole = this.roleService.findByScopeAndName(RoleScope.API, SystemRole.PRIMARY_OWNER.name());
            Set memberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(memberId, this.convert(memberType), this.convert(referenceType), referenceId);
            if (!memberships.isEmpty()) {
                for (Membership membership : memberships) {
                    if (sourceId == null || membership.getSource().equals(sourceId)) {
                        LOGGER.debug("Delete membership {}", (Object)membership.getId());
                        this.membershipRepository.delete(membership.getId());
                        this.createAuditLog((Audit.AuditEvent)Membership.AuditEvent.MEMBERSHIP_DELETED, new Date(), membership, null, environmentId, organizationId);
                    }
                    if (MembershipReferenceType.APPLICATION.equals((Object)referenceType) && MembershipMemberType.USER.equals((Object)memberType)) {
                        UserEntity userEntity = this.findUserFromMembershipMember(new MembershipService.MembershipMember(memberId, null, memberType), organizationId, environmentId);
                        this.applicationAlertService.deleteMemberFromApplication(environmentId, referenceId, userEntity.getEmail());
                    }
                    if (!optApiPORole.isPresent() || membership.getReferenceType() != io.gravitee.repository.management.model.MembershipReferenceType.GROUP || !membership.getRoleId().equals(optApiPORole.get().getId())) continue;
                    this.groupService.updateApiPrimaryOwner(membership.getReferenceId(), null);
                }
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete memberships for {} {} {} {}", new Object[]{referenceType, referenceId, memberType, memberId, ex});
            throw new TechnicalManagementException("An error occurs while trying to delete memberships for " + referenceType + " " + referenceId + " " + memberType + " " + memberId, ex);
        }
    }

    @Override
    public List<UserMembership> findUserMembershipBySource(MembershipReferenceType type, String userId, String sourceId) {
        try {
            Map<String, RoleEntity> roleMap = this.roleService.findAll().stream().collect(Collectors.toMap(RoleEntity::getId, r -> r));
            HashMap userMembershipMap = new HashMap();
            this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndSource(userId, io.gravitee.repository.management.model.MembershipMemberType.USER, this.convert(type), sourceId).stream().filter(membership -> sourceId != null && sourceId.equals(membership.getSource())).forEach(membership -> {
                UserMembership userMembership = new UserMembership();
                userMembership.setType(type.name());
                userMembership.setReference(membership.getReferenceId());
                userMembership.setSource(membership.getSource());
                RoleEntity role = (RoleEntity)roleMap.get(membership.getRoleId());
                if (role != null) {
                    int key = userMembership.hashCode();
                    if (userMembershipMap.containsKey(key)) {
                        ((UserMembership)userMembershipMap.get(key)).getRoles().put(role.getScope().name(), role.getName());
                    } else {
                        HashMap<String, String> roles = new HashMap<String, String>();
                        roles.put(role.getScope().name(), role.getName());
                        userMembership.setRoles(roles);
                        userMembershipMap.put(userMembership.hashCode(), userMembership);
                    }
                }
            });
            return new ArrayList<UserMembership>(userMembershipMap.values());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove user " + userId, ex);
        }
    }

    @Override
    public List<UserMembership> findUserMembership(MembershipReferenceType type, String userId) {
        if (type == null || !type.equals((Object)MembershipReferenceType.API) && !type.equals((Object)MembershipReferenceType.APPLICATION) && !type.equals((Object)MembershipReferenceType.GROUP)) {
            return Collections.emptyList();
        }
        try {
            Map<String, RoleEntity> roleMap = this.roleService.findByScope(this.roleService.findScopeByMembershipReferenceType(type)).stream().collect(Collectors.toMap(RoleEntity::getId, r -> r));
            HashMap userMembershipMap = new HashMap();
            this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(userId, io.gravitee.repository.management.model.MembershipMemberType.USER, this.convert(type)).forEach(membership -> {
                UserMembership userMembership = new UserMembership();
                userMembership.setType(type.name());
                userMembership.setReference(membership.getReferenceId());
                userMembership.setSource(membership.getSource());
                RoleEntity role = (RoleEntity)roleMap.get(membership.getRoleId());
                if (role != null) {
                    int key = userMembership.hashCode();
                    if (userMembershipMap.containsKey(key)) {
                        ((UserMembership)userMembershipMap.get(key)).getRoles().put(role.getScope().name(), role.getName());
                    } else {
                        HashMap<String, String> roles = new HashMap<String, String>();
                        roles.put(role.getScope().name(), role.getName());
                        userMembership.setRoles(roles);
                        userMembershipMap.put(userMembership.hashCode(), userMembership);
                    }
                }
            });
            HashSet userMemberships = new HashSet(userMembershipMap.values());
            if (type.equals((Object)MembershipReferenceType.APPLICATION) || type.equals((Object)MembershipReferenceType.API)) {
                Set<GroupEntity> userGroups = this.groupService.findByUser(userId);
                for (GroupEntity group : userGroups) {
                    userMemberships.addAll(this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(group.getId(), io.gravitee.repository.management.model.MembershipMemberType.GROUP, this.convert(type)).stream().map(membership -> {
                        UserMembership userMembership = new UserMembership();
                        userMembership.setType(type.name());
                        userMembership.setReference(membership.getReferenceId());
                        return userMembership;
                    }).collect(Collectors.toSet()));
                }
            }
            return new ArrayList<UserMembership>(userMemberships);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove user " + userId, ex);
        }
    }

    @Override
    public Metadata findUserMembershipMetadata(List<UserMembership> memberships, MembershipReferenceType type) {
        if (memberships == null || memberships.isEmpty() || type == null || !type.equals((Object)MembershipReferenceType.API) && !type.equals((Object)MembershipReferenceType.APPLICATION) && !type.equals((Object)MembershipReferenceType.GROUP)) {
            return new Metadata();
        }
        try {
            Metadata metadata = new Metadata();
            if (type.equals((Object)MembershipReferenceType.API)) {
                ApiCriteria.Builder criteria = new ApiCriteria.Builder();
                ApiFieldExclusionFilter filter = new ApiFieldExclusionFilter.Builder().excludeDefinition().excludePicture().build();
                criteria.ids((String[])memberships.stream().map(UserMembership::getReference).toArray(String[]::new));
                this.apiRepository.search(criteria.build(), filter).forEach(api -> {
                    metadata.put(api.getId(), "name", (Object)api.getName());
                    metadata.put(api.getId(), "version", (Object)api.getVersion());
                    metadata.put(api.getId(), "visibility", (Object)api.getVisibility());
                });
            } else if (type.equals((Object)MembershipReferenceType.APPLICATION)) {
                this.applicationRepository.findByIds((Collection)memberships.stream().map(UserMembership::getReference).collect(Collectors.toList())).forEach(application -> metadata.put(application.getId(), "name", (Object)application.getName()));
            }
            return metadata;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get user membership metadata", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to get user membership metadata", ex);
        }
    }

    @Override
    public Page<MemberEntity> getMembersByReference(MembershipReferenceType referenceType, String referenceId, Pageable pageable) {
        return this.getMembersByReferenceAndRole(referenceType, referenceId, null, pageable);
    }

    @Override
    public Set<MemberEntity> getMembersByReference(MembershipReferenceType referenceType, String referenceId) {
        return new HashSet<MemberEntity>(this.getMembersByReferenceAndRole(referenceType, referenceId, null, null).getContent());
    }

    @Override
    public Page<MemberEntity> getMembersByReference(MembershipReferenceType referenceType, String referenceId, String role, Pageable pageable) {
        return this.getMembersByReferenceAndRole(referenceType, referenceId, role, pageable);
    }

    @Override
    public Set<MemberEntity> getMembersByReference(MembershipReferenceType referenceType, String referenceId, String role) {
        return new HashSet<MemberEntity>(this.getMembersByReferenceAndRole(referenceType, referenceId, role, null).getContent());
    }

    @Override
    public Page<MemberEntity> getMembersByReferenceAndRole(MembershipReferenceType referenceType, String referenceId, String role, Pageable pageable) {
        return this.getMembersByReferencesAndRole(referenceType, Collections.singletonList(referenceId), role, pageable);
    }

    @Override
    public Set<MemberEntity> getMembersByReferenceAndRole(MembershipReferenceType referenceType, String referenceId, String role) {
        return new HashSet<MemberEntity>(this.getMembersByReferencesAndRole(referenceType, Collections.singletonList(referenceId), role, null).getContent());
    }

    @Override
    public Set<MemberEntity> getMembersByReferencesAndRole(MembershipReferenceType referenceType, List<String> referenceIds, String role) {
        return new HashSet<MemberEntity>(this.getMembersByReferencesAndRole(referenceType, referenceIds, role, null).getContent());
    }

    @Override
    public Page<MemberEntity> getMembersByReferencesAndRole(MembershipReferenceType referenceType, List<String> referenceIds, String role, Pageable pageable) {
        try {
            LOGGER.debug("Get members for {} {}", (Object)referenceType, referenceIds);
            Set memberships = this.membershipRepository.findByReferencesAndRoleId(this.convert(referenceType), referenceIds, role);
            HashMap results = new HashMap();
            memberships.stream().map(this::convertToMemberEntity).forEach(member -> {
                String key = member.getId() + member.getReferenceId();
                MemberEntity existingEntity = (MemberEntity)results.get(key);
                if (existingEntity == null) {
                    results.put(key, member);
                    existingEntity = member;
                } else {
                    HashSet existingRoles = new HashSet(existingEntity.getRoles());
                    existingRoles.addAll(member.getRoles());
                    existingEntity.setRoles(new ArrayList(existingRoles));
                }
            });
            ArrayList<MemberEntity> members = new ArrayList<MemberEntity>(results.values());
            this.fillMemberUserInformation(memberships, members);
            return this.paginate(results.values(), pageable);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get members for {} {}", new Object[]{referenceType, referenceIds, ex});
            throw new TechnicalManagementException("An error occurs while trying to get members for " + referenceType + " " + referenceIds, ex);
        }
    }

    private Page<MemberEntity> paginate(Collection<MemberEntity> members, Pageable pageable) {
        Comparator<MemberEntity> comparator = Comparator.comparing(memberEntity -> memberEntity.getDisplayName().toLowerCase(Locale.ROOT));
        if (pageable == null) {
            pageable = new PageableImpl(1, Integer.MAX_VALUE);
        }
        int totalCount = members.size();
        int startIndex = (pageable.getPageNumber() - 1) * pageable.getPageSize();
        if (pageable.getPageNumber() < 1 || totalCount > 0 && startIndex >= totalCount) {
            throw new PaginationInvalidException();
        }
        List subsetApis = members.stream().sorted(comparator).skip(startIndex).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new Page(subsetApis, pageable.getPageNumber(), pageable.getPageSize(), (long)members.size());
    }

    private io.gravitee.repository.management.model.MembershipReferenceType convert(MembershipReferenceType referenceType) {
        return io.gravitee.repository.management.model.MembershipReferenceType.valueOf((String)referenceType.name());
    }

    private MembershipReferenceType convert(io.gravitee.repository.management.model.MembershipReferenceType referenceType) {
        return MembershipReferenceType.valueOf((String)referenceType.name());
    }

    private io.gravitee.repository.management.model.MembershipMemberType convert(MembershipMemberType memberType) {
        return io.gravitee.repository.management.model.MembershipMemberType.valueOf((String)memberType.name());
    }

    private MembershipMemberType convert(io.gravitee.repository.management.model.MembershipMemberType memberType) {
        return MembershipMemberType.valueOf((String)memberType.name());
    }

    private MembershipEntity convert(Membership membership) {
        MembershipEntity result = new MembershipEntity();
        result.setCreatedAt(membership.getCreatedAt());
        result.setId(membership.getId());
        result.setMemberId(membership.getMemberId());
        result.setMemberType(this.convert(membership.getMemberType()));
        result.setReferenceId(membership.getReferenceId());
        result.setReferenceType(this.convert(membership.getReferenceType()));
        result.setRoleId(membership.getRoleId());
        result.setUpdatedAt(membership.getUpdatedAt());
        return result;
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMember(MembershipMemberType memberType, String memberId) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberType(memberId, this.convert(memberType)).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMemberAndReference(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceType(memberId, this.convert(memberType), this.convert(referenceType)).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMemberAndReferenceAndRole(MembershipMemberType memberType, String memberId, MembershipReferenceType referenceType, String role) {
        try {
            return this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndRoleId(memberId, this.convert(memberType), this.convert(referenceType), role).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", (Object)memberId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByMembersAndReference(MembershipMemberType memberType, List<String> memberIds, MembershipReferenceType referenceType) {
        try {
            return this.membershipRepository.findByMemberIdsAndMemberTypeAndReferenceType(memberIds, this.convert(memberType), this.convert(referenceType)).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} ", memberIds, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + memberIds, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByReference(MembershipReferenceType referenceType, String referenceId) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, null).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} {} ", new Object[]{referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByReferenceAndRole(MembershipReferenceType referenceType, String referenceId, String role) {
        try {
            return this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, role).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} {} and role", new Object[]{referenceType, referenceId, role, ex});
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + referenceType + " " + referenceId + " and role " + role, ex);
        }
    }

    @Override
    public Set<MembershipEntity> getMembershipsByReferencesAndRole(MembershipReferenceType referenceType, List<String> referenceIds, String role) {
        try {
            return this.membershipRepository.findByReferencesAndRoleId(this.convert(referenceType), referenceIds, role).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get memberships for {} {} and role", new Object[]{referenceType, referenceIds, role, ex});
            throw new TechnicalManagementException("An error occurs while trying to get memberships for " + referenceType + " " + referenceIds + " and role " + role, ex);
        }
    }

    @Override
    public MembershipEntity getPrimaryOwner(String organizationId, MembershipReferenceType referenceType, String referenceId) {
        RoleScope poRoleScope;
        if (referenceType == MembershipReferenceType.API) {
            poRoleScope = RoleScope.API;
        } else if (referenceType == MembershipReferenceType.APPLICATION) {
            poRoleScope = RoleScope.APPLICATION;
        } else {
            throw new RoleNotFoundException(referenceType.name() + "_PRIMARY_OWNER");
        }
        RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, poRoleScope);
        if (poRole != null) {
            try {
                Optional poMember = this.membershipRepository.findByReferenceAndRoleId(this.convert(referenceType), referenceId, poRole.getId()).stream().findFirst();
                if (poMember.isPresent()) {
                    return this.convert((Membership)poMember.get());
                }
                return null;
            }
            catch (TechnicalException ex) {
                LOGGER.error("An error occurs while trying to get primary owner for {} {} and role", new Object[]{referenceType, referenceId, ex});
                throw new TechnicalManagementException("An error occurs while trying to get primary owner for " + referenceType + " " + referenceId, ex);
            }
        }
        throw new RoleNotFoundException(referenceType.name() + "_PRIMARY_OWNER");
    }

    @Override
    public Set<RoleEntity> getRoles(MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId) {
        try {
            LOGGER.debug("Get role for {} {} and member {} {}", new Object[]{referenceType, referenceId, memberType, memberId});
            return (Set)this.roles.get((Object)(referenceType.name() + referenceId + memberType + memberId), () -> this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(memberId, this.convert(memberType), this.convert(referenceType), referenceId).stream().map(Membership::getRoleId).map(this.roleService::findById).collect(Collectors.toSet()));
        }
        catch (Exception ex) {
            String message = "An error occurs while trying to get roles for " + referenceType + " " + referenceId + " " + memberType + " " + memberId;
            LOGGER.error(message, (Throwable)ex);
            throw new TechnicalManagementException(message, ex);
        }
    }

    @Override
    public MemberEntity getUserMember(String environmentId, MembershipReferenceType referenceType, String referenceId, String userId) {
        try {
            Set userMemberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(userId, this.convert(MembershipMemberType.USER), this.convert(referenceType), referenceId);
            Set entityGroups = new HashSet();
            switch (referenceType) {
                case API: {
                    entityGroups = this.apiService.findById(referenceId).getGroups();
                    break;
                }
                case APPLICATION: {
                    entityGroups = this.applicationService.findById(environmentId, referenceId).getGroups();
                    break;
                }
            }
            if (userMemberships.isEmpty() && (entityGroups == null || entityGroups.isEmpty())) {
                return null;
            }
            MemberEntity memberEntity = new MemberEntity();
            UserEntity userEntity = this.userService.findById(userId);
            memberEntity.setCreatedAt(userEntity.getCreatedAt());
            memberEntity.setDisplayName(userEntity.getDisplayName());
            memberEntity.setEmail(userEntity.getEmail());
            memberEntity.setId(userEntity.getId());
            memberEntity.setUpdatedAt(userEntity.getUpdatedAt());
            HashSet<RoleEntity> userRoles = new HashSet<RoleEntity>();
            Set<Object> userDirectRoles = new HashSet();
            if (!userMemberships.isEmpty()) {
                userDirectRoles = userMemberships.stream().map(Membership::getRoleId).map(this.roleService::findById).collect(Collectors.toSet());
                userRoles.addAll(userDirectRoles);
            }
            memberEntity.setRoles(new ArrayList(userDirectRoles));
            if (entityGroups != null && !entityGroups.isEmpty()) {
                for (String group : entityGroups) {
                    userRoles.addAll(this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(userId, this.convert(MembershipMemberType.USER), this.convert(MembershipReferenceType.GROUP), group).stream().map(Membership::getRoleId).map(this.roleService::findById).filter(role -> role.getScope().name().equals(referenceType.name())).collect(Collectors.toSet()));
                }
            }
            Map<Object, Object> permissions = new HashMap();
            if (!userRoles.isEmpty()) {
                permissions = this.computeGlobalPermissions(userRoles);
            }
            memberEntity.setPermissions(permissions);
            return memberEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to get user member for {} {} {} {}", new Object[]{referenceType, referenceId, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying to get roles for " + referenceType + " " + referenceId + " " + userId, ex);
        }
    }

    private Map<String, char[]> computeGlobalPermissions(Set<RoleEntity> userRoles) {
        HashMap<String, Set> mergedPermissions = new HashMap<String, Set>();
        for (RoleEntity role : userRoles) {
            for (Map.Entry perm : role.getPermissions().entrySet()) {
                if (mergedPermissions.containsKey(perm.getKey())) {
                    Set previousCRUD = (Set)mergedPermissions.get(perm.getKey());
                    for (char c : (char[])perm.getValue()) {
                        previousCRUD.add(Character.valueOf(c));
                    }
                    continue;
                }
                HashSet<Character> crudAsSet = new HashSet<Character>();
                for (char c : (char[])perm.getValue()) {
                    crudAsSet.add(Character.valueOf(c));
                }
                mergedPermissions.put((String)perm.getKey(), crudAsSet);
            }
        }
        HashMap<String, char[]> permissions = new HashMap<String, char[]>(mergedPermissions.size());
        mergedPermissions.forEach((k, v) -> {
            Character[] characters = v.toArray(new Character[v.size()]);
            char[] chars = new char[characters.length];
            for (int i = 0; i < characters.length; ++i) {
                chars[i] = characters[i].charValue();
            }
            permissions.put((String)k, chars);
        });
        return permissions;
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(String environmentId, MembershipReferenceType referenceType, String referenceId, String userId) {
        MemberEntity member = this.getUserMember(environmentId, referenceType, referenceId, userId);
        if (member != null) {
            return member.getPermissions();
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(String environmentId, ApiEntity api, String userId) {
        return this.getUserMemberPermissions(environmentId, MembershipReferenceType.API, api.getId(), userId);
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(String environmentId, ApplicationEntity application, String userId) {
        return this.getUserMemberPermissions(environmentId, MembershipReferenceType.APPLICATION, application.getId(), userId);
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(String environmentId, GroupEntity group, String userId) {
        return this.getUserMemberPermissions(environmentId, MembershipReferenceType.GROUP, group.getId(), userId);
    }

    @Override
    public Map<String, char[]> getUserMemberPermissions(String environmentId, EnvironmentEntity environment, String userId) {
        return this.getUserMemberPermissions(environmentId, MembershipReferenceType.ENVIRONMENT, environment.getId(), userId);
    }

    @Override
    public void removeRole(MembershipReferenceType referenceType, String referenceId, MembershipMemberType memberType, String memberId, String roleId) {
        try {
            Set membershipsToDelete = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(memberId, this.convert(memberType), this.convert(referenceType), referenceId, roleId);
            for (Membership m : membershipsToDelete) {
                this.membershipRepository.delete(m.getId());
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove role {} from member {} {} for {} {}", new Object[]{roleId, memberType, memberId, referenceType, referenceId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove role " + roleId + " from member " + memberType + " " + memberId + " for " + referenceType + " " + referenceId, ex);
        }
    }

    @Override
    public void removeRoleUsage(String oldRoleId, String newRoleId) {
        try {
            Set membershipsWithOldRole = this.membershipRepository.findByRoleId(oldRoleId);
            for (Membership membership : membershipsWithOldRole) {
                Set membershipsWithNewRole = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceIdAndRoleId(membership.getMemberId(), membership.getMemberType(), membership.getReferenceType(), membership.getReferenceId(), newRoleId);
                String oldMembershipId = membership.getId();
                if (membershipsWithNewRole.isEmpty()) {
                    membership.setId(UuidString.generateRandom());
                    membership.setRoleId(newRoleId);
                    membership.setSource(DEFAULT_SOURCE);
                    this.membershipRepository.create(membership);
                }
                this.membershipRepository.delete(oldMembershipId);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove role {} {}", (Object)oldRoleId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to remove role " + oldRoleId, ex);
        }
    }

    @Override
    public void removeMemberMemberships(MembershipMemberType memberType, String memberId) {
        HashSet<String> applicationIds = new HashSet<String>();
        HashSet<String> groupIds = new HashSet<String>();
        try {
            for (Membership membership : this.membershipRepository.findByMemberIdAndMemberType(memberId, this.convert(memberType))) {
                if (this.convert(MembershipReferenceType.APPLICATION).equals((Object)membership.getReferenceType())) {
                    applicationIds.add(membership.getReferenceId());
                }
                if (this.convert(MembershipReferenceType.GROUP).equals((Object)membership.getReferenceType())) {
                    groupIds.add(membership.getReferenceId());
                }
                this.membershipRepository.delete(membership.getId());
            }
            this.eventManager.publishEvent((Enum)ApplicationAlertEventType.APPLICATION_MEMBERSHIP_UPDATE, (Object)new ApplicationAlertMembershipEvent(applicationIds, groupIds));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove member {} {}", new Object[]{memberType, memberId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove " + memberType + " " + memberId, ex);
        }
    }

    @Override
    public void transferApiOwnership(String organizationId, String environmentId, String apiId, MembershipService.MembershipMember member, List<RoleEntity> newPrimaryOwnerRoles) {
        this.transferOwnership(MembershipReferenceType.API, RoleScope.API, apiId, member, newPrimaryOwnerRoles, organizationId, environmentId);
    }

    @Override
    public void transferApplicationOwnership(String organizationId, String environmentId, String applicationId, MembershipService.MembershipMember member, List<RoleEntity> newPrimaryOwnerRoles) {
        this.transferOwnership(MembershipReferenceType.APPLICATION, RoleScope.APPLICATION, applicationId, member, newPrimaryOwnerRoles, organizationId, environmentId);
    }

    private void transferOwnership(MembershipReferenceType membershipReferenceType, RoleScope roleScope, String itemId, MembershipService.MembershipMember member, List<RoleEntity> newPrimaryOwnerRoles, String organizationId, String environmentId) {
        RoleEntity poRoleEntity;
        List<RoleEntity> newRoles = newPrimaryOwnerRoles == null || newPrimaryOwnerRoles.isEmpty() ? this.roleService.findDefaultRoleByScopes(roleScope) : newPrimaryOwnerRoles;
        MembershipEntity primaryOwner = this.getPrimaryOwner(organizationId, membershipReferenceType, itemId);
        MemberEntity newPrimaryOwnerMember = this.addRoleToMemberOnReference(organizationId, environmentId, new MembershipService.MembershipReference(membershipReferenceType, itemId), new MembershipService.MembershipMember(member.getMemberId(), member.getReference(), member.getMemberType()), new MembershipService.MembershipRole(roleScope, SystemRole.PRIMARY_OWNER.name()));
        if (membershipReferenceType == MembershipReferenceType.API && member.getMemberType() == MembershipMemberType.GROUP) {
            this.apiService.addGroup(itemId, member.getMemberId());
        }
        if ((poRoleEntity = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, roleScope)) != null) {
            if (member.getMemberType() == MembershipMemberType.USER) {
                this.getRoles(membershipReferenceType, itemId, member.getMemberType(), member.getMemberId()).forEach(role -> {
                    if (!role.getId().equals(poRoleEntity.getId())) {
                        this.removeRole(membershipReferenceType, itemId, member.getMemberType(), member.getMemberId(), role.getId());
                    }
                });
            }
            this.removeRole(membershipReferenceType, itemId, primaryOwner.getMemberType(), primaryOwner.getMemberId(), poRoleEntity.getId());
            if (primaryOwner.getMemberType() == MembershipMemberType.USER) {
                for (RoleEntity newRole : newRoles) {
                    this.addRoleToMemberOnReference(organizationId, environmentId, new MembershipService.MembershipReference(membershipReferenceType, itemId), new MembershipService.MembershipMember(primaryOwner.getMemberId(), null, primaryOwner.getMemberType()), new MembershipService.MembershipRole(roleScope, newRole.getName()));
                }
            } else if (primaryOwner.getMemberType() == MembershipMemberType.GROUP) {
                this.apiService.removeGroup(itemId, primaryOwner.getId());
            }
        }
    }

    @Override
    public MemberEntity updateRoleToMemberOnReference(String organizationId, String environmentId, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, MembershipService.MembershipRole role) {
        return this.updateRolesToMemberOnReference(organizationId, environmentId, reference, member, Collections.singleton(role), null, true).stream().findFirst().orElse(null);
    }

    @Override
    public List<MemberEntity> updateRolesToMemberOnReference(String organizationId, String environmentId, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, Collection<MembershipService.MembershipRole> roles, String source, boolean notify) {
        try {
            Set existingMemberships = this.membershipRepository.findByMemberIdAndMemberTypeAndReferenceTypeAndReferenceId(member.getMemberId(), this.convert(member.getMemberType()), this.convert(reference.getType()), reference.getId());
            if (existingMemberships != null && !existingMemberships.isEmpty()) {
                existingMemberships.forEach(membership -> this.deleteMembership(organizationId, environmentId, membership.getId()));
            }
            return roles.stream().map(role -> this._addRoleToMemberOnReference(reference, member, (MembershipService.MembershipRole)role, source, notify, false, environmentId, organizationId)).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to update member for {} {}", new Object[]{reference.getType(), reference.getId(), ex});
            throw new TechnicalManagementException("An error occurs while trying to update member for " + reference.getType() + " " + reference.getId(), ex);
        }
    }

    @Override
    public List<MemberEntity> updateRolesToMemberOnReferenceBySource(String organizationId, String environmentId, MembershipService.MembershipReference reference, MembershipService.MembershipMember member, Collection<MembershipService.MembershipRole> roles, String source) {
        return roles.stream().map(role -> this._addRoleToMemberOnReference(reference, member, (MembershipService.MembershipRole)role, source, false, true, environmentId, organizationId)).collect(Collectors.toList());
    }
}

