/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service;

import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.NewPreRegisterUserEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.RegisterUserEntity;
import io.gravitee.rest.api.model.ResetPasswordUserEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.configuration.identity.RoleMappingEntity;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import io.gravitee.rest.api.service.common.JWTHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface UserService {
    public UserEntity connect(String var1);

    public UserEntity findById(String var1, boolean var2);

    default public UserEntity findById(String id) {
        return this.findById(id, false);
    }

    public Optional<UserEntity> findByEmail(String var1);

    public UserEntity findByIdWithRoles(String var1);

    public UserEntity findBySource(String var1, String var2, boolean var3);

    public Set<UserEntity> findByIds(List<String> var1);

    public Set<UserEntity> findByIds(List<String> var1, boolean var2);

    public UserEntity create(NewExternalUserEntity var1, boolean var2);

    public UserEntity update(String var1, UpdateUserEntity var2);

    public UserEntity update(String var1, UpdateUserEntity var2, String var3);

    public Page<UserEntity> search(String var1, Pageable var2);

    public Page<UserEntity> search(UserCriteria var1, Pageable var2);

    public UserEntity register(NewExternalUserEntity var1);

    public UserEntity register(NewExternalUserEntity var1, String var2);

    public UserEntity finalizeRegistration(RegisterUserEntity var1);

    public UserEntity finalizeResetPassword(ResetPasswordUserEntity var1);

    public UserEntity processRegistration(String var1, boolean var2);

    public PictureEntity getPicture(String var1);

    public void delete(String var1);

    public void resetPassword(String var1);

    public UserEntity resetPasswordFromSourceId(String var1, String var2);

    public Map<String, Object> getTokenRegistrationParams(UserEntity var1, String var2, JWTHelper.ACTION var3);

    public Map<String, Object> getTokenRegistrationParams(UserEntity var1, String var2, JWTHelper.ACTION var3, String var4);

    public UserEntity create(NewPreRegisterUserEntity var1);

    public UserEntity createOrUpdateUserFromSocialIdentityProvider(SocialIdentityProviderEntity var1, String var2);

    public void updateUserRoles(String var1, MembershipReferenceType var2, String var3, List<String> var4);

    public void computeRolesToAddUser(String var1, List<RoleMappingEntity> var2, String var3, Set<RoleEntity> var4, Map<String, Set<RoleEntity>> var5);
}

