/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.dictionary;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.utils.IdGenerator;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Dictionary;
import io.gravitee.repository.management.model.DictionaryProvider;
import io.gravitee.repository.management.model.DictionaryTrigger;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryProviderEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryTriggerEntity;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryType;
import io.gravitee.rest.api.model.configuration.dictionary.NewDictionaryEntity;
import io.gravitee.rest.api.model.configuration.dictionary.UpdateDictionaryEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.configuration.dictionary.DictionaryAlreadyExistsException;
import io.gravitee.rest.api.service.impl.configuration.dictionary.DictionaryNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DictionaryServiceImpl
extends AbstractService
implements DictionaryService {
    private final Logger LOGGER = LoggerFactory.getLogger(DictionaryServiceImpl.class);
    @Autowired
    private DictionaryRepository dictionaryRepository;
    @Autowired
    private AuditService auditService;
    @Autowired
    private EventService eventService;
    @Autowired
    private ObjectMapper mapper;

    @Override
    public Set<DictionaryEntity> findAll() {
        try {
            return this.dictionaryRepository.findAllByEnvironments(Collections.singleton(GraviteeContext.getCurrentEnvironment())).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to retrieve dictionaries", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to retrieve dictionaries", ex);
        }
    }

    @Override
    public DictionaryEntity deploy(String id) {
        try {
            this.LOGGER.debug("Deploy dictionary {}", (Object)id);
            Optional optDictionary = this.dictionaryRepository.findById((Object)id);
            if (!optDictionary.isPresent()) {
                throw new DictionaryNotFoundException(id);
            }
            Dictionary dictionary = (Dictionary)optDictionary.get();
            dictionary.setUpdatedAt(new Date());
            dictionary.setDeployedAt(dictionary.getUpdatedAt());
            dictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.DICTIONARY_ID.getValue(), id);
            this.eventService.create(Collections.singleton(GraviteeContext.getCurrentEnvironment()), EventType.PUBLISH_DICTIONARY, this.mapper.writeValueAsString((Object)dictionary), properties);
            return this.convert(dictionary);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to deploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity undeploy(String id) {
        try {
            this.LOGGER.debug("Undeploy dictionary {}", (Object)id);
            Optional optDictionary = this.dictionaryRepository.findById((Object)id);
            if (!optDictionary.isPresent()) {
                throw new DictionaryNotFoundException(id);
            }
            Dictionary dictionary = (Dictionary)optDictionary.get();
            dictionary.setUpdatedAt(new Date());
            dictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.DICTIONARY_ID.getValue(), id);
            this.eventService.create(Collections.singleton(GraviteeContext.getCurrentEnvironment()), EventType.UNPUBLISH_DICTIONARY, this.mapper.writeValueAsString((Object)dictionary), properties);
            return this.convert(dictionary);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to undeploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to undeploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity start(String id) {
        try {
            this.LOGGER.debug("Start dictionary {}", (Object)id);
            Optional optDictionary = this.dictionaryRepository.findById((Object)id);
            if (!optDictionary.isPresent()) {
                throw new DictionaryNotFoundException(id);
            }
            Dictionary dictionary = (Dictionary)optDictionary.get();
            dictionary.setUpdatedAt(new Date());
            dictionary.setState(LifecycleState.STARTED);
            dictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.DICTIONARY_ID.getValue(), id);
            this.eventService.create(Collections.singleton(GraviteeContext.getCurrentEnvironment()), EventType.START_DICTIONARY, null, properties);
            this.createAuditLog((Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, dictionary.getCreatedAt(), (Dictionary)optDictionary.get(), dictionary);
            return this.convert(dictionary);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to undeploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to undeploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity stop(String id) {
        try {
            this.LOGGER.debug("Stop dictionary {}", (Object)id);
            Optional optDictionary = this.dictionaryRepository.findById((Object)id);
            if (!optDictionary.isPresent()) {
                throw new DictionaryNotFoundException(id);
            }
            Dictionary dictionary = (Dictionary)optDictionary.get();
            dictionary.setUpdatedAt(new Date());
            dictionary.setState(LifecycleState.STOPPED);
            dictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.DICTIONARY_ID.getValue(), id);
            this.eventService.create(Collections.singleton(GraviteeContext.getCurrentEnvironment()), EventType.STOP_DICTIONARY, null, properties);
            this.createAuditLog((Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, dictionary.getCreatedAt(), (Dictionary)optDictionary.get(), dictionary);
            return this.convert(dictionary);
        }
        catch (Exception ex) {
            this.LOGGER.error("An error occurs while trying to undeploy dictionary {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to undeploy " + id, ex);
        }
    }

    @Override
    public DictionaryEntity create(NewDictionaryEntity newDictionaryEntity) {
        try {
            this.LOGGER.debug("Create dictionary {}", (Object)newDictionaryEntity);
            Optional optDictionary = this.dictionaryRepository.findById((Object)IdGenerator.generate((String)newDictionaryEntity.getName()));
            if (optDictionary.isPresent()) {
                throw new DictionaryAlreadyExistsException(newDictionaryEntity.getName());
            }
            Dictionary dictionary = this.convert(newDictionaryEntity);
            dictionary.setEnvironmentId(GraviteeContext.getCurrentEnvironment());
            dictionary.setCreatedAt(new Date());
            dictionary.setState(LifecycleState.STOPPED);
            dictionary.setUpdatedAt(dictionary.getCreatedAt());
            Dictionary createdDictionary = (Dictionary)this.dictionaryRepository.create((Object)dictionary);
            this.createAuditLog((Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_CREATED, dictionary.getCreatedAt(), null, dictionary);
            return this.convert(createdDictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to create dictionary {}", (Object)newDictionaryEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to create " + newDictionaryEntity, ex);
        }
    }

    @Override
    public DictionaryEntity update(String id, UpdateDictionaryEntity updateDictionaryEntity) {
        try {
            this.LOGGER.debug("Update dictionary {}", (Object)updateDictionaryEntity);
            Optional optDictionary = this.dictionaryRepository.findById((Object)id);
            if (!optDictionary.isPresent()) {
                throw new DictionaryNotFoundException(updateDictionaryEntity.getName());
            }
            Dictionary dictionary = this.convert(updateDictionaryEntity);
            dictionary.setId(id);
            dictionary.setCreatedAt(((Dictionary)optDictionary.get()).getCreatedAt());
            dictionary.setEnvironmentId(((Dictionary)optDictionary.get()).getEnvironmentId());
            dictionary.setUpdatedAt(new Date());
            dictionary.setState(((Dictionary)optDictionary.get()).getState());
            Dictionary updatedDictionary = (Dictionary)this.dictionaryRepository.update((Object)dictionary);
            if (updatedDictionary.getState() == LifecycleState.STARTED) {
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.DICTIONARY_ID.getValue(), id);
                this.eventService.create(Collections.singleton(GraviteeContext.getCurrentEnvironment()), EventType.START_DICTIONARY, null, properties);
            }
            this.createAuditLog((Audit.AuditEvent)Dictionary.AuditEvent.DICTIONARY_UPDATED, dictionary.getCreatedAt(), (Dictionary)optDictionary.get(), updatedDictionary);
            return this.convert(updatedDictionary);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to update dictionary {}", (Object)updateDictionaryEntity, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update " + updateDictionaryEntity, ex);
        }
    }

    @Override
    public DictionaryEntity findById(String id) {
        try {
            this.LOGGER.debug("Find dictionary by ID: {}", (Object)id);
            Optional dictionary = this.dictionaryRepository.findById((Object)id);
            if (dictionary.isPresent()) {
                return this.convert((Dictionary)dictionary.get());
            }
            throw new DictionaryNotFoundException(id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete a dictionary using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a dictionary using its ID " + id, ex);
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.LOGGER.debug("Delete dictionary: {}", (Object)id);
            Optional dictionary = this.dictionaryRepository.findById((Object)id);
            if (!dictionary.isPresent()) {
                throw new DictionaryNotFoundException(id);
            }
            if (((Dictionary)dictionary.get()).getType() == io.gravitee.repository.management.model.DictionaryType.MANUAL) {
                this.undeploy(id);
            }
            this.stop(id);
            this.dictionaryRepository.delete((Object)id);
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to delete a dictionary using its ID {}", (Object)id, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete a dictionary using its ID " + id, ex);
        }
    }

    private void createAuditLog(Audit.AuditEvent event, Date createdAt, Dictionary oldValue, Dictionary newValue) {
        String dictionaryName = oldValue != null ? oldValue.getName() : newValue.getName();
        this.auditService.createEnvironmentAuditLog(GraviteeContext.getCurrentEnvironment(), Collections.singletonMap(Audit.AuditProperties.DICTIONARY, dictionaryName), event, createdAt, oldValue, newValue);
    }

    private DictionaryEntity convert(Dictionary dictionary) {
        DictionaryEntity dictionaryEntity = new DictionaryEntity();
        dictionaryEntity.setId(dictionary.getId());
        dictionaryEntity.setName(dictionary.getName());
        dictionaryEntity.setDescription(dictionary.getDescription());
        dictionaryEntity.setCreatedAt(dictionary.getCreatedAt());
        dictionaryEntity.setUpdatedAt(dictionary.getUpdatedAt());
        dictionaryEntity.setDeployedAt(dictionary.getDeployedAt());
        dictionaryEntity.setType(DictionaryType.valueOf((String)dictionary.getType().name()));
        dictionaryEntity.setProperties(dictionary.getProperties());
        if (dictionary.getType() == io.gravitee.repository.management.model.DictionaryType.DYNAMIC) {
            dictionaryEntity.setProvider(this.convert(dictionary.getProvider()));
            dictionaryEntity.setTrigger(this.convert(dictionary.getTrigger()));
        }
        dictionaryEntity.setState(Lifecycle.State.valueOf((String)dictionary.getState().name()));
        return dictionaryEntity;
    }

    private Dictionary convert(UpdateDictionaryEntity updateDictionaryEntity) {
        Dictionary dictionary = new Dictionary();
        dictionary.setName(updateDictionaryEntity.getName());
        dictionary.setDescription(updateDictionaryEntity.getDescription());
        dictionary.setProperties(updateDictionaryEntity.getProperties());
        DictionaryType type = updateDictionaryEntity.getType();
        if (type != null) {
            dictionary.setType(io.gravitee.repository.management.model.DictionaryType.valueOf((String)type.name()));
        }
        if (type == DictionaryType.DYNAMIC) {
            dictionary.setProvider(this.convert(updateDictionaryEntity.getProvider()));
            dictionary.setTrigger(this.convert(updateDictionaryEntity.getTrigger()));
        }
        return dictionary;
    }

    private Dictionary convert(NewDictionaryEntity newDictionaryEntity) {
        Dictionary dictionary = new Dictionary();
        dictionary.setId(IdGenerator.generate((String)newDictionaryEntity.getName()));
        dictionary.setName(newDictionaryEntity.getName());
        dictionary.setDescription(newDictionaryEntity.getDescription());
        DictionaryType type = newDictionaryEntity.getType();
        if (type != null) {
            dictionary.setType(io.gravitee.repository.management.model.DictionaryType.valueOf((String)type.name()));
        }
        if (type == DictionaryType.MANUAL) {
            dictionary.setProperties(newDictionaryEntity.getProperties());
        } else {
            dictionary.setProvider(this.convert(newDictionaryEntity.getProvider()));
            dictionary.setTrigger(this.convert(newDictionaryEntity.getTrigger()));
        }
        return dictionary;
    }

    private DictionaryProvider convert(DictionaryProviderEntity providerEntity) {
        DictionaryProvider provider = null;
        if (providerEntity != null && providerEntity.getType() != null && providerEntity.getConfiguration() != null) {
            provider = new DictionaryProvider();
            provider.setType(providerEntity.getType());
            provider.setConfiguration(providerEntity.getConfiguration().toString());
        }
        return provider;
    }

    private DictionaryProviderEntity convert(DictionaryProvider provider) {
        DictionaryProviderEntity entity = null;
        if (provider != null) {
            entity = new DictionaryProviderEntity();
            entity.setType(provider.getType());
            try {
                entity.setConfiguration(this.mapper.readTree(provider.getConfiguration()));
            }
            catch (IOException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return entity;
    }

    private DictionaryTrigger convert(DictionaryTriggerEntity triggerEntity) {
        DictionaryTrigger trigger = null;
        if (triggerEntity != null) {
            trigger = new DictionaryTrigger();
            trigger.setRate(triggerEntity.getRate());
            trigger.setUnit(triggerEntity.getUnit());
        }
        return trigger;
    }

    private DictionaryTriggerEntity convert(DictionaryTrigger trigger) {
        DictionaryTriggerEntity entity = null;
        if (trigger != null) {
            entity = new DictionaryTriggerEntity();
            entity.setRate(trigger.getRate());
            entity.setUnit(trigger.getUnit());
        }
        return entity;
    }
}

