/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.designer.DeployModelCommand;
import io.gravitee.cockpit.api.command.designer.DeployModelPayload;
import io.gravitee.cockpit.api.command.designer.DeployModelReply;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.model.DeploymentMode;
import io.gravitee.rest.api.service.cockpit.services.ApiServiceCockpit;
import io.gravitee.rest.api.service.cockpit.services.CockpitApiPermissionChecker;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.reactivex.Single;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployModelCommandHandler
implements CommandHandler<DeployModelCommand, DeployModelReply> {
    private final Logger logger = LoggerFactory.getLogger(DeployModelCommandHandler.class);
    private final ApiService apiService;
    private final ApiServiceCockpit cockpitApiService;
    private final CockpitApiPermissionChecker permissionChecker;
    private final UserService userService;
    private final EnvironmentService environmentService;

    public DeployModelCommandHandler(ApiService apiService, ApiServiceCockpit cockpitApiService, CockpitApiPermissionChecker permissionChecker, UserService userService, EnvironmentService environmentService) {
        this.apiService = apiService;
        this.cockpitApiService = cockpitApiService;
        this.permissionChecker = permissionChecker;
        this.userService = userService;
        this.environmentService = environmentService;
    }

    public Command.Type handleType() {
        return Command.Type.DEPLOY_MODEL_COMMAND;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Single<DeployModelReply> handle(DeployModelCommand command) {
        DeployModelPayload payload = (DeployModelPayload)command.getPayload();
        String apiId = payload.getModelId();
        String userId = payload.getUserId();
        String swaggerDefinition = payload.getSwaggerDefinition();
        String environmentId = payload.getEnvironmentId();
        DeploymentMode mode = DeploymentMode.fromDeployModelPayload(payload);
        try {
            ApiEntity api;
            Optional<String> message;
            UserEntity user = this.userService.findBySource("cockpit", userId, false);
            EnvironmentEntity environment = this.environmentService.findByCockpitId(environmentId);
            if (this.apiService.exists(apiId)) {
                message = this.permissionChecker.checkUpdatePermission(user.getId(), environment.getId(), apiId, mode);
                if (message.isPresent()) {
                    DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
                    reply.setMessage(message.get());
                    Single single = Single.just((Object)reply);
                    return single;
                }
                api = this.cockpitApiService.updateApi(apiId, user.getId(), swaggerDefinition, environment.getId(), mode);
            } else {
                message = this.permissionChecker.checkCreatePermission(user.getId(), environment.getId(), mode);
                if (message.isPresent()) {
                    DeployModelReply reply = new DeployModelReply(command.getId(), CommandStatus.FAILED);
                    reply.setMessage(message.get());
                    Single single = Single.just((Object)reply);
                    return single;
                }
                api = this.cockpitApiService.createApi(apiId, user.getId(), swaggerDefinition, environment.getId(), mode);
            }
            this.logger.info("Api imported [{}].", (Object)api.getId());
            Single single = Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.SUCCEEDED));
            return single;
        }
        catch (Exception e) {
            this.logger.error("Error occurred when importing api [{}].", (Object)payload.getModelId(), (Object)e);
            Single single = Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.ERROR));
            return single;
        }
        finally {
            GraviteeContext.cleanContext();
        }
    }
}

