/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.designer.DeployModelCommand;
import io.gravitee.cockpit.api.command.designer.DeployModelPayload;
import io.gravitee.cockpit.api.command.designer.DeployModelReply;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.UserService;
import io.reactivex.Single;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeployModelCommandHandler
implements CommandHandler<DeployModelCommand, DeployModelReply> {
    private final Logger logger = LoggerFactory.getLogger(DeployModelCommandHandler.class);
    private final ApiService apiService;
    private final UserService userService;

    public DeployModelCommandHandler(ApiService apiService, UserService userService) {
        this.apiService = apiService;
        this.userService = userService;
    }

    public Command.Type handleType() {
        return Command.Type.DEPLOY_MODEL_COMMAND;
    }

    public Single<DeployModelReply> handle(DeployModelCommand command) {
        DeployModelPayload payload = (DeployModelPayload)command.getPayload();
        String apiId = payload.getModelId();
        String userId = payload.getUserId();
        String swaggerDefinition = payload.getSwaggerDefinition();
        try {
            UserEntity user = this.userService.findBySource("cockpit", userId, false);
            ApiEntity api = this.apiService.createFromCockpit(apiId, user.getId(), swaggerDefinition);
            this.logger.info("Api imported [{}].", (Object)api.getId());
            return Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.SUCCEEDED));
        }
        catch (Exception e) {
            this.logger.error("Error occurred when importing api [{}].", (Object)payload.getModelId(), (Object)e);
            return Single.just((Object)new DeployModelReply(command.getId(), CommandStatus.ERROR));
        }
    }
}

