/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.DuplicateApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.service.ApiDuplicatorService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.vertx.core.buffer.Buffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ApiDuplicatorServiceImpl
extends AbstractService
implements ApiDuplicatorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiDuplicatorServiceImpl.class);
    private final HttpClientService httpClientService;
    private final ImportConfiguration importConfiguration;
    private final MediaService mediaService;
    private final ObjectMapper objectMapper;
    private final ApiMetadataService apiMetadataService;
    private final MembershipService membershipService;
    private final RoleService roleService;
    private final PageService pageService;
    private final PlanService planService;
    private final GroupService groupService;
    private final UserService userService;
    private final ApiService apiService;

    public ApiDuplicatorServiceImpl(HttpClientService httpClientService, ImportConfiguration importConfiguration, MediaService mediaService, ObjectMapper objectMapper, ApiMetadataService apiMetadataService, MembershipService membershipService, RoleService roleService, PageService pageService, PlanService planService, GroupService groupService, UserService userService, ApiService apiService) {
        this.httpClientService = httpClientService;
        this.importConfiguration = importConfiguration;
        this.mediaService = mediaService;
        this.objectMapper = objectMapper;
        this.apiMetadataService = apiMetadataService;
        this.membershipService = membershipService;
        this.roleService = roleService;
        this.pageService = pageService;
        this.planService = planService;
        this.groupService = groupService;
        this.userService = userService;
        this.apiService = apiService;
    }

    @Override
    public ApiEntity createWithImportedDefinition(String apiDefinitionOrURL, String userId, String organizationId, String environmentId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            apiDefinition = this.preprocessApiDefinitionUpdatingIds(jsonNode, environmentId);
            UpdateApiEntity importedApi = this.convertToEntity(apiDefinition, jsonNode);
            ApiEntity createdApiEntity = this.apiService.createWithApiDefinition(importedApi, userId, jsonNode);
            this.createPageAndMedia(createdApiEntity, jsonNode, environmentId);
            this.updateApiReferences(createdApiEntity, jsonNode, organizationId, environmentId, false);
            return createdApiEntity;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    @Override
    public ApiEntity duplicate(ApiEntity apiEntity, DuplicateApiEntity duplicateApiEntity, String organizationId, String environmentId) {
        Objects.requireNonNull(apiEntity, "Missing ApiEntity");
        String apiId = apiEntity.getId();
        LOGGER.debug("Duplicate API {}", (Object)apiId);
        UpdateApiEntity newApiEntity = ApiService.convert(apiEntity);
        Proxy proxy = apiEntity.getProxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(duplicateApiEntity.getContextPath())));
        newApiEntity.setProxy(proxy);
        newApiEntity.setVersion(duplicateApiEntity.getVersion() == null ? apiEntity.getVersion() : duplicateApiEntity.getVersion());
        if (duplicateApiEntity.getFilteredFields().contains("groups")) {
            newApiEntity.setGroups(null);
        } else {
            newApiEntity.setGroups(apiEntity.getGroups());
        }
        HashMap plansIdsMap = new HashMap();
        if (!duplicateApiEntity.getFilteredFields().contains("plans")) {
            newApiEntity.getPlans().forEach(plan -> {
                String newPlanId = UuidString.generateRandom();
                plansIdsMap.put(plan.getId(), newPlanId);
                plan.setId(newPlanId);
            });
        }
        ApiEntity duplicatedApi = this.apiService.createWithApiDefinition(newApiEntity, this.getAuthenticatedUsername(), null);
        if (!duplicateApiEntity.getFilteredFields().contains("members")) {
            Set<MembershipEntity> membershipsToDuplicate = this.membershipService.getMembershipsByReference(MembershipReferenceType.API, apiId);
            RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, RoleScope.API);
            if (primaryOwnerRole != null) {
                String primaryOwnerRoleId = primaryOwnerRole.getId();
                membershipsToDuplicate.forEach(membership -> {
                    String roleId = membership.getRoleId();
                    if (!primaryOwnerRoleId.equals(roleId)) {
                        this.membershipService.addRoleToMemberOnReference(MembershipReferenceType.API, duplicatedApi.getId(), membership.getMemberType(), membership.getMemberId(), roleId);
                    }
                });
            }
        }
        if (!duplicateApiEntity.getFilteredFields().contains("pages")) {
            List<PageEntity> pages = this.pageService.search(new PageQuery.Builder().api(apiId).build(), true, environmentId);
            this.pageService.duplicatePages(pages, environmentId, duplicatedApi.getId());
        }
        if (!duplicateApiEntity.getFilteredFields().contains("plans")) {
            this.planService.findByApi(apiId).forEach(plan -> {
                plan.setId((String)plansIdsMap.get(plan.getId()));
                plan.setApi(duplicatedApi.getId());
                this.planService.create(NewPlanEntity.from((PlanEntity)plan));
            });
        }
        return duplicatedApi;
    }

    @Override
    public String exportAsJson(String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.apiService.findById(apiId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public ApiEntity updateWithImportedDefinition(String apiId, String apiDefinitionOrURL, String userId, String organizationId, String environmentId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            if (!jsonNode.has("id") || !apiId.equals(jsonNode.get("id").asText())) {
                apiDefinition = this.preprocessApiDefinitionUpdatingIds(jsonNode, environmentId);
            }
            UpdateApiEntity importedApi = this.convertToEntity(apiDefinition, jsonNode);
            ApiEntity updatedApiEntity = this.apiService.update(apiId, importedApi, false);
            this.updateApiReferences(updatedApiEntity, jsonNode, organizationId, environmentId, true);
            return updatedApiEntity;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    private UpdateApiEntity convertToEntity(String apiDefinition, JsonNode jsonNode) throws JsonProcessingException {
        JsonNode viewsDefinition;
        UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
        if (Objects.equals(importedApi.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (importedApi.getPaths() == null || importedApi.getPaths().isEmpty())) {
            importedApi.setPaths(Collections.singletonMap("/", new ArrayList()));
        }
        if (importedApi.getGroups() != null) {
            HashSet groupNames = new HashSet(importedApi.getGroups());
            importedApi.getGroups().clear();
            for (String name : groupNames) {
                GroupEntity group;
                List<GroupEntity> groupEntities = this.groupService.findByName(name);
                if (groupEntities.isEmpty()) {
                    NewGroupEntity newGroupEntity = new NewGroupEntity();
                    newGroupEntity.setName(name);
                    group = this.groupService.create(newGroupEntity);
                } else {
                    group = groupEntities.get(0);
                }
                importedApi.getGroups().add(group.getId());
            }
        }
        if ((viewsDefinition = jsonNode.path("views")) != null && viewsDefinition.isArray()) {
            HashSet<String> categories = new HashSet<String>();
            for (JsonNode viewNode : viewsDefinition) {
                categories.add(viewNode.asText());
            }
            importedApi.setCategories(categories);
        }
        return importedApi;
    }

    private void createPageAndMedia(ApiEntity createdApiEntity, JsonNode jsonNode, String environmentId) throws JsonProcessingException {
        List<PageEntity> search;
        JsonNode pages;
        JsonNode apiMedia = jsonNode.path("apiMedia");
        if (apiMedia != null && apiMedia.isArray()) {
            for (JsonNode media : apiMedia) {
                this.mediaService.createWithDefinition(createdApiEntity.getId(), media.toString());
            }
        }
        if ((pages = jsonNode.path("pages")) != null && pages.isArray()) {
            List pagesList = (List)this.objectMapper.readValue(pages.toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            this.pageService.duplicatePages(pagesList, environmentId, createdApiEntity.getId());
        }
        if ((search = this.pageService.search(new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build(), environmentId)).isEmpty()) {
            this.createSystemFolder(createdApiEntity.getId(), environmentId);
        }
    }

    private void createSystemFolder(String apiId, String environmentId) {
        NewPageEntity asideSystemFolder = new NewPageEntity();
        asideSystemFolder.setName(SystemFolderType.ASIDE.folderName());
        asideSystemFolder.setPublished(true);
        asideSystemFolder.setType(PageType.SYSTEM_FOLDER);
        asideSystemFolder.setVisibility(Visibility.PUBLIC);
        this.pageService.createPage(apiId, asideSystemFolder, environmentId);
    }

    private String fetchApiDefinitionContentFromURL(String apiDefinitionOrURL) {
        if (apiDefinitionOrURL.toUpperCase().startsWith("HTTP")) {
            UrlSanitizerUtils.checkAllowed(apiDefinitionOrURL, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
            Buffer buffer = this.httpClientService.request(HttpMethod.GET, apiDefinitionOrURL, null, null, null);
            return buffer.toString();
        }
        return apiDefinitionOrURL;
    }

    private void updateApiReferences(ApiEntity createdOrUpdatedApiEntity, JsonNode jsonNode, String organizationId, String environmentId, boolean isUpdate) throws JsonProcessingException {
        JsonNode metadataDefinition;
        JsonNode plansDefinition;
        JsonNode pagesDefinition;
        JsonNode membersToImport = jsonNode.path("members");
        if (membersToImport != null && membersToImport.isArray()) {
            Set membersAlreadyPresent = this.membershipService.getMembersByReference(MembershipReferenceType.API, createdOrUpdatedApiEntity.getId()).stream().map(member -> {
                UserEntity userEntity = this.userService.findById(member.getId());
                return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()), null);
            }).collect(Collectors.toSet());
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(organizationId, RoleScope.API);
            if (poRole != null) {
                String poRoleId = poRole.getId();
                MemberToImport currentPo = membersAlreadyPresent.stream().filter(memberToImport -> memberToImport.getRoles().contains(poRoleId)).findFirst().orElse(new MemberToImport());
                List<String> roleUsedInTransfert = null;
                MemberToImport futurePO = null;
                for (JsonNode memberNode : membersToImport) {
                    boolean presentWithSameRole;
                    MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                    String roleToAdd = memberToImport2.getRole();
                    List<String> rolesToImport = memberToImport2.getRoles();
                    if (roleToAdd != null && !roleToAdd.isEmpty()) {
                        Optional<RoleEntity> optRoleToAddEntity;
                        if (rolesToImport == null) {
                            rolesToImport = new ArrayList<String>();
                            memberToImport2.setRoles(rolesToImport);
                        }
                        if ((optRoleToAddEntity = this.roleService.findByScopeAndName(RoleScope.API, roleToAdd)).isPresent()) {
                            rolesToImport.add(optRoleToAddEntity.get().getId());
                        } else {
                            LOGGER.warn("Role {} does not exist", (Object)roleToAdd);
                        }
                    }
                    if (rolesToImport != null) {
                        rolesToImport.sort(Comparator.naturalOrder());
                    }
                    boolean bl = presentWithSameRole = memberToImport2.getRoles() != null && !memberToImport2.getRoles().isEmpty() && membersAlreadyPresent.stream().anyMatch(m -> {
                        m.getRoles().sort(Comparator.naturalOrder());
                        return m.getRoles().equals(memberToImport2.getRoles()) && m.getSourceId().equals(memberToImport2.getSourceId()) && m.getSource().equals(memberToImport2.getSource());
                    });
                    if (!(presentWithSameRole || memberToImport2.getRoles() == null || memberToImport2.getRoles().isEmpty() || memberToImport2.getRoles().contains(poRoleId) || memberToImport2.getSourceId().equals(currentPo.getSourceId()) && memberToImport2.getSource().equals(currentPo.getSource()))) {
                        try {
                            UserEntity userEntity = this.userService.findBySource(memberToImport2.getSource(), memberToImport2.getSourceId(), false);
                            rolesToImport.forEach(role -> {
                                try {
                                    this.membershipService.addRoleToMemberOnReference(MembershipReferenceType.API, createdOrUpdatedApiEntity.getId(), MembershipMemberType.USER, userEntity.getId(), (String)role);
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Unable to add role '{}' to member '{}' on API '{}' due to : {}", new Object[]{role, userEntity.getId(), createdOrUpdatedApiEntity.getId(), e.getMessage()});
                                }
                            });
                        }
                        catch (UserNotFoundException userNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (currentPo.getSourceId().equals(memberToImport2.getSourceId()) && currentPo.getSource().equals(memberToImport2.getSource()) && !rolesToImport.contains(poRoleId)) {
                        roleUsedInTransfert = rolesToImport;
                    }
                    if (!rolesToImport.contains(poRoleId)) continue;
                    futurePO = memberToImport2;
                }
                if (!(futurePO == null || currentPo.getSource().equals(futurePO.getSource()) && currentPo.getSourceId().equals(futurePO.getSourceId()))) {
                    try {
                        UserEntity userEntity = this.userService.findBySource(futurePO.getSource(), futurePO.getSourceId(), false);
                        List roleEntity = null;
                        if (roleUsedInTransfert != null && !roleUsedInTransfert.isEmpty()) {
                            roleEntity = roleUsedInTransfert.stream().map(this.roleService::findById).collect(Collectors.toList());
                        }
                        this.membershipService.transferApiOwnership(createdOrUpdatedApiEntity.getId(), new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), roleEntity);
                    }
                    catch (UserNotFoundException userNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        if (isUpdate && (pagesDefinition = jsonNode.path("pages")) != null && pagesDefinition.isArray()) {
            List pagesList = (List)this.objectMapper.readValue(pagesDefinition.toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            this.pageService.createOrUpdatePages(pagesList, environmentId, createdOrUpdatedApiEntity.getId());
        }
        if ((plansDefinition = jsonNode.path("plans")) != null && plansDefinition.isArray()) {
            List plansToImport = (List)this.objectMapper.readValue(plansDefinition.toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PlanEntity.class));
            if (isUpdate) {
                this.findRemovedPlansIds(this.planService.findByApi(createdOrUpdatedApiEntity.getId()), plansToImport).forEach(this.planService::delete);
            }
            plansToImport.forEach(planEntity -> {
                planEntity.setApi(createdOrUpdatedApiEntity.getId());
                this.planService.createOrUpdatePlan((PlanEntity)planEntity, environmentId);
            });
        }
        if ((metadataDefinition = jsonNode.path("metadata")) != null && metadataDefinition.isArray()) {
            try {
                for (JsonNode metadataNode : metadataDefinition) {
                    UpdateApiMetadataEntity updateApiMetadataEntity = (UpdateApiMetadataEntity)this.objectMapper.readValue(metadataNode.toString(), UpdateApiMetadataEntity.class);
                    updateApiMetadataEntity.setApiId(createdOrUpdatedApiEntity.getId());
                    this.apiMetadataService.update(updateApiMetadataEntity);
                }
            }
            catch (Exception ex) {
                LOGGER.error("An error occurs while creating API metadata", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while creating API Metadata", ex);
            }
        }
    }

    protected String preprocessApiDefinitionUpdatingIds(JsonNode apiJsonNode, String environmentId) {
        JsonNode plansDefinition = apiJsonNode.path("plans");
        if (plansDefinition != null && plansDefinition.isArray()) {
            plansDefinition.forEach(planJsonNode -> this.regenerateApiDefinitionPlanId(apiJsonNode, (JsonNode)planJsonNode, environmentId));
        }
        return apiJsonNode.toString();
    }

    private void regenerateApiDefinitionPlanId(JsonNode apiJsonNode, JsonNode planJsonNode, String environmentId) {
        String apiId = apiJsonNode.has("id") ? apiJsonNode.get("id").asText() : null;
        String planId = planJsonNode.has("id") ? planJsonNode.get("id").asText() : null;
        ((ObjectNode)planJsonNode).put("id", UuidString.generateForEnvironment(environmentId, apiId, planId));
    }

    private Stream<String> findRemovedPlansIds(Collection<PlanEntity> existingPlans, Collection<PlanEntity> importedPlans) {
        return existingPlans.stream().filter(existingPlan -> !importedPlans.contains(existingPlan)).map(plan -> plan.getId());
    }

    private static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }
}

