/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Collections;
import java.util.Map;

public class UnauthorizedPlanSecurityTypeException
extends AbstractManagementException {
    private final String security;

    public UnauthorizedPlanSecurityTypeException(PlanSecurityType security) {
        this.security = security.name();
    }

    @Override
    public String getMessage() {
        return "The security type " + this.security + " is not allowed.";
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "plan.security.typeNotAllowed";
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.singletonMap("type", this.security);
    }
}

