/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge;

import io.gravitee.cockpit.api.command.Command;
import io.gravitee.cockpit.api.command.CommandHandler;
import io.gravitee.cockpit.api.command.CommandStatus;
import io.gravitee.cockpit.api.command.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.bridge.BridgeSimpleReply;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.reactivex.Single;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BridgeCommandHandler
implements CommandHandler<BridgeCommand, BridgeReply> {
    private final Logger logger = LoggerFactory.getLogger(BridgeCommandHandler.class);
    private List<BridgeOperationHandler> operationHandlers;
    private final BridgeOperationHandler noOperationHandler = new BridgeOperationHandler(){

        @Override
        public boolean canHandle(String bridgeOperation) {
            return true;
        }

        @Override
        public Single<BridgeReply> handle(BridgeCommand command) {
            BridgeCommandHandler.this.logger.warn("No handler found for this operation {} ", (Object)command.getOperation());
            return Single.just((Object)new BridgeSimpleReply(command.getId(), CommandStatus.ERROR, "No handler found for this operation: " + command.getOperation()));
        }
    };

    public BridgeCommandHandler(List<BridgeOperationHandler> operationHandlers) {
        this.operationHandlers = operationHandlers;
    }

    public Command.Type handleType() {
        return Command.Type.BRIDGE_COMMAND;
    }

    public Single<BridgeReply> handle(BridgeCommand command) {
        return this.operationHandlers.stream().filter(handle -> handle.canHandle(command.getOperation())).findFirst().orElse(this.noOperationHandler).handle(command);
    }
}

