/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.promotion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.TaskEntity;
import io.gravitee.rest.api.model.TaskType;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.common.SortableImpl;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.model.promotion.PromotionEntityStatus;
import io.gravitee.rest.api.model.promotion.PromotionQuery;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.gravitee.rest.api.service.promotion.PromotionTasksService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class PromotionTasksServiceImpl
extends AbstractService
implements PromotionTasksService {
    private final Logger logger = LoggerFactory.getLogger(PromotionTasksServiceImpl.class);
    private final PromotionService promotionService;
    private final PermissionService permissionService;
    private final ObjectMapper objectMapper;
    private final EnvironmentService environmentService;
    private final ApiService apiService;

    public PromotionTasksServiceImpl(PromotionService promotionService, PermissionService permissionService, EnvironmentService environmentService, ObjectMapper objectMapper, ApiService apiService) {
        this.promotionService = promotionService;
        this.permissionService = permissionService;
        this.environmentService = environmentService;
        this.objectMapper = objectMapper;
        this.apiService = apiService;
    }

    @Override
    public List<TaskEntity> getPromotionTasks(String organizationId) {
        List<EnvironmentEntity> environments = this.environmentService.findByOrganization(organizationId);
        List<EnvironmentEntity> environmentsWithCreationPermissions = environments.stream().filter(environment -> this.permissionService.hasPermission(RolePermission.ENVIRONMENT_API, environment.getId(), RolePermissionAction.CREATE)).collect(Collectors.toList());
        List<EnvironmentEntity> environmentsWithUpdatePermissions = environments.stream().filter(environment -> this.permissionService.hasPermission(RolePermission.ENVIRONMENT_API, environment.getId(), RolePermissionAction.UPDATE)).collect(Collectors.toList());
        ArrayList<TaskEntity> tasks = new ArrayList<TaskEntity>();
        tasks.addAll(this.getPromotionTasksForEnvironments(environmentsWithCreationPermissions, false));
        tasks.addAll(this.getPromotionTasksForEnvironments(environmentsWithUpdatePermissions, true));
        return tasks;
    }

    @NotNull
    private List<TaskEntity> getPromotionTasksForEnvironments(List<EnvironmentEntity> environments, boolean selectUpdatePromotion) {
        if (environments.isEmpty()) {
            return Collections.emptyList();
        }
        List envCockpitIds = environments.stream().map(EnvironmentEntity::getCockpitId).filter(Objects::nonNull).collect(Collectors.toList());
        PromotionQuery promotionQuery = new PromotionQuery();
        promotionQuery.setStatuses(Collections.singletonList(PromotionEntityStatus.TO_BE_VALIDATED));
        promotionQuery.setTargetEnvCockpitIds(envCockpitIds);
        Page<PromotionEntity> promotionsPage = this.promotionService.search(promotionQuery, (Sortable)new SortableImpl("created_at", false), null);
        PromotionQuery previousPromotionsQuery = new PromotionQuery();
        previousPromotionsQuery.setStatuses(Collections.singletonList(PromotionEntityStatus.ACCEPTED));
        previousPromotionsQuery.setTargetEnvCockpitIds(envCockpitIds);
        previousPromotionsQuery.setTargetApiExists(Boolean.valueOf(true));
        List previousPromotions = this.promotionService.search(previousPromotionsQuery, (Sortable)new SortableImpl("created_at", false), null).getContent();
        Map promotionByApiWithTargetApiId = previousPromotions.stream().collect(Collectors.groupingBy(PromotionEntity::getApiId, Collectors.mapping(PromotionEntity::getTargetApiId, Collectors.toList())));
        return promotionsPage.getContent().stream().map(promotionEntity -> {
            Optional<String> foundTargetApiId = promotionByApiWithTargetApiId.getOrDefault(promotionEntity.getApiId(), Collections.emptyList()).stream().filter(StringUtils::hasText).findFirst();
            boolean isUpdate = foundTargetApiId.isPresent() && this.apiService.exists(foundTargetApiId.get());
            return this.convert((PromotionEntity)promotionEntity, isUpdate, foundTargetApiId);
        }).filter(taskEntity -> ((Map)taskEntity.getData()).getOrDefault("isApiUpdate", false) == selectUpdatePromotion).collect(Collectors.toList());
    }

    private TaskEntity convert(PromotionEntity promotionEntity, boolean isUpdate, Optional<String> foundTargetApiId) {
        ApiEntity apiEntity;
        TaskEntity taskEntity = new TaskEntity();
        taskEntity.setType(TaskType.PROMOTION_APPROVAL);
        taskEntity.setCreatedAt(promotionEntity.getCreatedAt());
        try {
            apiEntity = (ApiEntity)this.objectMapper.readValue(promotionEntity.getApiDefinition(), ApiEntity.class);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Problem while deserializing api definition for promotion {}", (Object)promotionEntity.getId());
            throw new TechnicalManagementException();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("apiName", apiEntity.getName());
        data.put("apiId", promotionEntity.getApiId());
        data.put("sourceEnvironmentName", promotionEntity.getSourceEnvName());
        data.put("targetEnvironmentName", promotionEntity.getTargetEnvName());
        data.put("authorDisplayName", promotionEntity.getAuthor().getDisplayName());
        data.put("authorEmail", promotionEntity.getAuthor().getEmail());
        data.put("authorPicture", promotionEntity.getAuthor().getPicture());
        data.put("promotionId", promotionEntity.getId());
        data.put("isApiUpdate", isUpdate);
        foundTargetApiId.ifPresent(targetApiId -> data.put("targetApiId", targetApiId));
        taskEntity.setData(data);
        return taskEntity;
    }
}

