/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Strings;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.data.domain.Page;
import io.gravitee.common.http.HttpMethod;
import io.gravitee.common.util.DataEncryptor;
import io.gravitee.definition.model.Api;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.Endpoint;
import io.gravitee.definition.model.EndpointGroup;
import io.gravitee.definition.model.Logging;
import io.gravitee.definition.model.LoggingMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.definition.model.endpoint.HttpEndpoint;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.definition.model.services.discovery.EndpointDiscoveryService;
import io.gravitee.definition.model.services.healthcheck.HealthCheckService;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiQualityRuleRepository;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.rest.api.model.ApiMetadataEntity;
import io.gravitee.rest.api.model.ApiModelEntity;
import io.gravitee.rest.api.model.CategoryEntity;
import io.gravitee.rest.api.model.EntrypointEntity;
import io.gravitee.rest.api.model.EntrypointReferenceType;
import io.gravitee.rest.api.model.EventEntity;
import io.gravitee.rest.api.model.EventQuery;
import io.gravitee.rest.api.model.EventType;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.ImportSwaggerDescriptorEntity;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.MetadataFormat;
import io.gravitee.rest.api.model.NewApiMetadataEntity;
import io.gravitee.rest.api.model.NewGroupEntity;
import io.gravitee.rest.api.model.NewPageEntity;
import io.gravitee.rest.api.model.NewPlanEntity;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageSourceEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PlanSecurityType;
import io.gravitee.rest.api.model.PlanStatus;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.PropertyEntity;
import io.gravitee.rest.api.model.ProxyModelEntity;
import io.gravitee.rest.api.model.ReviewEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.SystemFolderType;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.model.UpdateApiMetadataEntity;
import io.gravitee.rest.api.model.UpdatePageEntity;
import io.gravitee.rest.api.model.UpdatePlanEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.api.ApiDeploymentEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.api.NewApiEntity;
import io.gravitee.rest.api.model.api.SwaggerApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.application.ApplicationListItem;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.documentation.PageQuery;
import io.gravitee.rest.api.model.notification.GenericNotificationConfigEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.plan.PlanQuery;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.model.subscription.SubscriptionQuery;
import io.gravitee.rest.api.service.AlertService;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.ApiMetadataService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.ApplicationService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.EmailService;
import io.gravitee.rest.api.service.EntrypointService;
import io.gravitee.rest.api.service.EventService;
import io.gravitee.rest.api.service.GenericNotificationConfigService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.HttpClientService;
import io.gravitee.rest.api.service.MediaService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.PageService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.PortalNotificationConfigService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.SubscriptionService;
import io.gravitee.rest.api.service.SwaggerService;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.TopApiService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.VirtualHostService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.builder.EmailNotificationBuilder;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.AllowOriginNotAllowedException;
import io.gravitee.rest.api.service.exceptions.ApiAlreadyExistsException;
import io.gravitee.rest.api.service.exceptions.ApiMetadataNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiNotDeletableException;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.ApiRunningStateException;
import io.gravitee.rest.api.service.exceptions.EndpointMissingException;
import io.gravitee.rest.api.service.exceptions.EndpointNameInvalidException;
import io.gravitee.rest.api.service.exceptions.GroupNotFoundException;
import io.gravitee.rest.api.service.exceptions.GroupsNotFoundException;
import io.gravitee.rest.api.service.exceptions.HealthcheckInheritanceException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.exceptions.LifecycleStateChangeNotAllowedException;
import io.gravitee.rest.api.service.exceptions.NoPrimaryOwnerGroupForUserException;
import io.gravitee.rest.api.service.exceptions.PaginationInvalidException;
import io.gravitee.rest.api.service.exceptions.PlanNotFoundException;
import io.gravitee.rest.api.service.exceptions.RoleNotFoundException;
import io.gravitee.rest.api.service.exceptions.TagNotAllowedException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.jackson.ser.api.ApiSerializer;
import io.gravitee.rest.api.service.migration.APIV1toAPIV2Converter;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.HookScope;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.notification.NotificationTemplateService;
import io.gravitee.rest.api.service.processor.ApiSynchronizationProcessor;
import io.gravitee.rest.api.service.sanitizer.UrlSanitizerUtils;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import io.gravitee.rest.api.service.spring.ImportConfiguration;
import io.vertx.core.buffer.Buffer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ApiServiceImpl
extends AbstractService
implements ApiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiServiceImpl.class);
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("(?<!(http:|https:))[//]+");
    private static final Pattern CORS_REGEX_PATTERN = Pattern.compile("^((\\*)|(null)|(^(([^:\\/?#]+):)?(\\/\\/([^\\/?#]*))?))$");
    private static final String[] CORS_REGEX_CHARS = new String[]{"{", "[", "(", "*"};
    private static final String URI_PATH_SEPARATOR = "/";
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ApiQualityRuleRepository apiQualityRuleRepository;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EventService eventService;
    @Autowired
    private UserService userService;
    @Autowired
    private PageService pageService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private PlanService planService;
    @Autowired
    private ApiSynchronizationProcessor apiSynchronizationProcessor;
    @Autowired
    private ApiMetadataService apiMetadataService;
    @Autowired
    private SubscriptionService subscriptionService;
    @Autowired
    private AuditService auditService;
    @Autowired
    private TopApiService topApiService;
    @Autowired
    private GenericNotificationConfigService genericNotificationConfigService;
    @Autowired
    private PortalNotificationConfigService portalNotificationConfigService;
    @Autowired
    private NotifierService notifierService;
    @Autowired
    private SwaggerService swaggerService;
    @Autowired
    private SearchEngineService searchEngineService;
    @Autowired
    private ApiHeaderService apiHeaderService;
    @Autowired
    private NotificationTemplateService notificationTemplateService;
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private TagService tagService;
    @Autowired
    private EntrypointService entrypointService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private HttpClientService httpClientService;
    @Autowired
    private VirtualHostService virtualHostService;
    @Autowired
    private AlertService alertService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ImportConfiguration importConfiguration;
    @Autowired
    private PolicyService policyService;
    @Autowired
    private MediaService mediaService;
    @Autowired
    private EmailService emailService;
    @Autowired
    private APIV1toAPIV2Converter apiv1toAPIV2Converter;
    @Autowired
    private DataEncryptor dataEncryptor;
    @Value(value="${configuration.default-api-icon:}")
    private String defaultApiIcon;
    private static final Pattern LOGGING_MAX_DURATION_PATTERN = Pattern.compile("(?<before>.*)\\#request.timestamp\\s*\\<\\=?\\s*(?<timestamp>\\d*)l(?<after>.*)");
    private static final String LOGGING_MAX_DURATION_CONDITION = "#request.timestamp <= %dl";
    private static final String LOGGING_DELIMITER_BASE = "\\s+(\\|\\||\\&\\&)\\s+";
    private static final String ENDPOINTS_DELIMITER = "\n";

    @Override
    public ApiEntity createFromCockpit(String apiId, String userId, String swaggerDefinition) {
        ImportSwaggerDescriptorEntity swaggerDescriptor = new ImportSwaggerDescriptorEntity();
        swaggerDescriptor.setPayload(swaggerDefinition);
        swaggerDescriptor.setWithDocumentation(true);
        swaggerDescriptor.setWithPolicyPaths(true);
        swaggerDescriptor.setWithPolicies(List.of("mock"));
        SwaggerApiEntity api = this.swaggerService.createAPI(swaggerDescriptor, DefinitionVersion.V2);
        api.setPaths(null);
        ObjectNode apiDefinition = (ObjectNode)this.objectMapper.valueToTree((Object)api);
        apiDefinition.put("id", apiId);
        ApiEntity createdApi = this.createWithApiDefinition((UpdateApiEntity)api, userId, (JsonNode)apiDefinition);
        this.createSystemFolder(createdApi.getId());
        this.createOrUpdateDocumentation(swaggerDescriptor, createdApi, true);
        this.createMetadata(api.getMetadata(), createdApi.getId());
        return createdApi;
    }

    @Override
    public ApiEntity createFromSwagger(SwaggerApiEntity swaggerApiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) throws ApiAlreadyExistsException {
        ApiEntity createdApi = this.createFromUpdateApiEntity((UpdateApiEntity)swaggerApiEntity, userId, swaggerDescriptor);
        this.createMetadata(swaggerApiEntity.getMetadata(), createdApi.getId());
        return createdApi;
    }

    private void checkGroupExistence(Set<String> groups) {
        if (groups != null && !groups.isEmpty()) {
            try {
                this.groupService.findByIds(new HashSet<String>(groups));
            }
            catch (GroupsNotFoundException gnfe) {
                throw new InvalidDataException("These groups [" + gnfe.getParameters().get("groups") + "] do not exist");
            }
        }
    }

    private Set<String> removePOGroups(Set<String> groups, String apiId) {
        MembershipEntity primaryOwner;
        Stream<Object> groupEntityStream = this.groupService.findByIds(groups).stream();
        groupEntityStream = apiId != null ? ((primaryOwner = this.membershipService.getPrimaryOwner(MembershipReferenceType.API, apiId)).getMemberType() == MembershipMemberType.GROUP ? groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()) || group.getId().equals(primaryOwner.getMemberId())) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()))) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()));
        return groupEntityStream.map(GroupEntity::getId).collect(Collectors.toSet());
    }

    private void createMetadata(List<ApiMetadataEntity> apiMetadata, String apiId) {
        if (apiMetadata != null && !apiMetadata.isEmpty()) {
            apiMetadata.stream().map(data -> {
                NewApiMetadataEntity newMD = new NewApiMetadataEntity();
                newMD.setFormat(data.getFormat());
                newMD.setName(data.getName());
                newMD.setValue(data.getValue());
                newMD.setApiId(apiId);
                return newMD;
            }).forEach(this.apiMetadataService::create);
        }
    }

    @Override
    public ApiEntity create(NewApiEntity newApiEntity, String userId) throws ApiAlreadyExistsException {
        List declaredPaths;
        UpdateApiEntity apiEntity = new UpdateApiEntity();
        apiEntity.setName(newApiEntity.getName());
        apiEntity.setDescription(newApiEntity.getDescription());
        apiEntity.setVersion(newApiEntity.getVersion());
        Set<String> groups = newApiEntity.getGroups();
        if (groups != null && !groups.isEmpty()) {
            this.checkGroupExistence(groups);
            groups = this.removePOGroups(groups, null);
            newApiEntity.setGroups(groups);
        }
        apiEntity.setGroups((Set)groups);
        Proxy proxy = new Proxy();
        proxy.setVirtualHosts(Collections.singletonList(new VirtualHost(newApiEntity.getContextPath())));
        EndpointGroup group = new EndpointGroup();
        group.setName("default-group");
        String[] endpoints = null;
        if (newApiEntity.getEndpoint() != null) {
            endpoints = newApiEntity.getEndpoint().split(ENDPOINTS_DELIMITER);
        }
        if (endpoints == null) {
            group.setEndpoints(Collections.singleton(new HttpEndpoint("default", null)));
        } else if (endpoints.length == 1) {
            group.setEndpoints(Collections.singleton(new HttpEndpoint("default", endpoints[0])));
        } else {
            group.setEndpoints(new HashSet());
            for (int i = 0; i < endpoints.length; ++i) {
                group.getEndpoints().add(new HttpEndpoint("server" + (i + 1), endpoints[i]));
            }
        }
        proxy.setGroups(Collections.singleton(group));
        apiEntity.setProxy(proxy);
        List list = declaredPaths = newApiEntity.getPaths() != null ? newApiEntity.getPaths() : new ArrayList();
        if (!declaredPaths.contains(URI_PATH_SEPARATOR)) {
            declaredPaths.add(0, URI_PATH_SEPARATOR);
        }
        apiEntity.setPathMappings(new HashSet(declaredPaths));
        return this.createFromUpdateApiEntity(apiEntity, userId, null);
    }

    @Override
    public ApiEntity createWithApiDefinition(UpdateApiEntity api, String userId, JsonNode apiDefinition) throws ApiAlreadyExistsException {
        try {
            LOGGER.debug("Create {} for user {}", (Object)api, (Object)userId);
            String apiId = apiDefinition != null && apiDefinition.has("id") ? apiDefinition.get("id").asText() : null;
            String id = apiId != null && UUID.fromString(apiId) != null ? apiId : UuidString.generateRandom();
            Optional checkApi = this.apiRepository.findById((Object)id);
            if (checkApi.isPresent()) {
                throw new ApiAlreadyExistsException(id);
            }
            this.checkShardingTags(api, null);
            Collection<VirtualHost> sanitizedVirtualHosts = this.virtualHostService.sanitizeAndValidate(api.getProxy().getVirtualHosts());
            api.getProxy().setVirtualHosts(new ArrayList<VirtualHost>(sanitizedVirtualHosts));
            this.checkEndpointsName(api);
            this.checkHealthcheckInheritance(api);
            this.addLoggingMaxDuration(api.getProxy().getLogging());
            this.validateRegexfields(api);
            this.checkPolicyConfigurations(api);
            PrimaryOwnerEntity primaryOwner = this.findPrimaryOwner(apiDefinition, userId);
            if (apiDefinition != null) {
                apiDefinition = ((ObjectNode)apiDefinition).put("id", id);
            }
            io.gravitee.repository.management.model.Api repoApi = this.convert(id, api, apiDefinition != null ? apiDefinition.toString() : null);
            repoApi.setId(id);
            repoApi.setEnvironmentId(GraviteeContext.getCurrentEnvironment());
            repoApi.setCreatedAt(new Date());
            repoApi.setUpdatedAt(repoApi.getCreatedAt());
            repoApi.setLifecycleState(LifecycleState.STOPPED);
            repoApi.setVisibility(api.getVisibility() == null ? io.gravitee.repository.management.model.Visibility.PRIVATE : io.gravitee.repository.management.model.Visibility.valueOf((String)api.getVisibility().toString()));
            Set defaultGroups = this.groupService.findByEvent(GroupEvent.API_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
            if (repoApi.getGroups() == null) {
                repoApi.setGroups(defaultGroups.isEmpty() ? null : defaultGroups);
            } else {
                repoApi.getGroups().addAll(defaultGroups);
            }
            if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwner.getType())) {
                if (repoApi.getGroups() == null) {
                    repoApi.setGroups(new HashSet());
                }
                repoApi.getGroups().add(primaryOwner.getId());
            }
            repoApi.setApiLifecycleState(ApiLifecycleState.CREATED);
            if (this.parameterService.findAsBoolean(Key.API_REVIEW_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                this.workflowService.create(WorkflowReferenceType.API, id, WorkflowType.REVIEW, userId, WorkflowState.DRAFT, "");
            }
            io.gravitee.repository.management.model.Api createdApi = (io.gravitee.repository.management.model.Api)this.apiRepository.create((Object)repoApi);
            this.auditService.createApiAuditLog(createdApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_CREATED, createdApi.getCreatedAt(), null, createdApi);
            this.membershipService.addRoleToMemberOnReference(new MembershipService.MembershipReference(MembershipReferenceType.API, createdApi.getId()), new MembershipService.MembershipMember(primaryOwner.getId(), null, MembershipMemberType.valueOf((String)primaryOwner.getType())), new MembershipService.MembershipRole(RoleScope.API, SystemRole.PRIMARY_OWNER.name()));
            String emailMetadataValue = "${(api.primaryOwner.email)!''}";
            GenericNotificationConfigEntity notificationConfigEntity = new GenericNotificationConfigEntity();
            notificationConfigEntity.setName("Default Mail Notifications");
            notificationConfigEntity.setReferenceType(HookScope.API.name());
            notificationConfigEntity.setReferenceId(createdApi.getId());
            notificationConfigEntity.setHooks(Arrays.stream(ApiHook.values()).map(Enum::name).collect(Collectors.toList()));
            notificationConfigEntity.setNotifier("default-email");
            notificationConfigEntity.setConfig("${(api.primaryOwner.email)!''}");
            this.genericNotificationConfigService.create(notificationConfigEntity);
            NewApiMetadataEntity newApiMetadataEntity = new NewApiMetadataEntity();
            newApiMetadataEntity.setFormat(MetadataFormat.MAIL);
            newApiMetadataEntity.setName("email-support");
            newApiMetadataEntity.setDefaultValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setValue("${(api.primaryOwner.email)!''}");
            newApiMetadataEntity.setApiId(createdApi.getId());
            this.apiMetadataService.create(newApiMetadataEntity);
            ApiEntity apiEntity = this.convert(createdApi, primaryOwner, null);
            ApiEntity apiWithMetadata = this.fetchMetadataForApi(apiEntity);
            this.searchEngineService.index((Indexable)apiWithMetadata, false);
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to create {} for user {}", new Object[]{api, userId, ex});
            throw new TechnicalManagementException("An error occurs while trying create " + api + " for user " + userId, ex);
        }
    }

    private ApiEntity createFromUpdateApiEntity(UpdateApiEntity apiEntity, String userId, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ApiEntity createdApi = this.createWithApiDefinition(apiEntity, userId, null);
        this.createSystemFolder(createdApi.getId());
        this.createOrUpdateDocumentation(swaggerDescriptor, createdApi, true);
        return createdApi;
    }

    private void createOrUpdateDocumentation(ImportSwaggerDescriptorEntity swaggerDescriptor, ApiEntity api, boolean isForCreation) {
        if (swaggerDescriptor != null && swaggerDescriptor.isWithDocumentation()) {
            List<PageEntity> apiDocs = this.pageService.search(new PageQuery.Builder().api(api.getId()).type(PageType.SWAGGER).build(), GraviteeContext.getCurrentEnvironment());
            if (isForCreation || apiDocs == null || apiDocs.isEmpty()) {
                NewPageEntity page = new NewPageEntity();
                page.setName("Swagger");
                page.setType(PageType.SWAGGER);
                page.setOrder(1);
                if (ImportSwaggerDescriptorEntity.Type.INLINE.equals((Object)swaggerDescriptor.getType())) {
                    page.setContent(swaggerDescriptor.getPayload());
                } else {
                    PageSourceEntity source = new PageSourceEntity();
                    page.setSource(source);
                    source.setType("http-fetcher");
                    source.setConfiguration((JsonNode)this.objectMapper.convertValue(Collections.singletonMap("url", swaggerDescriptor.getPayload()), JsonNode.class));
                }
                this.pageService.createPage(api.getId(), page, GraviteeContext.getCurrentEnvironment());
            } else if (apiDocs.size() == 1) {
                PageEntity pageToUpdate = apiDocs.get(0);
                UpdatePageEntity page = new UpdatePageEntity();
                page.setName(pageToUpdate.getName());
                page.setOrder(Integer.valueOf(pageToUpdate.getOrder()));
                page.setHomepage(Boolean.valueOf(pageToUpdate.isHomepage()));
                page.setPublished(Boolean.valueOf(pageToUpdate.isPublished()));
                page.setParentId(pageToUpdate.getParentId());
                page.setConfiguration(pageToUpdate.getConfiguration());
                if (ImportSwaggerDescriptorEntity.Type.INLINE.equals((Object)swaggerDescriptor.getType())) {
                    page.setContent(swaggerDescriptor.getPayload());
                } else {
                    PageSourceEntity source = new PageSourceEntity();
                    page.setSource(source);
                    source.setType("http-fetcher");
                    source.setConfiguration((JsonNode)this.objectMapper.convertValue(Collections.singletonMap("url", swaggerDescriptor.getPayload()), JsonNode.class));
                }
                this.pageService.update(pageToUpdate.getId(), page);
            }
        }
    }

    public PrimaryOwnerEntity findPrimaryOwner(JsonNode apiDefinition, String userId) {
        ApiPrimaryOwnerMode poMode = ApiPrimaryOwnerMode.valueOf((String)this.parameterService.find(Key.API_PRIMARY_OWNER_MODE, ParameterReferenceType.ENVIRONMENT));
        PrimaryOwnerEntity primaryOwnerFromDefinition = this.findPrimaryOwnerFromApiDefinition(apiDefinition);
        switch (poMode) {
            case USER: {
                if (primaryOwnerFromDefinition == null || ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerFromDefinition.getType())) {
                    return new PrimaryOwnerEntity(this.userService.findById(userId));
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(primaryOwnerFromDefinition.getType())) break;
                try {
                    return new PrimaryOwnerEntity(this.userService.findById(primaryOwnerFromDefinition.getId()));
                }
                catch (UserNotFoundException unfe) {
                    return new PrimaryOwnerEntity(this.userService.findById(userId));
                }
            }
            case GROUP: {
                if (primaryOwnerFromDefinition == null) {
                    return this.getFirstPoGroupUserBelongsTo(userId);
                }
                if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerFromDefinition.getType())) {
                    try {
                        return new PrimaryOwnerEntity(this.groupService.findById(primaryOwnerFromDefinition.getId()));
                    }
                    catch (GroupNotFoundException unfe) {
                        return this.getFirstPoGroupUserBelongsTo(userId);
                    }
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(primaryOwnerFromDefinition.getType())) break;
                try {
                    String poUserId = primaryOwnerFromDefinition.getId();
                    this.userService.findById(poUserId);
                    Set poGroupsOfPoUser = this.groupService.findByUser(poUserId).stream().filter(group -> group.getApiPrimaryOwner() != null && !group.getApiPrimaryOwner().isEmpty()).collect(Collectors.toSet());
                    if (poGroupsOfPoUser.isEmpty()) {
                        return this.getFirstPoGroupUserBelongsTo(userId);
                    }
                    return new PrimaryOwnerEntity((GroupEntity)poGroupsOfPoUser.iterator().next());
                }
                catch (UserNotFoundException unfe) {
                    return this.getFirstPoGroupUserBelongsTo(userId);
                }
            }
            default: {
                if (primaryOwnerFromDefinition == null) {
                    return new PrimaryOwnerEntity(this.userService.findById(userId));
                }
                if (ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerFromDefinition.getType())) {
                    try {
                        return new PrimaryOwnerEntity(this.groupService.findById(primaryOwnerFromDefinition.getId()));
                    }
                    catch (GroupNotFoundException unfe) {
                        try {
                            return this.getFirstPoGroupUserBelongsTo(userId);
                        }
                        catch (NoPrimaryOwnerGroupForUserException ex) {
                            return new PrimaryOwnerEntity(this.userService.findById(userId));
                        }
                    }
                }
                if (!ApiPrimaryOwnerMode.USER.name().equals(primaryOwnerFromDefinition.getType())) break;
                try {
                    return new PrimaryOwnerEntity(this.userService.findById(primaryOwnerFromDefinition.getId()));
                }
                catch (UserNotFoundException unfe) {
                    return new PrimaryOwnerEntity(this.userService.findById(userId));
                }
            }
        }
        return new PrimaryOwnerEntity(this.userService.findById(userId));
    }

    @NotNull
    private PrimaryOwnerEntity getFirstPoGroupUserBelongsTo(String userId) {
        Set poGroupsOfCurrentUser = this.groupService.findByUser(userId).stream().filter(group -> !StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner())).collect(Collectors.toSet());
        if (poGroupsOfCurrentUser.isEmpty()) {
            throw new NoPrimaryOwnerGroupForUserException(userId);
        }
        return new PrimaryOwnerEntity((GroupEntity)poGroupsOfCurrentUser.iterator().next());
    }

    private PrimaryOwnerEntity findPrimaryOwnerFromApiDefinition(JsonNode apiDefinition) {
        PrimaryOwnerEntity primaryOwnerEntity = null;
        if (apiDefinition != null && apiDefinition.has("primaryOwner")) {
            try {
                primaryOwnerEntity = (PrimaryOwnerEntity)this.objectMapper.readValue(apiDefinition.get("primaryOwner").toString(), PrimaryOwnerEntity.class);
            }
            catch (JsonProcessingException e) {
                LOGGER.warn("Cannot parse primary owner from definition, continue with current user", (Throwable)e);
            }
        }
        return primaryOwnerEntity;
    }

    private void createSystemFolder(String apiId) {
        NewPageEntity asideSystemFolder = new NewPageEntity();
        asideSystemFolder.setName(SystemFolderType.ASIDE.folderName());
        asideSystemFolder.setPublished(true);
        asideSystemFolder.setType(PageType.SYSTEM_FOLDER);
        asideSystemFolder.setVisibility(Visibility.PUBLIC);
        this.pageService.createPage(apiId, asideSystemFolder, GraviteeContext.getCurrentEnvironment());
    }

    private void checkEndpointsName(UpdateApiEntity api) {
        if (api.getProxy() != null && api.getProxy().getGroups() != null) {
            for (EndpointGroup group : api.getProxy().getGroups()) {
                this.assertEndpointNameNotContainsInvalidCharacters(group.getName());
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    this.assertEndpointNameNotContainsInvalidCharacters(endpoint.getName());
                }
            }
        }
    }

    private void checkEndpointsExists(UpdateApiEntity api) {
        EndpointDiscoveryService endpointDiscoveryService;
        if (api.getProxy().getGroups() == null || api.getProxy().getGroups().isEmpty()) {
            throw new EndpointMissingException();
        }
        EndpointGroup endpointGroup = (EndpointGroup)api.getProxy().getGroups().iterator().next();
        EndpointDiscoveryService endpointDiscoveryService2 = endpointDiscoveryService = endpointGroup.getServices() == null ? null : (EndpointDiscoveryService)endpointGroup.getServices().get(EndpointDiscoveryService.class);
        if (!(endpointDiscoveryService != null && endpointDiscoveryService.isEnabled() || endpointGroup.getEndpoints() != null && !endpointGroup.getEndpoints().isEmpty())) {
            throw new EndpointMissingException();
        }
    }

    private void validateHealtcheckSchedule(UpdateApiEntity api) {
        String schedule;
        HealthCheckService healthCheckService;
        if (api.getServices() != null && (healthCheckService = (HealthCheckService)api.getServices().get(HealthCheckService.class)) != null && (schedule = healthCheckService.getSchedule()) != null) {
            try {
                new CronTrigger(schedule);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidDataException(e);
            }
        }
    }

    private void checkHealthcheckInheritance(UpdateApiEntity api) {
        boolean inherit = false;
        if (api.getProxy() != null && api.getProxy().getGroups() != null) {
            block0: for (EndpointGroup group : api.getProxy().getGroups()) {
                if (group.getEndpoints() == null) continue;
                for (Endpoint endpoint : group.getEndpoints()) {
                    HttpEndpoint httpEndpoint;
                    if (!(endpoint instanceof HttpEndpoint) || (httpEndpoint = (HttpEndpoint)endpoint).getHealthCheck() == null || !httpEndpoint.getHealthCheck().isInherit()) continue;
                    inherit = true;
                    continue block0;
                }
            }
        }
        if (inherit) {
            boolean hcServiceExists = false;
            if (api.getServices() != null) {
                HealthCheckService healthCheckService = (HealthCheckService)api.getServices().get(HealthCheckService.class);
                boolean bl = hcServiceExists = healthCheckService != null;
            }
            if (!hcServiceExists) {
                throw new HealthcheckInheritanceException();
            }
        }
    }

    private void assertEndpointNameNotContainsInvalidCharacters(String name) {
        if (name != null && name.contains(":")) {
            throw new EndpointNameInvalidException(name);
        }
    }

    private void addLoggingMaxDuration(Logging logging) {
        Optional optionalMaxDuration;
        if (logging != null && !LoggingMode.NONE.equals((Object)logging.getMode()) && (optionalMaxDuration = this.parameterService.findAll(Key.LOGGING_DEFAULT_MAX_DURATION, Long::valueOf, ParameterReferenceType.ORGANIZATION).stream().findFirst()).isPresent() && (Long)optionalMaxDuration.get() > 0L) {
            long maxEndDate = System.currentTimeMillis() + (Long)optionalMaxDuration.get();
            if (logging.getCondition() == null || logging.getCondition().isEmpty()) {
                logging.setCondition(String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate));
            } else {
                Matcher matcher = LOGGING_MAX_DURATION_PATTERN.matcher(logging.getCondition());
                if (matcher.matches()) {
                    String currentDurationAsStr = matcher.group("timestamp");
                    String before = this.formatExpression(matcher, "before");
                    String after = this.formatExpression(matcher, "after");
                    try {
                        long currentDuration = Long.parseLong(currentDurationAsStr);
                        if (currentDuration > maxEndDate || !before.isEmpty() || !after.isEmpty()) {
                            logging.setCondition(before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        LOGGER.error("Wrong format of the logging condition. Add the default one", (Throwable)nfe);
                        logging.setCondition(before + String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + after);
                    }
                } else {
                    logging.setCondition(String.format(LOGGING_MAX_DURATION_CONDITION, maxEndDate) + " && " + logging.getCondition());
                }
            }
        }
    }

    private String formatExpression(Matcher matcher, String group) {
        Object expression;
        String matchedExpression = matcher.group(group);
        boolean expressionBlank = matchedExpression == null || "".equals(matchedExpression);
        boolean after = "after".equals(group);
        if (after) {
            if (matchedExpression.startsWith(" && (") && matchedExpression.endsWith(")")) {
                matchedExpression = matchedExpression.substring(5, matchedExpression.length() - 1);
            }
            expression = expressionBlank ? "" : " && (" + matchedExpression + ")";
            expression = ((String)expression).replaceAll("\\(\\s+(\\|\\||\\&\\&)\\s+", "\\(");
        } else {
            if (matchedExpression.startsWith("(") && matchedExpression.endsWith(") && ")) {
                matchedExpression = matchedExpression.substring(1, matchedExpression.length() - 5);
            }
            expression = expressionBlank ? "" : "(" + matchedExpression + ") && ";
            expression = ((String)expression).replaceAll("\\s+(\\|\\||\\&\\&)\\s+\\)", "\\)");
        }
        return expression;
    }

    @Override
    public ApiEntity findById(String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(apiId);
        ApiEntity apiEntity = this.convert(api, this.getPrimaryOwner(api), null);
        this.calculateEntrypoints(apiEntity, api.getEnvironmentId());
        return apiEntity;
    }

    @Override
    public PrimaryOwnerEntity getPrimaryOwner(String apiId) throws TechnicalManagementException {
        MembershipEntity primaryOwnerMemberEntity = this.membershipService.getPrimaryOwner(MembershipReferenceType.API, apiId);
        if (primaryOwnerMemberEntity == null) {
            LOGGER.error("The API {} doesn't have any primary owner.", (Object)apiId);
            throw new TechnicalManagementException("The API " + apiId + " doesn't have any primary owner.");
        }
        if (MembershipMemberType.GROUP == primaryOwnerMemberEntity.getMemberType()) {
            return new PrimaryOwnerEntity(this.groupService.findById(primaryOwnerMemberEntity.getMemberId()));
        }
        return new PrimaryOwnerEntity(this.userService.findById(primaryOwnerMemberEntity.getMemberId()));
    }

    private PrimaryOwnerEntity getPrimaryOwner(io.gravitee.repository.management.model.Api api) throws TechnicalManagementException {
        return this.getPrimaryOwner(api.getId());
    }

    private void calculateEntrypoints(ApiEntity api, String environmentId) {
        ArrayList apiEntrypoints = new ArrayList();
        if (api.getProxy() != null) {
            String defaultEntrypoint = this.parameterService.find(Key.PORTAL_ENTRYPOINT, environmentId, ParameterReferenceType.ENVIRONMENT);
            String scheme = this.getScheme(defaultEntrypoint);
            if (api.getTags() != null && !api.getTags().isEmpty()) {
                List<EntrypointEntity> entrypoints = this.entrypointService.findByReference(GraviteeContext.getCurrentOrganization(), EntrypointReferenceType.ORGANIZATION);
                entrypoints.forEach(entrypoint -> {
                    HashSet<String> tagEntrypoints = new HashSet<String>(Arrays.asList(entrypoint.getTags()));
                    tagEntrypoints.retainAll(api.getTags());
                    if (tagEntrypoints.size() == entrypoint.getTags().length) {
                        api.getProxy().getVirtualHosts().forEach(virtualHost -> {
                            Object targetHost;
                            Object object = targetHost = virtualHost.getHost() == null || !virtualHost.isOverrideEntrypoint() ? entrypoint.getValue() : virtualHost.getHost();
                            if (!((String)targetHost).toLowerCase().startsWith("http")) {
                                targetHost = scheme + "://" + (String)targetHost;
                            }
                            apiEntrypoints.add(new ApiEntrypointEntity(tagEntrypoints, DUPLICATE_SLASH_REMOVER.matcher((String)targetHost + URI_PATH_SEPARATOR + virtualHost.getPath()).replaceAll(URI_PATH_SEPARATOR), virtualHost.getHost()));
                        });
                    }
                });
            }
            if (apiEntrypoints.isEmpty()) {
                api.getProxy().getVirtualHosts().forEach(virtualHost -> {
                    Object targetHost;
                    Object object = targetHost = virtualHost.getHost() == null || !virtualHost.isOverrideEntrypoint() ? defaultEntrypoint : virtualHost.getHost();
                    if (!((String)targetHost).toLowerCase().startsWith("http")) {
                        targetHost = scheme + "://" + (String)targetHost;
                    }
                    apiEntrypoints.add(new ApiEntrypointEntity(DUPLICATE_SLASH_REMOVER.matcher((String)targetHost + URI_PATH_SEPARATOR + virtualHost.getPath()).replaceAll(URI_PATH_SEPARATOR), virtualHost.getHost()));
                });
            }
        }
        api.setEntrypoints(apiEntrypoints);
    }

    private String getScheme(String defaultEntrypoint) {
        String scheme = "https";
        if (defaultEntrypoint != null) {
            try {
                scheme = new URL(defaultEntrypoint).getProtocol();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return scheme;
    }

    @Override
    public Set<ApiEntity> findByVisibility(Visibility visibility) {
        try {
            LOGGER.debug("Find APIs by visibility {}", (Object)visibility);
            return new HashSet<ApiEntity>(this.convert(this.apiRepository.search(new ApiCriteria.Builder().environmentId(GraviteeContext.getCurrentEnvironment()).visibility(io.gravitee.repository.management.model.Visibility.valueOf((String)visibility.name())).build())));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all APIs", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs", ex);
        }
    }

    @Override
    public Set<ApiEntity> findAll() {
        try {
            LOGGER.debug("Find all APIs for current environment {}", (Object)GraviteeContext.getCurrentEnvironment());
            return new HashSet<ApiEntity>(this.convert(this.apiRepository.search(new ApiCriteria.Builder().environmentId(GraviteeContext.getCurrentEnvironment()).build())));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all APIs for current environment {}", (Object)GraviteeContext.getCurrentEnvironment(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs for current environment", ex);
        }
    }

    @Override
    public Set<ApiEntity> findAllLight() {
        try {
            LOGGER.debug("Find all APIs without some fields (definition, picture...)");
            return new HashSet<ApiEntity>(this.convert(this.apiRepository.search(new ApiCriteria.Builder().environmentId(GraviteeContext.getCurrentEnvironment()).build(), new ApiFieldExclusionFilter.Builder().excludeDefinition().excludePicture().build())));
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find all APIs light", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all APIs light", ex);
        }
    }

    @Override
    public Set<ApiEntity> findByUser(String userId, ApiQuery apiQuery, boolean portal) {
        return new HashSet<ApiEntity>(this.findByUser(userId, apiQuery, null, null, portal).getContent());
    }

    @Override
    public Page<ApiEntity> findByUser(String userId, ApiQuery apiQuery, Sortable sortable, Pageable pageable, boolean portal) {
        try {
            LOGGER.debug("Find APIs page by user {}", (Object)userId);
            List<io.gravitee.repository.management.model.Api> allApis = this.findApisByUser(userId, apiQuery, portal);
            Page<io.gravitee.repository.management.model.Api> apiPage = this.sortAndPaginate(allApis, sortable, pageable);
            List<ApiEntity> apis = this.convert(apiPage.getContent());
            return new Page(this.filterApiByQuery(apis.stream(), apiQuery).collect(Collectors.toList()), apiPage.getPageNumber(), (int)apiPage.getPageElements(), apiPage.getTotalElements());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find APIs for user {}", (Object)userId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find APIs for user " + userId, ex);
        }
    }

    @Override
    public List<String> findIdsByUser(String userId, ApiQuery apiQuery, boolean portal) {
        try {
            LOGGER.debug("Search API ids by user {} and {}", (Object)userId, (Object)apiQuery);
            return this.findApisByUser(userId, apiQuery, portal).stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList());
        }
        catch (Exception ex) {
            String errorMessage = "An error occurs while trying to search for API ids for user " + userId + ": " + apiQuery;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    private io.gravitee.repository.management.model.Api findApiById(String apiId) {
        try {
            LOGGER.debug("Find API by ID: {}", (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (GraviteeContext.getCurrentEnvironment() != null) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(GraviteeContext.getCurrentEnvironment()));
            }
            if (optApi.isPresent()) {
                return optApi.get();
            }
            throw new ApiNotFoundException(apiId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    private List<io.gravitee.repository.management.model.Api> findApisByUser(String userId, ApiQuery apiQuery, boolean portal) {
        List publicApis = portal ? this.apiRepository.search(this.queryToCriteria(apiQuery).visibility(io.gravitee.repository.management.model.Visibility.PUBLIC).build()) : Collections.emptyList();
        List userApis = Collections.emptyList();
        List groupApis = Collections.emptyList();
        List subscribedApis = Collections.emptyList();
        if (userId != null) {
            Set applications;
            String[] groupIds;
            String[] userApiIds = (String[])this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.API).stream().map(MembershipEntity::getReferenceId).filter(apiId -> {
                if (apiQuery != null && !CollectionUtils.isEmpty((Collection)apiQuery.getIds())) {
                    return apiQuery.getIds().contains(apiId);
                }
                return true;
            }).toArray(String[]::new);
            if (userApiIds.length > 0) {
                userApis = this.apiRepository.search(this.queryToCriteria(apiQuery).ids(userApiIds).build());
            }
            if ((groupIds = (String[])this.membershipService.getMembershipsByMemberAndReference(MembershipMemberType.USER, userId, MembershipReferenceType.GROUP).stream().filter(m -> {
                RoleEntity roleInGroup = this.roleService.findById(m.getRoleId());
                if (!portal) {
                    return m.getRoleId() != null && roleInGroup.getScope().equals((Object)RoleScope.API) && this.canManageApi(roleInGroup.getPermissions());
                }
                return m.getRoleId() != null && roleInGroup.getScope().equals((Object)RoleScope.API);
            }).map(MembershipEntity::getReferenceId).toArray(String[]::new)).length > 0 && groupIds[0] != null) {
                groupApis = this.apiRepository.search(this.queryToCriteria(apiQuery).groups(groupIds).build());
            }
            if (portal && !(applications = this.applicationService.findByUser(userId).stream().map(ApplicationListItem::getId).collect(Collectors.toSet())).isEmpty()) {
                SubscriptionQuery query = new SubscriptionQuery();
                query.setApplications(applications);
                Collection<SubscriptionEntity> subscriptions = this.subscriptionService.search(query);
                if (subscriptions != null && !subscriptions.isEmpty()) {
                    subscribedApis = this.apiRepository.search(this.queryToCriteria(apiQuery).ids((String[])subscriptions.stream().map(SubscriptionEntity::getApi).distinct().toArray(String[]::new)).build());
                }
            }
        }
        ArrayList allApis = new ArrayList();
        allApis.addAll(publicApis);
        allApis.addAll(userApis);
        allApis.addAll(groupApis);
        allApis.addAll(subscribedApis);
        return allApis.stream().distinct().collect(Collectors.toList());
    }

    private boolean canManageApi(Map<String, char[]> permissions) {
        return permissions.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(ApiPermission.RATING.name()) && !((String)entry.getKey()).equals(ApiPermission.RATING_ANSWER.name())).anyMatch(entry -> {
            String stringPerm = new String((char[])entry.getValue());
            return stringPerm.contains("C") || stringPerm.contains("U") || stringPerm.contains("D");
        });
    }

    @Override
    public Set<ApiEntity> findPublishedByUser(String userId, ApiQuery apiQuery) {
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        apiQuery.setLifecycleStates(Arrays.asList(io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED));
        return this.findByUser(userId, apiQuery, true);
    }

    @Override
    public Page<ApiEntity> findPublishedByUser(String userId, ApiQuery apiQuery, Sortable sortable, Pageable pageable) {
        if (apiQuery == null) {
            apiQuery = new ApiQuery();
        }
        apiQuery.setLifecycleStates(Arrays.asList(io.gravitee.rest.api.model.api.ApiLifecycleState.PUBLISHED));
        return this.findByUser(userId, apiQuery, sortable, pageable, true);
    }

    @Override
    public Set<ApiEntity> findPublishedByUser(String userId) {
        return this.findPublishedByUser(userId, null);
    }

    private Stream<ApiEntity> filterApiByQuery(Stream<ApiEntity> apiEntityStream, ApiQuery query) {
        if (query == null) {
            return apiEntityStream;
        }
        return apiEntityStream.filter(api -> query.getTag() == null || api.getTags() != null && api.getTags().contains(query.getTag())).filter(api -> query.getContextPath() == null || api.getProxy().getVirtualHosts().stream().anyMatch(virtualHost -> query.getContextPath().equals(virtualHost.getPath())));
    }

    private Set merge(List originSet, Collection setToAdd) {
        if (originSet == null) {
            return this.merge(Collections.emptySet(), setToAdd);
        }
        return this.merge(new HashSet(originSet), setToAdd);
    }

    private Set merge(Set originSet, Collection setToAdd) {
        if (setToAdd != null && !setToAdd.isEmpty()) {
            if (originSet == null) {
                originSet = new HashSet();
            }
            originSet.addAll(setToAdd);
        }
        return originSet;
    }

    @Override
    public ApiEntity updateFromSwagger(String apiId, SwaggerApiEntity swaggerApiEntity, ImportSwaggerDescriptorEntity swaggerDescriptor) {
        ApiEntity apiEntityToUpdate = this.findById(apiId);
        UpdateApiEntity updateApiEntity = ApiService.convert(apiEntityToUpdate);
        updateApiEntity.setVersion(swaggerApiEntity.getVersion());
        updateApiEntity.setName(swaggerApiEntity.getName());
        updateApiEntity.setDescription(swaggerApiEntity.getDescription());
        updateApiEntity.setCategories(this.merge(updateApiEntity.getCategories(), (Collection)swaggerApiEntity.getCategories()));
        if (swaggerApiEntity.getProxy() != null) {
            Proxy proxy = updateApiEntity.getProxy();
            if (proxy == null) {
                proxy = new Proxy();
            }
            proxy.setGroups(this.merge(proxy.getGroups(), (Collection)swaggerApiEntity.getProxy().getGroups()));
            List virtualHostsToAdd = swaggerApiEntity.getProxy().getVirtualHosts();
            if (virtualHostsToAdd != null && !virtualHostsToAdd.isEmpty()) {
                virtualHostsToAdd = virtualHostsToAdd.stream().map(this.virtualHostService::sanitize).collect(Collectors.toList());
                proxy.setVirtualHosts(new ArrayList(this.merge(proxy.getVirtualHosts().stream().map(this.virtualHostService::sanitize).collect(Collectors.toSet()), virtualHostsToAdd)));
            }
            updateApiEntity.setProxy(proxy);
        }
        updateApiEntity.setGroups(this.merge(updateApiEntity.getGroups(), (Collection)swaggerApiEntity.getGroups()));
        updateApiEntity.setLabels(new ArrayList(this.merge(updateApiEntity.getLabels(), (Collection)swaggerApiEntity.getLabels())));
        if (swaggerApiEntity.getPicture() != null) {
            updateApiEntity.setPicture(swaggerApiEntity.getPicture());
        }
        updateApiEntity.setTags(this.merge(updateApiEntity.getTags(), (Collection)swaggerApiEntity.getTags()));
        if (swaggerApiEntity.getVisibility() != null) {
            updateApiEntity.setVisibility(swaggerApiEntity.getVisibility());
        }
        if (swaggerApiEntity.getProperties() != null) {
            PropertiesEntity properties = updateApiEntity.getProperties();
            if (properties == null) {
                properties = new PropertiesEntity();
            }
            properties.setProperties(new ArrayList(this.merge(properties.getProperties(), (Collection)swaggerApiEntity.getProperties().getProperties())));
            updateApiEntity.setProperties(properties);
        }
        if (swaggerDescriptor != null) {
            if (swaggerDescriptor.isWithPathMapping()) {
                updateApiEntity.setPathMappings(swaggerApiEntity.getPathMappings());
            }
            if (swaggerDescriptor.isWithPolicyPaths()) {
                if (DefinitionVersion.V2.equals((Object)updateApiEntity.getGraviteeDefinitionVersion())) {
                    updateApiEntity.setFlows(swaggerApiEntity.getFlows());
                } else {
                    updateApiEntity.setPaths(swaggerApiEntity.getPaths());
                }
            }
        }
        this.createOrUpdateDocumentation(swaggerDescriptor, apiEntityToUpdate, false);
        ApiEntity updatedApi = this.update(apiId, updateApiEntity);
        if (swaggerApiEntity.getMetadata() != null && !swaggerApiEntity.getMetadata().isEmpty()) {
            swaggerApiEntity.getMetadata().forEach(data -> {
                try {
                    ApiMetadataEntity apiMetadataEntity = this.apiMetadataService.findByIdAndApi(data.getKey(), apiId);
                    UpdateApiMetadataEntity updateApiMetadataEntity = new UpdateApiMetadataEntity();
                    updateApiMetadataEntity.setApiId(apiId);
                    updateApiMetadataEntity.setFormat(data.getFormat());
                    updateApiMetadataEntity.setKey(apiMetadataEntity.getKey());
                    updateApiMetadataEntity.setName(data.getName());
                    updateApiMetadataEntity.setValue(data.getValue());
                    ApiMetadataEntity metadata = this.apiMetadataService.update(updateApiMetadataEntity);
                    updatedApi.getMetadata().put(metadata.getKey(), metadata.getValue());
                }
                catch (ApiMetadataNotFoundException amnfe) {
                    NewApiMetadataEntity newMD = new NewApiMetadataEntity();
                    newMD.setApiId(apiId);
                    newMD.setFormat(data.getFormat());
                    newMD.setName(data.getName());
                    newMD.setValue(data.getValue());
                    ApiMetadataEntity metadata = this.apiMetadataService.create(newMD);
                    updatedApi.getMetadata().put(metadata.getKey(), metadata.getValue());
                }
            });
        }
        this.searchEngineService.index((Indexable)updatedApi, false);
        return updatedApi;
    }

    @Override
    public ApiEntity update(String apiId, UpdateApiEntity updateApiEntity) {
        return this.update(apiId, updateApiEntity, false);
    }

    @Override
    public ApiEntity update(String apiId, UpdateApiEntity updateApiEntity, boolean checkPlans) {
        try {
            io.gravitee.repository.management.model.Api api;
            LOGGER.debug("Update API {}", (Object)apiId);
            Optional optApiToUpdate = this.apiRepository.findById((Object)apiId);
            if (!optApiToUpdate.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            Collection<VirtualHost> sanitizedVirtualHosts = this.virtualHostService.sanitizeAndValidate(updateApiEntity.getProxy().getVirtualHosts(), apiId);
            updateApiEntity.getProxy().setVirtualHosts(new ArrayList<VirtualHost>(sanitizedVirtualHosts));
            this.checkEndpointsExists(updateApiEntity);
            this.checkEndpointsName(updateApiEntity);
            this.checkHealthcheckInheritance(updateApiEntity);
            this.validateHealtcheckSchedule(updateApiEntity);
            this.checkAllowOriginFormat(updateApiEntity);
            this.addLoggingMaxDuration(updateApiEntity.getProxy().getLogging());
            this.validateRegexfields(updateApiEntity);
            this.checkPolicyConfigurations(updateApiEntity);
            ApiEntity apiToCheck = this.convert((io.gravitee.repository.management.model.Api)optApiToUpdate.get());
            this.checkShardingTags(updateApiEntity, apiToCheck);
            if (updateApiEntity.getLifecycleState() == null) {
                updateApiEntity.setLifecycleState(apiToCheck.getLifecycleState());
            }
            this.checkLifecycleState(updateApiEntity, apiToCheck);
            Set<String> groups = updateApiEntity.getGroups();
            if (groups != null && !groups.isEmpty()) {
                this.checkGroupExistence(groups);
                groups = this.removePOGroups(groups, apiId);
                updateApiEntity.setGroups(groups);
            }
            if (Objects.equals(updateApiEntity.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (updateApiEntity.getPaths() == null || updateApiEntity.getPaths().isEmpty())) {
                updateApiEntity.setPaths(Collections.singletonMap(URI_PATH_SEPARATOR, new ArrayList()));
            }
            if (updateApiEntity.getPlans() == null) {
                updateApiEntity.setPlans(new ArrayList());
            } else if (checkPlans) {
                List existingPlans = apiToCheck.getPlans();
                HashMap<String, String> planStatuses = new HashMap<String, String>();
                if (existingPlans != null && !existingPlans.isEmpty()) {
                    planStatuses.putAll(existingPlans.stream().collect(Collectors.toMap(Plan::getId, Plan::getStatus)));
                }
                updateApiEntity.getPlans().forEach(planToUpdate -> {
                    if (!planStatuses.containsKey(planToUpdate.getId()) || planStatuses.containsKey(planToUpdate.getId()) && ((String)planStatuses.get(planToUpdate.getId())).equalsIgnoreCase(PlanStatus.CLOSED.name()) && !((String)planStatuses.get(planToUpdate.getId())).equalsIgnoreCase(planToUpdate.getStatus())) {
                        throw new InvalidDataException("Invalid status for plan '" + planToUpdate.getName() + "'");
                    }
                });
            }
            this.encryptProperties(updateApiEntity.getPropertyList());
            io.gravitee.repository.management.model.Api apiToUpdate = (io.gravitee.repository.management.model.Api)optApiToUpdate.get();
            if (io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED.equals((Object)updateApiEntity.getLifecycleState())) {
                this.planService.findByApi(apiId).forEach(plan -> {
                    if (PlanStatus.PUBLISHED.equals((Object)plan.getStatus()) || PlanStatus.STAGING.equals((Object)plan.getStatus())) {
                        this.planService.deprecate(plan.getId(), true);
                        updateApiEntity.getPlans().stream().filter(p -> p.getId().equals(plan.getId())).forEach(p -> p.setStatus(PlanStatus.DEPRECATED.name()));
                    }
                });
            }
            if ((api = this.convert(apiId, updateApiEntity, apiToUpdate.getDefinition())) != null) {
                api.setId(apiId.trim());
                api.setUpdatedAt(new Date());
                api.setEnvironmentId(apiToUpdate.getEnvironmentId());
                api.setDeployedAt(apiToUpdate.getDeployedAt());
                api.setCreatedAt(apiToUpdate.getCreatedAt());
                api.setLifecycleState(apiToUpdate.getLifecycleState());
                if (updateApiEntity.getPicture() == null && updateApiEntity.getPictureUrl() != null && updateApiEntity.getPictureUrl().indexOf("?hash") > 0) {
                    api.setPicture(apiToUpdate.getPicture());
                }
                if (updateApiEntity.getBackground() == null && updateApiEntity.getBackgroundUrl() != null && updateApiEntity.getBackgroundUrl().indexOf("?hash") > 0) {
                    api.setBackground(apiToUpdate.getBackground());
                }
                if (updateApiEntity.getGroups() == null) {
                    api.setGroups(apiToUpdate.getGroups());
                }
                if (updateApiEntity.getLabels() == null && apiToUpdate.getLabels() != null) {
                    api.setLabels(new ArrayList(new HashSet(apiToUpdate.getLabels())));
                }
                if (updateApiEntity.getCategories() == null) {
                    api.setCategories(apiToUpdate.getCategories());
                }
                if (ApiLifecycleState.DEPRECATED.equals((Object)api.getApiLifecycleState())) {
                    this.notifierService.trigger(ApiHook.API_DEPRECATED, apiId, new NotificationParamsBuilder().api(apiToCheck).user(this.userService.findById(this.getAuthenticatedUsername())).build());
                }
                io.gravitee.repository.management.model.Api updatedApi = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                this.auditService.createApiAuditLog(updatedApi.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, updatedApi.getUpdatedAt(), apiToUpdate, updatedApi);
                if (this.parameterService.findAsBoolean(Key.LOGGING_AUDIT_TRAIL_ENABLED, ParameterReferenceType.ENVIRONMENT)) {
                    this.auditApiLogging(apiToUpdate, updatedApi);
                }
                ApiEntity apiEntity = this.convert(Collections.singletonList(updatedApi)).iterator().next();
                ApiEntity apiWithMetadata = this.fetchMetadataForApi(apiEntity);
                this.searchEngineService.index((Indexable)apiWithMetadata, false);
                return apiEntity;
            }
            LOGGER.error("Unable to update API {} because of previous error.", (Object)apiId);
            throw new TechnicalManagementException("Unable to update API " + apiId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to update API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to update API " + apiId, ex);
        }
    }

    private String buildApiDefinition(String apiId, String apiDefinition, UpdateApiEntity updateApiEntity) {
        try {
            Api updateApiDefinition;
            if (apiDefinition == null || apiDefinition.isEmpty()) {
                updateApiDefinition = new Api();
                updateApiDefinition.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion()));
            } else {
                updateApiDefinition = (Api)this.objectMapper.readValue(apiDefinition, Api.class);
            }
            updateApiDefinition.setId(apiId);
            updateApiDefinition.setName(updateApiEntity.getName());
            updateApiDefinition.setVersion(updateApiEntity.getVersion());
            updateApiDefinition.setProxy(updateApiEntity.getProxy());
            if (StringUtils.isNotEmpty((CharSequence)updateApiEntity.getGraviteeDefinitionVersion())) {
                updateApiDefinition.setDefinitionVersion(DefinitionVersion.valueOfLabel((String)updateApiEntity.getGraviteeDefinitionVersion()));
            }
            if (updateApiEntity.getFlowMode() != null) {
                updateApiDefinition.setFlowMode(updateApiEntity.getFlowMode());
            }
            if (updateApiEntity.getPaths() != null) {
                updateApiDefinition.setPaths(updateApiEntity.getPaths());
            }
            if (updateApiEntity.getPathMappings() != null) {
                updateApiDefinition.setPathMappings(updateApiEntity.getPathMappings().stream().collect(Collectors.toMap(pathMapping -> pathMapping, pathMapping -> Pattern.compile(""))));
            }
            if (updateApiEntity.getFlows() != null) {
                updateApiDefinition.setFlows(updateApiEntity.getFlows());
            }
            if (updateApiEntity.getPlans() != null) {
                List plans = updateApiEntity.getPlans().stream().filter(plan -> plan.getId() != null).collect(Collectors.toList());
                updateApiDefinition.setPlans(plans);
            }
            updateApiDefinition.setServices(updateApiEntity.getServices());
            updateApiDefinition.setResources(updateApiEntity.getResources());
            if (updateApiEntity.getProperties() != null) {
                updateApiDefinition.setProperties(updateApiEntity.getProperties().toDefinition());
            }
            updateApiDefinition.setTags(updateApiEntity.getTags());
            updateApiDefinition.setResponseTemplates(updateApiEntity.getResponseTemplates());
            return this.objectMapper.writeValueAsString((Object)updateApiDefinition);
        }
        catch (JsonProcessingException jse) {
            LOGGER.error("Unexpected error while generating API definition", (Throwable)jse);
            throw new TechnicalManagementException("An error occurs while trying to parse API definition " + jse);
        }
    }

    private void checkAllowOriginFormat(UpdateApiEntity updateApiEntity) {
        Set accessControlAllowOrigin;
        if (updateApiEntity.getProxy() != null && updateApiEntity.getProxy().getCors() != null && (accessControlAllowOrigin = updateApiEntity.getProxy().getCors().getAccessControlAllowOrigin()) != null && !accessControlAllowOrigin.isEmpty()) {
            for (String allowOriginItem : accessControlAllowOrigin) {
                if (CORS_REGEX_PATTERN.matcher(allowOriginItem).matches()) continue;
                if (StringUtils.indexOfAny((CharSequence)allowOriginItem, (CharSequence[])CORS_REGEX_CHARS) >= 0) {
                    try {
                        Pattern.compile(allowOriginItem);
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new AllowOriginNotAllowedException(allowOriginItem);
                    }
                }
                throw new AllowOriginNotAllowedException(allowOriginItem);
            }
        }
    }

    private void checkShardingTags(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        Set<String> userTags;
        Set<Object> updatedTags;
        Set tagsToUpdate;
        Set set = tagsToUpdate = updateApiEntity.getTags() == null ? new HashSet() : updateApiEntity.getTags();
        if (existingAPI == null) {
            updatedTags = tagsToUpdate;
        } else {
            Set existingAPITags = existingAPI.getTags() == null ? new HashSet() : existingAPI.getTags();
            updatedTags = existingAPITags.stream().filter(tag -> !tagsToUpdate.contains(tag)).collect(Collectors.toSet());
            updatedTags.addAll(tagsToUpdate.stream().filter(tag -> !existingAPITags.contains(tag)).collect(Collectors.toSet()));
        }
        if (updatedTags != null && !updatedTags.isEmpty() && !(userTags = this.tagService.findByUser(this.getAuthenticatedUsername(), GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION)).containsAll(updatedTags)) {
            String[] notAllowedTags = (String[])updatedTags.stream().filter(tag -> !userTags.contains(tag)).toArray(String[]::new);
            throw new TagNotAllowedException(notAllowedTags);
        }
    }

    private void checkPolicyConfigurations(UpdateApiEntity updateApiEntity) {
        this.checkPolicyConfigurations(updateApiEntity.getPaths(), updateApiEntity.getFlows(), updateApiEntity.getPlans());
    }

    @Override
    public void checkPolicyConfigurations(Map<String, List<Rule>> paths, List<Flow> flows, List<Plan> plans) {
        this.checkPathsPolicyConfiguration(paths);
        this.checkFlowsPolicyConfiguration(flows);
        if (plans != null) {
            plans.stream().forEach(plan -> {
                this.checkPathsPolicyConfiguration(plan.getPaths());
                this.checkFlowsPolicyConfiguration(plan.getFlows());
            });
        }
    }

    private void checkPathsPolicyConfiguration(Map<String, List<Rule>> paths) {
        if (paths != null) {
            paths.forEach((s, rules) -> rules.stream().filter(Rule::isEnabled).map(Rule::getPolicy).forEach(policy -> this.policyService.validatePolicyConfiguration((Policy)policy)));
        }
    }

    private void checkFlowsPolicyConfiguration(List<Flow> flows) {
        if (flows != null) {
            flows.stream().filter(flow -> flow.getPre() != null).forEach(flow -> flow.getPre().stream().filter(Step::isEnabled).forEach(step -> this.policyService.validatePolicyConfiguration((Step)step)));
            flows.stream().filter(flow -> flow.getPost() != null).forEach(flow -> flow.getPost().stream().filter(Step::isEnabled).forEach(step -> this.policyService.validatePolicyConfiguration((Step)step)));
        }
    }

    private void validateRegexfields(UpdateApiEntity updateApiEntity) {
        if (updateApiEntity.getPaths() != null) {
            updateApiEntity.getPaths().forEach((path, v) -> {
                try {
                    Pattern.compile(path);
                }
                catch (PatternSyntaxException pse) {
                    LOGGER.error("An error occurs while trying to parse the path {}", path, (Object)pse);
                    throw new TechnicalManagementException("An error occurs while trying to parse the path " + path, pse);
                }
            });
        }
        if (updateApiEntity.getPathMappings() != null) {
            updateApiEntity.getPathMappings().forEach(pathMapping -> {
                try {
                    Pattern.compile(pathMapping);
                }
                catch (PatternSyntaxException pse) {
                    LOGGER.error("An error occurs while trying to parse the path mapping {}", pathMapping, (Object)pse);
                    throw new TechnicalManagementException("An error occurs while trying to parse the path mapping" + pathMapping, pse);
                }
            });
        }
    }

    private void checkLifecycleState(UpdateApiEntity updateApiEntity, ApiEntity existingAPI) {
        if (io.gravitee.rest.api.model.api.ApiLifecycleState.DEPRECATED.equals((Object)existingAPI.getLifecycleState())) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
        if (existingAPI.getLifecycleState().name().equals(updateApiEntity.getLifecycleState().name())) {
            return;
        }
        if (io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED.equals((Object)existingAPI.getLifecycleState()) ? !io.gravitee.rest.api.model.api.ApiLifecycleState.ARCHIVED.equals((Object)updateApiEntity.getLifecycleState()) : (io.gravitee.rest.api.model.api.ApiLifecycleState.UNPUBLISHED.equals((Object)existingAPI.getLifecycleState()) ? io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED.equals((Object)updateApiEntity.getLifecycleState()) : io.gravitee.rest.api.model.api.ApiLifecycleState.CREATED.equals((Object)existingAPI.getLifecycleState()) && WorkflowState.IN_REVIEW.equals((Object)existingAPI.getWorkflowState()))) {
            throw new LifecycleStateChangeNotAllowedException(updateApiEntity.getLifecycleState().name());
        }
    }

    @Override
    public void delete(String apiId) {
        try {
            LOGGER.debug("Delete API {}", (Object)apiId);
            Optional optApi = this.apiRepository.findById((Object)apiId);
            if (!optApi.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            if (((io.gravitee.repository.management.model.Api)optApi.get()).getLifecycleState() == LifecycleState.STARTED) {
                throw new ApiRunningStateException(apiId);
            }
            Set<PlanEntity> plans = this.planService.findByApi(apiId);
            Set<String> plansNotClosed = plans.stream().filter(plan -> plan.getStatus() == PlanStatus.PUBLISHED).map(PlanEntity::getName).collect(Collectors.toSet());
            if (!plansNotClosed.isEmpty()) {
                throw new ApiNotDeletableException(plansNotClosed);
            }
            Collection<SubscriptionEntity> subscriptions = this.subscriptionService.findByApi(apiId);
            subscriptions.forEach(sub -> this.subscriptionService.delete(sub.getId()));
            for (PlanEntity plan2 : plans) {
                this.planService.delete(plan2.getId());
            }
            EventQuery query = new EventQuery();
            query.setApi(apiId);
            this.eventService.search(query).forEach(event -> this.eventService.delete(event.getId()));
            HashMap<String, String> properties = new HashMap<String, String>(2);
            properties.put(Event.EventProperties.API_ID.getValue(), apiId);
            if (this.getAuthenticatedUser() != null) {
                properties.put(Event.EventProperties.USER.getValue(), this.getAuthenticatedUser().getUsername());
            }
            this.eventService.create(EventType.UNPUBLISH_API, null, properties);
            this.pageService.deleteAllByApi(apiId, GraviteeContext.getCurrentEnvironment());
            this.topApiService.delete(apiId);
            this.apiRepository.delete((Object)apiId);
            this.membershipService.deleteReference(MembershipReferenceType.API, apiId);
            this.genericNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            this.portalNotificationConfigService.deleteReference(NotificationReferenceType.API, apiId);
            List<AlertTriggerEntity> alerts = this.alertService.findByReferenceWithEventCounts(AlertReferenceType.API, apiId);
            alerts.forEach(alert -> this.alertService.delete(alert.getId(), alert.getReferenceId()));
            this.apiQualityRuleRepository.deleteByApi(apiId);
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_DELETED, new Date(), optApi.get(), null);
            this.searchEngineService.delete((Indexable)this.convert((io.gravitee.repository.management.model.Api)optApi.get()), false);
            this.mediaService.deleteAllByApi(apiId);
            this.apiMetadataService.deleteAllByApi(apiId);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to delete API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to delete API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity start(String apiId, String userId) {
        try {
            LOGGER.debug("Start API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(apiId, LifecycleState.STARTED, userId);
            this.notifierService.trigger(ApiHook.API_STARTED, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to start API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to start API " + apiId, ex);
        }
    }

    @Override
    public ApiEntity stop(String apiId, String userId) {
        try {
            LOGGER.debug("Stop API {}", (Object)apiId);
            ApiEntity apiEntity = this.updateLifecycle(apiId, LifecycleState.STOPPED, userId);
            this.notifierService.trigger(ApiHook.API_STOPPED, apiId, new NotificationParamsBuilder().api(apiEntity).user(this.userService.findById(userId)).build());
            return apiEntity;
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to stop API {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to stop API " + apiId, ex);
        }
    }

    @Override
    public boolean isSynchronized(String apiId) {
        try {
            ApiEntity api = this.findById(apiId);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put(Event.EventProperties.API_ID.getValue(), apiId);
            Page<EventEntity> events = this.eventService.search(Arrays.asList(EventType.PUBLISH_API, EventType.UNPUBLISH_API), properties, 0L, 0L, 0, 1);
            if (!events.getContent().isEmpty()) {
                EventEntity lastEvent = (EventEntity)events.getContent().get(0);
                boolean enabled = this.objectMapper.getDeserializationConfig().isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                io.gravitee.repository.management.model.Api payloadEntity = (io.gravitee.repository.management.model.Api)this.objectMapper.readValue(lastEvent.getPayload(), io.gravitee.repository.management.model.Api.class);
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, enabled);
                ApiEntity deployedApi = this.convert(payloadEntity);
                this.removeDescriptionFromPolicies(api);
                this.removeDescriptionFromPolicies(deployedApi);
                boolean sync = this.apiSynchronizationProcessor.processCheckSynchronization(deployedApi, api);
                if (sync) {
                    Set<PlanEntity> plans = this.planService.findByApi(api.getId());
                    sync = plans.stream().filter(plan -> plan.getStatus() != PlanStatus.STAGING).filter(plan -> plan.getNeedRedeployAt().after(api.getDeployedAt())).count() == 0L;
                }
                return sync;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to check API synchronization state {}", (Object)apiId, (Object)e);
        }
        return false;
    }

    private void removeDescriptionFromPolicies(ApiEntity api) {
        if (api.getPaths() != null) {
            api.getPaths().forEach((s, rules) -> {
                if (rules != null) {
                    rules.forEach(rule -> rule.setDescription(""));
                }
            });
        }
    }

    @Override
    public ApiEntity deploy(String apiId, String userId, EventType eventType, ApiDeploymentEntity apiDeploymentEntity) {
        try {
            LOGGER.debug("Deploy API : {}", (Object)apiId);
            return this.deployCurrentAPI(apiId, userId, eventType, apiDeploymentEntity);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to deploy API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to deploy API: " + apiId, ex);
        }
    }

    @Override
    public ApiEntity rollback(String apiId, UpdateApiEntity api) {
        LOGGER.debug("Rollback API : {}", (Object)apiId);
        try {
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_ROLLBACKED, new Date(), null, null);
            return this.update(apiId, api);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while trying to rollback API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to rollback API: " + apiId, ex);
        }
    }

    private ApiEntity deployCurrentAPI(String apiId, String userId, EventType eventType, ApiDeploymentEntity apiDeploymentEntity) throws Exception {
        Optional api = this.apiRepository.findById((Object)apiId);
        if (api.isPresent()) {
            io.gravitee.repository.management.model.Api apiValue = (io.gravitee.repository.management.model.Api)api.get();
            apiValue.setUpdatedAt(new Date());
            apiValue.setDeployedAt(apiValue.getUpdatedAt());
            apiValue = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)apiValue);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(Event.EventProperties.API_ID.getValue(), apiValue.getId());
            properties.put(Event.EventProperties.USER.getValue(), userId);
            apiValue.setPicture(null);
            this.addDeploymentLabelToProperties(apiId, eventType, properties, apiDeploymentEntity);
            this.eventService.create(eventType, this.objectMapper.writeValueAsString((Object)apiValue), properties);
            return this.convert(Collections.singletonList(apiValue)).iterator().next();
        }
        throw new ApiNotFoundException(apiId);
    }

    private void addDeploymentLabelToProperties(String apiId, EventType eventType, Map<String, String> properties, ApiDeploymentEntity apiDeploymentEntity) {
        if (EventType.PUBLISH_API.equals((Object)eventType)) {
            EventQuery query = new EventQuery();
            query.setApi(apiId);
            query.setTypes(Collections.singleton(EventType.PUBLISH_API));
            Optional<EventEntity> optEvent = this.eventService.search(query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
            String lastDeployNumber = optEvent.isPresent() ? optEvent.get().getProperties().getOrDefault(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), "0") : "0";
            String newDeployNumber = Long.toString(Long.parseLong(lastDeployNumber) + 1L);
            properties.put(Event.EventProperties.DEPLOYMENT_NUMBER.getValue(), newDeployNumber);
            if (apiDeploymentEntity != null && StringUtils.isNotEmpty((CharSequence)apiDeploymentEntity.getDeploymentLabel())) {
                properties.put(Event.EventProperties.DEPLOYMENT_LABEL.getValue(), apiDeploymentEntity.getDeploymentLabel());
            }
        }
    }

    private ApiEntity deployLastPublishedAPI(String apiId, String userId, EventType eventType) throws TechnicalException {
        EventQuery query = new EventQuery();
        query.setApi(apiId);
        query.setTypes(Collections.singleton(EventType.PUBLISH_API));
        Optional<EventEntity> optEvent = this.eventService.search(query).stream().max(Comparator.comparing(EventEntity::getCreatedAt));
        try {
            if (optEvent.isPresent()) {
                EventEntity event = optEvent.get();
                JsonNode node = this.objectMapper.readTree(event.getPayload());
                io.gravitee.repository.management.model.Api lastPublishedAPI = (io.gravitee.repository.management.model.Api)this.objectMapper.convertValue((Object)node, io.gravitee.repository.management.model.Api.class);
                lastPublishedAPI.setLifecycleState(this.convert(eventType));
                lastPublishedAPI.setUpdatedAt(new Date());
                lastPublishedAPI.setDeployedAt(new Date());
                HashMap<String, String> properties = new HashMap<String, String>();
                properties.put(Event.EventProperties.API_ID.getValue(), lastPublishedAPI.getId());
                properties.put(Event.EventProperties.USER.getValue(), userId);
                lastPublishedAPI.setPicture(null);
                this.eventService.create(eventType, this.objectMapper.writeValueAsString((Object)lastPublishedAPI), properties);
                return null;
            }
            return this.deploy(apiId, userId, EventType.PUBLISH_API, new ApiDeploymentEntity());
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to deploy last published API {}", (Object)apiId, (Object)e);
            throw new TechnicalException("An error occurs while trying to deploy last published API " + apiId, (Throwable)e);
        }
    }

    @Override
    public String exportAsJson(String apiId, String exportVersion, String ... filteredFields) {
        ApiEntity apiEntity = this.findById(apiId);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put(ApiSerializer.METADATA_EXPORT_VERSION, exportVersion);
        metadata.put(ApiSerializer.METADATA_FILTERED_FIELDS_LIST, Arrays.asList(filteredFields));
        apiEntity.setMetadata(metadata);
        try {
            return this.objectMapper.writeValueAsString((Object)apiEntity);
        }
        catch (Exception e) {
            LOGGER.error("An error occurs while trying to JSON serialize the API {}", (Object)apiEntity, (Object)e);
            return "";
        }
    }

    @Override
    public ApiEntity createWithImportedDefinition(ApiEntity apiEntity, String apiDefinitionOrURL, String userId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            UpdateApiEntity importedApi = this.convertToEntity(apiDefinition, jsonNode);
            ApiEntity createdApiEntity = this.createWithApiDefinition(importedApi, userId, jsonNode);
            this.createPageAndMedia(createdApiEntity, jsonNode);
            this.updateApiReferences(createdApiEntity, jsonNode);
            return createdApiEntity;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    private void createPageAndMedia(ApiEntity createdApiEntity, JsonNode jsonNode) {
        List<PageEntity> search;
        JsonNode pages;
        JsonNode apiMedia = jsonNode.path("apiMedia");
        if (apiMedia != null && apiMedia.isArray()) {
            for (Iterator media : apiMedia) {
                this.mediaService.createWithDefinition(createdApiEntity.getId(), media.toString());
            }
        }
        if ((pages = jsonNode.path("pages")) != null && pages.isArray()) {
            for (JsonNode page : pages) {
                PageEntity pageEntity = this.pageService.createWithDefinition(createdApiEntity.getId(), page.toString(), GraviteeContext.getCurrentEnvironment());
                ((ObjectNode)page).put("id", pageEntity.getId());
            }
        }
        if ((search = this.pageService.search(new PageQuery.Builder().api(createdApiEntity.getId()).name(SystemFolderType.ASIDE.folderName()).type(PageType.SYSTEM_FOLDER).build(), GraviteeContext.getCurrentEnvironment())).isEmpty()) {
            this.createSystemFolder(createdApiEntity.getId());
        }
    }

    @Override
    public ApiEntity updateWithImportedDefinition(ApiEntity apiEntity, String apiDefinitionOrURL, String userId) {
        String apiDefinition = this.fetchApiDefinitionContentFromURL(apiDefinitionOrURL);
        try {
            JsonNode jsonNode = this.objectMapper.readTree(apiDefinition);
            UpdateApiEntity importedApi = this.convertToEntity(apiDefinition, jsonNode);
            ApiEntity updatedApiEntity = this.update(apiEntity.getId(), importedApi);
            this.updateApiReferences(updatedApiEntity, jsonNode);
            return updatedApiEntity;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("An error occurs while trying to JSON deserialize the API {}", (Object)apiDefinition, (Object)e);
            throw new TechnicalManagementException("An error occurs while trying to JSON deserialize the API definition.");
        }
    }

    private UpdateApiEntity convertToEntity(String apiDefinition, JsonNode jsonNode) throws JsonProcessingException {
        JsonNode viewsDefinition;
        UpdateApiEntity importedApi = (UpdateApiEntity)this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue(apiDefinition, UpdateApiEntity.class);
        if (Objects.equals(importedApi.getGraviteeDefinitionVersion(), DefinitionVersion.V1.getLabel()) && (importedApi.getPaths() == null || importedApi.getPaths().isEmpty())) {
            importedApi.setPaths(Collections.singletonMap(URI_PATH_SEPARATOR, new ArrayList()));
        }
        if (importedApi.getGroups() != null) {
            HashSet groupNames = new HashSet(importedApi.getGroups());
            importedApi.getGroups().clear();
            for (String name : groupNames) {
                GroupEntity group;
                List<GroupEntity> groupEntities = this.groupService.findByName(name);
                if (groupEntities.isEmpty()) {
                    NewGroupEntity newGroupEntity = new NewGroupEntity();
                    newGroupEntity.setName(name);
                    group = this.groupService.create(newGroupEntity);
                } else {
                    group = groupEntities.get(0);
                }
                importedApi.getGroups().add(group.getId());
            }
        }
        if ((viewsDefinition = jsonNode.path("views")) != null && viewsDefinition.isArray()) {
            HashSet<String> categories = new HashSet<String>();
            for (JsonNode viewNode : viewsDefinition) {
                categories.add(viewNode.asText());
            }
            importedApi.setCategories(categories);
        }
        return importedApi;
    }

    private void updateApiReferences(ApiEntity createdOrUpdatedApiEntity, JsonNode jsonNode) throws JsonProcessingException {
        JsonNode metadataDefinition;
        JsonNode plansDefinition;
        JsonNode pagesDefinition;
        JsonNode membersToImport = jsonNode.path("members");
        if (membersToImport != null && membersToImport.isArray()) {
            Set membersAlreadyPresent = this.membershipService.getMembersByReference(MembershipReferenceType.API, createdOrUpdatedApiEntity.getId()).stream().map(member -> {
                UserEntity userEntity = this.userService.findById(member.getId());
                return new MemberToImport(userEntity.getSource(), userEntity.getSourceId(), member.getRoles().stream().map(RoleEntity::getId).collect(Collectors.toList()), null);
            }).collect(Collectors.toSet());
            RoleEntity poRole = this.roleService.findPrimaryOwnerRoleByOrganization(GraviteeContext.getCurrentOrganization(), RoleScope.API);
            if (poRole != null) {
                String poRoleId = poRole.getId();
                MemberToImport currentPo = membersAlreadyPresent.stream().filter(memberToImport -> memberToImport.getRoles().contains(poRoleId)).findFirst().orElse(new MemberToImport());
                List<String> roleUsedInTransfert = null;
                MemberToImport futurePO = null;
                for (JsonNode memberNode : membersToImport) {
                    boolean presentWithSameRole;
                    MemberToImport memberToImport2 = (MemberToImport)this.objectMapper.readValue(memberNode.toString(), MemberToImport.class);
                    String roleToAdd = memberToImport2.getRole();
                    List<String> rolesToImport = memberToImport2.getRoles();
                    if (roleToAdd != null && !roleToAdd.isEmpty()) {
                        Optional<RoleEntity> optRoleToAddEntity;
                        if (rolesToImport == null) {
                            rolesToImport = new ArrayList<String>();
                            memberToImport2.setRoles(rolesToImport);
                        }
                        if ((optRoleToAddEntity = this.roleService.findByScopeAndName(RoleScope.API, roleToAdd)).isPresent()) {
                            rolesToImport.add(optRoleToAddEntity.get().getId());
                        } else {
                            LOGGER.warn("Role {} does not exist", (Object)roleToAdd);
                        }
                    }
                    if (rolesToImport != null) {
                        rolesToImport.sort(Comparator.naturalOrder());
                    }
                    boolean bl = presentWithSameRole = memberToImport2.getRoles() != null && !memberToImport2.getRoles().isEmpty() && membersAlreadyPresent.stream().anyMatch(m -> {
                        m.getRoles().sort(Comparator.naturalOrder());
                        return m.getRoles().equals(memberToImport2.getRoles()) && m.getSourceId().equals(memberToImport2.getSourceId()) && m.getSource().equals(memberToImport2.getSource());
                    });
                    if (!(presentWithSameRole || memberToImport2.getRoles() == null || memberToImport2.getRoles().isEmpty() || memberToImport2.getRoles().contains(poRoleId) || memberToImport2.getSourceId().equals(currentPo.getSourceId()) && memberToImport2.getSource().equals(currentPo.getSource()))) {
                        try {
                            UserEntity userEntity = this.userService.findBySource(memberToImport2.getSource(), memberToImport2.getSourceId(), false);
                            rolesToImport.forEach(role -> this.membershipService.addRoleToMemberOnReference(MembershipReferenceType.API, createdOrUpdatedApiEntity.getId(), MembershipMemberType.USER, userEntity.getId(), (String)role));
                        }
                        catch (UserNotFoundException userNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (currentPo.getSourceId().equals(memberToImport2.getSourceId()) && currentPo.getSource().equals(memberToImport2.getSource()) && !rolesToImport.contains(poRoleId)) {
                        roleUsedInTransfert = rolesToImport;
                    }
                    if (!rolesToImport.contains(poRoleId)) continue;
                    futurePO = memberToImport2;
                }
                if (!(futurePO == null || currentPo.getSource().equals(futurePO.getSource()) && currentPo.getSourceId().equals(futurePO.getSourceId()))) {
                    try {
                        UserEntity userEntity = this.userService.findBySource(futurePO.getSource(), futurePO.getSourceId(), false);
                        List roleEntity = null;
                        if (roleUsedInTransfert != null && !roleUsedInTransfert.isEmpty()) {
                            roleEntity = roleUsedInTransfert.stream().map(this.roleService::findById).collect(Collectors.toList());
                        }
                        this.membershipService.transferApiOwnership(createdOrUpdatedApiEntity.getId(), new MembershipService.MembershipMember(userEntity.getId(), null, MembershipMemberType.USER), roleEntity);
                    }
                    catch (UserNotFoundException userEntity) {
                        // empty catch block
                    }
                }
            }
        }
        if ((pagesDefinition = jsonNode.path("pages")) != null && pagesDefinition.isArray()) {
            List pagesList = (List)this.objectMapper.readValue(pagesDefinition.toString(), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, PageEntity.class));
            PageEntityTreeNode documentationTree = new PageEntityTreeNode(new PageEntity());
            documentationTree.appendListToTree(pagesList);
            this.createOrUpdateChildrenPages(createdOrUpdatedApiEntity.getId(), null, documentationTree.children);
        }
        if ((plansDefinition = jsonNode.path("plans")) != null && plansDefinition.isArray()) {
            for (Object planNode : plansDefinition) {
                if (planNode.has("id")) {
                    try {
                        PlanEntity plan = this.planService.findById(planNode.get("id").asText());
                        UpdatePlanEntity updatePlanEntity = (UpdatePlanEntity)this.objectMapper.readValue(planNode.toString(), UpdatePlanEntity.class);
                        updatePlanEntity.setId(plan.getId());
                        this.planService.update(updatePlanEntity, true);
                    }
                    catch (PlanNotFoundException npe) {
                        NewPlanEntity newPlanEntity = (NewPlanEntity)this.objectMapper.readValue(planNode.toString(), NewPlanEntity.class);
                        newPlanEntity.setApi(createdOrUpdatedApiEntity.getId());
                        this.planService.create(newPlanEntity);
                    }
                    continue;
                }
                PlanQuery query = new PlanQuery.Builder().api(createdOrUpdatedApiEntity.getId()).name(planNode.get("name").asText()).security(PlanSecurityType.valueOf((String)planNode.get("security").asText().toUpperCase())).build();
                List planEntities = this.planService.search(query).stream().filter(planEntity -> !PlanStatus.CLOSED.equals((Object)planEntity.getStatus())).collect(Collectors.toList());
                if (planEntities.isEmpty()) {
                    NewPlanEntity newPlanEntity = (NewPlanEntity)this.objectMapper.readValue(planNode.toString(), NewPlanEntity.class);
                    newPlanEntity.setApi(createdOrUpdatedApiEntity.getId());
                    this.planService.create(newPlanEntity);
                    continue;
                }
                if (planEntities.size() == 1) {
                    UpdatePlanEntity updatePlanEntity = (UpdatePlanEntity)this.objectMapper.readValue(planNode.toString(), UpdatePlanEntity.class);
                    updatePlanEntity.setId(((PlanEntity)planEntities.iterator().next()).getId());
                    this.planService.update(updatePlanEntity, true);
                    continue;
                }
                LOGGER.error("Not able to identify the plan to update: {}. Too much plan with the same name", (Object)planNode.get("name").asText());
                throw new TechnicalManagementException("Not able to identify the plan to update: " + planNode.get("name").asText() + ". Too much plan with the same name");
            }
        }
        if ((metadataDefinition = jsonNode.path("metadata")) != null && metadataDefinition.isArray()) {
            try {
                for (JsonNode metadataNode : metadataDefinition) {
                    UpdateApiMetadataEntity updateApiMetadataEntity = (UpdateApiMetadataEntity)this.objectMapper.readValue(metadataNode.toString(), UpdateApiMetadataEntity.class);
                    updateApiMetadataEntity.setApiId(createdOrUpdatedApiEntity.getId());
                    this.apiMetadataService.update(updateApiMetadataEntity);
                }
            }
            catch (Exception ex) {
                LOGGER.error("An error occurs while creating API metadata", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while creating API Metadata", ex);
            }
        }
    }

    private String fetchApiDefinitionContentFromURL(String apiDefinitionOrURL) {
        if (apiDefinitionOrURL.toUpperCase().startsWith("HTTP")) {
            UrlSanitizerUtils.checkAllowed(apiDefinitionOrURL, this.importConfiguration.getImportWhitelist(), this.importConfiguration.isAllowImportFromPrivate());
            Buffer buffer = this.httpClientService.request(HttpMethod.GET, apiDefinitionOrURL, null, null, null);
            return buffer.toString();
        }
        return apiDefinitionOrURL;
    }

    private void createOrUpdateChildrenPages(String apiId, String parentId, List<PageEntityTreeNode> children) {
        for (PageEntityTreeNode child : children) {
            PageEntity pageEntityToImport = child.data;
            pageEntityToImport.setParentId(parentId);
            PageEntity createdOrUpdatedPage = null;
            if (pageEntityToImport.getId() != null) {
                createdOrUpdatedPage = this.pageService.findById(pageEntityToImport.getId());
            } else {
                PageQuery query = new PageQuery.Builder().api(apiId).name(pageEntityToImport.getName()).type(PageType.valueOf((String)pageEntityToImport.getType())).build();
                List<PageEntity> pages = this.pageService.search(query, GraviteeContext.getCurrentEnvironment());
                if (pages.size() == 1) {
                    createdOrUpdatedPage = pages.get(0);
                } else if (pages.size() > 1) {
                    LOGGER.error("Not able to identify the page to update: {}. Too much pages with the same name", (Object)pageEntityToImport.getName());
                    throw new TechnicalManagementException("Not able to identify the page to update: " + pageEntityToImport.getName() + ". Too much pages with the same name");
                }
            }
            if (createdOrUpdatedPage == null) {
                NewPageEntity newPage = new NewPageEntity();
                newPage.setConfiguration(pageEntityToImport.getConfiguration());
                newPage.setContent(pageEntityToImport.getContent());
                newPage.setExcludedAccessControls(pageEntityToImport.isExcludedAccessControls());
                newPage.setAccessControls(pageEntityToImport.getAccessControls());
                newPage.setHomepage(pageEntityToImport.isHomepage());
                newPage.setLastContributor(pageEntityToImport.getLastContributor());
                newPage.setName(pageEntityToImport.getName());
                newPage.setOrder(pageEntityToImport.getOrder());
                newPage.setParentId(pageEntityToImport.getParentId());
                newPage.setPublished(pageEntityToImport.isPublished());
                newPage.setSource(pageEntityToImport.getSource());
                newPage.setType(PageType.valueOf((String)pageEntityToImport.getType()));
                newPage.setAttachedMedia(pageEntityToImport.getAttachedMedia());
                createdOrUpdatedPage = this.pageService.createPage(apiId, newPage, GraviteeContext.getCurrentEnvironment());
            } else {
                UpdatePageEntity updatePageEntity = new UpdatePageEntity();
                updatePageEntity.setConfiguration(pageEntityToImport.getConfiguration());
                updatePageEntity.setContent(pageEntityToImport.getContent());
                updatePageEntity.setExcludedAccessControls(Boolean.valueOf(pageEntityToImport.isExcludedAccessControls()));
                updatePageEntity.setAccessControls(pageEntityToImport.getAccessControls());
                updatePageEntity.setHomepage(Boolean.valueOf(pageEntityToImport.isHomepage()));
                updatePageEntity.setLastContributor(pageEntityToImport.getLastContributor());
                updatePageEntity.setName(pageEntityToImport.getName());
                updatePageEntity.setOrder(Integer.valueOf(pageEntityToImport.getOrder()));
                updatePageEntity.setParentId(pageEntityToImport.getParentId());
                updatePageEntity.setPublished(Boolean.valueOf(pageEntityToImport.isPublished()));
                updatePageEntity.setSource(pageEntityToImport.getSource());
                updatePageEntity.setAttachedMedia(pageEntityToImport.getAttachedMedia());
                createdOrUpdatedPage = this.pageService.update(createdOrUpdatedPage.getId(), updatePageEntity);
            }
            if (child.children == null || child.children.isEmpty()) continue;
            this.createOrUpdateChildrenPages(apiId, createdOrUpdatedPage.getId(), child.children);
        }
    }

    @Override
    public InlinePictureEntity getPicture(String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (api.getPicture() != null) {
            String[] parts = api.getPicture().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = api.getPicture().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        } else {
            this.getDefaultPicture().ifPresent(content -> {
                imageEntity.setType("image/png");
                imageEntity.setContent(content);
            });
        }
        return imageEntity;
    }

    private Optional<byte[]> getDefaultPicture() {
        Optional<byte[]> content = Optional.empty();
        if (!Strings.isNullOrEmpty((String)this.defaultApiIcon)) {
            try {
                content = Optional.of(IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultApiIcon)));
            }
            catch (IOException ioe) {
                LOGGER.error("Default icon for API does not exist", (Throwable)ioe);
            }
        }
        return content;
    }

    @Override
    public InlinePictureEntity getBackground(String apiId) {
        io.gravitee.repository.management.model.Api api = this.findApiById(apiId);
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        if (api.getBackground() != null) {
            String[] parts = api.getBackground().split(";", 2);
            imageEntity.setType(parts[0].split(":")[1]);
            String base64Content = api.getBackground().split(",", 2)[1];
            imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        }
        return imageEntity;
    }

    @Override
    public ApiEntity migrate(String apiId) {
        ApiEntity apiEntity = this.findById(apiId);
        Set<PolicyEntity> policies = this.policyService.findAll();
        Set<PlanEntity> plans = this.planService.findByApi(apiId);
        ApiEntity migratedApi = this.apiv1toAPIV2Converter.migrateToV2(apiEntity, policies, plans);
        return this.update(apiId, ApiService.convert(migratedApi));
    }

    @Override
    public void deleteCategoryFromAPIs(String categoryId) {
        this.findAll().forEach(api -> {
            if (api.getCategories() != null && api.getCategories().contains(categoryId)) {
                this.removeCategory(api.getId(), categoryId);
            }
        });
    }

    private void removeCategory(String apiId, String categoryId) throws TechnicalManagementException {
        try {
            Optional optApi = this.apiRepository.findById((Object)apiId);
            if (!optApi.isPresent()) {
                throw new ApiNotFoundException(apiId);
            }
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            api.getCategories().remove(categoryId);
            api.setUpdatedAt(new Date());
            this.apiRepository.update((Object)api);
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while removing category from API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while removing category from API: " + apiId, ex);
        }
    }

    @Override
    public void deleteTagFromAPIs(String tagId) {
        this.findAll().forEach(api -> {
            if (api.getTags() != null && api.getTags().contains(tagId)) {
                this.removeTag(api.getId(), tagId);
            }
        });
    }

    @Override
    public ApiModelEntity findByIdForTemplates(String apiId, boolean decodeTemplate) {
        ApiEntity apiEntity = this.findById(apiId);
        ApiModelEntity apiModelEntity = new ApiModelEntity();
        apiModelEntity.setId(apiEntity.getId());
        apiModelEntity.setName(apiEntity.getName());
        apiModelEntity.setDescription(apiEntity.getDescription());
        apiModelEntity.setCreatedAt(apiEntity.getCreatedAt());
        apiModelEntity.setDeployedAt(apiEntity.getDeployedAt());
        apiModelEntity.setUpdatedAt(apiEntity.getUpdatedAt());
        apiModelEntity.setGroups(apiEntity.getGroups());
        apiModelEntity.setVisibility(apiEntity.getVisibility());
        apiModelEntity.setCategories(apiEntity.getCategories());
        apiModelEntity.setVersion(apiEntity.getVersion());
        apiModelEntity.setState(apiEntity.getState());
        apiModelEntity.setTags(apiEntity.getTags());
        apiModelEntity.setServices(apiEntity.getServices());
        apiModelEntity.setPaths(apiEntity.getPaths());
        apiModelEntity.setPicture(apiEntity.getPicture());
        apiModelEntity.setPrimaryOwner(apiEntity.getPrimaryOwner());
        apiModelEntity.setProperties(apiEntity.getProperties());
        apiModelEntity.setProxy(this.convert(apiEntity.getProxy()));
        apiModelEntity.setLifecycleState(apiEntity.getLifecycleState());
        apiModelEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(apiId);
        if (metadataList != null) {
            HashMap mapMetadata = new HashMap(metadataList.size());
            metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
            apiModelEntity.setMetadata(mapMetadata);
            if (decodeTemplate) {
                try {
                    String decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(apiModelEntity.getId(), new StringReader(((Object)mapMetadata).toString()), Collections.singletonMap("api", apiModelEntity));
                    Map<String, String> metadataDecoded = Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=", 2)).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
                    apiModelEntity.setMetadata(metadataDecoded);
                }
                catch (Exception ex) {
                    throw new TechnicalManagementException("An error occurs while evaluating API metadata", ex);
                }
            }
        }
        return apiModelEntity;
    }

    @Override
    public boolean exists(String apiId) {
        try {
            return this.apiRepository.findById((Object)apiId).isPresent();
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while checking if the API exists: " + apiId;
            LOGGER.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public ApiEntity importPathMappingsFromPage(ApiEntity apiEntity, String page) {
        PageEntity pageEntity = this.pageService.findById(page);
        if (PageType.SWAGGER.name().equals(pageEntity.getType())) {
            ImportSwaggerDescriptorEntity importSwaggerDescriptorEntity = new ImportSwaggerDescriptorEntity();
            importSwaggerDescriptorEntity.setPayload(pageEntity.getContent());
            SwaggerApiEntity swaggerApiEntity = this.swaggerService.createAPI(importSwaggerDescriptorEntity);
            apiEntity.getPathMappings().addAll(swaggerApiEntity.getPathMappings());
        }
        return this.update(apiEntity.getId(), ApiService.convert(apiEntity));
    }

    @Override
    public Page<ApiEntity> search(ApiQuery query, Sortable sortable, Pageable pageable) {
        try {
            LOGGER.debug("Search paginated APIs by {}", (Object)query);
            Page<io.gravitee.repository.management.model.Api> apiPage = this.sortAndPaginate(this.apiRepository.search(this.queryToCriteria(query).build()), sortable, pageable);
            return new Page(this.convert(apiPage.getContent()), apiPage.getPageNumber(), (int)apiPage.getPageElements(), apiPage.getTotalElements());
        }
        catch (TechnicalException ex) {
            String errorMessage = "An error occurs while trying to search for paginated APIs: " + query;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    @Override
    public Collection<ApiEntity> search(ApiQuery query) {
        try {
            LOGGER.debug("Search APIs by {}", (Object)query);
            return this.filterApiByQuery(this.convert(this.apiRepository.search(this.queryToCriteria(query).build())).stream(), query).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String errorMessage = "An error occurs while trying to search for APIs: " + query;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    @Override
    public Collection<String> searchIds(ApiQuery query) {
        try {
            LOGGER.debug("Search API ids by {}", (Object)query);
            return this.apiRepository.search(this.queryToCriteria(query).build()).stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList());
        }
        catch (Exception ex) {
            String errorMessage = "An error occurs while trying to search for API ids: " + query;
            LOGGER.error(errorMessage, (Throwable)ex);
            throw new TechnicalManagementException(errorMessage, ex);
        }
    }

    @Override
    public Page<ApiEntity> search(String query, Map<String, Object> filters, Sortable sortable, Pageable pageable) {
        try {
            String[] apiIds;
            LOGGER.debug("Search paged APIs by {}", (Object)query);
            Query<ApiEntity> apiQuery = QueryBuilder.create(ApiEntity.class).setQuery(query).setFilters(filters).build();
            SearchResult matchApis = this.searchEngineService.search(apiQuery);
            Stream<Object> apiIdStream = matchApis.getDocuments().stream();
            if (filters.containsKey("api")) {
                List availableApis = (List)filters.get("api");
                apiIdStream = apiIdStream.filter(availableApis::contains);
            }
            if ((apiIds = (String[])apiIdStream.toArray(String[]::new)).length == 0) {
                return new Page(Collections.emptyList(), 0, 0, 0L);
            }
            ApiCriteria apiCriteria = new ApiCriteria.Builder().ids(apiIds).build();
            Page<io.gravitee.repository.management.model.Api> apiPage = this.sortAndPaginate(this.apiRepository.search(apiCriteria), sortable, pageable);
            List<ApiEntity> apis = this.convert(apiPage.getContent());
            return new Page(apis, apiPage.getPageNumber(), (int)apiPage.getPageElements(), apiPage.getTotalElements());
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to search paged apis", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to search paged apis", ex);
        }
    }

    @Override
    public Collection<ApiEntity> search(String query, Map<String, Object> filters) {
        Query<ApiEntity> apiQuery = QueryBuilder.create(ApiEntity.class).setQuery(query).setFilters(filters).build();
        SearchResult matchApis = this.searchEngineService.search(apiQuery);
        Stream<Object> apiIdStream = matchApis.getDocuments().stream();
        if (filters.containsKey("api")) {
            Set availableApis = (Set)filters.get("api");
            apiIdStream = apiIdStream.filter(availableApis::contains);
        }
        return apiIdStream.map(this::findById).collect(Collectors.toList());
    }

    @Override
    public List<ApiHeaderEntity> getPortalHeaders(String apiId) {
        List<ApiHeaderEntity> entities = this.apiHeaderService.findAll();
        ApiModelEntity apiEntity = this.findByIdForTemplates(apiId);
        HashMap<String, ApiModelEntity> model = new HashMap<String, ApiModelEntity>();
        model.put("api", apiEntity);
        entities.forEach(entity -> {
            if (entity.getValue().contains("${")) {
                String entityValue = this.notificationTemplateService.resolveInlineTemplateWithParam(entity.getId() + entity.getUpdatedAt().toString(), entity.getValue(), (Object)model);
                entity.setValue(entityValue);
            }
        });
        return entities.stream().filter(apiHeaderEntity -> apiHeaderEntity.getValue() != null && !apiHeaderEntity.getValue().isEmpty()).collect(Collectors.toList());
    }

    @Override
    public ApiEntity askForReview(String apiId, String userId, ReviewEntity reviewEntity) {
        LOGGER.debug("Ask for review API {}", (Object)apiId);
        return this.updateWorkflowReview(apiId, userId, ApiHook.ASK_FOR_REVIEW, WorkflowState.IN_REVIEW, reviewEntity.getMessage());
    }

    @Override
    public ApiEntity acceptReview(String apiId, String userId, ReviewEntity reviewEntity) {
        LOGGER.debug("Accept review API {}", (Object)apiId);
        return this.updateWorkflowReview(apiId, userId, ApiHook.REVIEW_OK, WorkflowState.REVIEW_OK, reviewEntity.getMessage());
    }

    @Override
    public ApiEntity rejectReview(String apiId, String userId, ReviewEntity reviewEntity) {
        LOGGER.debug("Reject review API {}", (Object)apiId);
        return this.updateWorkflowReview(apiId, userId, ApiHook.REQUEST_FOR_CHANGES, WorkflowState.REQUEST_FOR_CHANGES, reviewEntity.getMessage());
    }

    @Override
    public boolean hasHealthCheckEnabled(ApiEntity api, boolean mustBeEnabledOnAllEndpoints) {
        boolean globalHC;
        boolean bl = globalHC = api.getServices() != null && api.getServices().getAll() != null && api.getServices().getAll().stream().anyMatch(service -> service.isEnabled() && service instanceof HealthCheckService);
        if (globalHC) {
            return true;
        }
        Predicate<Endpoint> endpointHealthCheckEnabledPredicate = endpoint -> {
            if (endpoint instanceof HttpEndpoint) {
                return ((HttpEndpoint)endpoint).getHealthCheck() != null && ((HttpEndpoint)endpoint).getHealthCheck().isEnabled();
            }
            return false;
        };
        if (mustBeEnabledOnAllEndpoints) {
            return api.getProxy().getGroups().stream().allMatch(group -> group.getEndpoints().stream().allMatch(endpointHealthCheckEnabledPredicate));
        }
        return api.getProxy() != null && api.getProxy().getGroups() != null && api.getProxy().getGroups().stream().anyMatch(group -> group.getEndpoints() != null && group.getEndpoints().stream().anyMatch(endpointHealthCheckEnabledPredicate));
    }

    @Override
    public ApiEntity fetchMetadataForApi(ApiEntity apiEntity) {
        List<ApiMetadataEntity> metadataList = this.apiMetadataService.findAllByApi(apiEntity.getId());
        HashMap mapMetadata = new HashMap(metadataList.size());
        metadataList.forEach(metadata -> mapMetadata.put(metadata.getKey(), metadata.getValue() == null ? metadata.getDefaultValue() : metadata.getValue()));
        String decodedValue = this.notificationTemplateService.resolveInlineTemplateWithParam(apiEntity.getId(), new StringReader(((Object)mapMetadata).toString()), Collections.singletonMap("api", apiEntity));
        Map<String, Object> metadataDecoded = Arrays.stream(decodedValue.substring(1, decodedValue.length() - 1).split(", ")).map(entry -> entry.split("=")).collect(Collectors.toMap(entry -> entry[0], entry -> ((String[])entry).length > 1 ? entry[1] : ""));
        apiEntity.setMetadata(metadataDecoded);
        return apiEntity;
    }

    @Override
    public void addGroup(String apiId, String group) {
        try {
            io.gravitee.repository.management.model.Api api;
            HashSet<String> groups;
            LOGGER.debug("Add group {} to API {}", (Object)group, (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (GraviteeContext.getCurrentEnvironment() != null) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(GraviteeContext.getCurrentEnvironment()));
            }
            if ((groups = (api = optApi.orElseThrow(() -> new ApiNotFoundException(apiId))).getGroups()) == null) {
                groups = new HashSet<String>();
                api.setGroups(groups);
            }
            groups.add(group);
            this.apiRepository.update((Object)api);
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to add group {} to API {}: {}", new Object[]{group, apiId, ex});
            throw new TechnicalManagementException("An error occurs while trying to add group " + group + " to API " + apiId, ex);
        }
    }

    @Override
    public void removeGroup(String apiId, String group) {
        try {
            io.gravitee.repository.management.model.Api api;
            LOGGER.debug("Remove group {} to API {}", (Object)group, (Object)apiId);
            Optional<io.gravitee.repository.management.model.Api> optApi = this.apiRepository.findById((Object)apiId);
            if (GraviteeContext.getCurrentEnvironment() != null) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(GraviteeContext.getCurrentEnvironment()));
            }
            if ((api = optApi.orElseThrow(() -> new ApiNotFoundException(apiId))).getGroups() != null && api.getGroups().remove(group)) {
                this.apiRepository.update((Object)api);
            }
        }
        catch (TechnicalException ex) {
            LOGGER.error("An error occurs while trying to remove group {} from API {}: {}", new Object[]{group, apiId, ex});
            throw new TechnicalManagementException("An error occurs while trying to remove group " + group + " from API " + apiId, ex);
        }
    }

    private ApiEntity updateWorkflowReview(String apiId, String userId, ApiHook hook, WorkflowState workflowState, String workflowMessage) {
        Workflow workflow = this.workflowService.create(WorkflowReferenceType.API, apiId, WorkflowType.REVIEW, userId, workflowState, workflowMessage);
        ApiEntity apiEntity = this.findById(apiId);
        apiEntity.setWorkflowState(workflowState);
        UserEntity user = this.userService.findById(userId);
        this.notifierService.trigger(hook, apiId, new NotificationParamsBuilder().api(apiEntity).user(user).build());
        if (hook.equals(ApiHook.ASK_FOR_REVIEW)) {
            List<String> reviewersEmail = this.findAllReviewersEmail(apiId);
            this.emailService.sendAsyncEmailNotification(new EmailNotificationBuilder().params(new NotificationParamsBuilder().api(apiEntity).user(user).build()).to(reviewersEmail.toArray(new String[reviewersEmail.size()])).template(EmailNotificationBuilder.EmailTemplate.API_ASK_FOR_REVIEW).build(), GraviteeContext.getCurrentContext());
        }
        HashMap<Audit.AuditProperties, String> properties = new HashMap<Audit.AuditProperties, String>();
        properties.put(Audit.AuditProperties.USER, userId);
        properties.put(Audit.AuditProperties.API, apiId);
        Workflow.AuditEvent evtType = null;
        switch (workflowState) {
            case REQUEST_FOR_CHANGES: {
                evtType = Workflow.AuditEvent.API_REVIEW_REJECTED;
                break;
            }
            case REVIEW_OK: {
                evtType = Workflow.AuditEvent.API_REVIEW_ACCEPTED;
                break;
            }
            default: {
                evtType = Workflow.AuditEvent.API_REVIEW_ASKED;
            }
        }
        this.auditService.createApiAuditLog(apiId, properties, (Audit.AuditEvent)evtType, new Date(), null, workflow);
        return apiEntity;
    }

    private List<String> findAllReviewersEmail(String apiId) {
        RolePermissionAction[] acls = new RolePermissionAction[]{RolePermissionAction.UPDATE};
        Set reviewerEmails = this.roleService.findByScope(RoleScope.API).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.API, apiId, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(this.userService::findById).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet());
        Set groups = this.findById(apiId).getGroups();
        if (groups != null && !groups.isEmpty()) {
            groups.forEach(group -> reviewerEmails.addAll(this.roleService.findByScope(RoleScope.API).stream().filter(role -> this.roleService.hasPermission(role.getPermissions(), (Permission)ApiPermission.REVIEWS, acls)).flatMap(role -> this.membershipService.getMembershipsByReferenceAndRole(MembershipReferenceType.GROUP, (String)group, role.getId()).stream()).filter(m -> m.getMemberType().equals((Object)MembershipMemberType.USER)).map(MembershipEntity::getMemberId).distinct().map(this.userService::findById).map(UserEntity::getEmail).filter(Objects::nonNull).collect(Collectors.toSet())));
        }
        return new ArrayList<String>(reviewerEmails);
    }

    private ApiCriteria.Builder queryToCriteria(ApiQuery query) {
        ApiCriteria.Builder builder = new ApiCriteria.Builder().environmentId(GraviteeContext.getCurrentEnvironment());
        if (query == null) {
            return builder;
        }
        builder.label(query.getLabel()).name(query.getName()).version(query.getVersion());
        if (!StringUtils.isBlank((CharSequence)query.getCategory())) {
            builder.category(this.categoryService.findById(query.getCategory()).getId());
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            builder.groups(query.getGroups().toArray(new String[0]));
        }
        if (!StringUtils.isBlank((CharSequence)query.getState())) {
            builder.state(LifecycleState.valueOf((String)query.getState()));
        }
        if (query.getVisibility() != null) {
            builder.visibility(io.gravitee.repository.management.model.Visibility.valueOf((String)query.getVisibility().name()));
        }
        if (query.getLifecycleStates() != null) {
            builder.lifecycleStates(query.getLifecycleStates().stream().map(apiLifecycleState -> ApiLifecycleState.valueOf((String)apiLifecycleState.name())).collect(Collectors.toList()));
        }
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            builder.ids(query.getIds().toArray(new String[0]));
        }
        if (!StringUtils.isBlank((CharSequence)query.getContextPath())) {
            builder.contextPath(query.getContextPath());
        }
        return builder;
    }

    private void removeTag(String apiId, String tagId) throws TechnicalManagementException {
        try {
            io.gravitee.repository.management.model.Api api = this.findApiById(apiId);
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
            if (apiDefinition.getTags().remove(tagId)) {
                api.setDefinition(this.objectMapper.writeValueAsString((Object)apiDefinition));
                io.gravitee.repository.management.model.Api updated = (io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api);
                this.auditService.createApiAuditLog(api.getId(), Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, updated);
            }
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while removing tag from API: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while removing tag from API: " + apiId, ex);
        }
    }

    private ApiEntity updateLifecycle(String apiId, LifecycleState lifecycleState, String username) throws TechnicalException {
        Optional optApi = this.apiRepository.findById((Object)apiId);
        if (optApi.isPresent()) {
            io.gravitee.repository.management.model.Api api = (io.gravitee.repository.management.model.Api)optApi.get();
            io.gravitee.repository.management.model.Api previousApi = new io.gravitee.repository.management.model.Api(api);
            api.setUpdatedAt(new Date());
            api.setLifecycleState(lifecycleState);
            ApiEntity apiEntity = this.convert((io.gravitee.repository.management.model.Api)this.apiRepository.update((Object)api), this.getPrimaryOwner(api), null);
            this.auditService.createApiAuditLog(apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, api.getUpdatedAt(), previousApi, api);
            EventType eventType = null;
            switch (lifecycleState) {
                case STARTED: {
                    eventType = EventType.START_API;
                    break;
                }
                case STOPPED: {
                    eventType = EventType.STOP_API;
                    break;
                }
            }
            ApiEntity deployedApi = this.deployLastPublishedAPI(apiId, username, eventType);
            if (deployedApi != null) {
                return deployedApi;
            }
            return apiEntity;
        }
        throw new ApiNotFoundException(apiId);
    }

    private void auditApiLogging(io.gravitee.repository.management.model.Api apiToUpdate, io.gravitee.repository.management.model.Api apiUpdated) {
        try {
            Api apiToUpdateDefinition = (Api)this.objectMapper.readValue(apiToUpdate.getDefinition(), Api.class);
            Logging loggingToUpdate = apiToUpdateDefinition.getProxy().getLogging();
            Api apiUpdatedDefinition = (Api)this.objectMapper.readValue(apiUpdated.getDefinition(), Api.class);
            Logging loggingUpdated = apiUpdatedDefinition.getProxy().getLogging();
            if (loggingToUpdate == loggingUpdated || loggingToUpdate != null && loggingUpdated != null && Objects.equals(loggingToUpdate.getMode(), loggingUpdated.getMode()) && Objects.equals(loggingToUpdate.getCondition(), loggingUpdated.getCondition())) {
                return;
            }
            Api.AuditEvent auditEvent = (loggingToUpdate == null || loggingToUpdate.getMode().equals((Object)LoggingMode.NONE)) && !loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_ENABLED : (loggingToUpdate != null && !loggingToUpdate.getMode().equals((Object)LoggingMode.NONE) && loggingUpdated.getMode().equals((Object)LoggingMode.NONE) ? Api.AuditEvent.API_LOGGING_DISABLED : Api.AuditEvent.API_LOGGING_UPDATED);
            this.auditService.createApiAuditLog(apiUpdated.getId(), Collections.emptyMap(), (Audit.AuditEvent)auditEvent, new Date(), loggingToUpdate, loggingUpdated);
        }
        catch (Exception ex) {
            LOGGER.error("An error occurs while auditing API logging configuration for API: {}", (Object)apiUpdated.getId(), (Object)ex);
            throw new TechnicalManagementException("An error occurs while auditing API logging configuration for API: " + apiUpdated.getId(), ex);
        }
    }

    private List<ApiEntity> convert(List<io.gravitee.repository.management.model.Api> apis) throws TechnicalException {
        Set<String> groupIds;
        if (apis == null || apis.isEmpty()) {
            return Collections.emptyList();
        }
        RoleEntity primaryOwnerRole = this.roleService.findPrimaryOwnerRoleByOrganization(GraviteeContext.getCurrentOrganization(), RoleScope.API);
        if (primaryOwnerRole == null) {
            throw new RoleNotFoundException("API_PRIMARY_OWNER");
        }
        List<String> apiIds = apis.stream().map(io.gravitee.repository.management.model.Api::getId).collect(Collectors.toList());
        Set<MemberEntity> memberships = this.membershipService.getMembersByReferencesAndRole(MembershipReferenceType.API, apiIds, primaryOwnerRole.getId());
        int poMissing = apis.size() - memberships.size();
        Stream<Object> streamApis = apis.stream();
        if (poMissing > 0) {
            Set apiMembershipsIds = memberships.stream().map(MemberEntity::getReferenceId).collect(Collectors.toSet());
            apiIds.removeAll(apiMembershipsIds);
            Optional optionalApisAsString = apiIds.stream().reduce((a, b) -> a + " / " + b);
            String apisAsString = "?";
            if (optionalApisAsString.isPresent()) {
                apisAsString = (String)optionalApisAsString.get();
            }
            LOGGER.error("{} apis has no identified primary owners in this list {}.", (Object)poMissing, (Object)apisAsString);
            streamApis = streamApis.filter(api -> !apiIds.contains(api.getId()));
        }
        HashMap apiToMember = new HashMap(memberships.size());
        memberships.forEach(membership -> apiToMember.put(membership.getReferenceId(), membership.getId()));
        HashMap primaryOwnerIdToPrimaryOwnerEntity = new HashMap(memberships.size());
        List<String> userIds = memberships.stream().filter(membership -> membership.getType() == MembershipMemberType.USER).map(MemberEntity::getId).collect(Collectors.toList());
        if (userIds != null && !userIds.isEmpty()) {
            this.userService.findByIds(userIds).forEach(userEntity -> primaryOwnerIdToPrimaryOwnerEntity.put(userEntity.getId(), new PrimaryOwnerEntity(userEntity)));
        }
        if ((groupIds = memberships.stream().filter(membership -> membership.getType() == MembershipMemberType.GROUP).map(MemberEntity::getId).collect(Collectors.toSet())) != null && !groupIds.isEmpty()) {
            this.groupService.findByIds(groupIds).forEach(groupEntity -> primaryOwnerIdToPrimaryOwnerEntity.put(groupEntity.getId(), new PrimaryOwnerEntity(groupEntity)));
        }
        List<CategoryEntity> categories = this.categoryService.findAll();
        return streamApis.map(publicApi -> this.convert((io.gravitee.repository.management.model.Api)publicApi, (PrimaryOwnerEntity)primaryOwnerIdToPrimaryOwnerEntity.get(apiToMember.get(publicApi.getId())), categories)).collect(Collectors.toList());
    }

    private ApiEntity convert(io.gravitee.repository.management.model.Api api) {
        return this.convert(api, null, null);
    }

    private ApiEntity convert(io.gravitee.repository.management.model.Api api, PrimaryOwnerEntity primaryOwner, List<CategoryEntity> categories) {
        List<Workflow> workflows;
        ApiLifecycleState lifecycleState;
        LifecycleState state;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        apiEntity.setGroups(api.getGroups());
        apiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.setReferenceType(GraviteeContext.ReferenceContextType.ENVIRONMENT.name());
        apiEntity.setReferenceId(api.getEnvironmentId());
        if (api.getDefinition() != null) {
            try {
                Api apiDefinition = (Api)this.objectMapper.readValue(api.getDefinition(), Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                if (apiDefinition.getDefinitionVersion() != null) {
                    apiEntity.setGraviteeDefinitionVersion(apiDefinition.getDefinitionVersion().getLabel());
                }
                if (apiDefinition.getFlowMode() != null) {
                    apiEntity.setFlowMode(apiDefinition.getFlowMode());
                }
                if (DefinitionVersion.V2.equals((Object)apiDefinition.getDefinitionVersion())) {
                    apiEntity.setFlows(apiDefinition.getFlows());
                    apiEntity.setPlans(new ArrayList(apiDefinition.getPlans()));
                } else {
                    apiEntity.setFlows(null);
                    apiEntity.setPlans(null);
                }
                if (apiDefinition.getProxy().getVirtualHosts() != null && !apiDefinition.getProxy().getVirtualHosts().isEmpty()) {
                    apiEntity.setContextPath(((VirtualHost)apiDefinition.getProxy().getVirtualHosts().get(0)).getPath());
                }
                if (apiDefinition.getPathMappings() != null) {
                    apiEntity.setPathMappings(new HashSet(apiDefinition.getPathMappings().keySet()));
                }
                apiEntity.setResponseTemplates(apiDefinition.getResponseTemplates());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setLabels(api.getLabels());
        Set apiCategories = api.getCategories();
        if (apiCategories != null) {
            if (categories == null) {
                categories = this.categoryService.findAll();
            }
            HashSet newApiCategories = new HashSet(apiCategories.size());
            for (String apiView : apiCategories) {
                Optional<CategoryEntity> optionalView = categories.stream().filter(c -> apiView.equals(c.getId())).findAny();
                optionalView.ifPresent(category -> newApiCategories.add(category.getKey()));
            }
            apiEntity.setCategories(newApiCategories);
        }
        if ((state = api.getLifecycleState()) != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)state.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if (primaryOwner != null) {
            apiEntity.setPrimaryOwner(primaryOwner);
        }
        if ((lifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(io.gravitee.rest.api.model.api.ApiLifecycleState.valueOf((String)lifecycleState.name()));
        }
        if (this.parameterService.findAsBoolean(Key.API_REVIEW_ENABLED, api.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT) && (workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, api.getId(), WorkflowType.REVIEW)) != null && !workflows.isEmpty()) {
            apiEntity.setWorkflowState(WorkflowState.valueOf((String)workflows.get(0).getState()));
        }
        return apiEntity;
    }

    private io.gravitee.repository.management.model.Api convert(String apiId, UpdateApiEntity updateApiEntity, String apiDefinition) {
        io.gravitee.repository.management.model.Api api = new io.gravitee.repository.management.model.Api();
        api.setId(apiId);
        if (updateApiEntity.getVisibility() != null) {
            api.setVisibility(io.gravitee.repository.management.model.Visibility.valueOf((String)updateApiEntity.getVisibility().toString()));
        }
        api.setVersion(updateApiEntity.getVersion().trim());
        api.setName(updateApiEntity.getName().trim());
        api.setDescription(updateApiEntity.getDescription().trim());
        api.setPicture(updateApiEntity.getPicture());
        api.setBackground(updateApiEntity.getBackground());
        api.setDefinition(this.buildApiDefinition(apiId, apiDefinition, updateApiEntity));
        Set apiCategories = updateApiEntity.getCategories();
        if (apiCategories != null) {
            List<CategoryEntity> categories = this.categoryService.findAll();
            HashSet newApiCategories = new HashSet(apiCategories.size());
            for (String apiCategory : apiCategories) {
                Optional<CategoryEntity> optionalCategory = categories.stream().filter(c -> apiCategory.equals(c.getKey()) || apiCategory.equals(c.getId())).findAny();
                optionalCategory.ifPresent(category -> newApiCategories.add(category.getId()));
            }
            api.setCategories(newApiCategories);
        }
        if (updateApiEntity.getLabels() != null) {
            api.setLabels(new ArrayList(new HashSet(updateApiEntity.getLabels())));
        }
        api.setGroups(updateApiEntity.getGroups());
        api.setDisableMembershipNotifications(updateApiEntity.isDisableMembershipNotifications());
        if (updateApiEntity.getLifecycleState() != null) {
            api.setApiLifecycleState(ApiLifecycleState.valueOf((String)updateApiEntity.getLifecycleState().name()));
        }
        return api;
    }

    private LifecycleState convert(EventType eventType) {
        LifecycleState lifecycleState;
        switch (eventType) {
            case START_API: {
                lifecycleState = LifecycleState.STARTED;
                break;
            }
            case STOP_API: {
                lifecycleState = LifecycleState.STOPPED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown EventType " + eventType.toString() + " to convert EventType into Lifecycle");
            }
        }
        return lifecycleState;
    }

    private ProxyModelEntity convert(Proxy proxy) {
        ProxyModelEntity proxyModelEntity = new ProxyModelEntity();
        proxyModelEntity.setCors(proxy.getCors());
        proxyModelEntity.setFailover(proxy.getFailover());
        proxyModelEntity.setGroups(proxy.getGroups());
        proxyModelEntity.setLogging(proxy.getLogging());
        proxyModelEntity.setPreserveHost(proxy.isPreserveHost());
        proxyModelEntity.setStripContextPath(proxy.isStripContextPath());
        proxyModelEntity.setVirtualHosts(proxy.getVirtualHosts());
        if (proxy.getVirtualHosts() != null && !proxy.getVirtualHosts().isEmpty()) {
            proxyModelEntity.setContextPath(((VirtualHost)proxy.getVirtualHosts().get(0)).getPath());
        }
        return proxyModelEntity;
    }

    private Page<io.gravitee.repository.management.model.Api> sortAndPaginate(List<io.gravitee.repository.management.model.Api> apis, Sortable sortable, Pageable pageable) {
        Comparator<io.gravitee.repository.management.model.Api> comparator = this.buildApiComparator(sortable, pageable, apis);
        pageable = this.buildPageable(pageable);
        int totalCount = apis.size();
        int startIndex = (pageable.getPageNumber() - 1) * pageable.getPageSize();
        if (pageable.getPageNumber() < 1 || totalCount > 0 && startIndex >= totalCount) {
            throw new PaginationInvalidException();
        }
        List subsetApis = apis.stream().sorted(comparator).skip(startIndex).limit(pageable.getPageSize()).collect(Collectors.toList());
        return new Page(subsetApis, pageable.getPageNumber(), pageable.getPageSize(), (long)apis.size());
    }

    private Pageable buildPageable(Pageable pageable) {
        if (pageable == null) {
            return new PageableImpl(1, Integer.MAX_VALUE);
        }
        return pageable;
    }

    private Comparator<io.gravitee.repository.management.model.Api> buildApiComparator(Sortable sortable, Pageable pageable, List<io.gravitee.repository.management.model.Api> apis) {
        Comparator comparator = (api1, api2) -> 0;
        if (pageable != null) {
            comparator = Comparator.comparing(api -> api.getName().toLowerCase());
        }
        if (sortable != null) {
            comparator = Comparator.comparing(api -> api.getName().toLowerCase());
            if (sortable.getField().equalsIgnoreCase("virtual_hosts")) {
                HashMap apiDefinitions = new HashMap(apis.size());
                apis.stream().filter(api -> api.getDefinition() != null).forEach(api -> {
                    try {
                        apiDefinitions.put(api.getId(), (Api)this.objectMapper.readValue(api.getDefinition(), Api.class));
                    }
                    catch (JsonProcessingException jsonProcessingException) {
                        // empty catch block
                    }
                });
                comparator = (api1, api2) -> {
                    Api apiDefinition1 = (Api)apiDefinitions.get(api1.getId());
                    Api apiDefinition2 = (Api)apiDefinitions.get(api2.getId());
                    if (apiDefinition1 != null && apiDefinition2 != null && apiDefinition1.getProxy().getVirtualHosts() != null && !apiDefinition1.getProxy().getVirtualHosts().isEmpty() && apiDefinition2.getProxy().getVirtualHosts() != null && !apiDefinition2.getProxy().getVirtualHosts().isEmpty()) {
                        return ((VirtualHost)apiDefinition1.getProxy().getVirtualHosts().get(0)).getPath().toLowerCase().compareTo(((VirtualHost)apiDefinition2.getProxy().getVirtualHosts().get(0)).getPath().toLowerCase());
                    }
                    return api1.getName().toLowerCase().compareTo(api2.getName().toLowerCase());
                };
            }
            if (!sortable.isAscOrder()) {
                comparator = comparator.reversed();
            }
        }
        return comparator;
    }

    protected void encryptProperties(List<PropertyEntity> properties) {
        for (PropertyEntity property : properties) {
            if (!property.isEncryptable() || property.isEncrypted()) continue;
            try {
                property.setValue(this.dataEncryptor.encrypt(property.getValue()));
                property.setEncrypted(true);
            }
            catch (GeneralSecurityException e) {
                LOGGER.error("Error encrypting property value", (Throwable)e);
            }
        }
    }

    private static class MemberToImport {
        private String source;
        private String sourceId;
        private List<String> roles;
        private String role;

        public MemberToImport() {
        }

        public MemberToImport(String source, String sourceId, List<String> roles, String role) {
            this.source = source;
            this.sourceId = sourceId;
            this.roles = roles;
            this.role = role;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public void setRoles(List<String> roles) {
            this.roles = roles;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemberToImport that = (MemberToImport)o;
            return this.source.equals(that.source) && this.sourceId.equals(that.sourceId);
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = 31 * result + this.sourceId.hashCode();
            return result;
        }
    }

    class PageEntityTreeNode {
        PageEntity data;
        PageEntityTreeNode parent;
        List<PageEntityTreeNode> children;

        public PageEntityTreeNode(PageEntity data) {
            this.data = data;
            this.children = new LinkedList<PageEntityTreeNode>();
        }

        public PageEntityTreeNode addChild(PageEntity child) {
            PageEntityTreeNode childNode = new PageEntityTreeNode(child);
            childNode.parent = this;
            this.children.add(childNode);
            return childNode;
        }

        private PageEntityTreeNode findById(String id) {
            if (id.equals(this.data.getId())) {
                return this;
            }
            for (PageEntityTreeNode child : this.children) {
                PageEntityTreeNode result = child.findById(id);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        public void appendListToTree(List<PageEntity> pagesList) {
            ArrayList<PageEntity> orphans = new ArrayList<PageEntity>();
            for (PageEntity newPage : pagesList) {
                if (newPage.getParentId() == null || newPage.getParentId().isEmpty()) {
                    this.addChild(newPage);
                    continue;
                }
                PageEntityTreeNode parentNode = this.findById(newPage.getParentId());
                if (parentNode != null) {
                    parentNode.addChild(newPage);
                    continue;
                }
                orphans.add(newPage);
            }
            if (!orphans.isEmpty() && orphans.size() < pagesList.size()) {
                this.appendListToTree(orphans);
            }
        }
    }
}

