/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.spring;

import io.gravitee.common.event.Event;
import io.gravitee.common.event.EventListener;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.management.model.Parameter;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.JavaMailSenderImpl;

public class GraviteeJavaMailManager
implements EventListener<Key, Parameter> {
    private static final String EMAIL_PROPERTIES_PREFIX = "email.properties";
    private static final String MAILAPI_PROPERTIES_PREFIX = "mail.smtp.";
    private final ParameterService parameterService;
    private final Map<GraviteeContext.ReferenceContext, JavaMailSenderImpl> mailSenderByReference;

    public GraviteeJavaMailManager(ParameterService parameterService, EventManager eventManager) {
        this.parameterService = parameterService;
        this.mailSenderByReference = new ConcurrentHashMap<GraviteeContext.ReferenceContext, JavaMailSenderImpl>();
        eventManager.subscribeForEvents((EventListener)this, Key.class);
    }

    public JavaMailSender getOrCreateMailSender(String referenceId, ParameterReferenceType type) {
        GraviteeContext.ReferenceContext ref = GraviteeContext.getCurrentContext();
        JavaMailSenderImpl mailSender = this.getMailSenderByReference(ref);
        if (mailSender == null) {
            String password;
            String username;
            mailSender = new JavaMailSenderImpl();
            mailSender.setHost(this.parameterService.find(Key.EMAIL_HOST, referenceId, type));
            String port = this.parameterService.find(Key.EMAIL_PORT, referenceId, type);
            if (StringUtils.isNumeric((CharSequence)port)) {
                mailSender.setPort(Integer.parseInt(port));
            }
            if ((username = this.parameterService.find(Key.EMAIL_USERNAME, referenceId, type)) != null && !username.isEmpty()) {
                mailSender.setUsername(username);
            }
            if ((password = this.parameterService.find(Key.EMAIL_PASSWORD, referenceId, type)) != null && !password.isEmpty()) {
                mailSender.setPassword(password);
            }
            mailSender.setProtocol(this.parameterService.find(Key.EMAIL_PROTOCOL, referenceId, type));
            mailSender.setJavaMailProperties(this.loadProperties(referenceId, type));
            this.mailSenderByReference.put(ref, mailSender);
        }
        return mailSender;
    }

    public void onEvent(Event<Key, Parameter> event) {
        JavaMailSenderImpl mailSender = this.getMailSenderByReference(((Parameter)event.content()).getReferenceId(), ParameterReferenceType.valueOf((String)((Parameter)event.content()).getReferenceType().name()));
        if (mailSender != null) {
            switch ((Key)event.type()) {
                case EMAIL_HOST: {
                    mailSender.setHost(((Parameter)event.content()).getValue());
                    break;
                }
                case EMAIL_PORT: {
                    if (!StringUtils.isNumeric((CharSequence)((Parameter)event.content()).getValue())) break;
                    mailSender.setPort(Integer.parseInt(((Parameter)event.content()).getValue()));
                    break;
                }
                case EMAIL_USERNAME: {
                    if (((Parameter)event.content()).getValue() != null && !((Parameter)event.content()).getValue().isEmpty()) {
                        mailSender.setUsername(((Parameter)event.content()).getValue());
                        break;
                    }
                    mailSender.setUsername(null);
                    break;
                }
                case EMAIL_PASSWORD: {
                    if (((Parameter)event.content()).getValue() != null && !((Parameter)event.content()).getValue().isEmpty()) {
                        mailSender.setPassword(((Parameter)event.content()).getValue());
                        break;
                    }
                    mailSender.setPassword(null);
                    break;
                }
                case EMAIL_PROTOCOL: {
                    mailSender.setProtocol(((Parameter)event.content()).getValue());
                    break;
                }
                case EMAIL_PROPERTIES_AUTH_ENABLED: 
                case EMAIL_PROPERTIES_SSL_TRUST: 
                case EMAIL_PROPERTIES_STARTTLS_ENABLE: {
                    mailSender.getJavaMailProperties().setProperty(this.computeMailProperty(((Key)event.type()).key()), ((Parameter)event.content()).getValue());
                }
            }
        }
    }

    JavaMailSenderImpl getMailSenderByReference(GraviteeContext.ReferenceContext ref) {
        return this.mailSenderByReference.get(ref);
    }

    JavaMailSenderImpl getMailSenderByReference(String referenceId, ParameterReferenceType referenceType) {
        return this.getMailSenderByReference(new GraviteeContext.ReferenceContext(referenceId, GraviteeContext.ReferenceContextType.valueOf(referenceType.name())));
    }

    private String computeMailProperty(String graviteeProperty) {
        return MAILAPI_PROPERTIES_PREFIX + graviteeProperty.substring(EMAIL_PROPERTIES_PREFIX.length() + 1);
    }

    private Properties loadProperties(String referenceId, ParameterReferenceType referenceType) {
        Map<String, List<String>> parameters = this.parameterService.findAll(Arrays.asList(Key.EMAIL_PROPERTIES_AUTH_ENABLED, Key.EMAIL_PROPERTIES_STARTTLS_ENABLE, Key.EMAIL_PROPERTIES_SSL_TRUST), referenceId, referenceType);
        Properties properties = new Properties();
        parameters.forEach((key, value) -> {
            if (!value.isEmpty()) {
                properties.setProperty(this.computeMailProperty((String)key), (String)value.get(0));
            }
        });
        return properties;
    }
}

