/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.swagger.policy;

import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.policy.api.swagger.v2.SwaggerOperationVisitor;
import io.gravitee.policy.api.swagger.v3.OAIOperationVisitor;
import io.gravitee.rest.api.service.impl.swagger.policy.OAIOperationVisitorClassFinder;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitor;
import io.gravitee.rest.api.service.impl.swagger.policy.PolicyOperationVisitorManager;
import io.gravitee.rest.api.service.impl.swagger.policy.SwaggerOperationVisitorClassFinder;
import org.springframework.beans.factory.annotation.Autowired;

public class PolicyPluginHandler
extends io.gravitee.plugin.policy.internal.PolicyPluginHandler {
    @Autowired
    private PolicyOperationVisitorManager visitorManager;

    protected void register(PolicyPlugin policyPlugin) {
        Class oaiVisitor = new OAIOperationVisitorClassFinder().lookupFirst(policyPlugin.policy());
        Class swaggerVisitor = new SwaggerOperationVisitorClassFinder().lookupFirst(policyPlugin.policy());
        try {
            this.addVisitor(policyPlugin, (SwaggerOperationVisitor)this.createInstance(swaggerVisitor), (OAIOperationVisitor)this.createInstance(oaiVisitor));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addVisitor(PolicyPlugin policyPlugin, SwaggerOperationVisitor swaggerOperationVisitor, OAIOperationVisitor oaiOperationVisitor) {
        if (swaggerOperationVisitor != null && oaiOperationVisitor != null) {
            this.logger.info("Add a Swagger visitor for policy: id{}", (Object)policyPlugin.id());
            PolicyOperationVisitor visitor = new PolicyOperationVisitor();
            visitor.setId(policyPlugin.id());
            visitor.setName(policyPlugin.manifest().name());
            visitor.setSwaggerOperationVisitor(swaggerOperationVisitor);
            visitor.setOaiOperationVisitor(oaiOperationVisitor);
            this.visitorManager.add(visitor);
        }
    }

    private <T> T createInstance(Class<T> clazz) throws Exception {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            this.logger.error("Unable to instantiate class: {}", clazz, (Object)ex);
            throw ex;
        }
    }
}

