/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.HashMap;
import java.util.Map;

public class SubscriptionNotActiveException
extends AbstractManagementException {
    private final SubscriptionEntity subscription;

    public SubscriptionNotActiveException(SubscriptionEntity subscription) {
        this.subscription = subscription;
    }

    @Override
    public String getMessage() {
        return "Subscription [" + this.subscription.getId() + "] should be paused or accepted. Currently it is " + this.subscription.getStatus();
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getTechnicalCode() {
        return "subscription.closed";
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(){
            {
                this.put("subscription", SubscriptionNotActiveException.this.subscription.getId());
                this.put("status", SubscriptionNotActiveException.this.subscription.getStatus().name());
            }
        };
    }
}

