/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.search.lucene.transformer;

import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.search.Indexable;
import io.gravitee.rest.api.service.impl.search.lucene.DocumentTransformer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.springframework.stereotype.Component;

@Component
public class ApiDocumentTransformer
implements DocumentTransformer<ApiEntity> {
    private static final String FIELD_ID = "id";
    private static final String FIELD_TYPE = "type";
    private static final String FIELD_TYPE_VALUE = "api";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NAME_LOWERCASE = "name_lowercase";
    private static final String FIELD_NAME_SPLIT = "name_split";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_OWNER = "ownerName";
    private static final String FIELD_OWNER_MAIL = "ownerMail";
    private static final String FIELD_LABELS = "labels";
    private static final String FIELD_LABELS_SPLIT = "labels_split";
    private static final String FIELD_CATEGORIES = "categories";
    private static final String FIELD_CATEGORIES_SPLIT = "categories_split";
    private static final String FIELD_CREATED_AT = "createdAt";
    private static final String FIELD_UPDATED_AT = "updatedAt";
    private static final String FIELD_PATHS = "paths";
    private static final String FIELD_HOSTS = "hosts";
    private static final String FIELD_PATHS_SPLIT = "paths_split";
    private static final String FIELD_HOSTS_SPLIT = "hosts_split";
    private static final String FIELD_TAGS = "tags";
    private static final String FIELD_TAGS_SPLIT = "tags_split";
    private static final String FIELD_METADATA = "metadata";
    private static final String FIELD_METADATA_SPLIT = "metadata_split";

    @Override
    public Document transform(ApiEntity api) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("reference_type", api.getReferenceType(), Field.Store.NO));
        doc.add((IndexableField)new StringField("reference_id", api.getReferenceId(), Field.Store.NO));
        doc.add((IndexableField)new StringField(FIELD_ID, api.getId(), Field.Store.YES));
        doc.add((IndexableField)new StringField(FIELD_TYPE, FIELD_TYPE_VALUE, Field.Store.YES));
        if (api.getName() != null) {
            doc.add((IndexableField)new StringField(FIELD_NAME, api.getName(), Field.Store.NO));
            doc.add((IndexableField)new StringField(FIELD_NAME_LOWERCASE, api.getName().toLowerCase(), Field.Store.NO));
            doc.add((IndexableField)new TextField(FIELD_NAME_SPLIT, api.getName(), Field.Store.NO));
        }
        if (api.getDescription() != null) {
            doc.add((IndexableField)new TextField(FIELD_DESCRIPTION, api.getDescription(), Field.Store.NO));
        }
        if (api.getPrimaryOwner() != null) {
            doc.add((IndexableField)new TextField(FIELD_OWNER, api.getPrimaryOwner().getDisplayName(), Field.Store.NO));
            if (api.getPrimaryOwner().getEmail() != null) {
                doc.add((IndexableField)new TextField(FIELD_OWNER_MAIL, api.getPrimaryOwner().getEmail(), Field.Store.NO));
            }
        }
        if (api.getProxy() != null) {
            api.getProxy().getVirtualHosts().forEach(virtualHost -> {
                doc.add((IndexableField)new StringField(FIELD_PATHS, virtualHost.getPath(), Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_PATHS_SPLIT, virtualHost.getPath(), Field.Store.NO));
                if (virtualHost.getHost() != null && !virtualHost.getHost().isEmpty()) {
                    doc.add((IndexableField)new StringField(FIELD_HOSTS, virtualHost.getHost(), Field.Store.NO));
                    doc.add((IndexableField)new TextField(FIELD_HOSTS_SPLIT, virtualHost.getHost(), Field.Store.NO));
                }
            });
        }
        if (api.getLabels() != null) {
            for (String label : api.getLabels()) {
                doc.add((IndexableField)new StringField(FIELD_LABELS, label, Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_LABELS_SPLIT, label, Field.Store.NO));
            }
        }
        if (api.getCategories() != null) {
            for (String category : api.getCategories()) {
                doc.add((IndexableField)new StringField(FIELD_CATEGORIES, category, Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_CATEGORIES_SPLIT, category, Field.Store.NO));
            }
        }
        if (api.getTags() != null) {
            for (String tag : api.getTags()) {
                doc.add((IndexableField)new StringField(FIELD_TAGS, tag, Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_TAGS_SPLIT, tag, Field.Store.NO));
            }
        }
        if (api.getCreatedAt() != null) {
            doc.add((IndexableField)new LongPoint(FIELD_CREATED_AT, new long[]{api.getCreatedAt().getTime()}));
        }
        if (api.getUpdatedAt() != null) {
            doc.add((IndexableField)new LongPoint(FIELD_UPDATED_AT, new long[]{api.getUpdatedAt().getTime()}));
        }
        if (api.getMetadata() != null) {
            api.getMetadata().values().forEach(metadataValue -> {
                doc.add((IndexableField)new StringField(FIELD_METADATA, metadataValue.toString(), Field.Store.NO));
                doc.add((IndexableField)new TextField(FIELD_METADATA_SPLIT, metadataValue.toString(), Field.Store.NO));
            });
        }
        return doc;
    }

    @Override
    public boolean handle(Class<? extends Indexable> source) {
        return ApiEntity.class.isAssignableFrom(source);
    }
}

