/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.rest.api.model.AccessControlReferenceType;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MemberEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PageEntity;
import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.Permission;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.AccessControlService;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessControlServiceImpl
extends AbstractService
implements AccessControlService {
    private final Logger logger = LoggerFactory.getLogger(AccessControlServiceImpl.class);
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private ApiService apiService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PermissionService permissionService;

    @Override
    public boolean canAccessApiFromPortal(ApiEntity apiEntity) {
        if (Visibility.PUBLIC.equals((Object)apiEntity.getVisibility())) {
            return true;
        }
        if (this.isAuthenticated()) {
            ApiQuery apiQuery = new ApiQuery();
            apiQuery.setIds(Collections.singletonList(apiEntity.getId()));
            Set<ApiEntity> publishedByUser = this.apiService.findPublishedByUser(this.getAuthenticatedUser().getUsername(), apiQuery);
            return publishedByUser.contains(apiEntity);
        }
        return false;
    }

    @Override
    public boolean canAccessApiFromPortal(String apiId) {
        ApiEntity apiEntity = this.apiService.findById(apiId);
        return this.canAccessApiFromPortal(apiEntity);
    }

    private boolean canAccessPage(ApiEntity apiEntity, PageEntity pageEntity) {
        if (!pageEntity.isPublished()) {
            return false;
        }
        if (Visibility.PUBLIC.equals((Object)pageEntity.getVisibility())) {
            return true;
        }
        if (!this.isAuthenticated()) {
            return false;
        }
        Set accessControls = pageEntity.getAccessControls();
        if (accessControls == null || accessControls.isEmpty()) {
            return true;
        }
        Set<GroupEntity> userGroups = this.groupService.findByUser(this.getAuthenticatedUsername());
        Set<RoleEntity> contextualUserRoles = this.getContextualUserRoles(apiEntity);
        return accessControls.stream().anyMatch(acl -> {
            if (AccessControlReferenceType.ROLE.name().equals(acl.getReferenceType())) {
                boolean roleMatched = contextualUserRoles.stream().anyMatch(role -> role.getId().equals(acl.getReferenceId()));
                return pageEntity.isExcludedAccessControls() ? !roleMatched : roleMatched;
            }
            if (AccessControlReferenceType.GROUP.name().equals(acl.getReferenceType())) {
                boolean groupMatched = userGroups.stream().anyMatch(group -> group.getId().equals(acl.getReferenceId()));
                return pageEntity.isExcludedAccessControls() ? !groupMatched : groupMatched;
            }
            this.logger.warn("ACL reference type [{}] not found", (Object)acl.getReferenceType());
            return false;
        });
    }

    @Override
    public boolean canAccessPageFromPortal(PageEntity pageEntity) {
        return this.canAccessPageFromPortal(null, pageEntity);
    }

    @Override
    public boolean canAccessPageFromPortal(String apiId, PageEntity pageEntity) {
        if (PageType.SYSTEM_FOLDER.name().equals(pageEntity.getType()) || PageType.MARKDOWN_TEMPLATE.name().equals(pageEntity.getType())) {
            return false;
        }
        if (apiId != null) {
            ApiEntity apiEntity = this.apiService.findById(apiId);
            return this.canAccessPage(apiEntity, pageEntity);
        }
        return this.canAccessPage(null, pageEntity);
    }

    @Override
    public boolean canAccessPageFromConsole(PageEntity pageEntity) {
        if (this.canEditEnvPage()) {
            return true;
        }
        return this.canAccessPage(null, pageEntity);
    }

    @Override
    public boolean canAccessPageFromConsole(ApiEntity apiEntity, PageEntity pageEntity) {
        if (this.canAccessPage(apiEntity, pageEntity)) {
            return true;
        }
        return this.canEditApiPage(apiEntity);
    }

    private boolean canEditEnvPage() {
        return this.isAuthenticated() && (this.isAdmin() || this.permissionService.hasPermission(RolePermission.ENVIRONMENT_DOCUMENTATION, null, RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE));
    }

    private boolean canEditApiPage(ApiEntity api) {
        if (api == null) {
            return false;
        }
        boolean canEditApiPage = false;
        MemberEntity member = this.membershipService.getUserMember(MembershipReferenceType.API, api.getId(), this.getAuthenticatedUsername());
        if (member == null && api.getGroups() != null) {
            Iterator groupIdIterator = api.getGroups().iterator();
            while (!canEditApiPage && groupIdIterator.hasNext()) {
                String groupId = (String)groupIdIterator.next();
                member = this.membershipService.getUserMember(MembershipReferenceType.GROUP, groupId, this.getAuthenticatedUsername());
                canEditApiPage = this.canEditApiPage(member);
            }
        } else {
            canEditApiPage = this.canEditApiPage(member);
        }
        return canEditApiPage;
    }

    private boolean canEditApiPage(MemberEntity member) {
        if (member == null) {
            return false;
        }
        return this.roleService.hasPermission(member.getPermissions(), (Permission)ApiPermission.DOCUMENTATION, new RolePermissionAction[]{RolePermissionAction.UPDATE, RolePermissionAction.CREATE, RolePermissionAction.DELETE});
    }

    private Set<RoleEntity> getContextualUserRoles(ApiEntity api) {
        if (api != null) {
            Set<RoleEntity> roles = this.membershipService.getRoles(MembershipReferenceType.API, api.getId(), MembershipMemberType.USER, this.getAuthenticatedUsername());
            if (api.getGroups() != null && !api.getGroups().isEmpty()) {
                api.getGroups().forEach(groupId -> {
                    MemberEntity member = this.membershipService.getUserMember(MembershipReferenceType.GROUP, (String)groupId, this.getAuthenticatedUsername());
                    if (member != null) {
                        roles.addAll(member.getRoles());
                    }
                });
            }
            return roles;
        }
        return this.membershipService.getRoles(MembershipReferenceType.ENVIRONMENT, GraviteeContext.getCurrentEnvironment(), MembershipMemberType.USER, this.getAuthenticatedUsername());
    }
}

