/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.flow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.flow.Consumer;
import io.gravitee.definition.model.flow.ConsumerType;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.flow.Operator;
import io.gravitee.definition.model.flow.PathOperator;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.model.flow.FlowConsumer;
import io.gravitee.repository.management.model.flow.FlowConsumerType;
import io.gravitee.repository.management.model.flow.FlowOperator;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.repository.management.model.flow.FlowStep;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowServiceImpl
extends AbstractService
implements FlowService {
    private final Logger LOGGER = LoggerFactory.getLogger(FlowServiceImpl.class);
    @Autowired
    private FlowRepository flowRepository;
    @Autowired
    private TagService tagService;

    private String getFileContent(String path) {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(path);
            return IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new TechnicalManagementException("An error occurs while trying load flow configuration", e);
        }
    }

    @Override
    public String getConfigurationSchemaForm() {
        return this.getFileContent("/flow/configuration-schema-form.json");
    }

    @Override
    public String getApiFlowSchemaForm() {
        return this.getFileContent("/flow/api-flow-schema-form.json");
    }

    @Override
    public String getPlatformFlowSchemaForm() {
        this.LOGGER.debug("Get platform schema form");
        String fileContent = this.getFileContent("/flow/platform-flow-schema-form.json");
        List<TagEntity> tags = this.tagService.findByReference(GraviteeContext.getCurrentOrganization(), TagReferenceType.ORGANIZATION);
        if (tags.size() > 0) {
            this.LOGGER.debug("Append {} tag(s) to platform schema form", (Object)tags.size());
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonSchema = mapper.readTree(fileContent);
                ObjectNode consumers = (ObjectNode)jsonSchema.get("properties").get("consumers");
                ArrayNode enumNode = (ArrayNode)consumers.get("items").get("enum");
                HashMap titleMap = new HashMap();
                tags.forEach(tagEntity -> titleMap.put(tagEntity.getId(), tagEntity.getName()));
                titleMap.keySet().forEach(arg_0 -> ((ArrayNode)enumNode).add(arg_0));
                JsonNode titleMapNode = mapper.valueToTree(titleMap);
                ObjectNode xSchemaForm = mapper.createObjectNode();
                consumers.set("x-schema-form", (JsonNode)xSchemaForm);
                xSchemaForm.set("titleMap", titleMapNode);
                return jsonSchema.toPrettyString();
            }
            catch (JsonProcessingException ex) {
                String error = "An error occurs while append tags to platform flow schema form";
                this.LOGGER.error("An error occurs while append tags to platform flow schema form", (Throwable)ex);
                throw new TechnicalManagementException("An error occurs while append tags to platform flow schema form", ex);
            }
        }
        return fileContent;
    }

    @Override
    public List<Flow> findByReference(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            this.LOGGER.debug("Find flows by reference {} - {}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(flow -> {
                Flow f = new Flow();
                f.setPost(flow.getPost().stream().map(this::convert).collect(Collectors.toList()));
                f.setPre(flow.getPre().stream().map(this::convert).collect(Collectors.toList()));
                PathOperator pathOperator = new PathOperator();
                pathOperator.setPath(flow.getPath());
                pathOperator.setOperator(Operator.valueOf((String)flow.getOperator().name()));
                f.setPathOperator(pathOperator);
                f.setName(flow.getName());
                f.setMethods(flow.getMethods());
                f.setEnabled(flow.isEnabled());
                f.setCondition(flow.getCondition());
                f.setConsumers(flow.getConsumers().stream().map(this::convert).collect(Collectors.toList()));
                return f;
            }).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while find flows by reference";
            this.LOGGER.error("An error occurs while find flows by reference", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while find flows by reference", ex);
        }
    }

    @Override
    public List<Flow> save(FlowReferenceType flowReferenceType, String referenceId, List<Flow> flows) {
        try {
            this.LOGGER.debug("Save flows for reference {},{}", (Object)flowReferenceType, (Object)flowReferenceType);
            this.flowRepository.deleteByReference(flowReferenceType, referenceId);
            if (flows != null) {
                ArrayList<Flow> savedFlows = new ArrayList<Flow>();
                int flowOrder = 0;
                for (Flow flow : flows) {
                    io.gravitee.repository.management.model.flow.Flow convertedFlow = this.convert(flowReferenceType, referenceId, flow);
                    convertedFlow.setOrder(flowOrder++);
                    io.gravitee.repository.management.model.flow.Flow savedFlow = (io.gravitee.repository.management.model.flow.Flow)this.flowRepository.create((Object)convertedFlow);
                    savedFlows.add(this.convert(savedFlow));
                }
            }
            return flows;
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while save flows";
            this.LOGGER.error("An error occurs while save flows", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while save flows", ex);
        }
    }

    private Flow convert(io.gravitee.repository.management.model.flow.Flow model) {
        Flow flow = new Flow();
        flow.setCondition(model.getCondition());
        flow.setEnabled(model.isEnabled());
        flow.setMethods(model.getMethods());
        flow.setName(model.getName());
        PathOperator pathOperator = new PathOperator();
        pathOperator.setPath(model.getPath());
        pathOperator.setOperator(Operator.valueOf((String)model.getOperator().name()));
        flow.setPathOperator(pathOperator);
        flow.setPre(model.getPre().stream().map(this::convert).collect(Collectors.toList()));
        flow.setPost(model.getPost().stream().map(this::convert).collect(Collectors.toList()));
        flow.setConsumers(model.getConsumers().stream().map(this::convert).collect(Collectors.toList()));
        return flow;
    }

    private FlowConsumer convertConsumer(Consumer consumer) {
        FlowConsumer flowConsumer = new FlowConsumer();
        flowConsumer.setConsumerId(consumer.getConsumerId());
        flowConsumer.setConsumerType(FlowConsumerType.valueOf((String)consumer.getConsumerType().name()));
        return flowConsumer;
    }

    private Consumer convert(FlowConsumer flowConsumer) {
        Consumer consumer = new Consumer();
        consumer.setConsumerId(flowConsumer.getConsumerId());
        consumer.setConsumerType(ConsumerType.valueOf((String)flowConsumer.getConsumerType().name()));
        return consumer;
    }

    private io.gravitee.repository.management.model.flow.Flow convert(FlowReferenceType flowReferenceType, String referenceId, Flow flow) {
        io.gravitee.repository.management.model.flow.Flow f = new io.gravitee.repository.management.model.flow.Flow();
        f.setReferenceType(flowReferenceType);
        f.setReferenceId(referenceId);
        f.setPost(flow.getPost().stream().map(this::convertStep).collect(Collectors.toList()));
        f.setPre(flow.getPre().stream().map(this::convertStep).collect(Collectors.toList()));
        f.setPath(flow.getPath());
        f.setOperator(FlowOperator.valueOf((String)flow.getOperator().name()));
        f.setName(flow.getName());
        f.setMethods(flow.getMethods());
        f.setEnabled(flow.isEnabled());
        f.setCondition(flow.getCondition());
        f.setConsumers(flow.getConsumers().stream().map(this::convertConsumer).collect(Collectors.toList()));
        return f;
    }

    private FlowStep convertStep(Step step) {
        FlowStep flowStep = new FlowStep();
        flowStep.setPolicy(step.getPolicy());
        flowStep.setName(step.getName());
        flowStep.setEnabled(step.isEnabled());
        flowStep.setConfiguration(step.getConfiguration());
        flowStep.setDescription(step.getDescription());
        return flowStep;
    }

    private Step convert(FlowStep flowStep) {
        Step step = new Step();
        step.setPolicy(flowStep.getPolicy());
        step.setName(flowStep.getName());
        step.setEnabled(flowStep.isEnabled());
        step.setConfiguration(flowStep.getConfiguration());
        step.setDescription(flowStep.getDescription());
        return step;
    }
}

