/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.exceptions;

import io.gravitee.rest.api.model.PageType;
import io.gravitee.rest.api.service.exceptions.AbstractManagementException;
import java.util.Map;

public class PageActionException
extends AbstractManagementException {
    private final String action;
    private final String pageType;

    public PageActionException(PageType pageType, String action) {
        this.action = action;
        this.pageType = pageType.name().toLowerCase();
    }

    @Override
    public int getHttpStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        return "This " + this.pageType + " page can not " + this.action;
    }

    @Override
    public String getTechnicalCode() {
        return "page." + this.pageType + ".invalid";
    }

    @Override
    public Map<String, String> getParameters() {
        return null;
    }
}

