/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade;

import io.gravitee.repository.management.api.search.UserCriteria;
import io.gravitee.repository.management.model.UserStatus;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.PageableImpl;
import io.gravitee.rest.api.service.Upgrader;
import io.gravitee.rest.api.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class DefaultUserStatusUpgrader
implements Upgrader,
Ordered {
    private final Logger logger = LoggerFactory.getLogger(DefaultUserStatusUpgrader.class);
    @Autowired
    private UserService userService;

    @Override
    public boolean upgrade() {
        UpdateUserEntity updateUserEntity = new UpdateUserEntity();
        updateUserEntity.setStatus(UserStatus.ACTIVE.name());
        this.userService.search(new UserCriteria.Builder().noStatus().build(), (Pageable)new PageableImpl(1, Integer.MAX_VALUE)).getContent().forEach(userEntity -> {
            if (userEntity.getStatus() == null) {
                this.userService.update(userEntity.getId(), updateUserEntity);
            }
        });
        return true;
    }

    @Override
    public int getOrder() {
        return 200;
    }
}

