/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.ListProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.MethodInfo;
import io.github.classgraph.MethodInfoList;
import io.github.classgraph.ScanResult;
import io.gravitee.definition.model.Policy;
import io.gravitee.definition.model.flow.Step;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.policy.PolicyClassLoaderFactory;
import io.gravitee.plugin.policy.PolicyPlugin;
import io.gravitee.policy.api.annotations.OnRequest;
import io.gravitee.policy.api.annotations.OnRequestContent;
import io.gravitee.policy.api.annotations.OnResponse;
import io.gravitee.policy.api.annotations.OnResponseContent;
import io.gravitee.policy.api.annotations.RequireResource;
import io.gravitee.rest.api.model.PluginEntity;
import io.gravitee.rest.api.model.PolicyDevelopmentEntity;
import io.gravitee.rest.api.model.PolicyEntity;
import io.gravitee.rest.api.service.PolicyService;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.impl.AbstractPluginService;
import io.gravitee.rest.api.service.validator.PolicyHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolicyServiceImpl
extends AbstractPluginService<PolicyPlugin, PolicyEntity>
implements PolicyService {
    @Autowired
    private JsonSchemaFactory jsonSchemaFactory;
    @Autowired
    private PolicyClassLoaderFactory policyClassLoaderFactory;
    private final Map<String, PolicyDevelopmentEntity> policies = new ConcurrentHashMap<String, PolicyDevelopmentEntity>();

    @Override
    public Set<PolicyEntity> findAll(Boolean withResource) {
        Stream<Object> policies = super.list().stream();
        if (Boolean.FALSE.equals(withResource)) {
            policies = policies.filter(policyPlugin -> !policyPlugin.policy().isAnnotationPresent(RequireResource.class));
        }
        return policies.map(policyDefinition -> this.convert((PolicyPlugin)policyDefinition, true)).collect(Collectors.toSet());
    }

    @Override
    public Set<PolicyEntity> findAll() {
        return this.findAll(true);
    }

    @Override
    public PolicyEntity findById(String policyId) {
        PolicyPlugin policyDefinition = (PolicyPlugin)super.get(policyId);
        return this.convert(policyDefinition, true);
    }

    private String validatePolicyConfiguration(String policyName, String configuration) {
        if (policyName != null && configuration != null) {
            String schema = this.getSchema(policyName);
            try {
                String safePolicyConfiguration = PolicyHelper.clearNullValues(configuration);
                JsonNode jsonConfiguration = JsonLoader.fromString((String)safePolicyConfiguration);
                if (schema != null && !schema.equals("")) {
                    JsonNode jsonSchema = JsonLoader.fromString((String)schema);
                    ListProcessingReport report = (ListProcessingReport)this.jsonSchemaFactory.getValidator().validate(jsonSchema, jsonConfiguration, true);
                    if (!report.isSuccess()) {
                        boolean hasDefaultValue = false;
                        Object msg = "";
                        if (report.iterator().hasNext()) {
                            msg = " : " + ((ProcessingMessage)report.iterator().next()).getMessage();
                            Pattern pattern = Pattern.compile("\\(\\[\\\"(.*?)\\\"\\]\\)");
                            Matcher matcher = pattern.matcher((CharSequence)msg);
                            if (matcher.find()) {
                                String field = matcher.group(1);
                                JsonNode properties = jsonSchema.get("properties");
                                boolean bl = hasDefaultValue = properties != null && properties.get(field) != null && properties.get(field).get("default") != null;
                            }
                        }
                        if (!hasDefaultValue) {
                            throw new InvalidDataException("Invalid policy configuration" + (String)msg);
                        }
                    }
                }
                return safePolicyConfiguration;
            }
            catch (ProcessingException | IOException e) {
                throw new InvalidDataException("Unable to validate policy configuration", e);
            }
        }
        return configuration;
    }

    @Override
    public void validatePolicyConfiguration(Step step) {
        if (step != null) {
            step.setConfiguration(this.validatePolicyConfiguration(step.getPolicy(), step.getConfiguration()));
        }
    }

    @Override
    public void validatePolicyConfiguration(Policy policy) {
        if (policy != null) {
            policy.setConfiguration(this.validatePolicyConfiguration(policy.getName(), policy.getConfiguration()));
        }
    }

    private PolicyEntity convert(PolicyPlugin policyPlugin, Boolean withPlugin) {
        PolicyEntity entity = new PolicyEntity();
        entity.setId(policyPlugin.id());
        entity.setDescription(policyPlugin.manifest().description());
        entity.setName(policyPlugin.manifest().name());
        entity.setVersion(policyPlugin.manifest().version());
        entity.setCategory(policyPlugin.manifest().category());
        if (withPlugin.booleanValue()) {
            PluginEntity pluginEntity = new PluginEntity();
            pluginEntity.setPlugin(policyPlugin.clazz());
            pluginEntity.setPath(policyPlugin.path().toString());
            pluginEntity.setType(policyPlugin.type().toLowerCase());
            pluginEntity.setDependencies(policyPlugin.dependencies());
            entity.setPlugin(pluginEntity);
            entity.setDevelopment(this.loadPolicy(policyPlugin));
        }
        return entity;
    }

    private PolicyDevelopmentEntity loadPolicy(final PolicyPlugin policy) {
        return this.policies.computeIfAbsent(policy.id(), new Function<String, PolicyDevelopmentEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PolicyDevelopmentEntity apply(String s) {
                PolicyDevelopmentEntity developmentEntity = new PolicyDevelopmentEntity();
                developmentEntity.setClassName(policy.policy().getName());
                ScanResult scan = null;
                PluginClassLoader policyClassLoader = null;
                try {
                    policyClassLoader = PolicyServiceImpl.this.policyClassLoaderFactory.getOrCreateClassLoader(policy);
                    scan = new ClassGraph().enableMethodInfo().enableAnnotationInfo().acceptClasses(new String[]{policy.policy().getName()}).ignoreParentClassLoaders().overrideClassLoaders(new ClassLoader[]{policyClassLoader}).scan(1);
                    MethodInfoList methodInfo = scan.getClassInfo(policy.policy().getName()).getMethodInfo();
                    MethodInfoList filter = methodInfo.filter(methodInfo1 -> methodInfo1.hasAnnotation(OnRequest.class.getName()) || methodInfo1.hasAnnotation(OnRequestContent.class.getName()));
                    if (!filter.isEmpty()) {
                        developmentEntity.setOnRequestMethod(((MethodInfo)filter.get(0)).getName());
                    }
                    if (!(filter = methodInfo.filter(methodInfo12 -> methodInfo12.hasAnnotation(OnResponse.class.getName()) || methodInfo12.hasAnnotation(OnResponseContent.class.getName()))).isEmpty()) {
                        developmentEntity.setOnResponseMethod(((MethodInfo)filter.get(0)).getName());
                    }
                    PolicyDevelopmentEntity policyDevelopmentEntity = developmentEntity;
                    return policyDevelopmentEntity;
                }
                catch (Throwable ex) {
                    PolicyServiceImpl.this.logger.error("An unexpected error occurs while loading policy", ex);
                    PolicyDevelopmentEntity policyDevelopmentEntity = null;
                    return policyDevelopmentEntity;
                }
                finally {
                    if (policyClassLoader != null) {
                        try {
                            policyClassLoader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (scan != null) {
                        scan.close();
                    }
                }
            }
        });
    }
}

