/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.filter;

import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.security.filter.error.ErrorHelper;
import io.gravitee.rest.api.service.common.GraviteeContext;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.web.filter.GenericFilterBean;

public class GraviteeContextAuthorizationFilter
extends GenericFilterBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraviteeContextAuthorizationFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserDetails userDetails;
        log.debug("Check if authenticated user is associated to the resolved GraviteeContext");
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String organizationId = GraviteeContext.getCurrentOrganization();
        UsernamePasswordAuthenticationToken principal = (UsernamePasswordAuthenticationToken)httpServletRequest.getUserPrincipal();
        UserDetails userDetails2 = userDetails = Objects.isNull(principal) ? null : (UserDetails)principal.getPrincipal();
        if (Objects.nonNull(userDetails)) {
            if (Objects.isNull(userDetails.getOrganizationId())) {
                ErrorHelper.sendError(httpServletResponse, 403, "No organization associated to user");
                return;
            }
            if (organizationId != null && !organizationId.equals(userDetails.getOrganizationId())) {
                ErrorHelper.sendError(httpServletResponse, 403, "User is not allowed to access this organization");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    @Generated
    public GraviteeContextAuthorizationFilter() {
    }
}

