/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.cors;

import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.security.cors.GraviteeCorsConfiguration;
import io.gravitee.rest.api.service.ParameterService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.env.Environment;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public abstract class AbstractGraviteeUrlBasedCorsConfigurationSource
extends UrlBasedCorsConfigurationSource {
    private final Map<String, CorsConfiguration> corsConfigurationByOrganization = new ConcurrentHashMap<String, CorsConfiguration>();
    private final Environment environment;
    private final ParameterService parameterService;
    private final InstallationAccessQueryService installationAccessQueryService;
    private final EventManager eventManager;
    private final ParameterReferenceType parameterReferenceType;

    public CorsConfiguration getCorsConfiguration(@NonNull HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        String referenceId = this.getReferenceId();
        if (referenceId == null) {
            referenceId = "undefined";
        }
        return this.corsConfigurationByOrganization.computeIfAbsent(referenceId, id -> new GraviteeCorsConfiguration(this.environment, this.parameterService, this.installationAccessQueryService, this.eventManager, (String)id, this.parameterReferenceType));
    }

    protected abstract String getReferenceId();

    @Generated
    public AbstractGraviteeUrlBasedCorsConfigurationSource(Environment environment, ParameterService parameterService, InstallationAccessQueryService installationAccessQueryService, EventManager eventManager, ParameterReferenceType parameterReferenceType) {
        this.environment = environment;
        this.parameterService = parameterService;
        this.installationAccessQueryService = installationAccessQueryService;
        this.eventManager = eventManager;
        this.parameterReferenceType = parameterReferenceType;
    }
}

