/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.repository.healthcheck;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.repository.analytics.api.AnalyticsRepository;
import io.gravitee.repository.analytics.query.Query;
import io.gravitee.repository.analytics.query.count.CountQuery;
import io.gravitee.repository.common.query.QueryContext;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;

public class AnalyticsRepositoryProbe
implements Probe {
    @Autowired
    private AnalyticsRepository analyticsRepository;
    @Autowired
    private Vertx vertx;

    public String id() {
        return "repository-analytics";
    }

    public CompletionStage<Result> check() {
        return this.vertx.executeBlocking(() -> {
            try {
                this.analyticsRepository.query(new QueryContext("DEFAULT", "DEFAULT"), (Query)new CountQuery());
                return Result.healthy();
            }
            catch (Exception ex) {
                return Result.unhealthy((Throwable)ex);
            }
        }).toCompletionStage();
    }

    @Generated
    public void setAnalyticsRepository(AnalyticsRepository analyticsRepository) {
        this.analyticsRepository = analyticsRepository;
    }

    @Generated
    public void setVertx(Vertx vertx) {
        this.vertx = vertx;
    }
}

