/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.repository.healthcheck;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.gravitee.repository.analytics.api.AnalyticsRepository;
import io.gravitee.repository.analytics.query.Query;
import io.gravitee.repository.analytics.query.count.CountQuery;
import io.gravitee.rest.api.repository.vertx.VertxCompletableFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;

public class AnalyticsRepositoryProbe
implements Probe {
    @Autowired
    private AnalyticsRepository analyticsRepository;
    @Autowired
    private Vertx vertx;

    public String id() {
        return "repository-analytics";
    }

    public CompletableFuture<Result> check() {
        final Future future = Future.future();
        this.vertx.executeBlocking((Handler)new Handler<Promise<Result>>(){

            public void handle(Promise<Result> event) {
                try {
                    AnalyticsRepositoryProbe.this.analyticsRepository.query((Query)new CountQuery());
                    event.complete((Object)Result.healthy());
                }
                catch (Exception ex) {
                    event.complete((Object)Result.unhealthy((Throwable)ex));
                }
            }
        }, (Handler)new Handler<AsyncResult<Result>>(){

            public void handle(AsyncResult<Result> event) {
                future.complete((Object)((Result)event.result()));
            }
        });
        return VertxCompletableFuture.from(this.vertx, future);
    }
}

