/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.repository.plugins;

import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.core.api.PluginClassLoader;
import io.gravitee.plugin.core.api.PluginClassLoaderFactory;
import io.gravitee.plugin.core.api.PluginContextConfigurer;
import io.gravitee.plugin.core.api.PluginContextFactory;
import io.gravitee.plugin.core.api.PluginHandler;
import io.gravitee.plugin.core.internal.AnnotationBasedPluginContextConfigurer;
import io.gravitee.repository.Repository;
import io.gravitee.repository.Scope;
import io.gravitee.rest.api.repository.proxy.AbstractProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class RepositoryPluginHandler
implements PluginHandler,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryPluginHandler.class);
    private static final String PLUGIN_TYPE = "repository";
    @Autowired
    private Environment environment;
    @Autowired
    private PluginContextFactory pluginContextFactory;
    @Autowired
    @Qualifier(value="pluginClassLoaderFactory")
    private PluginClassLoaderFactory pluginClassLoaderFactory;
    @Autowired
    private ApplicationContext applicationContext;
    private final Map<Scope, Repository> repositories = new HashMap<Scope, Repository>();
    private final Map<Scope, String> repositoryTypeByScope = new HashMap<Scope, String>();
    private final Map<String, Collection<Scope>> scopeByRepositoryType = new HashMap<String, Collection<Scope>>();

    public void afterPropertiesSet() throws Exception {
        this.lookForRepositoryType(Scope.MANAGEMENT);
        this.lookForRepositoryType(Scope.ANALYTICS);
    }

    public boolean canHandle(Plugin plugin) {
        return PLUGIN_TYPE.equalsIgnoreCase(plugin.type());
    }

    public void handle(Plugin plugin) {
        try {
            PluginClassLoader classloader = this.pluginClassLoaderFactory.getOrCreateClassLoader(plugin, this.getClass().getClassLoader());
            Class<?> repositoryClass = classloader.loadClass(plugin.clazz());
            LOGGER.info("Register a new repository: {} [{}]", (Object)plugin.id(), (Object)plugin.clazz());
            Assert.isAssignable(Repository.class, repositoryClass);
            Repository repository = (Repository)this.createInstance(repositoryClass);
            Collection<Scope> scopes = this.scopeByRepositoryType.getOrDefault(repository.type(), Collections.EMPTY_LIST);
            for (Scope scope : scopes) {
                if (!this.repositories.containsKey(scope)) {
                    boolean loaded = false;
                    int tries = 0;
                    while (!loaded) {
                        if (tries > 0) {
                            Thread.sleep(5000L);
                        }
                        loaded = this.loadRepository(scope, repository, plugin);
                        ++tries;
                        if (loaded) continue;
                        LOGGER.error("Unable to load repository {} for scope {}. Retry in 5 seconds...", (Object)scope, (Object)plugin.id());
                    }
                    continue;
                }
                LOGGER.warn("Repository scope {} already loaded by {}", (Object)scope, (Object)this.repositories.get(scope));
            }
        }
        catch (Exception iae) {
            LOGGER.error("Unexpected error while create repository instance", (Throwable)iae);
        }
    }

    private boolean loadRepository(final Scope scope, final Repository repository, Plugin plugin) {
        LOGGER.info("Repository [{}] loaded by {}", (Object)scope, (Object)repository.type());
        try {
            ApplicationContext repoApplicationContext = this.pluginContextFactory.create((PluginContextConfigurer)new AnnotationBasedPluginContextConfigurer(plugin){

                public Set<Class<?>> configurations() {
                    return Collections.singleton(repository.configuration(scope));
                }
            });
            this.registerRepositoryDefinitions(repository, repoApplicationContext);
            this.repositories.put(scope, repository);
            return true;
        }
        catch (Exception iae) {
            LOGGER.error("Unexpected error while creating context for repository instance", (Throwable)iae);
            this.pluginContextFactory.remove(plugin);
            return false;
        }
    }

    private void registerRepositoryDefinitions(Repository repository, ApplicationContext repoApplicationContext) {
        String[] beanNames;
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        for (String beanName : beanNames = repoApplicationContext.getBeanDefinitionNames()) {
            Object repositoryClassInstance = repoApplicationContext.getBean(beanName);
            Class<?> repositoryObjectClass = repositoryClassInstance.getClass();
            if ((beanName.endsWith("Repository") || beanName.endsWith("Manager") && !beanName.endsWith("TransactionManager")) && !repository.getClass().equals(repositoryClassInstance.getClass())) {
                if (repositoryObjectClass.getInterfaces().length <= 0) continue;
                Class<?> repositoryItfClass = repositoryObjectClass.getInterfaces()[0];
                LOGGER.debug("Set proxy target for {} [{}]", (Object)beanName, repositoryItfClass);
                try {
                    Object proxyRepository = beanFactory.getBean(repositoryItfClass);
                    if (!(proxyRepository instanceof AbstractProxy)) continue;
                    AbstractProxy proxy = (AbstractProxy)proxyRepository;
                    proxy.setTarget(repositoryClassInstance);
                }
                catch (NoSuchBeanDefinitionException nsbde) {
                    LOGGER.debug("Unable to proxify {} [{}]", (Object)beanName, repositoryItfClass);
                }
                continue;
            }
            if (!beanName.endsWith("TransactionManager")) continue;
            beanFactory.registerSingleton(beanName, repositoryClassInstance);
        }
    }

    private String lookForRepositoryType(Scope scope) throws Exception {
        String repositoryType = this.environment.getProperty(scope.getName() + ".type");
        LOGGER.info("Loading repository for scope {}: {}", (Object)scope, (Object)repositoryType);
        if (repositoryType == null || repositoryType.isEmpty()) {
            LOGGER.error("No repository type defined in configuration for {}", (Object)scope.getName());
            throw new IllegalStateException("No repository type defined in configuration for " + scope.getName());
        }
        this.repositoryTypeByScope.put(scope, repositoryType);
        Collection scopes = this.scopeByRepositoryType.getOrDefault(repositoryType, new ArrayList());
        scopes.add(scope);
        this.scopeByRepositoryType.put(repositoryType, scopes);
        return repositoryType;
    }

    private <T> T createInstance(Class<T> clazz) throws Exception {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            LOGGER.error("Unable to instantiate class: {}", (Throwable)ex);
            throw ex;
        }
    }
}

