/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.settings;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.gravitee.rest.api.model.annotations.ParameterKey;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.settings.Enabled;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Portal {
    @ParameterKey(value=Key.PORTAL_ENTRYPOINT)
    private String entrypoint;
    @ParameterKey(value=Key.PORTAL_APIKEY_HEADER)
    private String apikeyHeader;
    @ParameterKey(value=Key.PORTAL_SUPPORT_ENABLED)
    private Enabled support;
    @ParameterKey(value=Key.PORTAL_URL)
    private String url;
    @ParameterKey(value=Key.PORTAL_HOMEPAGE_TITLE)
    private String homepageTitle;
    @ParameterKey(value=Key.PORTAL_TCP_PORT)
    @Min(value=1025L)
    @Max(value=65535L)
    private @Min(value=1025L) @Max(value=65535L) Integer tcpPort;
    @ParameterKey(value=Key.PORTAL_KAFKA_DOMAIN)
    @Size(max=192)
    private @Size(max=192) String kafkaDomain;
    @ParameterKey(value=Key.PORTAL_KAFKA_PORT)
    @Min(value=1025L)
    @Max(value=65535L)
    private @Min(value=1025L) @Max(value=65535L) Integer kafkaPort;
    @ParameterKey(value=Key.PORTAL_KAFKA_SASL_MECHANISMS)
    private List<String> kafkaSaslMechanisms;
    private PortalApis apis = new PortalApis();
    private PortalAnalytics analytics = new PortalAnalytics();
    private PortalRating rating = new PortalRating();
    private PortalUploadMedia media = new PortalUploadMedia();
    private PortalUserCreation userCreation = new PortalUserCreation();

    public PortalUploadMedia getUploadMedia() {
        return this.media;
    }

    public void setUploadMedia(PortalUploadMedia media) {
        this.media = media;
    }

    @Generated
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @Generated
    public String getApikeyHeader() {
        return this.apikeyHeader;
    }

    @Generated
    public Enabled getSupport() {
        return this.support;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getHomepageTitle() {
        return this.homepageTitle;
    }

    @Generated
    public Integer getTcpPort() {
        return this.tcpPort;
    }

    @Generated
    public String getKafkaDomain() {
        return this.kafkaDomain;
    }

    @Generated
    public Integer getKafkaPort() {
        return this.kafkaPort;
    }

    @Generated
    public List<String> getKafkaSaslMechanisms() {
        return this.kafkaSaslMechanisms;
    }

    @Generated
    public PortalApis getApis() {
        return this.apis;
    }

    @Generated
    public PortalAnalytics getAnalytics() {
        return this.analytics;
    }

    @Generated
    public PortalRating getRating() {
        return this.rating;
    }

    @Generated
    public PortalUploadMedia getMedia() {
        return this.media;
    }

    @Generated
    public PortalUserCreation getUserCreation() {
        return this.userCreation;
    }

    @Generated
    public void setEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
    }

    @Generated
    public void setApikeyHeader(String apikeyHeader) {
        this.apikeyHeader = apikeyHeader;
    }

    @Generated
    public void setSupport(Enabled support) {
        this.support = support;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setHomepageTitle(String homepageTitle) {
        this.homepageTitle = homepageTitle;
    }

    @Generated
    public void setTcpPort(Integer tcpPort) {
        this.tcpPort = tcpPort;
    }

    @Generated
    public void setKafkaDomain(String kafkaDomain) {
        this.kafkaDomain = kafkaDomain;
    }

    @Generated
    public void setKafkaPort(Integer kafkaPort) {
        this.kafkaPort = kafkaPort;
    }

    @Generated
    public void setKafkaSaslMechanisms(List<String> kafkaSaslMechanisms) {
        this.kafkaSaslMechanisms = kafkaSaslMechanisms;
    }

    @Generated
    public void setApis(PortalApis apis) {
        this.apis = apis;
    }

    @Generated
    public void setAnalytics(PortalAnalytics analytics) {
        this.analytics = analytics;
    }

    @Generated
    public void setRating(PortalRating rating) {
        this.rating = rating;
    }

    @Generated
    public void setMedia(PortalUploadMedia media) {
        this.media = media;
    }

    @Generated
    public void setUserCreation(PortalUserCreation userCreation) {
        this.userCreation = userCreation;
    }

    public static class PortalUploadMedia {
        @ParameterKey(value=Key.PORTAL_UPLOAD_MEDIA_ENABLED)
        private Boolean enabled;
        @ParameterKey(value=Key.PORTAL_UPLOAD_MEDIA_MAXSIZE)
        private Integer maxSizeInOctet;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Integer getMaxSizeInOctet() {
            return this.maxSizeInOctet;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMaxSizeInOctet(Integer maxSizeInOctet) {
            this.maxSizeInOctet = maxSizeInOctet;
        }
    }

    public static class PortalApis {
        @ParameterKey(value=Key.PORTAL_APIS_TILESMODE_ENABLED)
        private Enabled tilesMode;
        @ParameterKey(value=Key.PORTAL_APIS_DOCUMENTATIONONLYMODE_ENABLED)
        private Enabled documentationOnlyMode;
        @ParameterKey(value=Key.PORTAL_APIS_CATEGORY_ENABLED)
        private Enabled categoryMode;
        @ParameterKey(value=Key.PORTAL_APIS_PROMOTED_API_ENABLED)
        private Enabled promotedApiMode;
        @ParameterKey(value=Key.PORTAL_APIS_SHOW_TAGS_IN_APIHEADER)
        private Enabled apiHeaderShowTags;
        @ParameterKey(value=Key.PORTAL_APIS_SHOW_CATEGORIES_IN_APIHEADER)
        private Enabled apiHeaderShowCategories;

        @Generated
        public Enabled getTilesMode() {
            return this.tilesMode;
        }

        @Generated
        public Enabled getDocumentationOnlyMode() {
            return this.documentationOnlyMode;
        }

        @Generated
        public Enabled getCategoryMode() {
            return this.categoryMode;
        }

        @Generated
        public Enabled getPromotedApiMode() {
            return this.promotedApiMode;
        }

        @Generated
        public Enabled getApiHeaderShowTags() {
            return this.apiHeaderShowTags;
        }

        @Generated
        public Enabled getApiHeaderShowCategories() {
            return this.apiHeaderShowCategories;
        }

        @Generated
        public void setTilesMode(Enabled tilesMode) {
            this.tilesMode = tilesMode;
        }

        @Generated
        public void setDocumentationOnlyMode(Enabled documentationOnlyMode) {
            this.documentationOnlyMode = documentationOnlyMode;
        }

        @Generated
        public void setCategoryMode(Enabled categoryMode) {
            this.categoryMode = categoryMode;
        }

        @Generated
        public void setPromotedApiMode(Enabled promotedApiMode) {
            this.promotedApiMode = promotedApiMode;
        }

        @Generated
        public void setApiHeaderShowTags(Enabled apiHeaderShowTags) {
            this.apiHeaderShowTags = apiHeaderShowTags;
        }

        @Generated
        public void setApiHeaderShowCategories(Enabled apiHeaderShowCategories) {
            this.apiHeaderShowCategories = apiHeaderShowCategories;
        }
    }

    public static class PortalAnalytics {
        @ParameterKey(value=Key.PORTAL_ANALYTICS_ENABLED)
        private Boolean enabled;
        @ParameterKey(value=Key.PORTAL_ANALYTICS_TRACKINGID)
        private String trackingId;

        public Boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setTrackingId(String trackingId) {
            this.trackingId = trackingId;
        }

        @Generated
        public String getTrackingId() {
            return this.trackingId;
        }
    }

    public static class PortalRating {
        @ParameterKey(value=Key.PORTAL_RATING_ENABLED)
        private Boolean enabled;
        private RatingComment comment = new RatingComment();

        public Boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public RatingComment getComment() {
            return this.comment;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setComment(RatingComment comment) {
            this.comment = comment;
        }

        public static class RatingComment {
            @ParameterKey(value=Key.PORTAL_RATING_COMMENT_MANDATORY)
            private Boolean mandatory;

            public Boolean isMandatory() {
                return this.mandatory;
            }

            @Generated
            public Boolean getMandatory() {
                return this.mandatory;
            }

            @Generated
            public void setMandatory(Boolean mandatory) {
                this.mandatory = mandatory;
            }
        }
    }

    public static class PortalUserCreation {
        @ParameterKey(value=Key.PORTAL_USERCREATION_ENABLED)
        private Boolean enabled;
        @ParameterKey(value=Key.PORTAL_USERCREATION_AUTOMATICVALIDATION_ENABLED)
        private Enabled automaticValidation;

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Enabled getAutomaticValidation() {
            return this.automaticValidation;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setAutomaticValidation(Enabled automaticValidation) {
            this.automaticValidation = automaticValidation;
        }
    }
}

