/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.parameters;

import io.gravitee.rest.api.model.parameters.KeyScope;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Schema(enumAsRef=true)
public enum Key {
    COMPANY_NAME("company.name", "Gravitee.io", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_TOP_APIS("portal.top-apis", List.class, false, new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_ENTRYPOINT("portal.entrypoint", "https://api.company.com", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_TCP_PORT("portal.tcpPort", "4082", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_KAFKA_DOMAIN("portal.kafkaDomain", "", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_KAFKA_PORT("portal.kafkaPort", "9092", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIKEY_HEADER("portal.apikey.header", "X-Gravitee-Api-Key", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_SUPPORT_ENABLED("portal.support.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RATING_ENABLED("portal.rating.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RATING_COMMENT_MANDATORY("portal.rating.comment.mandatory", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_USERCREATION_ENABLED("portal.userCreation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_USERCREATION_AUTOMATICVALIDATION_ENABLED("portal.userCreation.automaticValidation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_ANALYTICS_ENABLED("portal.analytics.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_ANALYTICS_TRACKINGID("portal.analytics.trackingId", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_TILESMODE_ENABLED("portal.apis.tilesMode.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_DOCUMENTATIONONLYMODE_ENABLED("portal.apis.documentationOnlyMode.enabled", "false", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    PORTAL_APIS_CATEGORY_ENABLED("portal.apis.categoryMode.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_PROMOTED_API_ENABLED("portal.apis.promotedApiMode.enabled", "true", Set.of(KeyScope.ENVIRONMENT)),
    PORTAL_APIS_SHOW_TAGS_IN_APIHEADER("portal.apis.apiheader.showtags.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_SHOW_CATEGORIES_IN_APIHEADER("portal.apis.apiheader.showcategories.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_UPLOAD_MEDIA_ENABLED("portal.uploadMedia.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_UPLOAD_MEDIA_MAXSIZE("portal.uploadMedia.maxSizeInOctet", "1000000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_URL("portal.url", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.SYSTEM))),
    PORTAL_HOMEPAGE_TITLE("portal.homepageTitle", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_SITE_TITLE("portal.next.siteTitle", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_CONFIG_TITLE("portal.next.banner.title", "Welcome to Gravitee Developer Portal!", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_CONFIG_SUBTITLE("portal.next.banner.subtitle", "Discover powerful APIs to supercharge your projects.", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_CONFIG_ENABLED("portal.next.banner.enabled", "true", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_PRIMARY_BUTTON_ENABLED("portal.next.banner.primaryButton.enabled", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_PRIMARY_BUTTON_TARGET("portal.next.banner.primaryButton.target", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_PRIMARY_BUTTON_TYPE("portal.next.banner.primaryButton.type", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_PRIMARY_BUTTON_LABEL("portal.next.banner.primaryButton.label", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_PRIMARY_BUTTON_VISIBILITY("portal.next.banner.primaryButton.visibility", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_SECONDARY_BUTTON_ENABLED("portal.next.banner.secondaryButton.enabled", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_SECONDARY_BUTTON_TARGET("portal.next.banner.secondaryButton.target", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_SECONDARY_BUTTON_TYPE("portal.next.banner.secondaryButton.type", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_SECONDARY_BUTTON_LABEL("portal.next.banner.secondaryButton.label", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_BANNER_SECONDARY_BUTTON_VISIBILITY("portal.next.banner.secondaryButton.visibility", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_ACCESS_ENABLED("portal.next.access.enabled", "false", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_COLOR_PRIMARY("portal.next.theme.color.primary", "#613CB0", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_COLOR_SECONDARY("portal.next.theme.color.secondary", "#958BA9", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_COLOR_TERTIARY("portal.next.theme.color.tertiary", "#B7818F", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_COLOR_ERROR("portal.next.theme.color.error", "#EC6152", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_COLOR_BACKGROUND_PAGE("portal.next.theme.color.background.page", "#F7F8FD", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_COLOR_BACKGROUND_CARD("portal.next.theme.color.background.card", "#FFFFFF", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_CUSTOM_CSS("portal.next.theme.customCss", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_THEME_FONT_FAMILY("portal.next.theme.font.family", "\"Roboto\", sans-serif", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_NEXT_CATALOG_VIEW_MODE("portal.next.catalog.viewMode", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    MANAGEMENT_TITLE("management.title", "Gravitee.io Management", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    MANAGEMENT_URL("management.url", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_AUTHENTICATION_FORCELOGIN_ENABLED("portal.authentication.forceLogin.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_AUTHENTICATION_LOCALLOGIN_ENABLED("portal.authentication.localLogin.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_SCHEDULER_TASKS("portal.scheduler.tasks", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_SCHEDULER_NOTIFICATIONS("portal.scheduler.notifications", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    DOCUMENTATION_URL("documentation.url", "https://documentation.gravitee.io/apim", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    DOCUMENTATION_PAGE_NOT_FOUND_MESSAGE("documentation.pageNotFoundMessage", "", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT))),
    PLAN_SECURITY_MTLS_ENABLED("plan.security.mtls.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_JWT_ENABLED("plan.security.jwt.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_OAUTH2_ENABLED("plan.security.oauth2.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_APIKEY_ENABLED("plan.security.apikey.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED("plan.security.apikey.allowCustom.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_APIKEY_SHARED_ALLOWED("plan.security.apikey.allowShared.enabled", "false", Set.of(KeyScope.ENVIRONMENT, KeyScope.SYSTEM)),
    PLAN_SECURITY_KEYLESS_ENABLED("plan.security.keyless.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_SUBSCRIPTION_ENABLED("plan.security.subscription.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_PUSH_ENABLED("plan.security.push.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    OPEN_API_DOC_TYPE_SWAGGER_ENABLED("open.api.doc.type.swagger.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    OPEN_API_DOC_TYPE_REDOC_ENABLED("open.api.doc.type.redoc.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    OPEN_API_DOC_TYPE_DEFAULT("open.api.doc.type.default", "Swagger", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_SCORE_ENABLED("api.score.enabled", "false", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    API_QUALITY_METRICS_ENABLED("api.quality.metrics.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_FUNCTIONAL_DOCUMENTATION_WEIGHT("api.quality.metrics.functional.documentation.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_TECHNICAL_DOCUMENTATION_WEIGHT("api.quality.metrics.technical.documentation.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_HEALTHCHECK_WEIGHT("api.quality.metrics.healthcheck.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_DESCRIPTION_WEIGHT("api.quality.metrics.description.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_DESCRIPTION_MIN_LENGTH("api.quality.metrics.description.min.length", "100", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_LOGO_WEIGHT("api.quality.metrics.logo.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_CATEGORIES_WEIGHT("api.quality.metrics.categories.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_LABELS_WEIGHT("api.quality.metrics.labels.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    ALERT_ENABLED("alert.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_DEFAULT_MAX_DURATION("logging.default.max.duration", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_AUDIT_ENABLED("logging.audit.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_AUDIT_TRAIL_ENABLED("logging.audit.trail.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_USER_DISPLAYED("logging.user.displayed", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_MESSAGE_SAMPLING_COUNT_DEFAULT("logging.messageSampling.count.default", "100", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    LOGGING_MESSAGE_SAMPLING_COUNT_LIMIT("logging.messageSampling.count.limit", "10", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    LOGGING_MESSAGE_SAMPLING_PROBABILISTIC_DEFAULT("logging.messageSampling.probabilistic.default", "0.01", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    LOGGING_MESSAGE_SAMPLING_PROBABILISTIC_LIMIT("logging.messageSampling.probabilistic.limit", "0.5", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    LOGGING_MESSAGE_SAMPLING_TEMPORAL_DEFAULT("logging.messageSampling.temporal.default", "PT1S", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    LOGGING_MESSAGE_SAMPLING_TEMPORAL_LIMIT("logging.messageSampling.temporal.limit", "PT1S", Set.of(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    ANALYTICS_CLIENT_TIMEOUT("analytics.client.timeout", "30000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_SIMPLE_ENABLED("application.types.simple.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_BROWSER_ENABLED("application.types.browser.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_WEB_ENABLED("application.types.web.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_NATIVE_ENABLED("application.types.native.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_BACKEND_TO_BACKEND_ENABLED("application.types.backend_to_backend.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_REGISTRATION_ENABLED("application.registration.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_REVIEW_ENABLED("api.review.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    MAINTENANCE_MODE_ENABLED("maintenance.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    NEWSLETTER_ENABLED("newsletter.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RECAPTCHA_ENABLED("portal.reCaptcha.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RECAPTCHA_SITE_KEY("portal.reCaptcha.siteKey", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_ALLOW_ORIGIN("http.api.portal.cors.allow-origin", "*", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_ALLOW_HEADERS("http.api.portal.cors.allow-headers", "Cache-Control;Pragma;Origin;Authorization;Content-Type;X-Requested-With;If-Match;X-Xsrf-Token;X-Recaptcha-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_ALLOW_METHODS("http.api.portal.cors.allow-methods", "OPTIONS;GET;POST;PUT;DELETE;PATCH", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_EXPOSED_HEADERS("http.api.portal.cors.exposed-headers", "ETag;X-Xsrf-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_MAX_AGE("http.api.portal.cors.max-age", "1728000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_ENABLED("email.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_HOST("email.host", "smtp.my.domain", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_PORT("email.port", "587", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_USERNAME("email.username", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_PASSWORD("email.password", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_PROTOCOL("email.protocol", "smtp", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_SUBJECT("email.subject", "[Gravitee.io] %s", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_FROM("email.from", "noreply@my.domain", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_PROPERTIES_AUTH_ENABLED("email.properties.auth", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_PROPERTIES_STARTTLS_ENABLE("email.properties.starttls.enable", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    EMAIL_PROPERTIES_SSL_TRUST("email.properties.ssl.trust", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM)), true),
    API_LABELS_DICTIONARY("api.labelsDictionary", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_PRIMARY_OWNER_MODE("api.primary.owner.mode", ApiPrimaryOwnerMode.HYBRID.name(), new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_AUTHENTICATION_LOCALLOGIN_ENABLED("console.authentication.localLogin.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SCHEDULER_TASKS("console.scheduler.tasks", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SCHEDULER_NOTIFICATIONS("console.scheduler.notifications", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_RECAPTCHA_ENABLED("console.reCaptcha.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_RECAPTCHA_SITE_KEY("console.reCaptcha.siteKey", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_ALLOW_ORIGIN("http.api.management.cors.allow-origin", "*", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_ALLOW_HEADERS("http.api.management.cors.allow-headers", "Cache-Control;Pragma;Origin;Authorization;Content-Type;X-Requested-With;If-Match;X-Xsrf-Token;X-Recaptcha-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_ALLOW_METHODS("http.api.management.cors.allow-methods", "OPTIONS;GET;POST;PUT;DELETE;PATCH", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_EXPOSED_HEADERS("http.api.management.cors.exposed-headers", "ETag;X-Xsrf-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_MAX_AGE("http.api.management.cors.max-age", "1728000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_USERCREATION_ENABLED("console.userCreation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_USERCREATION_AUTOMATICVALIDATION_ENABLED("console.userCreation.automaticValidation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SUPPORT_ENABLED("console.support.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_DASHBOARDS_API_STATUS("console.dashboards.apiStatus.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SYSTEM_ROLE_EDITION_ENABLED("console.systemRoleEdition.enabled", "false", Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_ENABLED("console.analytics.pendo.enabled", "false", Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_API_KEY("console.analytics.pendo.apiKey", "", Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_ACCOUNT_ID("console.analytics.pendo.account.id", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_ACCOUNT_HRID("console.analytics.pendo.account.hrid", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_ACCOUNT_TYPE("console.analytics.pendo.account.type", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_TITLE("console.customization.title", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_FAVICON("console.customization.favicon", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_LOGO("console.customization.logo", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_MENUACTIVE("console.customization.theme.menuActive", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_MENUBACKGROUND("console.customization.theme.menuBackground", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_CTACONFIGURATION_CUSTOMEENTERPRISENAME("console.customization.ctaConfiguration.customEnterpriseName", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_CTACONFIGURATION_TITLE("console.customization.ctaConfiguration.title", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_CTACONFIGURATION_HIDEDAYS("console.customization.ctaConfiguration.hideDays", "true", Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_CTACONFIGURATION_TRIALBUTTONLABEL("console.customization.ctaConfiguration.trialButtonLabel", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_CUSTOMIZATION_THEME_CTACONFIGURATION_TRIALURL("console.customization.ctaConfiguration.trialURL", (String)null, Set.of(KeyScope.SYSTEM)),
    CONSOLE_LICENSE_EXPIRATION_NOTIFICATION_ENABLED("console.licenseExpirationNotification.enabled", "true", Set.of(KeyScope.SYSTEM)),
    V4_EMULATION_ENGINE_DEFAULT("api.v2.emulateV4Engine.default", "yes", Set.of(KeyScope.SYSTEM)),
    ALERT_ENGINE_ENABLED("alerts.alert-engine.enabled", "false", Set.of(KeyScope.SYSTEM)),
    FEDERATION_ENABLED("integration.enabled", "false", Set.of(KeyScope.SYSTEM)),
    INSTALLATION_TYPE("installation.type", "standalone", Set.of(KeyScope.SYSTEM)),
    TRIAL_INSTANCE("trialInstance.enabled", "false", Set.of(KeyScope.SYSTEM)),
    CLOUD_HOSTED_ENABLED("cloud-hosted.enabled", "false", Set.of(KeyScope.SYSTEM)),
    EXTERNAL_AUTH_ENABLED("auth.external.enabled", "false", Set.of(KeyScope.SYSTEM)),
    EXTERNAL_AUTH_ACCOUNT_DELETION_ENABLED("auth.external.allowAccountDeletion", "true", Set.of(KeyScope.SYSTEM));

    String key;
    String defaultValue;
    Class<?> type;
    boolean isOverridable = true;
    Set<KeyScope> scopes;
    boolean isHiddenForTrial = false;

    private Key(String key, Set<KeyScope> scopes) {
        this.key = key;
        this.scopes = scopes;
    }

    private Key(String key, String defaultValue, Class<?> type, Set<KeyScope> scopes) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.scopes = scopes;
    }

    private Key(String key, Class<?> type, Set<KeyScope> scopes) {
        this.key = key;
        this.type = type;
        this.scopes = scopes;
    }

    private Key(String key, Class<?> type, boolean isOverridable, Set<KeyScope> scopes) {
        this.key = key;
        this.type = type;
        this.isOverridable = isOverridable;
        this.scopes = scopes;
    }

    private Key(String key, String defaultValue, Set<KeyScope> scopes) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.scopes = scopes;
    }

    private Key(String key, String defaultValue, Set<KeyScope> scopes, boolean isHiddenForTrial) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.scopes = scopes;
        this.isHiddenForTrial = isHiddenForTrial;
    }

    private Key(String key, Set<KeyScope> scopes, boolean isHiddenForTrial) {
        this.key = key;
        this.scopes = scopes;
        this.isHiddenForTrial = isHiddenForTrial;
    }

    public static Key findByKey(String value) {
        for (Key key : Key.values()) {
            if (!key.key.equals(value)) continue;
            return key;
        }
        throw new IllegalArgumentException(value + " is not a valid Key");
    }

    public String key() {
        return this.key;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Class<?> type() {
        return this.type;
    }

    public boolean isOverridable() {
        return this.isOverridable;
    }

    public boolean isHiddenForTrial() {
        return this.isHiddenForTrial;
    }

    public Set<KeyScope> scopes() {
        return this.scopes;
    }
}

