/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.api;

import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.failover.Failover;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@Schema(name="NewApiEntityV4")
public class NewApiEntity {
    @NotBlank
    @NotEmpty(message="API's name must not be empty")
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private @NotBlank @NotEmpty(message="API's name must not be empty") String name;
    @NotBlank
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String apiVersion;
    @NotNull
    @Schema(description="API's gravitee definition version")
    private DefinitionVersion definitionVersion = DefinitionVersion.V4;
    @NotNull
    @Schema(description="API's type", example="async")
    private ApiType type;
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="The list of sharding tags associated with this API.", example="public, private")
    private Set<@NotBlank String> tags;
    @NotNull
    @Valid
    @Schema(description="A list of listeners used to describe our you api could be reached.")
    private @NotNull @Valid List<@NotNull Listener> listeners;
    @NotNull
    @Valid
    @Schema(description="A list of endpoint describing the endpoints to contact.")
    private List<EndpointGroup> endpointGroups;
    @Schema(description="Analytics configuration")
    private Analytics analytics;
    @Schema(description="Failover configuration")
    private Failover failover;
    @Schema(description="API's flow execution.")
    private FlowExecution flowExecution;
    @Valid
    @Schema(description="A list of flows containing the policies configuration.")
    private List<Flow> flows;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<@NotBlank String> groups;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public DefinitionVersion getDefinitionVersion() {
        return this.definitionVersion;
    }

    @Generated
    public ApiType getType() {
        return this.type;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Set<@NotBlank String> getTags() {
        return this.tags;
    }

    @Generated
    public List<@NotNull Listener> getListeners() {
        return this.listeners;
    }

    @Generated
    public List<EndpointGroup> getEndpointGroups() {
        return this.endpointGroups;
    }

    @Generated
    public Analytics getAnalytics() {
        return this.analytics;
    }

    @Generated
    public Failover getFailover() {
        return this.failover;
    }

    @Generated
    public FlowExecution getFlowExecution() {
        return this.flowExecution;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<@NotBlank String> getGroups() {
        return this.groups;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setDefinitionVersion(DefinitionVersion definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    @Generated
    public void setType(ApiType type) {
        this.type = type;
    }

    @Generated
    public void setTags(Set<@NotBlank String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setListeners(List<@NotNull Listener> listeners) {
        this.listeners = listeners;
    }

    @Generated
    public void setEndpointGroups(List<EndpointGroup> endpointGroups) {
        this.endpointGroups = endpointGroups;
    }

    @Generated
    public void setAnalytics(Analytics analytics) {
        this.analytics = analytics;
    }

    @Generated
    public void setFailover(Failover failover) {
        this.failover = failover;
    }

    @Generated
    public void setFlowExecution(FlowExecution flowExecution) {
        this.flowExecution = flowExecution;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setGroups(Set<@NotBlank String> groups) {
        this.groups = groups;
    }

    @Generated
    public String toString() {
        return "NewApiEntity(name=" + this.getName() + ", apiVersion=" + this.getApiVersion() + ", definitionVersion=" + this.getDefinitionVersion() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", listeners=" + this.getListeners() + ", endpointGroups=" + this.getEndpointGroups() + ", analytics=" + this.getAnalytics() + ", failover=" + this.getFailover() + ", flowExecution=" + this.getFlowExecution() + ", flows=" + this.getFlows() + ", groups=" + this.getGroups() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewApiEntity)) {
            return false;
        }
        NewApiEntity other = (NewApiEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        DefinitionVersion this$definitionVersion = this.getDefinitionVersion();
        DefinitionVersion other$definitionVersion = other.getDefinitionVersion();
        if (this$definitionVersion == null ? other$definitionVersion != null : !this$definitionVersion.equals(other$definitionVersion)) {
            return false;
        }
        ApiType this$type = this.getType();
        ApiType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<Listener> this$listeners = this.getListeners();
        List<Listener> other$listeners = other.getListeners();
        if (this$listeners == null ? other$listeners != null : !((Object)this$listeners).equals(other$listeners)) {
            return false;
        }
        List<EndpointGroup> this$endpointGroups = this.getEndpointGroups();
        List<EndpointGroup> other$endpointGroups = other.getEndpointGroups();
        if (this$endpointGroups == null ? other$endpointGroups != null : !((Object)this$endpointGroups).equals(other$endpointGroups)) {
            return false;
        }
        Analytics this$analytics = this.getAnalytics();
        Analytics other$analytics = other.getAnalytics();
        if (this$analytics == null ? other$analytics != null : !this$analytics.equals(other$analytics)) {
            return false;
        }
        Failover this$failover = this.getFailover();
        Failover other$failover = other.getFailover();
        if (this$failover == null ? other$failover != null : !this$failover.equals(other$failover)) {
            return false;
        }
        FlowExecution this$flowExecution = this.getFlowExecution();
        FlowExecution other$flowExecution = other.getFlowExecution();
        if (this$flowExecution == null ? other$flowExecution != null : !this$flowExecution.equals(other$flowExecution)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        Set<String> this$groups = this.getGroups();
        Set<String> other$groups = other.getGroups();
        return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewApiEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        DefinitionVersion $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + ($definitionVersion == null ? 43 : $definitionVersion.hashCode());
        ApiType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<Listener> $listeners = this.getListeners();
        result = result * 59 + ($listeners == null ? 43 : ((Object)$listeners).hashCode());
        List<EndpointGroup> $endpointGroups = this.getEndpointGroups();
        result = result * 59 + ($endpointGroups == null ? 43 : ((Object)$endpointGroups).hashCode());
        Analytics $analytics = this.getAnalytics();
        result = result * 59 + ($analytics == null ? 43 : $analytics.hashCode());
        Failover $failover = this.getFailover();
        result = result * 59 + ($failover == null ? 43 : $failover.hashCode());
        FlowExecution $flowExecution = this.getFlowExecution();
        result = result * 59 + ($flowExecution == null ? 43 : $flowExecution.hashCode());
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        Set<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        return result;
    }
}

